/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import java.util.HashSet;
import java.util.Set;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Float64ScalarCache;
import org.vcssl.nano.vm.memory.DataContainer;

public class Float64CachedScalarDualArithmeticUnit
extends AcceleratorExecutionUnit {
    public static final Set<OperationCode> AVAILABLE_OPERAND_SET = new HashSet<OperationCode>();

    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        int n = blArray.length;
        Float64ScalarCache[] float64ScalarCacheArray = new Float64ScalarCache[n];
        for (int i = 0; i < n; ++i) {
            float64ScalarCacheArray[i] = (Float64ScalarCache)objectArray[i];
        }
        OperationCode[] operationCodeArray = acceleratorInstruction.getFusedOperationCodes();
        int n2 = acceleratorInstruction.getFusedInputOperandIndices()[0];
        Float64CachedScalarDualNode float64CachedScalarDualNode = null;
        if (n2 == 1) {
            float64CachedScalarDualNode = this.generateLeftInputNode(operationCodeArray, float64ScalarCacheArray, acceleratorExecutionNode);
        } else if (n2 == 2) {
            float64CachedScalarDualNode = this.generateRightInputNode(operationCodeArray, float64ScalarCacheArray, acceleratorExecutionNode);
        } else {
            throw new VnanoFatalException("Invalid fused input operand index: " + n2);
        }
        return float64CachedScalarDualNode;
    }

    private Float64CachedScalarDualNode generateLeftInputNode(OperationCode[] operationCodeArray, Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
        Float64CachedScalarDualNode float64CachedScalarDualNode = null;
        block0 : switch (operationCodeArray[0]) {
            case ADD: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64CachedScalarDualNode = new Float64CachedScalarAddAddLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64CachedScalarDualNode = new Float64CachedScalarAddSubLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64CachedScalarDualNode = new Float64CachedScalarAddMulLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64CachedScalarDualNode = new Float64CachedScalarAddDivLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64CachedScalarDualNode = new Float64CachedScalarAddRemLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case SUB: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64CachedScalarDualNode = new Float64CachedScalarSubAddLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64CachedScalarDualNode = new Float64CachedScalarSubSubLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64CachedScalarDualNode = new Float64CachedScalarSubMulLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64CachedScalarDualNode = new Float64CachedScalarSubDivLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64CachedScalarDualNode = new Float64CachedScalarSubRemLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case MUL: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64CachedScalarDualNode = new Float64CachedScalarMulAddLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64CachedScalarDualNode = new Float64CachedScalarMulSubLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64CachedScalarDualNode = new Float64CachedScalarMulMulLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64CachedScalarDualNode = new Float64CachedScalarMulDivLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64CachedScalarDualNode = new Float64CachedScalarMulRemLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case DIV: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64CachedScalarDualNode = new Float64CachedScalarDivAddLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64CachedScalarDualNode = new Float64CachedScalarDivSubLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64CachedScalarDualNode = new Float64CachedScalarDivMulLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64CachedScalarDualNode = new Float64CachedScalarDivDivLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64CachedScalarDualNode = new Float64CachedScalarDivRemLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case REM: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64CachedScalarDualNode = new Float64CachedScalarRemAddLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64CachedScalarDualNode = new Float64CachedScalarRemSubLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64CachedScalarDualNode = new Float64CachedScalarRemMulLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64CachedScalarDualNode = new Float64CachedScalarRemDivLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64CachedScalarDualNode = new Float64CachedScalarRemRemLeftInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[0]) + " is invalid for for this unit");
            }
        }
        return float64CachedScalarDualNode;
    }

    private Float64CachedScalarDualNode generateRightInputNode(OperationCode[] operationCodeArray, Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
        Float64CachedScalarDualNode float64CachedScalarDualNode = null;
        block0 : switch (operationCodeArray[0]) {
            case ADD: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64CachedScalarDualNode = new Float64CachedScalarAddAddRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64CachedScalarDualNode = new Float64CachedScalarAddSubRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64CachedScalarDualNode = new Float64CachedScalarAddMulRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64CachedScalarDualNode = new Float64CachedScalarAddDivRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64CachedScalarDualNode = new Float64CachedScalarAddRemRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case SUB: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64CachedScalarDualNode = new Float64CachedScalarSubAddRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64CachedScalarDualNode = new Float64CachedScalarSubSubRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64CachedScalarDualNode = new Float64CachedScalarSubMulRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64CachedScalarDualNode = new Float64CachedScalarSubDivRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64CachedScalarDualNode = new Float64CachedScalarSubRemRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case MUL: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64CachedScalarDualNode = new Float64CachedScalarMulAddRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64CachedScalarDualNode = new Float64CachedScalarMulSubRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64CachedScalarDualNode = new Float64CachedScalarMulMulRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64CachedScalarDualNode = new Float64CachedScalarMulDivRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64CachedScalarDualNode = new Float64CachedScalarMulRemRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case DIV: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64CachedScalarDualNode = new Float64CachedScalarDivAddRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64CachedScalarDualNode = new Float64CachedScalarDivSubRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64CachedScalarDualNode = new Float64CachedScalarDivMulRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64CachedScalarDualNode = new Float64CachedScalarDivDivRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64CachedScalarDualNode = new Float64CachedScalarDivRemRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case REM: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64CachedScalarDualNode = new Float64CachedScalarRemAddRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64CachedScalarDualNode = new Float64CachedScalarRemSubRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64CachedScalarDualNode = new Float64CachedScalarRemMulRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64CachedScalarDualNode = new Float64CachedScalarRemDivRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64CachedScalarDualNode = new Float64CachedScalarRemRemRightInputNode(float64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[0]) + " is invalid for this unit");
            }
        }
        return float64CachedScalarDualNode;
    }

    static {
        AVAILABLE_OPERAND_SET.add(OperationCode.ADD);
        AVAILABLE_OPERAND_SET.add(OperationCode.SUB);
        AVAILABLE_OPERAND_SET.add(OperationCode.MUL);
        AVAILABLE_OPERAND_SET.add(OperationCode.DIV);
        AVAILABLE_OPERAND_SET.add(OperationCode.REM);
    }

    private abstract class Float64CachedScalarDualNode
    extends AcceleratorExecutionNode {
        protected final Float64ScalarCache cache00;
        protected final Float64ScalarCache cache01;
        protected final Float64ScalarCache cache02;
        protected final Float64ScalarCache cache10;
        protected final Float64ScalarCache cache11;
        protected final Float64ScalarCache cache12;

        public Float64CachedScalarDualNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.cache00 = float64ScalarCacheArray[0];
            this.cache01 = float64ScalarCacheArray[1];
            this.cache02 = float64ScalarCacheArray[2];
            this.cache10 = float64ScalarCacheArray[3];
            this.cache11 = float64ScalarCacheArray[4];
            this.cache12 = float64ScalarCacheArray[5];
        }
    }

    private final class Float64CachedScalarAddAddLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarAddAddLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache00.data + this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarAddSubLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarAddSubLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache00.data - this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarAddMulLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarAddMulLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache00.data * this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarAddDivLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarAddDivLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache00.data / this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarAddRemLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarAddRemLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache00.data % this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarSubAddLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarSubAddLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache00.data + this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarSubSubLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarSubSubLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache00.data - this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarSubMulLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarSubMulLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache00.data * this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarSubDivLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarSubDivLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache00.data / this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarSubRemLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarSubRemLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache00.data % this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarMulAddLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarMulAddLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache00.data + this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarMulSubLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarMulSubLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache00.data - this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarMulMulLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarMulMulLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache00.data * this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarMulDivLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarMulDivLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache00.data / this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarMulRemLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarMulRemLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache00.data % this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarDivAddLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarDivAddLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache00.data + this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarDivSubLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarDivSubLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache00.data - this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarDivMulLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarDivMulLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache00.data * this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarDivDivLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarDivDivLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache00.data / this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarDivRemLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarDivRemLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache00.data % this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarRemAddLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarRemAddLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache00.data + this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarRemSubLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarRemSubLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache00.data - this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarRemMulLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarRemMulLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache00.data * this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarRemDivLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarRemDivLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache00.data / this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarRemRemLeftInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarRemRemLeftInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache00.data % this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarAddAddRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarAddAddRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache11.data + this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarAddSubRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarAddSubRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache11.data - this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarAddMulRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarAddMulRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache11.data * this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarAddDivRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarAddDivRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache11.data / this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarAddRemRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarAddRemRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache11.data % this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarSubAddRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarSubAddRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache11.data + this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarSubSubRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarSubSubRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache11.data - this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarSubMulRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarSubMulRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache11.data * this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarSubDivRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarSubDivRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache11.data / this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarSubRemRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarSubRemRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache11.data % this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarMulAddRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarMulAddRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache11.data + this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarMulSubRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarMulSubRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache11.data - this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarMulMulRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarMulMulRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache11.data * this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarMulDivRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarMulDivRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache11.data / this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarMulRemRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarMulRemRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache11.data % this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarDivAddRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarDivAddRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache11.data + this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarDivSubRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarDivSubRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache11.data - this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarDivMulRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarDivMulRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache11.data * this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarDivDivRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarDivDivRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache11.data / this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarDivRemRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarDivRemRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache11.data % this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarRemAddRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarRemAddRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache11.data + this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarRemSubRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarRemSubRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache11.data - this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarRemMulRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarRemMulRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache11.data * this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarRemDivRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarRemDivRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache11.data / this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarRemRemRightInputNode
    extends Float64CachedScalarDualNode {
        public Float64CachedScalarRemRemRightInputNode(Float64ScalarCache[] float64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(float64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache11.data % this.cache00.data;
            return this.nextNode;
        }
    }
}

