/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import java.util.HashSet;
import java.util.Set;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Float64ScalarCache;
import org.vcssl.nano.vm.memory.DataContainer;

public class Float64CachedScalarMultipleTransferUnit
extends AcceleratorExecutionUnit {
    public static final Set<OperationCode> AVAILABLE_OPERAND_SET = new HashSet<OperationCode>();
    public static final int MAX_AVAILABLE_TRANSFER_COUNT = 10;

    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        AcceleratorExecutionNode acceleratorExecutionNode2 = null;
        OperationCode[] operationCodeArray = acceleratorInstruction.getFusedOperationCodes();
        boolean bl = true;
        for (OperationCode operationCode : operationCodeArray) {
            bl &= operationCode == OperationCode.MOV;
        }
        if (bl) {
            int n = dataContainerArray.length / 2;
            switch (n) {
                case 2: {
                    acceleratorExecutionNode2 = new Float64CachedScalarMovX2Node((Float64ScalarCache)objectArray[0], (Float64ScalarCache)objectArray[1], (Float64ScalarCache)objectArray[2], (Float64ScalarCache)objectArray[3], acceleratorExecutionNode);
                    break;
                }
                case 3: {
                    acceleratorExecutionNode2 = new Float64CachedScalarMovX3Node((Float64ScalarCache)objectArray[0], (Float64ScalarCache)objectArray[1], (Float64ScalarCache)objectArray[2], (Float64ScalarCache)objectArray[3], (Float64ScalarCache)objectArray[4], (Float64ScalarCache)objectArray[5], acceleratorExecutionNode);
                    break;
                }
                case 4: {
                    acceleratorExecutionNode2 = new Float64CachedScalarMovX4Node((Float64ScalarCache)objectArray[0], (Float64ScalarCache)objectArray[1], (Float64ScalarCache)objectArray[2], (Float64ScalarCache)objectArray[3], (Float64ScalarCache)objectArray[4], (Float64ScalarCache)objectArray[5], (Float64ScalarCache)objectArray[6], (Float64ScalarCache)objectArray[7], acceleratorExecutionNode);
                    break;
                }
                case 5: {
                    acceleratorExecutionNode2 = new Float64CachedScalarMovX5Node((Float64ScalarCache)objectArray[0], (Float64ScalarCache)objectArray[1], (Float64ScalarCache)objectArray[2], (Float64ScalarCache)objectArray[3], (Float64ScalarCache)objectArray[4], (Float64ScalarCache)objectArray[5], (Float64ScalarCache)objectArray[6], (Float64ScalarCache)objectArray[7], (Float64ScalarCache)objectArray[8], (Float64ScalarCache)objectArray[9], acceleratorExecutionNode);
                    break;
                }
                case 6: {
                    acceleratorExecutionNode2 = new Float64CachedScalarMovX6Node((Float64ScalarCache)objectArray[0], (Float64ScalarCache)objectArray[1], (Float64ScalarCache)objectArray[2], (Float64ScalarCache)objectArray[3], (Float64ScalarCache)objectArray[4], (Float64ScalarCache)objectArray[5], (Float64ScalarCache)objectArray[6], (Float64ScalarCache)objectArray[7], (Float64ScalarCache)objectArray[8], (Float64ScalarCache)objectArray[9], (Float64ScalarCache)objectArray[10], (Float64ScalarCache)objectArray[11], acceleratorExecutionNode);
                    break;
                }
                case 7: {
                    acceleratorExecutionNode2 = new Float64CachedScalarMovX7Node((Float64ScalarCache)objectArray[0], (Float64ScalarCache)objectArray[1], (Float64ScalarCache)objectArray[2], (Float64ScalarCache)objectArray[3], (Float64ScalarCache)objectArray[4], (Float64ScalarCache)objectArray[5], (Float64ScalarCache)objectArray[6], (Float64ScalarCache)objectArray[7], (Float64ScalarCache)objectArray[8], (Float64ScalarCache)objectArray[9], (Float64ScalarCache)objectArray[10], (Float64ScalarCache)objectArray[11], (Float64ScalarCache)objectArray[12], (Float64ScalarCache)objectArray[13], acceleratorExecutionNode);
                    break;
                }
                case 8: {
                    acceleratorExecutionNode2 = new Float64CachedScalarMovX8Node((Float64ScalarCache)objectArray[0], (Float64ScalarCache)objectArray[1], (Float64ScalarCache)objectArray[2], (Float64ScalarCache)objectArray[3], (Float64ScalarCache)objectArray[4], (Float64ScalarCache)objectArray[5], (Float64ScalarCache)objectArray[6], (Float64ScalarCache)objectArray[7], (Float64ScalarCache)objectArray[8], (Float64ScalarCache)objectArray[9], (Float64ScalarCache)objectArray[10], (Float64ScalarCache)objectArray[11], (Float64ScalarCache)objectArray[12], (Float64ScalarCache)objectArray[13], (Float64ScalarCache)objectArray[14], (Float64ScalarCache)objectArray[15], acceleratorExecutionNode);
                    break;
                }
                case 9: {
                    acceleratorExecutionNode2 = new Float64CachedScalarMovX9Node((Float64ScalarCache)objectArray[0], (Float64ScalarCache)objectArray[1], (Float64ScalarCache)objectArray[2], (Float64ScalarCache)objectArray[3], (Float64ScalarCache)objectArray[4], (Float64ScalarCache)objectArray[5], (Float64ScalarCache)objectArray[6], (Float64ScalarCache)objectArray[7], (Float64ScalarCache)objectArray[8], (Float64ScalarCache)objectArray[9], (Float64ScalarCache)objectArray[10], (Float64ScalarCache)objectArray[11], (Float64ScalarCache)objectArray[12], (Float64ScalarCache)objectArray[13], (Float64ScalarCache)objectArray[14], (Float64ScalarCache)objectArray[15], (Float64ScalarCache)objectArray[16], (Float64ScalarCache)objectArray[17], acceleratorExecutionNode);
                    break;
                }
                case 10: {
                    acceleratorExecutionNode2 = new Float64CachedScalarMovX10Node((Float64ScalarCache)objectArray[0], (Float64ScalarCache)objectArray[1], (Float64ScalarCache)objectArray[2], (Float64ScalarCache)objectArray[3], (Float64ScalarCache)objectArray[4], (Float64ScalarCache)objectArray[5], (Float64ScalarCache)objectArray[6], (Float64ScalarCache)objectArray[7], (Float64ScalarCache)objectArray[8], (Float64ScalarCache)objectArray[9], (Float64ScalarCache)objectArray[10], (Float64ScalarCache)objectArray[11], (Float64ScalarCache)objectArray[12], (Float64ScalarCache)objectArray[13], (Float64ScalarCache)objectArray[14], (Float64ScalarCache)objectArray[15], (Float64ScalarCache)objectArray[16], (Float64ScalarCache)objectArray[17], (Float64ScalarCache)objectArray[18], (Float64ScalarCache)objectArray[19], acceleratorExecutionNode);
                    break;
                }
                default: {
                    throw new VnanoFatalException("The plural transfer x" + n + " is not supported by " + this.getClass().getCanonicalName());
                }
            }
        } else {
            throw new VnanoFatalException("Unsupported fused operation codes has been detected in " + this.getClass().getCanonicalName());
        }
        return acceleratorExecutionNode2;
    }

    static {
        AVAILABLE_OPERAND_SET.add(OperationCode.MOV);
    }

    private class Float64CachedScalarMovX2Node
    extends AcceleratorExecutionNode {
        protected final Float64ScalarCache dest0;
        protected final Float64ScalarCache src0;
        protected final Float64ScalarCache dest1;
        protected final Float64ScalarCache src1;

        public Float64CachedScalarMovX2Node(Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, Float64ScalarCache float64ScalarCache3, Float64ScalarCache float64ScalarCache4, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.src0 = float64ScalarCache2;
            this.src1 = float64ScalarCache4;
            this.dest0 = float64ScalarCache;
            this.dest1 = float64ScalarCache3;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest0.data = this.src0.data;
            this.dest1.data = this.src1.data;
            return this.nextNode;
        }
    }

    private class Float64CachedScalarMovX3Node
    extends AcceleratorExecutionNode {
        protected final Float64ScalarCache dest0;
        protected final Float64ScalarCache src0;
        protected final Float64ScalarCache dest1;
        protected final Float64ScalarCache src1;
        protected final Float64ScalarCache dest2;
        protected final Float64ScalarCache src2;

        public Float64CachedScalarMovX3Node(Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, Float64ScalarCache float64ScalarCache3, Float64ScalarCache float64ScalarCache4, Float64ScalarCache float64ScalarCache5, Float64ScalarCache float64ScalarCache6, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 3);
            this.src0 = float64ScalarCache2;
            this.src1 = float64ScalarCache4;
            this.src2 = float64ScalarCache6;
            this.dest0 = float64ScalarCache;
            this.dest1 = float64ScalarCache3;
            this.dest2 = float64ScalarCache5;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest0.data = this.src0.data;
            this.dest1.data = this.src1.data;
            this.dest2.data = this.src2.data;
            return this.nextNode;
        }
    }

    private class Float64CachedScalarMovX4Node
    extends AcceleratorExecutionNode {
        protected final Float64ScalarCache dest0;
        protected final Float64ScalarCache src0;
        protected final Float64ScalarCache dest1;
        protected final Float64ScalarCache src1;
        protected final Float64ScalarCache dest2;
        protected final Float64ScalarCache src2;
        protected final Float64ScalarCache dest3;
        protected final Float64ScalarCache src3;

        public Float64CachedScalarMovX4Node(Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, Float64ScalarCache float64ScalarCache3, Float64ScalarCache float64ScalarCache4, Float64ScalarCache float64ScalarCache5, Float64ScalarCache float64ScalarCache6, Float64ScalarCache float64ScalarCache7, Float64ScalarCache float64ScalarCache8, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 4);
            this.src0 = float64ScalarCache2;
            this.src1 = float64ScalarCache4;
            this.src2 = float64ScalarCache6;
            this.src3 = float64ScalarCache8;
            this.dest0 = float64ScalarCache;
            this.dest1 = float64ScalarCache3;
            this.dest2 = float64ScalarCache5;
            this.dest3 = float64ScalarCache7;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest0.data = this.src0.data;
            this.dest1.data = this.src1.data;
            this.dest2.data = this.src2.data;
            this.dest3.data = this.src3.data;
            return this.nextNode;
        }
    }

    private class Float64CachedScalarMovX5Node
    extends AcceleratorExecutionNode {
        protected final Float64ScalarCache dest0;
        protected final Float64ScalarCache src0;
        protected final Float64ScalarCache dest1;
        protected final Float64ScalarCache src1;
        protected final Float64ScalarCache dest2;
        protected final Float64ScalarCache src2;
        protected final Float64ScalarCache dest3;
        protected final Float64ScalarCache src3;
        protected final Float64ScalarCache dest4;
        protected final Float64ScalarCache src4;

        public Float64CachedScalarMovX5Node(Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, Float64ScalarCache float64ScalarCache3, Float64ScalarCache float64ScalarCache4, Float64ScalarCache float64ScalarCache5, Float64ScalarCache float64ScalarCache6, Float64ScalarCache float64ScalarCache7, Float64ScalarCache float64ScalarCache8, Float64ScalarCache float64ScalarCache9, Float64ScalarCache float64ScalarCache10, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 5);
            this.src0 = float64ScalarCache2;
            this.src1 = float64ScalarCache4;
            this.src2 = float64ScalarCache6;
            this.src3 = float64ScalarCache8;
            this.src4 = float64ScalarCache10;
            this.dest0 = float64ScalarCache;
            this.dest1 = float64ScalarCache3;
            this.dest2 = float64ScalarCache5;
            this.dest3 = float64ScalarCache7;
            this.dest4 = float64ScalarCache9;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest0.data = this.src0.data;
            this.dest1.data = this.src1.data;
            this.dest2.data = this.src2.data;
            this.dest3.data = this.src3.data;
            this.dest4.data = this.src4.data;
            return this.nextNode;
        }
    }

    private class Float64CachedScalarMovX6Node
    extends AcceleratorExecutionNode {
        protected final Float64ScalarCache dest0;
        protected final Float64ScalarCache src0;
        protected final Float64ScalarCache dest1;
        protected final Float64ScalarCache src1;
        protected final Float64ScalarCache dest2;
        protected final Float64ScalarCache src2;
        protected final Float64ScalarCache dest3;
        protected final Float64ScalarCache src3;
        protected final Float64ScalarCache dest4;
        protected final Float64ScalarCache src4;
        protected final Float64ScalarCache dest5;
        protected final Float64ScalarCache src5;

        public Float64CachedScalarMovX6Node(Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, Float64ScalarCache float64ScalarCache3, Float64ScalarCache float64ScalarCache4, Float64ScalarCache float64ScalarCache5, Float64ScalarCache float64ScalarCache6, Float64ScalarCache float64ScalarCache7, Float64ScalarCache float64ScalarCache8, Float64ScalarCache float64ScalarCache9, Float64ScalarCache float64ScalarCache10, Float64ScalarCache float64ScalarCache11, Float64ScalarCache float64ScalarCache12, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 6);
            this.src0 = float64ScalarCache2;
            this.src1 = float64ScalarCache4;
            this.src2 = float64ScalarCache6;
            this.src3 = float64ScalarCache8;
            this.src4 = float64ScalarCache10;
            this.src5 = float64ScalarCache12;
            this.dest0 = float64ScalarCache;
            this.dest1 = float64ScalarCache3;
            this.dest2 = float64ScalarCache5;
            this.dest3 = float64ScalarCache7;
            this.dest4 = float64ScalarCache9;
            this.dest5 = float64ScalarCache11;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest0.data = this.src0.data;
            this.dest1.data = this.src1.data;
            this.dest2.data = this.src2.data;
            this.dest3.data = this.src3.data;
            this.dest4.data = this.src4.data;
            this.dest5.data = this.src5.data;
            return this.nextNode;
        }
    }

    private class Float64CachedScalarMovX7Node
    extends AcceleratorExecutionNode {
        protected final Float64ScalarCache dest0;
        protected final Float64ScalarCache src0;
        protected final Float64ScalarCache dest1;
        protected final Float64ScalarCache src1;
        protected final Float64ScalarCache dest2;
        protected final Float64ScalarCache src2;
        protected final Float64ScalarCache dest3;
        protected final Float64ScalarCache src3;
        protected final Float64ScalarCache dest4;
        protected final Float64ScalarCache src4;
        protected final Float64ScalarCache dest5;
        protected final Float64ScalarCache src5;
        protected final Float64ScalarCache dest6;
        protected final Float64ScalarCache src6;

        public Float64CachedScalarMovX7Node(Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, Float64ScalarCache float64ScalarCache3, Float64ScalarCache float64ScalarCache4, Float64ScalarCache float64ScalarCache5, Float64ScalarCache float64ScalarCache6, Float64ScalarCache float64ScalarCache7, Float64ScalarCache float64ScalarCache8, Float64ScalarCache float64ScalarCache9, Float64ScalarCache float64ScalarCache10, Float64ScalarCache float64ScalarCache11, Float64ScalarCache float64ScalarCache12, Float64ScalarCache float64ScalarCache13, Float64ScalarCache float64ScalarCache14, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 7);
            this.src0 = float64ScalarCache2;
            this.src1 = float64ScalarCache4;
            this.src2 = float64ScalarCache6;
            this.src3 = float64ScalarCache8;
            this.src4 = float64ScalarCache10;
            this.src5 = float64ScalarCache12;
            this.src6 = float64ScalarCache14;
            this.dest0 = float64ScalarCache;
            this.dest1 = float64ScalarCache3;
            this.dest2 = float64ScalarCache5;
            this.dest3 = float64ScalarCache7;
            this.dest4 = float64ScalarCache9;
            this.dest5 = float64ScalarCache11;
            this.dest6 = float64ScalarCache13;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest0.data = this.src0.data;
            this.dest1.data = this.src1.data;
            this.dest2.data = this.src2.data;
            this.dest3.data = this.src3.data;
            this.dest4.data = this.src4.data;
            this.dest5.data = this.src5.data;
            this.dest6.data = this.src6.data;
            return this.nextNode;
        }
    }

    private class Float64CachedScalarMovX8Node
    extends AcceleratorExecutionNode {
        protected final Float64ScalarCache dest0;
        protected final Float64ScalarCache src0;
        protected final Float64ScalarCache dest1;
        protected final Float64ScalarCache src1;
        protected final Float64ScalarCache dest2;
        protected final Float64ScalarCache src2;
        protected final Float64ScalarCache dest3;
        protected final Float64ScalarCache src3;
        protected final Float64ScalarCache dest4;
        protected final Float64ScalarCache src4;
        protected final Float64ScalarCache dest5;
        protected final Float64ScalarCache src5;
        protected final Float64ScalarCache dest6;
        protected final Float64ScalarCache src6;
        protected final Float64ScalarCache dest7;
        protected final Float64ScalarCache src7;

        public Float64CachedScalarMovX8Node(Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, Float64ScalarCache float64ScalarCache3, Float64ScalarCache float64ScalarCache4, Float64ScalarCache float64ScalarCache5, Float64ScalarCache float64ScalarCache6, Float64ScalarCache float64ScalarCache7, Float64ScalarCache float64ScalarCache8, Float64ScalarCache float64ScalarCache9, Float64ScalarCache float64ScalarCache10, Float64ScalarCache float64ScalarCache11, Float64ScalarCache float64ScalarCache12, Float64ScalarCache float64ScalarCache13, Float64ScalarCache float64ScalarCache14, Float64ScalarCache float64ScalarCache15, Float64ScalarCache float64ScalarCache16, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 8);
            this.src0 = float64ScalarCache2;
            this.src1 = float64ScalarCache4;
            this.src2 = float64ScalarCache6;
            this.src3 = float64ScalarCache8;
            this.src4 = float64ScalarCache10;
            this.src5 = float64ScalarCache12;
            this.src6 = float64ScalarCache14;
            this.src7 = float64ScalarCache16;
            this.dest0 = float64ScalarCache;
            this.dest1 = float64ScalarCache3;
            this.dest2 = float64ScalarCache5;
            this.dest3 = float64ScalarCache7;
            this.dest4 = float64ScalarCache9;
            this.dest5 = float64ScalarCache11;
            this.dest6 = float64ScalarCache13;
            this.dest7 = float64ScalarCache15;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest0.data = this.src0.data;
            this.dest1.data = this.src1.data;
            this.dest2.data = this.src2.data;
            this.dest3.data = this.src3.data;
            this.dest4.data = this.src4.data;
            this.dest5.data = this.src5.data;
            this.dest6.data = this.src6.data;
            this.dest7.data = this.src7.data;
            return this.nextNode;
        }
    }

    private class Float64CachedScalarMovX9Node
    extends AcceleratorExecutionNode {
        protected final Float64ScalarCache dest0;
        protected final Float64ScalarCache src0;
        protected final Float64ScalarCache dest1;
        protected final Float64ScalarCache src1;
        protected final Float64ScalarCache dest2;
        protected final Float64ScalarCache src2;
        protected final Float64ScalarCache dest3;
        protected final Float64ScalarCache src3;
        protected final Float64ScalarCache dest4;
        protected final Float64ScalarCache src4;
        protected final Float64ScalarCache dest5;
        protected final Float64ScalarCache src5;
        protected final Float64ScalarCache dest6;
        protected final Float64ScalarCache src6;
        protected final Float64ScalarCache dest7;
        protected final Float64ScalarCache src7;
        protected final Float64ScalarCache dest8;
        protected final Float64ScalarCache src8;

        public Float64CachedScalarMovX9Node(Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, Float64ScalarCache float64ScalarCache3, Float64ScalarCache float64ScalarCache4, Float64ScalarCache float64ScalarCache5, Float64ScalarCache float64ScalarCache6, Float64ScalarCache float64ScalarCache7, Float64ScalarCache float64ScalarCache8, Float64ScalarCache float64ScalarCache9, Float64ScalarCache float64ScalarCache10, Float64ScalarCache float64ScalarCache11, Float64ScalarCache float64ScalarCache12, Float64ScalarCache float64ScalarCache13, Float64ScalarCache float64ScalarCache14, Float64ScalarCache float64ScalarCache15, Float64ScalarCache float64ScalarCache16, Float64ScalarCache float64ScalarCache17, Float64ScalarCache float64ScalarCache18, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 9);
            this.src0 = float64ScalarCache2;
            this.src1 = float64ScalarCache4;
            this.src2 = float64ScalarCache6;
            this.src3 = float64ScalarCache8;
            this.src4 = float64ScalarCache10;
            this.src5 = float64ScalarCache12;
            this.src6 = float64ScalarCache14;
            this.src7 = float64ScalarCache16;
            this.src8 = float64ScalarCache18;
            this.dest0 = float64ScalarCache;
            this.dest1 = float64ScalarCache3;
            this.dest2 = float64ScalarCache5;
            this.dest3 = float64ScalarCache7;
            this.dest4 = float64ScalarCache9;
            this.dest5 = float64ScalarCache11;
            this.dest6 = float64ScalarCache13;
            this.dest7 = float64ScalarCache15;
            this.dest8 = float64ScalarCache17;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest0.data = this.src0.data;
            this.dest1.data = this.src1.data;
            this.dest2.data = this.src2.data;
            this.dest3.data = this.src3.data;
            this.dest4.data = this.src4.data;
            this.dest5.data = this.src5.data;
            this.dest6.data = this.src6.data;
            this.dest7.data = this.src7.data;
            this.dest8.data = this.src8.data;
            return this.nextNode;
        }
    }

    private class Float64CachedScalarMovX10Node
    extends AcceleratorExecutionNode {
        protected final Float64ScalarCache dest0;
        protected final Float64ScalarCache src0;
        protected final Float64ScalarCache dest1;
        protected final Float64ScalarCache src1;
        protected final Float64ScalarCache dest2;
        protected final Float64ScalarCache src2;
        protected final Float64ScalarCache dest3;
        protected final Float64ScalarCache src3;
        protected final Float64ScalarCache dest4;
        protected final Float64ScalarCache src4;
        protected final Float64ScalarCache dest5;
        protected final Float64ScalarCache src5;
        protected final Float64ScalarCache dest6;
        protected final Float64ScalarCache src6;
        protected final Float64ScalarCache dest7;
        protected final Float64ScalarCache src7;
        protected final Float64ScalarCache dest8;
        protected final Float64ScalarCache src8;
        protected final Float64ScalarCache dest9;
        protected final Float64ScalarCache src9;

        public Float64CachedScalarMovX10Node(Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, Float64ScalarCache float64ScalarCache3, Float64ScalarCache float64ScalarCache4, Float64ScalarCache float64ScalarCache5, Float64ScalarCache float64ScalarCache6, Float64ScalarCache float64ScalarCache7, Float64ScalarCache float64ScalarCache8, Float64ScalarCache float64ScalarCache9, Float64ScalarCache float64ScalarCache10, Float64ScalarCache float64ScalarCache11, Float64ScalarCache float64ScalarCache12, Float64ScalarCache float64ScalarCache13, Float64ScalarCache float64ScalarCache14, Float64ScalarCache float64ScalarCache15, Float64ScalarCache float64ScalarCache16, Float64ScalarCache float64ScalarCache17, Float64ScalarCache float64ScalarCache18, Float64ScalarCache float64ScalarCache19, Float64ScalarCache float64ScalarCache20, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 10);
            this.src0 = float64ScalarCache2;
            this.src1 = float64ScalarCache4;
            this.src2 = float64ScalarCache6;
            this.src3 = float64ScalarCache8;
            this.src4 = float64ScalarCache10;
            this.src5 = float64ScalarCache12;
            this.src6 = float64ScalarCache14;
            this.src7 = float64ScalarCache16;
            this.src8 = float64ScalarCache18;
            this.src9 = float64ScalarCache20;
            this.dest0 = float64ScalarCache;
            this.dest1 = float64ScalarCache3;
            this.dest2 = float64ScalarCache5;
            this.dest3 = float64ScalarCache7;
            this.dest4 = float64ScalarCache9;
            this.dest5 = float64ScalarCache11;
            this.dest6 = float64ScalarCache13;
            this.dest7 = float64ScalarCache15;
            this.dest8 = float64ScalarCache17;
            this.dest9 = float64ScalarCache19;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest0.data = this.src0.data;
            this.dest1.data = this.src1.data;
            this.dest2.data = this.src2.data;
            this.dest3.data = this.src3.data;
            this.dest4.data = this.src4.data;
            this.dest5.data = this.src5.data;
            this.dest6.data = this.src6.data;
            this.dest7.data = this.src7.data;
            this.dest8.data = this.src8.data;
            this.dest9.data = this.src9.data;
            return this.nextNode;
        }
    }
}

