/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Float64ScalarCache;
import org.vcssl.nano.vm.accelerator.Int64ScalarCache;
import org.vcssl.nano.vm.memory.DataContainer;

public class Float64CachedScalarSubscriptUnit
extends AcceleratorExecutionUnit {
    public static final int MAX_AVAILABLE_RANK = 3;

    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        AcceleratorExecutionNode acceleratorExecutionNode2 = null;
        int n = dataContainerArray.length - 2;
        boolean bl = blArray[0];
        switch (acceleratorInstruction.getOperationCode()) {
            case MOVELM: {
                if (n == 1) {
                    if (bl) {
                        acceleratorExecutionNode2 = new Float64FullCachedScalarMovelm1DNode((Float64ScalarCache)objectArray[0], dataContainerArray[1], (Int64ScalarCache)objectArray[2], acceleratorExecutionNode);
                        break;
                    }
                    acceleratorExecutionNode2 = new Float64SemiCachedScalarMovelm1DNode(dataContainerArray[0], dataContainerArray[1], (Int64ScalarCache)objectArray[2], acceleratorExecutionNode);
                    break;
                }
                if (n == 2) {
                    if (bl) {
                        acceleratorExecutionNode2 = new Float64FullCachedScalarMovelm2DNode((Float64ScalarCache)objectArray[0], dataContainerArray[1], (Int64ScalarCache)objectArray[2], (Int64ScalarCache)objectArray[3], acceleratorExecutionNode);
                        break;
                    }
                    acceleratorExecutionNode2 = new Float64SemiCachedScalarMovelm2DNode(dataContainerArray[0], dataContainerArray[1], (Int64ScalarCache)objectArray[2], (Int64ScalarCache)objectArray[3], acceleratorExecutionNode);
                    break;
                }
                if (n == 3) {
                    if (bl) {
                        acceleratorExecutionNode2 = new Float64FullCachedScalarMovelm3DNode((Float64ScalarCache)objectArray[0], dataContainerArray[1], (Int64ScalarCache)objectArray[2], (Int64ScalarCache)objectArray[3], (Int64ScalarCache)objectArray[4], acceleratorExecutionNode);
                        break;
                    }
                    acceleratorExecutionNode2 = new Float64SemiCachedScalarMovelm3DNode(dataContainerArray[0], dataContainerArray[1], (Int64ScalarCache)objectArray[2], (Int64ScalarCache)objectArray[3], (Int64ScalarCache)objectArray[4], acceleratorExecutionNode);
                    break;
                }
                throw new VnanoFatalException("Operands of a MOVELM instructions are too many for this unit (max: 3)");
            }
            case REFELM: {
                if (bl) {
                    throw new VnanoFatalException("Invalid cacheability setting detected for the dest operand of a REFELM instruction");
                }
                if (n == 1) {
                    acceleratorExecutionNode2 = new Float64SemiCachedScalarRefelm1DNode(dataContainerArray[0], dataContainerArray[1], (Int64ScalarCache)objectArray[2], acceleratorExecutionNode);
                    break;
                }
                if (n == 2) {
                    acceleratorExecutionNode2 = new Float64SemiCachedScalarRefelm2DNode(dataContainerArray[0], dataContainerArray[1], (Int64ScalarCache)objectArray[2], (Int64ScalarCache)objectArray[3], acceleratorExecutionNode);
                    break;
                }
                if (n == 3) {
                    acceleratorExecutionNode2 = new Float64SemiCachedScalarRefelm3DNode(dataContainerArray[0], dataContainerArray[1], (Int64ScalarCache)objectArray[2], (Int64ScalarCache)objectArray[3], (Int64ScalarCache)objectArray[4], acceleratorExecutionNode);
                    break;
                }
                throw new VnanoFatalException("Operands of a REFELM instructions are too many for this unit (max: 3)");
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return acceleratorExecutionNode2;
    }

    private final class Float64FullCachedScalarMovelm1DNode
    extends AcceleratorExecutionNode {
        protected final Float64ScalarCache dest;
        protected final DataContainer<double[]> src;
        protected final Int64ScalarCache index0;

        public Float64FullCachedScalarMovelm1DNode(Float64ScalarCache float64ScalarCache, DataContainer<double[]> dataContainer, Int64ScalarCache int64ScalarCache, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.dest = float64ScalarCache;
            this.src = dataContainer;
            this.index0 = int64ScalarCache;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest.data = this.src.getArrayData()[(int)this.index0.data];
            return this.nextNode;
        }
    }

    private final class Float64SemiCachedScalarMovelm1DNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<double[]> dest;
        protected final DataContainer<double[]> src;
        protected final Int64ScalarCache index0;

        public Float64SemiCachedScalarMovelm1DNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, Int64ScalarCache int64ScalarCache, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.dest = dataContainer;
            this.src = dataContainer2;
            this.index0 = int64ScalarCache;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest.getArrayData()[this.dest.getArrayOffset()] = this.src.getArrayData()[(int)this.index0.data];
            return this.nextNode;
        }
    }

    private final class Float64FullCachedScalarMovelm2DNode
    extends AcceleratorExecutionNode {
        protected final Float64ScalarCache dest;
        protected final DataContainer<double[]> src;
        protected final Int64ScalarCache index0;
        protected final Int64ScalarCache index1;

        public Float64FullCachedScalarMovelm2DNode(Float64ScalarCache float64ScalarCache, DataContainer<double[]> dataContainer, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.dest = float64ScalarCache;
            this.src = dataContainer;
            this.index0 = int64ScalarCache;
            this.index1 = int64ScalarCache2;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            int[] nArray = this.src.getArrayLengths();
            int n = nArray[1] * (int)this.index0.data + (int)this.index1.data;
            this.dest.data = this.src.getArrayData()[n];
            return this.nextNode;
        }
    }

    private final class Float64SemiCachedScalarMovelm2DNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<double[]> dest;
        protected final DataContainer<double[]> src;
        protected final Int64ScalarCache index0;
        protected final Int64ScalarCache index1;

        public Float64SemiCachedScalarMovelm2DNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.dest = dataContainer;
            this.src = dataContainer2;
            this.index0 = int64ScalarCache;
            this.index1 = int64ScalarCache2;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            int[] nArray = this.src.getArrayLengths();
            int n = nArray[1] * (int)this.index0.data + (int)this.index1.data;
            this.dest.getArrayData()[this.dest.getArrayOffset()] = this.src.getArrayData()[n];
            return this.nextNode;
        }
    }

    private final class Float64FullCachedScalarMovelm3DNode
    extends AcceleratorExecutionNode {
        protected final Float64ScalarCache dest;
        protected final DataContainer<double[]> src;
        protected final Int64ScalarCache index0;
        protected final Int64ScalarCache index1;
        protected final Int64ScalarCache index2;

        public Float64FullCachedScalarMovelm3DNode(Float64ScalarCache float64ScalarCache, DataContainer<double[]> dataContainer, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, Int64ScalarCache int64ScalarCache3, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.dest = float64ScalarCache;
            this.src = dataContainer;
            this.index0 = int64ScalarCache;
            this.index1 = int64ScalarCache2;
            this.index2 = int64ScalarCache3;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            int[] nArray = this.src.getArrayLengths();
            int n = nArray[1] * nArray[2] * (int)this.index0.data + nArray[2] * (int)this.index1.data + (int)this.index2.data;
            this.dest.data = this.src.getArrayData()[n];
            return this.nextNode;
        }
    }

    private final class Float64SemiCachedScalarMovelm3DNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<double[]> dest;
        protected final DataContainer<double[]> src;
        protected final Int64ScalarCache index0;
        protected final Int64ScalarCache index1;
        protected final Int64ScalarCache index2;

        public Float64SemiCachedScalarMovelm3DNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, Int64ScalarCache int64ScalarCache3, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.dest = dataContainer;
            this.src = dataContainer2;
            this.index0 = int64ScalarCache;
            this.index1 = int64ScalarCache2;
            this.index2 = int64ScalarCache3;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            int[] nArray = this.src.getArrayLengths();
            int n = nArray[1] * nArray[2] * (int)this.index0.data + nArray[2] * (int)this.index1.data + (int)this.index2.data;
            this.dest.getArrayData()[this.dest.getArrayOffset()] = this.src.getArrayData()[n];
            return this.nextNode;
        }
    }

    private final class Float64SemiCachedScalarRefelm1DNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<double[]> dest;
        protected final DataContainer<double[]> src;
        protected final Int64ScalarCache index0;

        public Float64SemiCachedScalarRefelm1DNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, Int64ScalarCache int64ScalarCache, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.dest = dataContainer;
            this.src = dataContainer2;
            this.index0 = int64ScalarCache;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest.setArrayData(this.src.getArrayData(), (int)this.index0.data, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            return this.nextNode;
        }
    }

    private final class Float64SemiCachedScalarRefelm2DNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<double[]> dest;
        protected final DataContainer<double[]> src;
        protected final Int64ScalarCache index0;
        protected final Int64ScalarCache index1;

        public Float64SemiCachedScalarRefelm2DNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.dest = dataContainer;
            this.src = dataContainer2;
            this.index0 = int64ScalarCache;
            this.index1 = int64ScalarCache2;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            int[] nArray = this.src.getArrayLengths();
            int n = nArray[1] * (int)this.index0.data + (int)this.index1.data;
            this.dest.setArrayData(this.src.getArrayData(), n, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            return this.nextNode;
        }
    }

    private final class Float64SemiCachedScalarRefelm3DNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<double[]> dest;
        protected final DataContainer<double[]> src;
        protected final Int64ScalarCache index0;
        protected final Int64ScalarCache index1;
        protected final Int64ScalarCache index2;

        public Float64SemiCachedScalarRefelm3DNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, Int64ScalarCache int64ScalarCache3, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.dest = dataContainer;
            this.src = dataContainer2;
            this.index0 = int64ScalarCache;
            this.index1 = int64ScalarCache2;
            this.index2 = int64ScalarCache3;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            int[] nArray = this.src.getArrayLengths();
            int n = nArray[1] * nArray[2] * (int)this.index0.data + nArray[2] * (int)this.index1.data + (int)this.index2.data;
            this.dest.setArrayData(this.src.getArrayData(), n, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            return this.nextNode;
        }
    }
}

