/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Float64ScalarCache;
import org.vcssl.nano.vm.accelerator.Int64ScalarCache;
import org.vcssl.nano.vm.memory.DataContainer;

public class Float64CachedScalarTransferUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        AcceleratorExecutionNode acceleratorExecutionNode2 = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case MOV: 
            case FILL: {
                acceleratorExecutionNode2 = new Float64CachedScalarMovNode((Float64ScalarCache)objectArray[0], (Float64ScalarCache)objectArray[1], acceleratorExecutionNode);
                break;
            }
            case CAST: {
                if (acceleratorInstruction.getDataTypes()[1] == DataType.FLOAT64) {
                    acceleratorExecutionNode2 = new Float64CachedScalarMovNode((Float64ScalarCache)objectArray[0], (Float64ScalarCache)objectArray[1], acceleratorExecutionNode);
                    break;
                }
                if (acceleratorInstruction.getDataTypes()[1] == DataType.INT64) {
                    acceleratorExecutionNode2 = new Float64FromInt64CachedScalarCastNode((Float64ScalarCache)objectArray[0], (Int64ScalarCache)objectArray[1], acceleratorExecutionNode);
                    break;
                }
                throw new VnanoFatalException((Object)((Object)acceleratorInstruction.getDataTypes()[1]) + "-type operand of " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " instruction is invalid for " + this.getClass().getCanonicalName());
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return acceleratorExecutionNode2;
    }

    private class Float64CachedScalarMovNode
    extends AcceleratorExecutionNode {
        protected final Float64ScalarCache cache0;
        protected final Float64ScalarCache cache1;

        public Float64CachedScalarMovNode(Float64ScalarCache float64ScalarCache, Float64ScalarCache float64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.cache0 = float64ScalarCache;
            this.cache1 = float64ScalarCache2;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = this.cache1.data;
            return this.nextNode;
        }
    }

    private class Float64FromInt64CachedScalarCastNode
    extends AcceleratorExecutionNode {
        protected final Float64ScalarCache cache0;
        protected final Int64ScalarCache cache1;

        public Float64FromInt64CachedScalarCastNode(Float64ScalarCache float64ScalarCache, Int64ScalarCache int64ScalarCache, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.cache0 = float64ScalarCache;
            this.cache1 = int64ScalarCache;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = this.cache1.data;
            return this.nextNode;
        }
    }
}

