/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Float64x3ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class Float64VectorDualArithmeticUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        DataContainer<?>[] dataContainerArray2 = dataContainerArray;
        Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer = new Float64x3ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
        OperationCode[] operationCodeArray = acceleratorInstruction.getFusedOperationCodes();
        int n = acceleratorInstruction.getFusedInputOperandIndices()[0];
        Float64VectorDualArithmeticNode float64VectorDualArithmeticNode = null;
        if (n == 1) {
            float64VectorDualArithmeticNode = this.generateLeftInputNode(operationCodeArray, dataContainerArray2, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        } else if (n == 2) {
            float64VectorDualArithmeticNode = this.generateRightInputNode(operationCodeArray, dataContainerArray2, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        } else {
            throw new VnanoFatalException("Invalid fused input operand index: " + n);
        }
        return float64VectorDualArithmeticNode;
    }

    private Float64VectorDualArithmeticNode generateLeftInputNode(OperationCode[] operationCodeArray, DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
        Float64VectorDualArithmeticNode float64VectorDualArithmeticNode = null;
        block0 : switch (operationCodeArray[0]) {
            case ADD: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64VectorDualArithmeticNode = new Float64VectorAddAddLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64VectorDualArithmeticNode = new Float64VectorAddSubLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64VectorDualArithmeticNode = new Float64VectorAddMulLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64VectorDualArithmeticNode = new Float64VectorAddDivLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64VectorDualArithmeticNode = new Float64VectorAddRemLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case SUB: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64VectorDualArithmeticNode = new Float64VectorSubAddLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64VectorDualArithmeticNode = new Float64VectorSubSubLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64VectorDualArithmeticNode = new Float64VectorSubMulLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64VectorDualArithmeticNode = new Float64VectorSubDivLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64VectorDualArithmeticNode = new Float64VectorSubRemLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case MUL: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64VectorDualArithmeticNode = new Float64VectorMulAddLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64VectorDualArithmeticNode = new Float64VectorMulSubLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64VectorDualArithmeticNode = new Float64VectorMulMulLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64VectorDualArithmeticNode = new Float64VectorMulDivLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64VectorDualArithmeticNode = new Float64VectorMulRemLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case DIV: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64VectorDualArithmeticNode = new Float64VectorDivAddLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64VectorDualArithmeticNode = new Float64VectorDivSubLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64VectorDualArithmeticNode = new Float64VectorDivMulLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64VectorDualArithmeticNode = new Float64VectorDivDivLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64VectorDualArithmeticNode = new Float64VectorDivRemLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case REM: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64VectorDualArithmeticNode = new Float64VectorRemAddLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64VectorDualArithmeticNode = new Float64VectorRemSubLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64VectorDualArithmeticNode = new Float64VectorRemMulLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64VectorDualArithmeticNode = new Float64VectorRemDivLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64VectorDualArithmeticNode = new Float64VectorRemRemLeftInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[0]) + " is invalid for for this unit");
            }
        }
        return float64VectorDualArithmeticNode;
    }

    private Float64VectorDualArithmeticNode generateRightInputNode(OperationCode[] operationCodeArray, DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
        Float64VectorDualArithmeticNode float64VectorDualArithmeticNode = null;
        block0 : switch (operationCodeArray[0]) {
            case ADD: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64VectorDualArithmeticNode = new Float64VectorAddAddRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64VectorDualArithmeticNode = new Float64VectorAddSubRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64VectorDualArithmeticNode = new Float64VectorAddMulRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64VectorDualArithmeticNode = new Float64VectorAddDivRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64VectorDualArithmeticNode = new Float64VectorAddRemRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case SUB: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64VectorDualArithmeticNode = new Float64VectorSubAddRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64VectorDualArithmeticNode = new Float64VectorSubSubRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64VectorDualArithmeticNode = new Float64VectorSubMulRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64VectorDualArithmeticNode = new Float64VectorSubDivRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64VectorDualArithmeticNode = new Float64VectorSubRemRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case MUL: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64VectorDualArithmeticNode = new Float64VectorMulAddRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64VectorDualArithmeticNode = new Float64VectorMulSubRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64VectorDualArithmeticNode = new Float64VectorMulMulRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64VectorDualArithmeticNode = new Float64VectorMulDivRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64VectorDualArithmeticNode = new Float64VectorMulRemRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case DIV: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64VectorDualArithmeticNode = new Float64VectorDivAddRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64VectorDualArithmeticNode = new Float64VectorDivSubRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64VectorDualArithmeticNode = new Float64VectorDivMulRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64VectorDualArithmeticNode = new Float64VectorDivDivRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64VectorDualArithmeticNode = new Float64VectorDivRemRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case REM: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        float64VectorDualArithmeticNode = new Float64VectorRemAddRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        float64VectorDualArithmeticNode = new Float64VectorRemSubRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        float64VectorDualArithmeticNode = new Float64VectorRemMulRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        float64VectorDualArithmeticNode = new Float64VectorRemDivRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        float64VectorDualArithmeticNode = new Float64VectorRemRemRightInputNode(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[0]) + " is invalid for this unit");
            }
        }
        return float64VectorDualArithmeticNode;
    }

    private abstract class Float64VectorDualArithmeticNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<double[]> container01;
        protected final DataContainer<double[]> container02;
        protected final DataContainer<double[]> container10;
        protected final DataContainer<double[]> container11;
        protected final DataContainer<double[]> container12;
        protected final Float64x3ScalarCacheSynchronizer synchronizer;

        public Float64VectorDualArithmeticNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.container01 = dataContainerArray[1];
            this.container02 = dataContainerArray[2];
            this.container10 = dataContainerArray[0];
            this.container11 = dataContainerArray[1];
            this.container12 = dataContainerArray[2];
            this.synchronizer = float64x3ScalarCacheSynchronizer;
        }
    }

    private final class Float64VectorAddAddLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorAddAddLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] + dArray2[i] + dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorAddSubLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorAddSubLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] + dArray2[i] - dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorAddMulLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorAddMulLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = (dArray[i] + dArray2[i]) * dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorAddDivLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorAddDivLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = (dArray[i] + dArray2[i]) / dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorAddRemLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorAddRemLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = (dArray[i] + dArray2[i]) % dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorSubAddLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorSubAddLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] - dArray2[i] + dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorSubSubLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorSubSubLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] - dArray2[i] - dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorSubMulLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorSubMulLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = (dArray[i] - dArray2[i]) * dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorSubDivLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorSubDivLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = (dArray[i] - dArray2[i]) / dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorSubRemLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorSubRemLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = (dArray[i] - dArray2[i]) % dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorMulAddLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorMulAddLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] * dArray2[i] + dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorMulSubLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorMulSubLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] * dArray2[i] - dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorMulMulLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorMulMulLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] * dArray2[i] * dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorMulDivLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorMulDivLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] * dArray2[i] / dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorMulRemLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorMulRemLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] * dArray2[i] % dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorDivAddLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorDivAddLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] / dArray2[i] + dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorDivSubLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorDivSubLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] / dArray2[i] - dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorDivMulLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorDivMulLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] / dArray2[i] * dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorDivDivLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorDivDivLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] / dArray2[i] / dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorDivRemLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorDivRemLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] / dArray2[i] % dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorRemAddLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorRemAddLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] % dArray2[i] + dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorRemSubLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorRemSubLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] % dArray2[i] - dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorRemMulLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorRemMulLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] % dArray2[i] * dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorRemDivLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorRemDivLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] % dArray2[i] / dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorRemRemLeftInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorRemRemLeftInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] % dArray2[i] % dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorAddAddRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorAddAddRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] + (dArray[i] + dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorAddSubRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorAddSubRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] - (dArray[i] + dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorAddMulRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorAddMulRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] * (dArray[i] + dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorAddDivRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorAddDivRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] / (dArray[i] + dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorAddRemRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorAddRemRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] % (dArray[i] + dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorSubAddRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorSubAddRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] + (dArray[i] - dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorSubSubRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorSubSubRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] - (dArray[i] - dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorSubMulRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorSubMulRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] * (dArray[i] - dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorSubDivRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorSubDivRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] / (dArray[i] - dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorSubRemRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorSubRemRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] % (dArray[i] - dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorMulAddRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorMulAddRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] + dArray[i] * dArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorMulSubRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorMulSubRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] - dArray[i] * dArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorMulMulRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorMulMulRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] * (dArray[i] * dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorMulDivRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorMulDivRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] / (dArray[i] * dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorMulRemRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorMulRemRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] % (dArray[i] * dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorDivAddRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorDivAddRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] + dArray[i] / dArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorDivSubRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorDivSubRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] - dArray[i] / dArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorDivMulRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorDivMulRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] * (dArray[i] / dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorDivDivRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorDivDivRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] / (dArray[i] / dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorDivRemRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorDivRemRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] % (dArray[i] / dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorRemAddRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorRemAddRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] + dArray[i] % dArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorRemSubRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorRemSubRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] - dArray[i] % dArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorRemMulRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorRemMulRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] * (dArray[i] % dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorRemDivRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorRemDivRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] / (dArray[i] % dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorRemRemRightInputNode
    extends Float64VectorDualArithmeticNode {
        public Float64VectorRemRemRightInputNode(DataContainer<double[]>[] dataContainerArray, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] % (dArray[i] % dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }
}

