/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import java.util.Arrays;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Float64x1Int64x1ScalarCacheSynchronizer;
import org.vcssl.nano.vm.accelerator.Float64x2ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class Float64VectorTransferUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        AcceleratorExecutionNode acceleratorExecutionNode2 = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case MOV: {
                Float64x2ScalarCacheSynchronizer float64x2ScalarCacheSynchronizer = new Float64x2ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                acceleratorExecutionNode2 = new Float64VectorMovNode(dataContainerArray[0], dataContainerArray[1], float64x2ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case CAST: {
                if (acceleratorInstruction.getDataTypes()[1] == DataType.FLOAT64) {
                    Float64x2ScalarCacheSynchronizer float64x2ScalarCacheSynchronizer = new Float64x2ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                    acceleratorExecutionNode2 = new Float64VectorMovNode(dataContainerArray[0], dataContainerArray[1], float64x2ScalarCacheSynchronizer, acceleratorExecutionNode);
                    break;
                }
                if (acceleratorInstruction.getDataTypes()[1] == DataType.INT64) {
                    Float64x1Int64x1ScalarCacheSynchronizer float64x1Int64x1ScalarCacheSynchronizer = new Float64x1Int64x1ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                    acceleratorExecutionNode2 = new Float64FromInt64VectorCastNode(dataContainerArray[0], dataContainerArray[1], float64x1Int64x1ScalarCacheSynchronizer, acceleratorExecutionNode);
                    break;
                }
                throw new VnanoFatalException((Object)((Object)acceleratorInstruction.getDataTypes()[1]) + "-type operand of " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " instruction is invalid for " + this.getClass().getCanonicalName());
            }
            case FILL: {
                Float64x2ScalarCacheSynchronizer float64x2ScalarCacheSynchronizer = new Float64x2ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                acceleratorExecutionNode2 = new Float64VectorFillNode(dataContainerArray[0], dataContainerArray[1], float64x2ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
        }
        return acceleratorExecutionNode2;
    }

    private final class Float64VectorMovNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<double[]> container0;
        protected final DataContainer<double[]> container1;
        protected final Float64x2ScalarCacheSynchronizer synchronizer;

        public Float64VectorMovNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, Float64x2ScalarCacheSynchronizer float64x2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.synchronizer = float64x2ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            double[] dArray = this.container0.getArrayData();
            double[] dArray2 = this.container1.getArrayData();
            int n = this.container0.getArraySize();
            System.arraycopy(dArray2, 0, dArray, 0, n);
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64FromInt64VectorCastNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<double[]> container0;
        protected final DataContainer<long[]> container1;
        protected final Float64x1Int64x1ScalarCacheSynchronizer synchronizer;

        public Float64FromInt64VectorCastNode(DataContainer<double[]> dataContainer, DataContainer<long[]> dataContainer2, Float64x1Int64x1ScalarCacheSynchronizer float64x1Int64x1ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.synchronizer = float64x1Int64x1ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            double[] dArray = this.container0.getArrayData();
            long[] lArray = this.container1.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray[i] = lArray[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorFillNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<double[]> container0;
        protected final DataContainer<double[]> container1;
        protected final Float64x2ScalarCacheSynchronizer synchronizer;

        public Float64VectorFillNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, Float64x2ScalarCacheSynchronizer float64x2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.synchronizer = float64x2ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            double[] dArray = this.container0.getArrayData();
            double d = this.container1.getArrayData()[this.container1.getArrayOffset()];
            Arrays.fill(dArray, d);
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }
}

