/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.accelerator.BoolScalarCache;
import org.vcssl.nano.vm.accelerator.CacheSynchronizer;
import org.vcssl.nano.vm.accelerator.Float64ScalarCache;
import org.vcssl.nano.vm.accelerator.Int64ScalarCache;
import org.vcssl.nano.vm.accelerator.NoneCache;
import org.vcssl.nano.vm.memory.DataContainer;

public class GeneralScalarCacheSynchronizer
extends CacheSynchronizer {
    private final DataContainer<?>[] containers;
    private final Object[] caches;
    private final boolean[] cacheSyncEnabled;

    public GeneralScalarCacheSynchronizer(DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray) {
        this.containers = dataContainerArray;
        this.caches = objectArray;
        this.cacheSyncEnabled = blArray;
    }

    @Override
    public final void synchronizeFromCacheToMemory() {
        int n = this.containers.length;
        for (int i = 0; i < n; ++i) {
            if (!this.cacheSyncEnabled[i]) continue;
            if (this.caches[i] instanceof Int64ScalarCache) {
                ((long[])this.containers[i].getArrayData())[this.containers[i].getArrayOffset()] = ((Int64ScalarCache)this.caches[i]).data;
                continue;
            }
            if (this.caches[i] instanceof Float64ScalarCache) {
                ((double[])this.containers[i].getArrayData())[this.containers[i].getArrayOffset()] = ((Float64ScalarCache)this.caches[i]).data;
                continue;
            }
            if (this.caches[i] instanceof BoolScalarCache) {
                ((boolean[])this.containers[i].getArrayData())[this.containers[i].getArrayOffset()] = ((BoolScalarCache)this.caches[i]).data;
                continue;
            }
            if (this.caches[i] instanceof NoneCache) continue;
            throw new VnanoFatalException("Unknown Cache Type: " + this.caches[1]);
        }
    }

    @Override
    public final void synchronizeFromMemoryToCache() {
        int n = this.containers.length;
        for (int i = 0; i < n; ++i) {
            if (!this.cacheSyncEnabled[i]) continue;
            if (this.caches[i] instanceof Int64ScalarCache) {
                ((Int64ScalarCache)this.caches[i]).data = ((long[])this.containers[i].getArrayData())[this.containers[i].getArrayOffset()];
                continue;
            }
            if (this.caches[i] instanceof Float64ScalarCache) {
                ((Float64ScalarCache)this.caches[i]).data = ((double[])this.containers[i].getArrayData())[this.containers[i].getArrayOffset()];
                continue;
            }
            if (this.caches[i] instanceof BoolScalarCache) {
                ((BoolScalarCache)this.caches[i]).data = ((boolean[])this.containers[i].getArrayData())[this.containers[i].getArrayOffset()];
                continue;
            }
            if (this.caches[i] instanceof NoneCache) continue;
            throw new VnanoFatalException("Unknown Cache Type: " + this.caches[1]);
        }
    }
}

