/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Int64ScalarCache;
import org.vcssl.nano.vm.memory.DataContainer;

public class Int64CachedScalarArithmeticUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        int n = objectArray.length;
        Int64ScalarCache[] int64ScalarCacheArray = new Int64ScalarCache[n];
        for (int i = 0; i < n; ++i) {
            int64ScalarCacheArray[i] = (Int64ScalarCache)objectArray[i];
        }
        Int64CachedScalarArithmeticNode int64CachedScalarArithmeticNode = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case ADD: {
                if (dataContainerArray[0] == dataContainerArray[1] && blArray3[2]) {
                    long l = ((long[])dataContainerArray[2].getArrayData())[dataContainerArray[2].getArrayOffset()];
                    if (l == 1L) {
                        int64CachedScalarArithmeticNode = new Int64CachedScalarIncrementUnit(int64ScalarCacheArray[0], acceleratorExecutionNode);
                        break;
                    }
                    int64CachedScalarArithmeticNode = new Int64CachedScalarConstantAddUnit(int64ScalarCacheArray[0], l, acceleratorExecutionNode);
                    break;
                }
                int64CachedScalarArithmeticNode = new Int64CachedScalarAddUnit(int64ScalarCacheArray[0], int64ScalarCacheArray[1], int64ScalarCacheArray[2], acceleratorExecutionNode);
                break;
            }
            case SUB: {
                if (dataContainerArray[0] == dataContainerArray[1] && blArray3[2]) {
                    long l = ((long[])dataContainerArray[2].getArrayData())[dataContainerArray[2].getArrayOffset()];
                    if (l == 1L) {
                        int64CachedScalarArithmeticNode = new Int64CachedScalarDecrementUnit(int64ScalarCacheArray[0], acceleratorExecutionNode);
                        break;
                    }
                    int64CachedScalarArithmeticNode = new Int64CachedScalarConstantSubUnit(int64ScalarCacheArray[0], l, acceleratorExecutionNode);
                    break;
                }
                int64CachedScalarArithmeticNode = new Int64CachedScalarSubUnit(int64ScalarCacheArray[0], int64ScalarCacheArray[1], int64ScalarCacheArray[2], acceleratorExecutionNode);
                break;
            }
            case MUL: {
                int64CachedScalarArithmeticNode = new Int64CachedScalarMulUnit(int64ScalarCacheArray[0], int64ScalarCacheArray[1], int64ScalarCacheArray[2], acceleratorExecutionNode);
                break;
            }
            case DIV: {
                int64CachedScalarArithmeticNode = new Int64CachedScalarDivUnit(int64ScalarCacheArray[0], int64ScalarCacheArray[1], int64ScalarCacheArray[2], acceleratorExecutionNode);
                break;
            }
            case REM: {
                int64CachedScalarArithmeticNode = new Int64CachedScalarRemUnit(int64ScalarCacheArray[0], int64ScalarCacheArray[1], int64ScalarCacheArray[2], acceleratorExecutionNode);
                break;
            }
            case NEG: {
                int64CachedScalarArithmeticNode = new Int64CachedScalarNegUnit(int64ScalarCacheArray[0], int64ScalarCacheArray[1], acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return int64CachedScalarArithmeticNode;
    }

    private final class Int64CachedScalarIncrementUnit
    extends Int64CachedScalarArithmeticNode {
        public Int64CachedScalarIncrementUnit(Int64ScalarCache int64ScalarCache, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCache, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            ++this.cache0.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarConstantAddUnit
    extends Int64CachedScalarArithmeticNode {
        private final long diff;

        public Int64CachedScalarConstantAddUnit(Int64ScalarCache int64ScalarCache, long l, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCache, acceleratorExecutionNode);
            this.diff = l;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data += this.diff;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarAddUnit
    extends Int64CachedScalarArithmeticNode {
        public Int64CachedScalarAddUnit(Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, Int64ScalarCache int64ScalarCache3, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCache, int64ScalarCache2, int64ScalarCache3, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = this.cache1.data + this.cache2.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarDecrementUnit
    extends Int64CachedScalarArithmeticNode {
        public Int64CachedScalarDecrementUnit(Int64ScalarCache int64ScalarCache, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCache, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            --this.cache0.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarConstantSubUnit
    extends Int64CachedScalarArithmeticNode {
        private final long diff;

        public Int64CachedScalarConstantSubUnit(Int64ScalarCache int64ScalarCache, long l, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCache, acceleratorExecutionNode);
            this.diff = l;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data -= this.diff;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarSubUnit
    extends Int64CachedScalarArithmeticNode {
        public Int64CachedScalarSubUnit(Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, Int64ScalarCache int64ScalarCache3, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCache, int64ScalarCache2, int64ScalarCache3, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = this.cache1.data - this.cache2.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarMulUnit
    extends Int64CachedScalarArithmeticNode {
        public Int64CachedScalarMulUnit(Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, Int64ScalarCache int64ScalarCache3, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCache, int64ScalarCache2, int64ScalarCache3, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = this.cache1.data * this.cache2.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarDivUnit
    extends Int64CachedScalarArithmeticNode {
        public Int64CachedScalarDivUnit(Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, Int64ScalarCache int64ScalarCache3, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCache, int64ScalarCache2, int64ScalarCache3, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = this.cache1.data / this.cache2.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarRemUnit
    extends Int64CachedScalarArithmeticNode {
        public Int64CachedScalarRemUnit(Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, Int64ScalarCache int64ScalarCache3, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCache, int64ScalarCache2, int64ScalarCache3, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = this.cache1.data % this.cache2.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarNegUnit
    extends Int64CachedScalarArithmeticNode {
        public Int64CachedScalarNegUnit(Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCache, int64ScalarCache2, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = -this.cache1.data;
            return this.nextNode;
        }
    }

    private abstract class Int64CachedScalarArithmeticNode
    extends AcceleratorExecutionNode {
        protected final Int64ScalarCache cache0;
        protected final Int64ScalarCache cache1;
        protected final Int64ScalarCache cache2;

        public Int64CachedScalarArithmeticNode(Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, Int64ScalarCache int64ScalarCache3, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.cache0 = int64ScalarCache;
            this.cache1 = int64ScalarCache2;
            this.cache2 = int64ScalarCache3;
        }

        public Int64CachedScalarArithmeticNode(Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.cache0 = int64ScalarCache;
            this.cache1 = int64ScalarCache2;
            this.cache2 = null;
        }

        public Int64CachedScalarArithmeticNode(Int64ScalarCache int64ScalarCache, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.cache0 = int64ScalarCache;
            this.cache1 = null;
            this.cache2 = null;
        }
    }
}

