/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Int64x2ScalarCacheSynchronizer;
import org.vcssl.nano.vm.accelerator.Int64x3ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class Int64ScalarArithmeticUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        DataContainer<?>[] dataContainerArray2 = dataContainerArray;
        Int64x2ScalarCacheSynchronizer int64x2ScalarCacheSynchronizer = null;
        Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer = null;
        if (dataContainerArray.length == 2) {
            int64x2ScalarCacheSynchronizer = new Int64x2ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
        } else if (dataContainerArray.length == 3) {
            int64x3ScalarCacheSynchronizer = new Int64x3ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
        } else {
            throw new VnanoFatalException("Unexpected number of operands detected.");
        }
        Int64ScalarArithmeticNode int64ScalarArithmeticNode = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case ADD: {
                int64ScalarArithmeticNode = new Int64ScalarAddNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case SUB: {
                int64ScalarArithmeticNode = new Int64ScalarSubNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case MUL: {
                int64ScalarArithmeticNode = new Int64ScalarMulNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case DIV: {
                int64ScalarArithmeticNode = new Int64ScalarDivNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case REM: {
                int64ScalarArithmeticNode = new Int64ScalarRemNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case NEG: {
                int64ScalarArithmeticNode = new Int64ScalarNegNode(dataContainerArray2[0], dataContainerArray2[1], int64x2ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return int64ScalarArithmeticNode;
    }

    private final class Int64ScalarAddNode
    extends Int64ScalarArithmeticNode {
        public Int64ScalarAddNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerI64x3.synchronizeFromCacheToMemory();
            ((long[])this.container0.getArrayData())[this.container0.getArrayOffset()] = ((long[])this.container1.getArrayData())[this.container1.getArrayOffset()] + ((long[])this.container2.getArrayData())[this.container2.getArrayOffset()];
            this.synchronizerI64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64ScalarSubNode
    extends Int64ScalarArithmeticNode {
        public Int64ScalarSubNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerI64x3.synchronizeFromCacheToMemory();
            ((long[])this.container0.getArrayData())[this.container0.getArrayOffset()] = ((long[])this.container1.getArrayData())[this.container1.getArrayOffset()] - ((long[])this.container2.getArrayData())[this.container2.getArrayOffset()];
            this.synchronizerI64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64ScalarMulNode
    extends Int64ScalarArithmeticNode {
        public Int64ScalarMulNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerI64x3.synchronizeFromCacheToMemory();
            ((long[])this.container0.getArrayData())[this.container0.getArrayOffset()] = ((long[])this.container1.getArrayData())[this.container1.getArrayOffset()] * ((long[])this.container2.getArrayData())[this.container2.getArrayOffset()];
            this.synchronizerI64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64ScalarDivNode
    extends Int64ScalarArithmeticNode {
        public Int64ScalarDivNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerI64x3.synchronizeFromCacheToMemory();
            ((long[])this.container0.getArrayData())[this.container0.getArrayOffset()] = ((long[])this.container1.getArrayData())[this.container1.getArrayOffset()] / ((long[])this.container2.getArrayData())[this.container2.getArrayOffset()];
            this.synchronizerI64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64ScalarRemNode
    extends Int64ScalarArithmeticNode {
        public Int64ScalarRemNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerI64x3.synchronizeFromCacheToMemory();
            ((long[])this.container0.getArrayData())[this.container0.getArrayOffset()] = ((long[])this.container1.getArrayData())[this.container1.getArrayOffset()] % ((long[])this.container2.getArrayData())[this.container2.getArrayOffset()];
            this.synchronizerI64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64ScalarNegNode
    extends Int64ScalarArithmeticNode {
        public Int64ScalarNegNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, Int64x2ScalarCacheSynchronizer int64x2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, int64x2ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerI64x2.synchronizeFromCacheToMemory();
            ((long[])this.container0.getArrayData())[this.container0.getArrayOffset()] = -((long[])this.container1.getArrayData())[this.container1.getArrayOffset()];
            this.synchronizerI64x2.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private abstract class Int64ScalarArithmeticNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<long[]> container0;
        protected final DataContainer<long[]> container1;
        protected final DataContainer<long[]> container2;
        protected final Int64x3ScalarCacheSynchronizer synchronizerI64x3;
        protected final Int64x2ScalarCacheSynchronizer synchronizerI64x2;

        public Int64ScalarArithmeticNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.container2 = dataContainer3;
            this.synchronizerI64x2 = null;
            this.synchronizerI64x3 = int64x3ScalarCacheSynchronizer;
        }

        public Int64ScalarArithmeticNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, Int64x2ScalarCacheSynchronizer int64x2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.container2 = null;
            this.synchronizerI64x2 = int64x2ScalarCacheSynchronizer;
            this.synchronizerI64x3 = null;
        }
    }
}

