/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Int64x1ScalarCacheSynchronizer;
import org.vcssl.nano.vm.accelerator.Int64x2ScalarCacheSynchronizer;
import org.vcssl.nano.vm.accelerator.Int64x3ScalarCacheSynchronizer;
import org.vcssl.nano.vm.accelerator.Int64x4ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class Int64ScalarSubscriptUnit
extends AcceleratorExecutionUnit {
    public static final int MAX_AVAILABLE_RANK = 3;

    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        AcceleratorExecutionNode acceleratorExecutionNode2 = null;
        int n = dataContainerArray.length - 2;
        switch (acceleratorInstruction.getOperationCode()) {
            case MOVELM: {
                if (n == 1) {
                    Int64x2ScalarCacheSynchronizer int64x2ScalarCacheSynchronizer = new Int64x2ScalarCacheSynchronizer(new DataContainer[]{dataContainerArray[0], dataContainerArray[2]}, new Object[]{objectArray[0], objectArray[2]}, new boolean[]{blArray[0], blArray[2]});
                    acceleratorExecutionNode2 = new Int64ScalarMovelm1DNode(dataContainerArray[0], dataContainerArray[1], dataContainerArray[2], int64x2ScalarCacheSynchronizer, acceleratorExecutionNode);
                    break;
                }
                if (n == 2) {
                    Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer = new Int64x3ScalarCacheSynchronizer(new DataContainer[]{dataContainerArray[0], dataContainerArray[2], dataContainerArray[3]}, new Object[]{objectArray[0], objectArray[2], objectArray[3]}, new boolean[]{blArray[0], blArray[2], blArray[3]});
                    acceleratorExecutionNode2 = new Int64ScalarMovelm2DNode(dataContainerArray[0], dataContainerArray[1], dataContainerArray[2], dataContainerArray[3], int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                    break;
                }
                if (n == 3) {
                    Int64x4ScalarCacheSynchronizer int64x4ScalarCacheSynchronizer = new Int64x4ScalarCacheSynchronizer(new DataContainer[]{dataContainerArray[0], dataContainerArray[2], dataContainerArray[3], dataContainerArray[4]}, new Object[]{objectArray[0], objectArray[2], objectArray[3], objectArray[4]}, new boolean[]{blArray[0], blArray[2], blArray[3], blArray[4]});
                    acceleratorExecutionNode2 = new Int64ScalarMovelm3DNode(dataContainerArray[0], dataContainerArray[1], dataContainerArray[2], dataContainerArray[3], dataContainerArray[4], int64x4ScalarCacheSynchronizer, acceleratorExecutionNode);
                    break;
                }
                throw new VnanoFatalException("Operands of a MOVELM instructions are too many for this unit (max: 3)");
            }
            case REFELM: {
                if (n == 1) {
                    Int64x1ScalarCacheSynchronizer int64x1ScalarCacheSynchronizer = new Int64x1ScalarCacheSynchronizer(new DataContainer[]{dataContainerArray[2]}, new Object[]{objectArray[2]}, new boolean[]{blArray[2]});
                    acceleratorExecutionNode2 = new Int64ScalarRefelm1DNode(dataContainerArray[0], dataContainerArray[1], dataContainerArray[2], int64x1ScalarCacheSynchronizer, acceleratorExecutionNode);
                    break;
                }
                if (n == 2) {
                    Int64x2ScalarCacheSynchronizer int64x2ScalarCacheSynchronizer = new Int64x2ScalarCacheSynchronizer(new DataContainer[]{dataContainerArray[2], dataContainerArray[3]}, new Object[]{objectArray[2], objectArray[3]}, new boolean[]{blArray[2], blArray[3]});
                    acceleratorExecutionNode2 = new Int64ScalarRefelm2DNode(dataContainerArray[0], dataContainerArray[1], dataContainerArray[2], dataContainerArray[3], int64x2ScalarCacheSynchronizer, acceleratorExecutionNode);
                    break;
                }
                if (n == 3) {
                    Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer = new Int64x3ScalarCacheSynchronizer(new DataContainer[]{dataContainerArray[2], dataContainerArray[3], dataContainerArray[4]}, new Object[]{objectArray[2], objectArray[3], objectArray[4]}, new boolean[]{blArray[2], blArray[3], blArray[4]});
                    acceleratorExecutionNode2 = new Int64ScalarRefelm3DNode(dataContainerArray[0], dataContainerArray[1], dataContainerArray[2], dataContainerArray[3], dataContainerArray[4], int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                    break;
                }
                throw new VnanoFatalException("Operands of a REFELM instructions are too many for this unit (max: 3)");
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return acceleratorExecutionNode2;
    }

    private final class Int64ScalarMovelm1DNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<long[]> dest;
        protected final DataContainer<long[]> src;
        protected final DataContainer<long[]> index0;
        protected final Int64x2ScalarCacheSynchronizer synchronizer;

        public Int64ScalarMovelm1DNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x2ScalarCacheSynchronizer int64x2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.dest = dataContainer;
            this.src = dataContainer2;
            this.index0 = dataContainer3;
            this.synchronizer = int64x2ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            int n = (int)this.index0.getArrayData()[this.index0.getArrayOffset()];
            this.dest.getArrayData()[this.dest.getArrayOffset()] = this.src.getArrayData()[n];
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64ScalarMovelm2DNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<long[]> dest;
        protected final DataContainer<long[]> src;
        protected final DataContainer<long[]> index0;
        protected final DataContainer<long[]> index1;
        protected final Int64x3ScalarCacheSynchronizer synchronizer;

        public Int64ScalarMovelm2DNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, DataContainer<long[]> dataContainer4, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.dest = dataContainer;
            this.src = dataContainer2;
            this.index0 = dataContainer3;
            this.index1 = dataContainer4;
            this.synchronizer = int64x3ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            int[] nArray = this.src.getArrayLengths();
            int n = (int)this.index0.getArrayData()[this.index0.getArrayOffset()];
            int n2 = (int)this.index1.getArrayData()[this.index1.getArrayOffset()];
            int n3 = nArray[1] * n + n2;
            this.dest.getArrayData()[this.dest.getArrayOffset()] = this.src.getArrayData()[n3];
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64ScalarMovelm3DNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<long[]> dest;
        protected final DataContainer<long[]> src;
        protected final DataContainer<long[]> index0;
        protected final DataContainer<long[]> index1;
        protected final DataContainer<long[]> index2;
        protected final Int64x4ScalarCacheSynchronizer synchronizer;

        public Int64ScalarMovelm3DNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, DataContainer<long[]> dataContainer4, DataContainer<long[]> dataContainer5, Int64x4ScalarCacheSynchronizer int64x4ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.dest = dataContainer;
            this.src = dataContainer2;
            this.index0 = dataContainer3;
            this.index1 = dataContainer4;
            this.index2 = dataContainer5;
            this.synchronizer = int64x4ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            int[] nArray = this.src.getArrayLengths();
            int n = (int)this.index0.getArrayData()[this.index0.getArrayOffset()];
            int n2 = (int)this.index1.getArrayData()[this.index1.getArrayOffset()];
            int n3 = (int)this.index2.getArrayData()[this.index2.getArrayOffset()];
            int n4 = nArray[1] * nArray[2] * n + nArray[2] * n2 + n3;
            this.dest.getArrayData()[this.dest.getArrayOffset()] = this.src.getArrayData()[n4];
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64ScalarRefelm1DNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<long[]> dest;
        protected final DataContainer<long[]> src;
        protected final DataContainer<long[]> index0;
        protected final Int64x1ScalarCacheSynchronizer synchronizer;

        public Int64ScalarRefelm1DNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x1ScalarCacheSynchronizer int64x1ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.dest = dataContainer;
            this.src = dataContainer2;
            this.index0 = dataContainer3;
            this.synchronizer = int64x1ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            int n = (int)this.index0.getArrayData()[this.index0.getArrayOffset()];
            this.dest.setArrayData(this.src.getArrayData(), n, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64ScalarRefelm2DNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<long[]> dest;
        protected final DataContainer<long[]> src;
        protected final DataContainer<long[]> index0;
        protected final DataContainer<long[]> index1;
        protected final Int64x2ScalarCacheSynchronizer synchronizer;

        public Int64ScalarRefelm2DNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, DataContainer<long[]> dataContainer4, Int64x2ScalarCacheSynchronizer int64x2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.dest = dataContainer;
            this.src = dataContainer2;
            this.index0 = dataContainer3;
            this.index1 = dataContainer4;
            this.synchronizer = int64x2ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            int[] nArray = this.src.getArrayLengths();
            int n = (int)this.index0.getArrayData()[this.index0.getArrayOffset()];
            int n2 = (int)this.index1.getArrayData()[this.index1.getArrayOffset()];
            int n3 = nArray[1] * n + n2;
            this.dest.setArrayData(this.src.getArrayData(), n3, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64ScalarRefelm3DNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<long[]> dest;
        protected final DataContainer<long[]> src;
        protected final DataContainer<long[]> index0;
        protected final DataContainer<long[]> index1;
        protected final DataContainer<long[]> index2;
        protected final Int64x3ScalarCacheSynchronizer synchronizer;

        public Int64ScalarRefelm3DNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, DataContainer<long[]> dataContainer4, DataContainer<long[]> dataContainer5, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.dest = dataContainer;
            this.src = dataContainer2;
            this.index0 = dataContainer3;
            this.index1 = dataContainer4;
            this.index2 = dataContainer5;
            this.synchronizer = int64x3ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            int[] nArray = this.src.getArrayLengths();
            int n = (int)this.index0.getArrayData()[this.index0.getArrayOffset()];
            int n2 = (int)this.index1.getArrayData()[this.index1.getArrayOffset()];
            int n3 = (int)this.index2.getArrayData()[this.index2.getArrayOffset()];
            int n4 = nArray[1] * nArray[2] * n + nArray[2] * n2 + n3;
            this.dest.setArrayData(this.src.getArrayData(), n4, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }
}

