/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Int64x1Float64x1ScalarCacheSynchronizer;
import org.vcssl.nano.vm.accelerator.Int64x2ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class Int64ScalarTransferUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        AcceleratorExecutionNode acceleratorExecutionNode2 = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case MOV: 
            case FILL: {
                Int64x2ScalarCacheSynchronizer int64x2ScalarCacheSynchronizer = new Int64x2ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                acceleratorExecutionNode2 = new Int64ScalarMovNode(dataContainerArray[0], dataContainerArray[1], int64x2ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case CAST: {
                if (acceleratorInstruction.getDataTypes()[1] == DataType.INT64) {
                    Int64x2ScalarCacheSynchronizer int64x2ScalarCacheSynchronizer = new Int64x2ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                    acceleratorExecutionNode2 = new Int64ScalarMovNode(dataContainerArray[0], dataContainerArray[1], int64x2ScalarCacheSynchronizer, acceleratorExecutionNode);
                    break;
                }
                if (acceleratorInstruction.getDataTypes()[1] == DataType.FLOAT64) {
                    Int64x1Float64x1ScalarCacheSynchronizer int64x1Float64x1ScalarCacheSynchronizer = new Int64x1Float64x1ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                    acceleratorExecutionNode2 = new Int64FromFloat64ScalarCastNode(dataContainerArray[0], dataContainerArray[1], int64x1Float64x1ScalarCacheSynchronizer, acceleratorExecutionNode);
                    break;
                }
                throw new VnanoFatalException((Object)((Object)acceleratorInstruction.getDataTypes()[1]) + "-type operand of " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " instruction is invalid for " + this.getClass().getCanonicalName());
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return acceleratorExecutionNode2;
    }

    private final class Int64ScalarMovNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<long[]> container0;
        protected final DataContainer<long[]> container1;
        protected final Int64x2ScalarCacheSynchronizer synchronizer;

        public Int64ScalarMovNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, Int64x2ScalarCacheSynchronizer int64x2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.synchronizer = int64x2ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            this.container0.getArrayData()[this.container0.getArrayOffset()] = this.container1.getArrayData()[this.container1.getArrayOffset()];
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64FromFloat64ScalarCastNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<long[]> container0;
        protected final DataContainer<double[]> container1;
        protected final Int64x1Float64x1ScalarCacheSynchronizer synchronizer;

        public Int64FromFloat64ScalarCastNode(DataContainer<long[]> dataContainer, DataContainer<double[]> dataContainer2, Int64x1Float64x1ScalarCacheSynchronizer int64x1Float64x1ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.synchronizer = int64x1Float64x1ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            this.container0.getArrayData()[this.container0.getArrayOffset()] = (long)this.container1.getArrayData()[this.container1.getArrayOffset()];
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }
}

