/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Int64x2ScalarCacheSynchronizer;
import org.vcssl.nano.vm.accelerator.Int64x3ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class Int64VectorArithmeticUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        DataContainer<?>[] dataContainerArray2 = dataContainerArray;
        Int64x2ScalarCacheSynchronizer int64x2ScalarCacheSynchronizer = null;
        Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer = null;
        if (dataContainerArray.length == 2) {
            int64x2ScalarCacheSynchronizer = new Int64x2ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
        } else if (dataContainerArray.length == 3) {
            int64x3ScalarCacheSynchronizer = new Int64x3ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
        } else {
            throw new VnanoFatalException("Unexpected number of operands detected.");
        }
        Int64VectorArithmeticNode int64VectorArithmeticNode = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case ADD: {
                int64VectorArithmeticNode = new Int64VectorAddNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case SUB: {
                int64VectorArithmeticNode = new Int64VectorSubNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case MUL: {
                int64VectorArithmeticNode = new Int64VectorMulNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case DIV: {
                int64VectorArithmeticNode = new Int64VectorDivNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case REM: {
                int64VectorArithmeticNode = new Int64VectorRemNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case NEG: {
                int64VectorArithmeticNode = new Int64VectorNegNode(dataContainerArray2[0], dataContainerArray2[1], int64x2ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return int64VectorArithmeticNode;
    }

    private final class Int64VectorAddNode
    extends Int64VectorArithmeticNode {
        public Int64VectorAddNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerI64x3.synchronizeFromCacheToMemory();
            long[] lArray = (long[])this.container0.getArrayData();
            long[] lArray2 = (long[])this.container1.getArrayData();
            long[] lArray3 = (long[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                lArray[i] = lArray2[i] + lArray3[i];
            }
            this.synchronizerI64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorSubNode
    extends Int64VectorArithmeticNode {
        public Int64VectorSubNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerI64x3.synchronizeFromCacheToMemory();
            long[] lArray = (long[])this.container0.getArrayData();
            long[] lArray2 = (long[])this.container1.getArrayData();
            long[] lArray3 = (long[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                lArray[i] = lArray2[i] - lArray3[i];
            }
            this.synchronizerI64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorMulNode
    extends Int64VectorArithmeticNode {
        public Int64VectorMulNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerI64x3.synchronizeFromCacheToMemory();
            long[] lArray = (long[])this.container0.getArrayData();
            long[] lArray2 = (long[])this.container1.getArrayData();
            long[] lArray3 = (long[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                lArray[i] = lArray2[i] * lArray3[i];
            }
            this.synchronizerI64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorDivNode
    extends Int64VectorArithmeticNode {
        public Int64VectorDivNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerI64x3.synchronizeFromCacheToMemory();
            long[] lArray = (long[])this.container0.getArrayData();
            long[] lArray2 = (long[])this.container1.getArrayData();
            long[] lArray3 = (long[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                lArray[i] = lArray2[i] / lArray3[i];
            }
            this.synchronizerI64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorRemNode
    extends Int64VectorArithmeticNode {
        public Int64VectorRemNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerI64x3.synchronizeFromCacheToMemory();
            long[] lArray = (long[])this.container0.getArrayData();
            long[] lArray2 = (long[])this.container1.getArrayData();
            long[] lArray3 = (long[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                lArray[i] = lArray2[i] % lArray3[i];
            }
            this.synchronizerI64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorNegNode
    extends Int64VectorArithmeticNode {
        public Int64VectorNegNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, Int64x2ScalarCacheSynchronizer int64x2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, int64x2ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerI64x2.synchronizeFromCacheToMemory();
            long[] lArray = (long[])this.container0.getArrayData();
            long[] lArray2 = (long[])this.container1.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                lArray[i] = -lArray2[i];
            }
            this.synchronizerI64x2.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private abstract class Int64VectorArithmeticNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<long[]> container0;
        protected final DataContainer<long[]> container1;
        protected final DataContainer<long[]> container2;
        protected final Int64x3ScalarCacheSynchronizer synchronizerI64x3;
        protected final Int64x2ScalarCacheSynchronizer synchronizerI64x2;

        public Int64VectorArithmeticNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.container2 = dataContainer3;
            this.synchronizerI64x2 = null;
            this.synchronizerI64x3 = int64x3ScalarCacheSynchronizer;
        }

        public Int64VectorArithmeticNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, Int64x2ScalarCacheSynchronizer int64x2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.container2 = null;
            this.synchronizerI64x2 = int64x2ScalarCacheSynchronizer;
            this.synchronizerI64x3 = null;
        }
    }
}

