/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Int64x3ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class Int64VectorComparisonUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        DataContainer<boolean[]> dataContainer = dataContainerArray[0];
        DataContainer<long[]> dataContainer2 = dataContainerArray[1];
        DataContainer<long[]> dataContainer3 = dataContainerArray[2];
        Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer = new Int64x3ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
        Int64VectorComparisonNode int64VectorComparisonNode = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case LT: {
                int64VectorComparisonNode = new Int64VectorLtNode(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case GT: {
                int64VectorComparisonNode = new Int64VectorGtNode(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case LEQ: {
                int64VectorComparisonNode = new Int64VectorLeqNode(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case GEQ: {
                int64VectorComparisonNode = new Int64VectorGeqNode(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case EQ: {
                int64VectorComparisonNode = new Int64VectorEqNode(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case NEQ: {
                int64VectorComparisonNode = new Int64VectorNeqNode(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return int64VectorComparisonNode;
    }

    private final class Int64VectorLtNode
    extends Int64VectorComparisonNode {
        public Int64VectorLtNode(DataContainer<boolean[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            boolean[] blArray = (boolean[])this.container0.getArrayData();
            long[] lArray = (long[])this.container1.getArrayData();
            long[] lArray2 = (long[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                blArray[i] = lArray[i] < lArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorGtNode
    extends Int64VectorComparisonNode {
        public Int64VectorGtNode(DataContainer<boolean[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            boolean[] blArray = (boolean[])this.container0.getArrayData();
            long[] lArray = (long[])this.container1.getArrayData();
            long[] lArray2 = (long[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                blArray[i] = lArray[i] > lArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorLeqNode
    extends Int64VectorComparisonNode {
        public Int64VectorLeqNode(DataContainer<boolean[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            boolean[] blArray = (boolean[])this.container0.getArrayData();
            long[] lArray = (long[])this.container1.getArrayData();
            long[] lArray2 = (long[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                blArray[i] = lArray[i] <= lArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorGeqNode
    extends Int64VectorComparisonNode {
        public Int64VectorGeqNode(DataContainer<boolean[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            boolean[] blArray = (boolean[])this.container0.getArrayData();
            long[] lArray = (long[])this.container1.getArrayData();
            long[] lArray2 = (long[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                blArray[i] = lArray[i] >= lArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorEqNode
    extends Int64VectorComparisonNode {
        public Int64VectorEqNode(DataContainer<boolean[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            boolean[] blArray = (boolean[])this.container0.getArrayData();
            long[] lArray = (long[])this.container1.getArrayData();
            long[] lArray2 = (long[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                blArray[i] = lArray[i] == lArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorNeqNode
    extends Int64VectorComparisonNode {
        public Int64VectorNeqNode(DataContainer<boolean[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            boolean[] blArray = (boolean[])this.container0.getArrayData();
            long[] lArray = (long[])this.container1.getArrayData();
            long[] lArray2 = (long[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                blArray[i] = lArray[i] != lArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private abstract class Int64VectorComparisonNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<boolean[]> container0;
        protected final DataContainer<long[]> container1;
        protected final DataContainer<long[]> container2;
        protected final Int64x3ScalarCacheSynchronizer synchronizer;

        public Int64VectorComparisonNode(DataContainer<boolean[]> dataContainer, DataContainer<long[]> dataContainer2, DataContainer<long[]> dataContainer3, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.container2 = dataContainer3;
            this.synchronizer = int64x3ScalarCacheSynchronizer;
        }
    }
}

