/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import java.util.Arrays;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorExtendedOperationCode;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.BoolScalarCache;
import org.vcssl.nano.vm.accelerator.CacheSynchronizer;
import org.vcssl.nano.vm.accelerator.Float64ScalarCache;
import org.vcssl.nano.vm.accelerator.GeneralScalarCacheSynchronizer;
import org.vcssl.nano.vm.accelerator.Int64ScalarCache;
import org.vcssl.nano.vm.accelerator.ScalarCache;
import org.vcssl.nano.vm.memory.DataContainer;
import org.vcssl.nano.vm.processor.ExecutionUnit;
import org.vcssl.nano.vm.processor.Instruction;

public class InternalFunctionControlUnit
extends AcceleratorExecutionUnit {
    private static final int DEFAULT_ADDRESS_STACK_LENGTH = 1024;
    private static final int DEFAULT_DATA_STACK_LENGTH = 1024;
    private int[] addressStack = new int[this.addressStackLength];
    private DataContainer<?>[] dataStack = new DataContainer[this.dataStackLength];
    private int addressStackLength = 1024;
    private int dataStackLength = 1024;
    private int addressStackPointer = 0;
    private int dataStackPointer = 0;
    private AcceleratorExecutionNode[] allNodes;
    private boolean[] functionRunningFlags;

    public void setNodes(AcceleratorExecutionNode[] acceleratorExecutionNodeArray) {
        this.allNodes = acceleratorExecutionNodeArray;
        this.functionRunningFlags = new boolean[acceleratorExecutionNodeArray.length];
        Arrays.fill(this.functionRunningFlags, false);
    }

    private void expandAddressStack() {
        int[] nArray = new int[this.addressStackLength];
        System.arraycopy(this.addressStack, 0, nArray, 0, this.addressStackLength);
        this.addressStackLength *= 2;
        this.addressStack = new int[this.addressStackLength];
        System.arraycopy(nArray, 0, this.addressStack, 0, nArray.length);
    }

    private void expandDataStack() {
        int[] nArray = new int[this.dataStackLength];
        System.arraycopy(this.dataStack, 0, nArray, 0, this.dataStackLength);
        this.dataStackLength *= 2;
        this.dataStack = new DataContainer[this.dataStackLength];
        System.arraycopy(nArray, 0, this.dataStack, 0, nArray.length);
    }

    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        GeneralScalarCacheSynchronizer generalScalarCacheSynchronizer = new GeneralScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
        OperationCode operationCode = acceleratorInstruction.getOperationCode();
        DataType dataType = acceleratorInstruction.getDataTypes()[0];
        switch (operationCode) {
            case CALL: {
                int n = acceleratorInstruction.getReorderedAddress();
                int n2 = acceleratorInstruction.getReorderedLabelAddress();
                return new CallNode(dataContainerArray, generalScalarCacheSynchronizer, n, n2, acceleratorExecutionNode);
            }
            case RET: {
                int n = acceleratorInstruction.getReorderedLabelAddress();
                return new ReturnNode(dataContainerArray, generalScalarCacheSynchronizer, n, acceleratorExecutionNode);
            }
            case ALLOCP: {
                return new AllocpNode(dataContainerArray, dataType, acceleratorExecutionNode);
            }
            case POP: {
                return new PopNode(acceleratorExecutionNode);
            }
            case REFPOP: {
                return this.generateRefpopNode(acceleratorInstruction, dataContainerArray, blArray2, generalScalarCacheSynchronizer, acceleratorExecutionNode);
            }
            case MOVPOP: {
                return this.generateMovpopNode(acceleratorInstruction, dataContainerArray, (ScalarCache[])objectArray, blArray, blArray2, generalScalarCacheSynchronizer, acceleratorExecutionNode);
            }
            case EX: {
                AcceleratorExtendedOperationCode acceleratorExtendedOperationCode = acceleratorInstruction.getExtendedOperationCode();
                if (acceleratorExtendedOperationCode == AcceleratorExtendedOperationCode.RETURNED) {
                    return new ReturnedNode(generalScalarCacheSynchronizer, acceleratorExecutionNode);
                }
                throw new VnanoFatalException("Unsupported extended operation code for this unit: " + (Object)((Object)acceleratorExtendedOperationCode));
            }
        }
        throw new VnanoFatalException("Unsupported operation code for this unit: " + (Object)((Object)operationCode));
    }

    private AcceleratorExecutionNode generateMovpopNode(Instruction instruction, DataContainer<?>[] dataContainerArray, ScalarCache[] scalarCacheArray, boolean[] blArray, boolean[] blArray2, CacheSynchronizer cacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
        DataType dataType = instruction.getDataTypes()[0];
        if (blArray[0] && blArray2[0]) {
            switch (dataType) {
                case INT64: {
                    return new Int64CachedScalarMovpopNode((Int64ScalarCache)scalarCacheArray[0], acceleratorExecutionNode);
                }
                case FLOAT64: {
                    return new Float64CachedScalarMovpopNode((Float64ScalarCache)scalarCacheArray[0], acceleratorExecutionNode);
                }
                case BOOL: {
                    return new BoolCachedScalarMovpopNode((BoolScalarCache)scalarCacheArray[0], acceleratorExecutionNode);
                }
            }
            return new GeneralMovpopNode(dataContainerArray, cacheSynchronizer, acceleratorExecutionNode);
        }
        if (blArray2[0]) {
            switch (dataType) {
                case INT64: {
                    return new Int64ScalarMovpopNode(dataContainerArray, cacheSynchronizer, acceleratorExecutionNode);
                }
                case FLOAT64: {
                    return new Float64ScalarMovpopNode(dataContainerArray, cacheSynchronizer, acceleratorExecutionNode);
                }
                case BOOL: {
                    return new BoolScalarMovpopNode(dataContainerArray, cacheSynchronizer, acceleratorExecutionNode);
                }
            }
            return new GeneralMovpopNode(dataContainerArray, cacheSynchronizer, acceleratorExecutionNode);
        }
        return new GeneralMovpopNode(dataContainerArray, cacheSynchronizer, acceleratorExecutionNode);
    }

    private AcceleratorExecutionNode generateRefpopNode(Instruction instruction, DataContainer<?>[] dataContainerArray, boolean[] blArray, CacheSynchronizer cacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
        return new RefpopNode(dataContainerArray, cacheSynchronizer, acceleratorExecutionNode);
    }

    private final class CallNode
    extends AcceleratorExecutionNode {
        private final DataContainer<?>[] operandContainers;
        private final CacheSynchronizer synchronizer;
        private AcceleratorExecutionNode functionHeadNode;
        private int functionAddress;
        private int returnAddress;

        public CallNode(DataContainer<?>[] dataContainerArray, CacheSynchronizer cacheSynchronizer, int n, int n2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.synchronizer = cacheSynchronizer;
            this.operandContainers = dataContainerArray;
            this.returnAddress = n + 1;
            this.functionAddress = n2;
        }

        @Override
        public final void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
            this.functionHeadNode = acceleratorExecutionNodeArray[0];
        }

        @Override
        public AcceleratorExecutionNode[] getLaundingPointNodes() {
            return new AcceleratorExecutionNode[]{this.functionHeadNode};
        }

        @Override
        public final AcceleratorExecutionNode execute() throws VnanoException {
            this.synchronizer.synchronizeFromCacheToMemory();
            if (InternalFunctionControlUnit.this.functionRunningFlags[this.functionAddress]) {
                throw new VnanoException(ErrorType.RECURSIVE_FUNCTION_CALL);
            }
            ((InternalFunctionControlUnit)InternalFunctionControlUnit.this).functionRunningFlags[this.functionAddress] = true;
            if (InternalFunctionControlUnit.this.addressStackLength <= InternalFunctionControlUnit.this.addressStackPointer) {
                InternalFunctionControlUnit.this.expandAddressStack();
            }
            ((InternalFunctionControlUnit)InternalFunctionControlUnit.this).addressStack[((InternalFunctionControlUnit)InternalFunctionControlUnit.this).addressStackPointer] = this.returnAddress;
            InternalFunctionControlUnit.this.addressStackPointer++;
            int n = this.operandContainers.length;
            while (InternalFunctionControlUnit.this.dataStackLength <= InternalFunctionControlUnit.this.dataStackPointer + n) {
                InternalFunctionControlUnit.this.expandDataStack();
            }
            for (int i = 2; i < n; ++i) {
                ((InternalFunctionControlUnit)InternalFunctionControlUnit.this).dataStack[((InternalFunctionControlUnit)InternalFunctionControlUnit.this).dataStackPointer] = this.operandContainers[i];
                InternalFunctionControlUnit.this.dataStackPointer++;
            }
            return this.functionHeadNode;
        }
    }

    private final class ReturnNode
    extends AcceleratorExecutionNode {
        private final DataContainer<?> returnValueContainer;
        private final CacheSynchronizer synchronizer;
        private int functionAddress;

        public ReturnNode(DataContainer<?>[] dataContainerArray, CacheSynchronizer cacheSynchronizer, int n, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.synchronizer = cacheSynchronizer;
            this.returnValueContainer = 2 < dataContainerArray.length ? dataContainerArray[2] : new DataContainer();
            this.functionAddress = n;
        }

        @Override
        public final void setLaundingPointNodes(AcceleratorExecutionNode ... acceleratorExecutionNodeArray) {
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            --InternalFunctionControlUnit.this.addressStackPointer;
            int n = InternalFunctionControlUnit.this.addressStack[InternalFunctionControlUnit.this.addressStackPointer];
            if (InternalFunctionControlUnit.this.dataStackLength <= InternalFunctionControlUnit.this.dataStackPointer) {
                InternalFunctionControlUnit.this.expandDataStack();
            }
            ((InternalFunctionControlUnit)InternalFunctionControlUnit.this).dataStack[((InternalFunctionControlUnit)InternalFunctionControlUnit.this).dataStackPointer] = this.returnValueContainer;
            InternalFunctionControlUnit.this.dataStackPointer++;
            ((InternalFunctionControlUnit)InternalFunctionControlUnit.this).functionRunningFlags[this.functionAddress] = false;
            return InternalFunctionControlUnit.this.allNodes[n];
        }
    }

    private final class AllocpNode
    extends AcceleratorExecutionNode {
        private final DataContainer<?> allocTargetContainer;
        private final DataType dataType;

        public AllocpNode(DataContainer<?>[] dataContainerArray, DataType dataType, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.allocTargetContainer = dataContainerArray[0];
            this.dataType = dataType;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            DataContainer dataContainer = InternalFunctionControlUnit.this.dataStack[InternalFunctionControlUnit.this.dataStackPointer - 1];
            new ExecutionUnit().allocSameLengths(this.dataType, this.allocTargetContainer, dataContainer);
            return this.nextNode;
        }
    }

    private final class PopNode
    extends AcceleratorExecutionNode {
        public PopNode(AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            --InternalFunctionControlUnit.this.dataStackPointer;
            return this.nextNode;
        }
    }

    public final class ReturnedNode
    extends AcceleratorExecutionNode {
        private final CacheSynchronizer synchronizer;

        public ReturnedNode(CacheSynchronizer cacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.synchronizer = cacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarMovpopNode
    extends AcceleratorExecutionNode {
        private final Int64ScalarCache cache;

        public Int64CachedScalarMovpopNode(Int64ScalarCache int64ScalarCache, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.cache = int64ScalarCache;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            --InternalFunctionControlUnit.this.dataStackPointer;
            DataContainer dataContainer = InternalFunctionControlUnit.this.dataStack[InternalFunctionControlUnit.this.dataStackPointer];
            this.cache.data = ((long[])dataContainer.getArrayData())[dataContainer.getArrayOffset()];
            return this.nextNode;
        }
    }

    private final class Float64CachedScalarMovpopNode
    extends AcceleratorExecutionNode {
        private final Float64ScalarCache cache;

        public Float64CachedScalarMovpopNode(Float64ScalarCache float64ScalarCache, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.cache = float64ScalarCache;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            --InternalFunctionControlUnit.this.dataStackPointer;
            DataContainer dataContainer = InternalFunctionControlUnit.this.dataStack[InternalFunctionControlUnit.this.dataStackPointer];
            this.cache.data = ((double[])dataContainer.getArrayData())[dataContainer.getArrayOffset()];
            return this.nextNode;
        }
    }

    private final class BoolCachedScalarMovpopNode
    extends AcceleratorExecutionNode {
        private final BoolScalarCache cache;

        public BoolCachedScalarMovpopNode(BoolScalarCache boolScalarCache, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.cache = boolScalarCache;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            --InternalFunctionControlUnit.this.dataStackPointer;
            DataContainer dataContainer = InternalFunctionControlUnit.this.dataStack[InternalFunctionControlUnit.this.dataStackPointer];
            this.cache.data = ((boolean[])dataContainer.getArrayData())[dataContainer.getArrayOffset()];
            return this.nextNode;
        }
    }

    private final class GeneralMovpopNode
    extends AcceleratorExecutionNode {
        private final DataContainer<?>[] operandContainers;
        private final CacheSynchronizer synchronizer;

        public GeneralMovpopNode(DataContainer<?>[] dataContainerArray, CacheSynchronizer cacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.synchronizer = cacheSynchronizer;
            this.operandContainers = dataContainerArray;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            --InternalFunctionControlUnit.this.dataStackPointer;
            DataContainer dataContainer = InternalFunctionControlUnit.this.dataStack[InternalFunctionControlUnit.this.dataStackPointer];
            DataContainer<?> dataContainer2 = this.operandContainers[0];
            System.arraycopy(dataContainer.getArrayData(), dataContainer.getArrayOffset(), dataContainer2.getArrayData(), dataContainer2.getArrayOffset(), dataContainer2.getArraySize());
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64ScalarMovpopNode
    extends AcceleratorExecutionNode {
        private final DataContainer<?>[] operandContainers;
        private final CacheSynchronizer synchronizer;

        public Int64ScalarMovpopNode(DataContainer<?>[] dataContainerArray, CacheSynchronizer cacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.synchronizer = cacheSynchronizer;
            this.operandContainers = dataContainerArray;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            --InternalFunctionControlUnit.this.dataStackPointer;
            DataContainer dataContainer = InternalFunctionControlUnit.this.dataStack[InternalFunctionControlUnit.this.dataStackPointer];
            DataContainer<?> dataContainer2 = this.operandContainers[0];
            ((long[])dataContainer2.getArrayData())[dataContainer2.getArrayOffset()] = ((long[])dataContainer.getArrayData())[dataContainer.getArrayOffset()];
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64ScalarMovpopNode
    extends AcceleratorExecutionNode {
        private final DataContainer<?>[] operandContainers;
        private final CacheSynchronizer synchronizer;

        public Float64ScalarMovpopNode(DataContainer<?>[] dataContainerArray, CacheSynchronizer cacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.synchronizer = cacheSynchronizer;
            this.operandContainers = dataContainerArray;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            --InternalFunctionControlUnit.this.dataStackPointer;
            DataContainer dataContainer = InternalFunctionControlUnit.this.dataStack[InternalFunctionControlUnit.this.dataStackPointer];
            DataContainer<?> dataContainer2 = this.operandContainers[0];
            ((double[])dataContainer2.getArrayData())[dataContainer2.getArrayOffset()] = ((double[])dataContainer.getArrayData())[dataContainer.getArrayOffset()];
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class BoolScalarMovpopNode
    extends AcceleratorExecutionNode {
        private final DataContainer<?>[] operandContainers;
        private final CacheSynchronizer synchronizer;

        public BoolScalarMovpopNode(DataContainer<?>[] dataContainerArray, CacheSynchronizer cacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.synchronizer = cacheSynchronizer;
            this.operandContainers = dataContainerArray;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            --InternalFunctionControlUnit.this.dataStackPointer;
            DataContainer dataContainer = InternalFunctionControlUnit.this.dataStack[InternalFunctionControlUnit.this.dataStackPointer];
            DataContainer<?> dataContainer2 = this.operandContainers[0];
            ((boolean[])dataContainer2.getArrayData())[dataContainer2.getArrayOffset()] = ((boolean[])dataContainer.getArrayData())[dataContainer.getArrayOffset()];
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class RefpopNode
    extends AcceleratorExecutionNode {
        private final DataContainer<long[]>[] operandContainers;
        private final CacheSynchronizer synchronizer;

        public RefpopNode(DataContainer<?>[] dataContainerArray, CacheSynchronizer cacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.synchronizer = cacheSynchronizer;
            this.operandContainers = dataContainerArray;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            --InternalFunctionControlUnit.this.dataStackPointer;
            DataContainer dataContainer = InternalFunctionControlUnit.this.dataStack[InternalFunctionControlUnit.this.dataStackPointer];
            DataContainer<long[]> dataContainer2 = this.operandContainers[0];
            dataContainer2.refer(dataContainer);
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }
}

