/*
 * Decompiled with CFR 0.152.
 */
package com.rinearn.rinpn;

import com.rinearn.rinpn.RINPnFatalException;
import com.rinearn.rinpn.util.LocaleCode;
import com.rinearn.rinpn.util.MessageManager;
import com.rinearn.rinpn.util.OutputValueFormatter;
import com.rinearn.rinpn.util.SettingContainer;
import java.io.File;
import java.math.BigDecimal;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;
import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.interconnect.PluginLoader;
import org.vcssl.nano.interconnect.ScriptLoader;

public final class Model {
    private static final String SCRIPT_EXTENSION = ".vnano";
    private static final String DEFAULT_SCRIPT_ENCODING = "UTF-8";
    private static final String DEFAULT_FILE_IO_ENCODING = "UTF-8";
    private VnanoEngine engine = null;
    private String dirPath = ".";
    private String libraryListFilePath = null;
    private String pluginListFilePath = null;
    private volatile boolean calculating = false;
    private String lastOutputContent = null;

    public final boolean isCalculating() {
        return this.calculating;
    }

    public final void initialize(SettingContainer settingContainer, boolean bl, String string, String string2, String string3) {
        block8: {
            this.dirPath = string;
            this.libraryListFilePath = string2;
            this.pluginListFilePath = string3;
            this.engine = new VnanoEngine();
            try {
                this.loadLibraryScripts();
                this.loadPlugins();
                this.engine.connectPlugin("OutputPlugin", new OutputPlugin(settingContainer, bl));
            }
            catch (Exception exception) {
                String string4 = exception.getMessage();
                if (exception.getCause() != null && exception.getCause().getMessage() != null) {
                    string4 = exception.getCause().getMessage();
                }
                if (settingContainer.localeCode.equals("en-us")) {
                    MessageManager.showErrorMessage(string4, "Plug-in/Library Loading Error", settingContainer.localeCode, settingContainer.alwaysPrintError);
                }
                if (settingContainer.localeCode.equals("ja-jp")) {
                    MessageManager.showErrorMessage(string4, "\u30d7\u30e9\u30b0\u30a4\u30f3/\u30e9\u30a4\u30d6\u30e9\u30ea \u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc", settingContainer.localeCode, settingContainer.alwaysPrintError);
                }
                System.err.println("\n" + string4);
                MessageManager.showExceptionStackTrace(exception, settingContainer.localeCode);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("DEFAULT", "ASK");
            hashMap.put("FILE_READ", "ALLOW");
            hashMap.put("FILE_WRITE", "ALLOW");
            hashMap.put("FILE_CREATE", "ALLOW");
            hashMap.put("DIRECTORY_LIST", "ALLOW");
            hashMap.put("DIRECTORY_CREATE", "ALLOW");
            hashMap.put("PROGRAM_EXIT", "ALLOW");
            try {
                this.engine.setPermissionMap(hashMap);
            }
            catch (VnanoException vnanoException) {
                if (settingContainer.localeCode.equals("en-us")) {
                    MessageManager.showErrorMessage(vnanoException.getMessage(), "Permission Setting Error", settingContainer.localeCode, settingContainer.alwaysPrintError);
                }
                if (!settingContainer.localeCode.equals("ja-jp")) break block8;
                MessageManager.showErrorMessage(vnanoException.getMessage(), "\u30d1\u30fc\u30df\u30c3\u30b7\u30e7\u30f3\u8a2d\u5b9a\u30a8\u30e9\u30fc", settingContainer.localeCode, settingContainer.alwaysPrintError);
            }
        }
    }

    private final void loadLibraryScripts() throws VnanoException {
        ScriptLoader scriptLoader = new ScriptLoader("UTF-8");
        scriptLoader.setLibraryScriptListPath(this.libraryListFilePath);
        scriptLoader.load();
        String[] stringArray = scriptLoader.getLibraryScriptPaths(true);
        String[] stringArray2 = scriptLoader.getLibraryScriptContents();
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            this.engine.registerLibraryScript(stringArray[i], stringArray2[i]);
        }
    }

    private final void loadPlugins() throws VnanoException {
        PluginLoader pluginLoader = new PluginLoader("UTF-8");
        pluginLoader.setPluginListPath(this.pluginListFilePath);
        pluginLoader.load();
        for (Object object : pluginLoader.getPluginInstances()) {
            this.engine.connectPlugin("___VNANO_AUTO_KEY", object);
        }
    }

    public void shutdown(SettingContainer settingContainer) {
        try {
            this.engine.disconnectAllPlugins();
            this.engine.unregisterAllLibraryScripts();
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (exception.getCause() != null && exception.getCause().getMessage() != null) {
                string = exception.getCause().getMessage();
            }
            if (settingContainer.localeCode.equals("en-us")) {
                MessageManager.showErrorMessage(string, "Plug-in Finalization Error", settingContainer.localeCode, settingContainer.alwaysPrintError);
            }
            if (settingContainer.localeCode.equals("ja-jp")) {
                MessageManager.showErrorMessage(string, "\u30d7\u30e9\u30b0\u30a4\u30f3\u7d42\u4e86\u6642\u51e6\u7406\u30a8\u30e9\u30fc", settingContainer.localeCode, settingContainer.alwaysPrintError);
            }
            System.err.println("\n" + string);
            MessageManager.showExceptionStackTrace(exception, settingContainer.localeCode);
        }
    }

    public final String calculate(String string, boolean bl, SettingContainer settingContainer) throws VnanoException {
        Object object;
        Object object2;
        if (this.calculating) {
            throw new RINPnFatalException("The previous calculation has not finished yet");
        }
        this.calculating = true;
        if (string.trim().length() == 0) {
            this.calculating = false;
            return "";
        }
        this.lastOutputContent = null;
        boolean bl2 = false;
        File file = null;
        String string2 = string.trim();
        if (string2.startsWith("\"") && string2.endsWith("\"")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (string2.endsWith(SCRIPT_EXTENSION)) {
            bl2 = true;
            file = new File(string2);
            if (!file.isAbsolute()) {
                file = new File(this.dirPath, file.getPath());
            }
            object2 = new ScriptLoader("UTF-8");
            ((ScriptLoader)object2).setMainScriptPath(file.getAbsolutePath());
            ((ScriptLoader)object2).load();
            string = ((ScriptLoader)object2).getMainScriptContent();
            try {
                settingContainer = settingContainer.clone();
                settingContainer.evalIntLiteralAsFloat = false;
                settingContainer.evalOnlyFloat = false;
                settingContainer.evalOnlyExpression = false;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                this.calculating = false;
                throw new RINPnFatalException(cloneNotSupportedException);
            }
        } else {
            if (settingContainer.inputNormalizerEnabled) {
                string = Normalizer.normalize(string, Normalizer.Form.NFKC);
            }
            if (!string.trim().endsWith(";")) {
                string = string + ";";
            }
        }
        try {
            if (settingContainer.reloadLibrary) {
                this.engine.unregisterAllLibraryScripts();
                this.loadLibraryScripts();
            }
            if (settingContainer.reloadPlugin) {
                this.engine.disconnectAllPlugins();
                this.loadPlugins();
            }
        }
        catch (Exception exception) {
            object = exception.getMessage();
            if (exception.getCause() != null && exception.getCause().getMessage() != null) {
                object = exception.getCause().getMessage();
            }
            if (settingContainer.localeCode.equals("en-us")) {
                MessageManager.showErrorMessage((String)object, "Plug-in/Library Loading Error", settingContainer.localeCode, settingContainer.alwaysPrintError);
            }
            if (settingContainer.localeCode.equals("ja-jp")) {
                MessageManager.showErrorMessage((String)object, "\u30d7\u30e9\u30b0\u30a4\u30f3/\u30e9\u30a4\u30d6\u30e9\u30ea \u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc", settingContainer.localeCode, settingContainer.alwaysPrintError);
            }
            System.err.println("\n" + (String)object);
            MessageManager.showExceptionStackTrace(exception, settingContainer.localeCode);
        }
        object2 = new HashMap();
        object2.put("ACCELERATOR_ENABLED", settingContainer.acceleratorEnabled);
        object2.put("ACCELERATOR_OPTIMIZATION_LEVEL", settingContainer.acceleratorOptimizationLevel);
        object2.put("EVAL_INT_LITERAL_AS_FLOAT", settingContainer.evalIntLiteralAsFloat);
        object2.put("EVAL_ONLY_FLOAT", settingContainer.evalOnlyFloat);
        object2.put("EVAL_ONLY_EXPRESSION", settingContainer.evalOnlyExpression);
        object2.put("LOCALE", LocaleCode.toLocale(settingContainer.localeCode));
        object2.put("DUMPER_ENABLED", settingContainer.dumperEnabled);
        object2.put("DUMPER_TARGET", settingContainer.dumperTarget);
        object2.put("UI_MODE", bl ? "GUI" : "CUI");
        object2.put("FILE_IO_ENCODING", "UTF-8");
        if (bl2) {
            object2.put("MAIN_SCRIPT_NAME", file.getName());
            object2.put("MAIN_SCRIPT_DIRECTORY", file.getParentFile().getAbsolutePath());
        }
        this.engine.setOptionMap((Map<String, Object>)object2);
        object = null;
        try {
            object = this.engine.executeScript(string);
        }
        catch (VnanoException vnanoException) {
            this.calculating = false;
            throw vnanoException;
        }
        String string3 = null;
        if (bl2) {
            if (bl) {
                string3 = this.lastOutputContent;
            }
        } else {
            if (object instanceof Double && !((Double)object).isNaN() && !((Double)object).isInfinite()) {
                object = OutputValueFormatter.round((Double)object, settingContainer);
                object = OutputValueFormatter.simplify((BigDecimal)object);
            }
            if (object != null) {
                object = object.toString();
            }
            string3 = (String)object;
        }
        this.calculating = false;
        return string3;
    }

    public void calculateAsynchronously(String string, AsyncCalculationListener asyncCalculationListener, SettingContainer settingContainer) {
        AsyncCalculationRunner asyncCalculationRunner = new AsyncCalculationRunner(string, asyncCalculationListener, settingContainer);
        Thread thread = new Thread(asyncCalculationRunner);
        thread.start();
    }

    public class OutputPlugin {
        private boolean isGuiMode;
        private SettingContainer setting;

        public OutputPlugin(SettingContainer settingContainer, boolean bl) {
            this.setting = settingContainer;
            this.isGuiMode = bl;
        }

        public void output(String string) {
            Model.this.lastOutputContent = string;
            if (!this.isGuiMode) {
                System.out.println(string);
            }
        }

        public void output(long l) {
            this.output(Long.toString(l));
        }

        public void output(double d) {
            if (!Double.valueOf(d).isNaN() && !Double.valueOf(d).isInfinite()) {
                BigDecimal bigDecimal = OutputValueFormatter.round(d, this.setting);
                String string = OutputValueFormatter.simplify(bigDecimal);
                this.output(string);
            } else {
                this.output(Double.toString(d));
            }
        }

        public void output(boolean bl) {
            this.output(Boolean.toString(bl));
        }
    }

    private final class AsyncCalculationRunner
    implements Runnable {
        private AsyncCalculationListener calculationListener = null;
        private SettingContainer setting = null;
        private String inputtedContent = null;

        public AsyncCalculationRunner(String string, AsyncCalculationListener asyncCalculationListener, SettingContainer settingContainer) {
            this.inputtedContent = string;
            this.calculationListener = asyncCalculationListener;
            this.setting = settingContainer;
        }

        @Override
        public final void run() {
            block7: {
                if (Model.this.isCalculating()) {
                    if (this.setting.localeCode.equals("en-us")) {
                        MessageManager.showErrorMessage("The previous calculation has not finished yet.", "!", this.setting.localeCode, this.setting.alwaysPrintError);
                    }
                    if (this.setting.localeCode.equals("ja-jp")) {
                        MessageManager.showErrorMessage("\u307e\u3060\u524d\u306e\u8a08\u7b97\u3092\u5b9f\u884c\u4e2d\u3067\u3059\u3002", "!", this.setting.localeCode, this.setting.alwaysPrintError);
                    }
                    return;
                }
                try {
                    String string = Model.this.calculate(this.inputtedContent, true, this.setting);
                    this.calculationListener.calculationFinished(string);
                }
                catch (RINPnFatalException | VnanoException | VnanoFatalException exception) {
                    this.calculationListener.calculationFinished("ERROR");
                    String string = MessageManager.customizeExceptionMessage(exception.getMessage());
                    if (this.setting.localeCode.equals("en-us")) {
                        MessageManager.showErrorMessage(string, "Expression/Script Error", this.setting.localeCode, this.setting.alwaysPrintError);
                    }
                    if (this.setting.localeCode.equals("ja-jp")) {
                        MessageManager.showErrorMessage(string, "\u8a08\u7b97\u5f0f\u3084\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u30a8\u30e9\u30fc", this.setting.localeCode, this.setting.alwaysPrintError);
                    }
                    if (!this.setting.exceptionStackTracerEnabled) break block7;
                    MessageManager.showExceptionStackTrace(exception, this.setting.localeCode);
                }
            }
        }
    }

    public static interface AsyncCalculationListener {
        public void calculationFinished(String var1);
    }
}

