/*
 * Decompiled with CFR 0.152.
 */
package com.rinearn.rinpn;

import com.rinearn.rinpn.Model;
import com.rinearn.rinpn.Presenter;
import com.rinearn.rinpn.RINPnException;
import com.rinearn.rinpn.RINPnFatalException;
import com.rinearn.rinpn.View;
import com.rinearn.rinpn.util.LocaleCode;
import com.rinearn.rinpn.util.MessageManager;
import com.rinearn.rinpn.util.SettingContainer;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;

public final class RINPn {
    private static final String VERSION = "1.0.4";
    private static final String OPTION_NAME_VERSION = "--version";
    private static final String OPTION_NAME_DEBUG = "--debug";
    private static final String OPTION_NAME_DIR = "--dir";
    private static final String LIBRARY_LIST_FILE = "lib/VnanoLibraryList.txt";
    private static final String PLUGIN_LIST_FILE = "plugin/VnanoPluginList.txt";

    public static void main(String[] stringArray) {
        String string = null;
        boolean bl = false;
        String string2 = ".";
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2].equals(OPTION_NAME_VERSION)) {
                RINPn.printVersion();
                return;
            }
            if (stringArray[n2].equals(OPTION_NAME_DEBUG)) {
                bl = true;
                ++n2;
                continue;
            }
            if (stringArray[n2].equals(OPTION_NAME_DIR)) {
                if (n <= n2 + 1) {
                    if (LocaleCode.getDefaultLocaleCode().equals("ja-jp")) {
                        System.err.println("\u30aa\u30d7\u30b7\u30e7\u30f3\u300c --dir \u300d\u306e\u5f8c\u306b\u5024\u304c\u5fc5\u8981\u3067\u3059\u3002");
                    }
                    if (LocaleCode.getDefaultLocaleCode().equals("en-us")) {
                        System.err.println("An option value is required after \"--dir\".");
                    }
                }
                string2 = stringArray[n2 + 1];
                n2 += 2;
                continue;
            }
            if (string == null) {
                string = stringArray[n2];
            } else {
                if (LocaleCode.getDefaultLocaleCode().equals("ja-jp")) {
                    System.err.println("\u30b3\u30de\u30f3\u30c9\u30e9\u30a4\u30f3\u5f15\u6570\u306e\u6570\u304c\u591a\u3059\u304e\u307e\u3059\u3002");
                }
                if (LocaleCode.getDefaultLocaleCode().equals("en-us")) {
                    System.err.println("Too many command-line arguments.");
                }
            }
            ++n2;
        }
        if (string == null) {
            new RINPn().launchCalculatorWindow(string2, bl);
        } else {
            new RINPn().calculate(string, string2, bl);
        }
    }

    private static void printVersion() {
        System.out.print("RINPn Ver.1.0.4 ");
        System.out.print(" / with Vnano");
        System.out.print(" Ver.1.1.4");
        System.out.println("");
    }

    public final void calculate(String string, String string2, boolean bl) {
        Model model;
        SettingContainer settingContainer;
        block6: {
            MessageManager.setDisplayType(MessageManager.DisplayMode.CUI);
            settingContainer = null;
            model = null;
            try {
                settingContainer = this.createInitializedSettingContainer(false, bl);
                model = this.createInitializedCalculatorModel(string2, false, settingContainer);
            }
            catch (RINPnException rINPnException) {
                if (settingContainer == null || settingContainer.exceptionStackTracerEnabled) {
                    String string3 = settingContainer == null ? LocaleCode.getDefaultLocaleCode() : settingContainer.localeCode;
                    MessageManager.showExceptionStackTrace(rINPnException, string3);
                }
                return;
            }
            String string4 = null;
            try {
                string4 = model.calculate(string, false, settingContainer);
                if (string4 != null) {
                    System.out.println(string4);
                }
            }
            catch (RINPnFatalException | VnanoException | VnanoFatalException exception) {
                String string5 = MessageManager.customizeExceptionMessage(exception.getMessage());
                MessageManager.showErrorMessage(string5, "!", settingContainer.localeCode, settingContainer.alwaysPrintError);
                if (!settingContainer.exceptionStackTracerEnabled) break block6;
                MessageManager.showExceptionStackTrace(exception, settingContainer.localeCode);
            }
        }
        model.shutdown(settingContainer);
    }

    public final void launchCalculatorWindow(String string, boolean bl) {
        SettingContainer settingContainer = null;
        Model model = null;
        try {
            settingContainer = this.createInitializedSettingContainer(true, bl);
            model = this.createInitializedCalculatorModel(string, true, settingContainer);
        }
        catch (RINPnException rINPnException) {
            if (settingContainer == null || settingContainer.exceptionStackTracerEnabled) {
                String string2 = settingContainer == null ? LocaleCode.getDefaultLocaleCode() : settingContainer.localeCode;
                MessageManager.showExceptionStackTrace(rINPnException, string2);
            }
            return;
        }
        View view = new View();
        try {
            view.initialize(settingContainer);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            if (settingContainer.localeCode.equals("en-us")) {
                MessageManager.showErrorMessage("Unexpected exception occurred: " + exception.getClass().getCanonicalName(), "Error", settingContainer.localeCode, settingContainer.alwaysPrintError);
            }
            if (settingContainer.localeCode.equals("ja-jp")) {
                MessageManager.showErrorMessage("\u4e88\u671f\u3057\u306a\u3044\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f: " + exception.getClass().getCanonicalName(), "\u30a8\u30e9\u30fc", settingContainer.localeCode, settingContainer.alwaysPrintError);
            }
            if (settingContainer.exceptionStackTracerEnabled) {
                MessageManager.showExceptionStackTrace(exception, settingContainer.localeCode);
            }
            return;
        }
        Presenter presenter = new Presenter();
        presenter.link(view, model, settingContainer);
    }

    private final SettingContainer createInitializedSettingContainer(boolean bl, boolean bl2) throws RINPnException {
        SettingContainer settingContainer = new SettingContainer();
        String string = "Settings.vnano";
        if (!new File(string).exists() && !new File(string = "Settings.txt").exists()) {
            String string2 = null;
            if (settingContainer.localeCode.equals("ja-jp")) {
                string2 = "\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u300c Settings.txt \u300d\u307e\u305f\u306f\u300c Settings.vnano \u300d\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002";
                MessageManager.showErrorMessage(string2, "\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc", "ja-jp", settingContainer.alwaysPrintError);
            } else {
                string2 = "The setting file \"Settings.txt\" or \"Settings.vnano\" is not found.";
                MessageManager.showErrorMessage(string2, "Setting File Loading Error", "en-us", settingContainer.alwaysPrintError);
            }
            throw new RINPnException(string2);
        }
        settingContainer.evaluateSettingScript(string, LIBRARY_LIST_FILE, PLUGIN_LIST_FILE, bl, bl2);
        return settingContainer;
    }

    private final Model createInitializedCalculatorModel(String string, boolean bl, SettingContainer settingContainer) throws RINPnException {
        Model model = new Model();
        model.initialize(settingContainer, bl, string, LIBRARY_LIST_FILE, PLUGIN_LIST_FILE);
        return model;
    }
}

