/*
 * Decompiled with CFR 0.152.
 */
package com.rinearn.rinpn;

import com.rinearn.rinpn.util.SettingContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.text.DefaultEditorKit;

public final class View {
    private volatile boolean initialized = false;
    public static final int WINDOW_EDGE_WIDTH = 5;
    public static final int WINDOW_MIN_WIDTH = 200;
    public static final int WINDOW_MIN_HEIGHT = 100;
    public JFrame frame = null;
    public JPanel basePanel = null;
    public JPanel mainPanel = null;
    public JPanel keyPanel = null;
    public JTextField inputField = null;
    public JTextField outputField = null;
    public JLabel inputLabel = null;
    public JLabel outputLabel = null;
    public JLabel keyRetractorLabel = null;
    public JButton runButton = null;
    public JButton exitButton = null;
    public JPopupMenu textFieldPopupMenu = null;
    public List<JButton> numberKeyList = null;
    public List<JButton> functionKeyList = null;
    public List<JButton> behaviorKeyList = null;

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    public void initialize(SettingContainer settingContainer) throws InvocationTargetException, InterruptedException {
        if (this.initialized) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            new ViewInitializer(settingContainer).run();
        } else {
            SwingUtilities.invokeAndWait(new ViewInitializer(settingContainer));
        }
        this.initialized = true;
    }

    public void dispose() throws InvocationTargetException, InterruptedException {
        if (SwingUtilities.isEventDispatchThread()) {
            new ViewDisposer().run();
        } else {
            SwingUtilities.invokeAndWait(new ViewDisposer());
        }
        this.initialized = true;
    }

    public void resizePanels(SettingContainer settingContainer) throws InvocationTargetException, InterruptedException {
        if (SwingUtilities.isEventDispatchThread()) {
            new PanelResizer(settingContainer).run();
        } else {
            SwingUtilities.invokeAndWait(new PanelResizer(settingContainer));
        }
        this.initialized = true;
    }

    private class ViewInitializer
    implements Runnable {
        private SettingContainer settingContainer;

        public ViewInitializer(SettingContainer settingContainer) {
            this.settingContainer = settingContainer;
        }

        @Override
        public void run() {
            View.this.frame = new JFrame();
            View.this.frame.setBounds(0, 0, this.settingContainer.windowWidth, this.settingContainer.windowHeight);
            View.this.basePanel = new JPanel();
            View.this.basePanel.setBorder(new LineBorder(new Color(this.settingContainer.windowBackgroundColorR, this.settingContainer.windowBackgroundColorG, this.settingContainer.windowBackgroundColorB), 5));
            View.this.basePanel.setLayout(null);
            View.this.frame.getContentPane().add(View.this.basePanel);
            int n = 5;
            int n2 = 5;
            int n3 = this.settingContainer.windowWidth - 10;
            int n4 = this.settingContainer.retractedWindowHeight - 5;
            View.this.mainPanel = new JPanel();
            View.this.mainPanel.setBounds(n, n2, n3, n4);
            View.this.basePanel.add(View.this.mainPanel);
            int n5 = 5;
            int n6 = this.settingContainer.retractedWindowHeight;
            int n7 = this.settingContainer.windowWidth - 10;
            int n8 = this.settingContainer.windowHeight - this.settingContainer.retractedWindowHeight - 5;
            View.this.keyPanel = new JPanel();
            View.this.keyPanel.setBounds(n5, n6, n7, n8);
            View.this.basePanel.add(View.this.keyPanel);
            this.mountMainPanelComponents();
            this.mountKeyPanelComponents();
            GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            if (graphicsDevice.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSLUCENT)) {
                View.this.frame.setUndecorated(true);
                View.this.frame.setAlwaysOnTop(this.settingContainer.stayOnTopOfAllWindows);
                View.this.frame.setOpacity((float)this.settingContainer.windowOpacity);
                Color color = new Color(this.settingContainer.windowBackgroundColorR, this.settingContainer.windowBackgroundColorG, this.settingContainer.windowBackgroundColorB);
                View.this.mainPanel.setBackground(color);
                View.this.keyPanel.setBackground(color);
                View.this.runButton.setBackground(Color.WHITE);
                View.this.exitButton.setBackground(Color.WHITE);
                Color color2 = new Color(this.settingContainer.textLabelForgroundColorR, this.settingContainer.textLabelForgroundColorG, this.settingContainer.textLabelForgroundColorB);
                View.this.inputLabel.setForeground(color2);
                View.this.outputLabel.setForeground(color2);
                Color color3 = new Color(this.settingContainer.keyRetractorForegroundColorR, this.settingContainer.keyRetractorForegroundColorG, this.settingContainer.keyRetractorForegroundColorB);
                View.this.keyRetractorLabel.setForeground(color3);
                Color color4 = new Color(this.settingContainer.textFieldBackgroundColorR, this.settingContainer.textFieldBackgroundColorG, this.settingContainer.textFieldBackgroundColorB);
                View.this.inputField.setBackground(color4);
                View.this.outputField.setBackground(color4);
                Color color5 = new Color(this.settingContainer.textFieldForegroundColorR, this.settingContainer.textFieldForegroundColorG, this.settingContainer.textFieldForegroundColorB);
                View.this.inputField.setForeground(color5);
                View.this.outputField.setForeground(color5);
                View.this.inputField.setCaretColor(color5);
                View.this.outputField.setCaretColor(color5);
            }
            View.this.mainPanel.setVisible(true);
            View.this.basePanel.setVisible(true);
            View.this.frame.setVisible(true);
        }

        private void mountMainPanelComponents() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            View.this.mainPanel.setLayout(gridBagLayout);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            View.this.inputLabel = new JLabel("INPUT", 2);
            gridBagLayout.setConstraints(View.this.inputLabel, gridBagConstraints);
            View.this.inputLabel.setFont(SettingContainer.LABEL_FONT);
            View.this.mainPanel.add(View.this.inputLabel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            View.this.exitButton = new JButton("X");
            gridBagLayout.setConstraints(View.this.exitButton, gridBagConstraints);
            View.this.exitButton.setFont(SettingContainer.EXIT_BUTTON_FONT);
            View.this.exitButton.setForeground(Color.RED);
            View.this.mainPanel.add(View.this.exitButton);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            View.this.inputField = new JTextField();
            gridBagLayout.setConstraints(View.this.inputField, gridBagConstraints);
            View.this.inputField.setFont(new Font("Monospaced", 1, this.settingContainer.textFieldFontSize));
            View.this.mainPanel.add(View.this.inputField);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            View.this.outputLabel = new JLabel("OUTPUT", 2);
            gridBagLayout.setConstraints(View.this.outputLabel, gridBagConstraints);
            View.this.outputLabel.setFont(SettingContainer.LABEL_FONT);
            View.this.mainPanel.add(View.this.outputLabel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            View.this.runButton = new JButton("=");
            gridBagLayout.setConstraints(View.this.runButton, gridBagConstraints);
            View.this.runButton.setFont(SettingContainer.RUN_BUTTON_FONT);
            View.this.mainPanel.add(View.this.runButton);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            View.this.outputField = new JTextField();
            gridBagLayout.setConstraints(View.this.outputField, gridBagConstraints);
            View.this.outputField.setFont(new Font("Monospaced", 1, this.settingContainer.textFieldFontSize));
            View.this.mainPanel.add(View.this.outputField);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            View.this.keyRetractorLabel = new JLabel("\u25b2KEY-PANEL", 2);
            gridBagLayout.setConstraints(View.this.keyRetractorLabel, gridBagConstraints);
            View.this.keyRetractorLabel.setFont(SettingContainer.LABEL_FONT);
            View.this.mainPanel.add(View.this.keyRetractorLabel);
            View.this.textFieldPopupMenu = new JPopupMenu();
            View.this.textFieldPopupMenu.add(new DefaultEditorKit.CutAction()).setText("Cut");
            View.this.textFieldPopupMenu.add(new DefaultEditorKit.CopyAction()).setText("Copy");
            View.this.textFieldPopupMenu.add(new DefaultEditorKit.PasteAction()).setText("Paste");
        }

        private void mountKeyPanelComponents() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            View.this.keyPanel.setLayout(gridBagLayout);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 5.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(8, 3));
            jPanel.setBackground(new Color(0, 0, 0, 0));
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            View.this.keyPanel.add(jPanel);
            View.this.functionKeyList = new ArrayList<JButton>();
            JComponent jComponent = new JButton("sin");
            jPanel.add(jComponent);
            View.this.functionKeyList.add((JButton)jComponent);
            JComponent jComponent2 = new JButton("cos");
            jPanel.add(jComponent2);
            View.this.functionKeyList.add((JButton)jComponent2);
            JButton jButton = new JButton("tan");
            jPanel.add(jButton);
            View.this.functionKeyList.add(jButton);
            JButton jButton2 = new JButton("asin");
            jPanel.add(jButton2);
            View.this.functionKeyList.add(jButton2);
            JButton jButton3 = new JButton("acos");
            jPanel.add(jButton3);
            View.this.functionKeyList.add(jButton3);
            JButton jButton4 = new JButton("atan");
            jPanel.add(jButton4);
            View.this.functionKeyList.add(jButton4);
            Serializable serializable = new JButton("abs");
            jPanel.add((Component)serializable);
            View.this.functionKeyList.add((JButton)serializable);
            Object object = new JButton("sqrt");
            jPanel.add((Component)object);
            View.this.functionKeyList.add((JButton)object);
            JButton jButton52 = new JButton("pow");
            jPanel.add(jButton52);
            View.this.functionKeyList.add(jButton52);
            JButton jButton6 = new JButton("exp");
            jPanel.add(jButton6);
            View.this.functionKeyList.add(jButton6);
            JButton jButton7 = new JButton("ln");
            jPanel.add(jButton7);
            View.this.functionKeyList.add(jButton7);
            JButton jButton8 = new JButton("log10");
            jPanel.add(jButton8);
            View.this.functionKeyList.add(jButton8);
            JButton jButton9 = new JButton("sum");
            jPanel.add(jButton9);
            View.this.functionKeyList.add(jButton9);
            JButton jButton10 = new JButton("van");
            jPanel.add(jButton10);
            View.this.functionKeyList.add(jButton10);
            JButton jButton11 = new JButton("van1");
            jPanel.add(jButton11);
            View.this.functionKeyList.add(jButton11);
            JButton jButton12 = new JButton("mean");
            jPanel.add(jButton12);
            View.this.functionKeyList.add(jButton12);
            JButton jButton13 = new JButton("sdn");
            jPanel.add(jButton13);
            View.this.functionKeyList.add(jButton13);
            Serializable serializable2 = new JButton("sdn1");
            jPanel.add((Component)serializable2);
            View.this.functionKeyList.add((JButton)serializable2);
            JButton jButton14 = new JButton("rad");
            jPanel.add(jButton14);
            View.this.functionKeyList.add(jButton14);
            JButton jButton152 = new JButton("deg");
            jPanel.add(jButton152);
            View.this.functionKeyList.add(jButton152);
            JButton jButton16 = new JButton("PI");
            jPanel.add(jButton16);
            View.this.functionKeyList.add(jButton16);
            JButton jButton17 = new JButton("(");
            jPanel.add(jButton17);
            View.this.functionKeyList.add(jButton17);
            JButton jButton18 = new JButton(")");
            jPanel.add(jButton18);
            View.this.functionKeyList.add(jButton18);
            JButton jButton19 = new JButton("_");
            jPanel.add(jButton19);
            View.this.functionKeyList.add(jButton19);
            Font font = new Font("Dialog", 1, this.settingContainer.functionKeyFontSize);
            for (JButton jButton20 : View.this.functionKeyList) {
                jButton20.setFont(font);
            }
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 3.0;
            gridBagConstraints.insets = new Insets(0, 5, 0, 5);
            jComponent = new JPanel();
            jComponent.setLayout(new GridLayout(4, 4));
            jComponent.setBackground(new Color(0, 0, 0, 0));
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            View.this.keyPanel.add(jComponent);
            View.this.numberKeyList = new ArrayList<JButton>();
            jComponent2 = new JButton("7");
            jComponent.add(jComponent2);
            View.this.numberKeyList.add((JButton)jComponent2);
            jButton = new JButton("8");
            jComponent.add(jButton);
            View.this.numberKeyList.add(jButton);
            jButton2 = new JButton("9");
            jComponent.add(jButton2);
            View.this.numberKeyList.add(jButton2);
            jButton3 = new JButton("/");
            jComponent.add(jButton3);
            View.this.numberKeyList.add(jButton3);
            jButton4 = new JButton("4");
            jComponent.add(jButton4);
            View.this.numberKeyList.add(jButton4);
            serializable = new JButton("5");
            jComponent.add((Component)serializable);
            View.this.numberKeyList.add((JButton)serializable);
            object = new JButton("6");
            jComponent.add((Component)object);
            View.this.numberKeyList.add((JButton)object);
            jButton52 = new JButton("*");
            jComponent.add(jButton52);
            View.this.numberKeyList.add(jButton52);
            jButton6 = new JButton("1");
            jComponent.add(jButton6);
            View.this.numberKeyList.add(jButton6);
            jButton7 = new JButton("2");
            jComponent.add(jButton7);
            View.this.numberKeyList.add(jButton7);
            jButton8 = new JButton("3");
            jComponent.add(jButton8);
            View.this.numberKeyList.add(jButton8);
            jButton9 = new JButton("-");
            jComponent.add(jButton9);
            View.this.numberKeyList.add(jButton9);
            jButton10 = new JButton("0");
            jComponent.add(jButton10);
            View.this.numberKeyList.add(jButton10);
            jButton11 = new JButton(".");
            jComponent.add(jButton11);
            View.this.numberKeyList.add(jButton11);
            jButton12 = new JButton(",");
            jComponent.add(jButton12);
            View.this.numberKeyList.add(jButton12);
            jButton13 = new JButton("+");
            jComponent.add(jButton13);
            View.this.numberKeyList.add(jButton13);
            serializable2 = new Font("Dialog", 1, this.settingContainer.numberKeyFontSize);
            for (JButton jButton152 : View.this.numberKeyList) {
                jButton152.setFont((Font)serializable2);
            }
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jComponent2 = new JPanel();
            jComponent2.setLayout(new GridLayout(4, 1));
            jComponent2.setBackground(new Color(0, 0, 0, 0));
            gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
            View.this.keyPanel.add(jComponent2);
            View.this.behaviorKeyList = new ArrayList<JButton>();
            jButton = new JButton("=");
            jButton.setForeground(Color.BLUE);
            jComponent2.add(jButton);
            View.this.behaviorKeyList.add(jButton);
            jButton2 = new JButton("C");
            jButton2.setForeground(Color.RED);
            jComponent2.add(jButton2);
            View.this.behaviorKeyList.add(jButton2);
            jButton3 = new JButton("BS");
            jButton2.setForeground(Color.RED);
            jComponent2.add(jButton3);
            View.this.behaviorKeyList.add(jButton3);
            jButton4 = new JButton("Script");
            jComponent2.add(jButton4);
            View.this.behaviorKeyList.add(jButton4);
            serializable = new Font("Dialog", 1, this.settingContainer.behaviorKeyFontSize);
            for (JButton jButton52 : View.this.behaviorKeyList) {
                jButton52.setFont((Font)serializable);
            }
        }
    }

    private class ViewDisposer
    implements Runnable {
        @Override
        public void run() {
            View.this.frame.dispose();
            View.this.frame = null;
            View.this.basePanel = null;
            View.this.mainPanel = null;
            View.this.inputField = null;
            View.this.outputField = null;
            View.this.inputLabel = null;
            View.this.outputLabel = null;
            View.this.keyRetractorLabel = null;
            View.this.runButton = null;
            View.this.exitButton = null;
        }
    }

    private class PanelResizer
    implements Runnable {
        SettingContainer settingContainer;

        public PanelResizer(SettingContainer settingContainer) {
            this.settingContainer = settingContainer;
        }

        @Override
        public void run() {
            int n = View.this.frame.getSize().width;
            int n2 = View.this.frame.getSize().height;
            int n3 = 5;
            int n4 = 5;
            int n5 = n - 10;
            int n6 = this.settingContainer.retractedWindowHeight - 5;
            View.this.mainPanel.setBounds(n3, n4, n5, n6);
            int n7 = 5;
            int n8 = this.settingContainer.retractedWindowHeight;
            int n9 = n - 10;
            int n10 = n2 - this.settingContainer.retractedWindowHeight - 5;
            if (n10 < 20) {
                n10 = 20;
            }
            View.this.keyPanel.setBounds(n7, n8, n9, n10);
        }
    }
}

