/*
 * Decompiled with CFR 0.152.
 */
package com.rinearn.rinpn.util;

import com.rinearn.rinpn.RINPnFatalException;
import com.rinearn.rinpn.util.RoundingTarget;
import com.rinearn.rinpn.util.SettingContainer;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Locale;

public final class OutputValueFormatter {
    public static final BigDecimal round(double d, SettingContainer settingContainer) {
        if (settingContainer.outputRounderEnabled) {
            String string = settingContainer.roundingMode;
            if (string.equals("HALF_TO_EVEN")) {
                string = "HALF_EVEN";
            }
            RoundingMode roundingMode = RoundingMode.valueOf(string);
            RoundingTarget roundingTarget = RoundingTarget.valueOf(settingContainer.roundingTarget);
            int n = settingContainer.roundingLength;
            boolean bl = settingContainer.performImplicitRoundingBeforeRounding;
            return OutputValueFormatter.round(d, roundingMode, roundingTarget, n, bl);
        }
        return new BigDecimal(Double.toString(d));
    }

    public static final BigDecimal round(double d, RoundingMode roundingMode, RoundingTarget roundingTarget, int n, boolean bl) {
        Object object;
        BigDecimal bigDecimal = null;
        if (bl) {
            object = Double.toString(d);
            bigDecimal = new BigDecimal((String)object);
        } else {
            bigDecimal = new BigDecimal(d);
        }
        switch (roundingTarget) {
            case AFTER_FIXED_POINT: {
                bigDecimal = bigDecimal.setScale(n, roundingMode);
                break;
            }
            case SIGNIFICAND: {
                object = new MathContext(n, roundingMode);
                bigDecimal = bigDecimal.round((MathContext)object);
                break;
            }
        }
        return bigDecimal;
    }

    public static final String simplify(BigDecimal bigDecimal) {
        Object object;
        boolean bl;
        Object object2;
        boolean bl2;
        String string = bigDecimal.toString().toUpperCase(Locale.ROOT);
        String string2 = null;
        String string3 = null;
        boolean bl3 = bl2 = 0 <= string.indexOf("E");
        if (bl2) {
            object2 = string.split("E");
            if (((String[])object2).length != 2) {
                throw new RINPnFatalException("Unexpected value format detected.");
            }
            string2 = object2[0];
            string3 = object2[1];
        } else {
            string2 = string;
            string3 = "";
        }
        object2 = null;
        String string4 = null;
        boolean bl4 = bl = 0 <= string2.indexOf(".");
        if (bl) {
            object = string2.split("\\.");
            if (((String[])object).length != 2) {
                throw new RINPnFatalException("Unexpected value format detected.");
            }
            object2 = object[0];
            string4 = object[1];
        } else {
            object2 = string;
            string4 = "";
        }
        while (string4.endsWith("0")) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        if (string3.startsWith("+")) {
            string3 = string3.substring(1, string3.length());
        }
        object = object2;
        if (bl && 0 < string4.length()) {
            object = (String)object + "." + string4;
        }
        if (bl2) {
            object = (String)object + "E" + string3;
        }
        return object;
    }
}

