/*
 * Decompiled with CFR 0.152.
 */
package com.rinearn.rinpn.util;

import com.rinearn.rinpn.RINPnException;
import com.rinearn.rinpn.RINPnFatalException;
import com.rinearn.rinpn.util.LocaleCode;
import com.rinearn.rinpn.util.MessageManager;
import com.rinearn.rinpn.util.RoundingTarget;
import java.awt.Font;
import java.io.File;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.interconnect.PluginLoader;
import org.vcssl.nano.interconnect.ScriptLoader;

public final class SettingContainer
implements Cloneable {
    public static final String TEXT_FIELD_FONT_NAME = "Monospaced";
    public static final int TEXT_FIELD_FONT_TYPE = 1;
    public static final Font LABEL_FONT = new Font("Dialog", 1, 14);
    public static final Font RUN_BUTTON_FONT = new Font("Dialog", 1, 14);
    public static final Font EXIT_BUTTON_FONT = new Font("Dialog", 1, 14);
    public static final String SETTING_SCRIPT_PATH_TXT = "Settings.txt";
    public static final String SETTING_SCRIPT_PATH_VNANO = "Settings.vnano";
    public static final String DEFAULT_SETTING_SCRIPT_ENCODING = "UTF-8";
    public static final int MAX_ROUNDING_LENGTH = 100;
    public int textFieldFontSize = 18;
    public int numberKeyFontSize = 18;
    public int behaviorKeyFontSize = 18;
    public int functionKeyFontSize = 14;
    public boolean stayOnTopOfAllWindows = true;
    public int windowWidth = 540;
    public int windowHeight = 380;
    public double windowOpacity = 0.76;
    public int retractedWindowHeight = 160;
    public int windowBackgroundColorR = 180;
    public int windowBackgroundColorG = 220;
    public int windowBackgroundColorB = 255;
    public int textFieldBackgroundColorR = 100;
    public int textFieldBackgroundColorG = 100;
    public int textFieldBackgroundColorB = 100;
    public int textFieldForegroundColorR = 140;
    public int textFieldForegroundColorG = 255;
    public int textFieldForegroundColorB = 180;
    public int textLabelForgroundColorR = 100;
    public int textLabelForgroundColorG = 120;
    public int textLabelForgroundColorB = 140;
    public int keyRetractorForegroundColorR = 100;
    public int keyRetractorForegroundColorG = 120;
    public int keyRetractorForegroundColorB = 140;
    public boolean inputNormalizerEnabled = true;
    public boolean outputRounderEnabled = true;
    public boolean performImplicitRoundingBeforeRounding = true;
    public String roundingMode = "HALF_UP";
    public String roundingTarget = "SIGNIFICAND";
    public int roundingLength = 10;
    public boolean reloadPlugin = false;
    public boolean reloadLibrary = true;
    public boolean acceleratorEnabled = true;
    public int acceleratorOptimizationLevel = 0;
    public boolean evalIntLiteralAsFloat = true;
    public boolean evalOnlyFloat = true;
    public boolean evalOnlyExpression = true;
    public boolean dumperEnabled = false;
    public String dumperTarget = "ALL";
    public boolean alwaysPrintError = true;
    public boolean exceptionStackTracerEnabled = true;
    public String localeCode = LocaleCode.getDefaultLocaleCode();

    public SettingContainer clone() throws CloneNotSupportedException {
        SettingContainer settingContainer = (SettingContainer)super.clone();
        return settingContainer;
    }

    public final synchronized void evaluateSettingScript(String string, String string2, String string3, boolean bl, boolean bl2) throws RINPnException {
        String string4;
        Object object;
        Object object2;
        String string5 = LocaleCode.getDefaultLocaleCode();
        File file = new File(string);
        VnanoEngine vnanoEngine = new VnanoEngine();
        try {
            object2 = new PluginLoader(DEFAULT_SETTING_SCRIPT_ENCODING);
            ((PluginLoader)object2).setPluginListPath(string3);
            ((PluginLoader)object2).load();
            for (Object object3 : ((PluginLoader)object2).getPluginInstances()) {
                vnanoEngine.connectPlugin("___VNANO_AUTO_KEY", object3);
            }
            vnanoEngine.connectPlugin("SettingContainer", this);
        }
        catch (Exception exception) {
            object = exception.getMessage();
            if (exception.getCause() != null && exception.getCause().getMessage() != null) {
                object = exception.getCause().getMessage();
            }
            if (string5.equals("en-us")) {
                MessageManager.showErrorMessage((String)object, "Plug-in Loading Error", string5, this.alwaysPrintError);
            }
            if (string5.equals("ja-jp")) {
                MessageManager.showErrorMessage((String)object, "\u30d7\u30e9\u30b0\u30a4\u30f3\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc", string5, this.alwaysPrintError);
            }
            System.err.println("\n" + (String)object);
            MessageManager.showExceptionStackTrace(exception, string5);
        }
        object2 = new HashMap();
        object2.put("MAIN_SCRIPT_NAME", file.getName());
        object2.put("DUMPER_ENABLED", bl2);
        object2.put("ACCELERATOR_ENABLED", false);
        object2.put("UI_MODE", bl ? "GUI" : "CUI");
        try {
            vnanoEngine.setOptionMap((Map<String, Object>)object2);
        }
        catch (VnanoException vnanoException) {
            throw new RINPnFatalException(vnanoException);
        }
        if (bl2) {
            System.out.println("");
            System.out.println("################################################################################");
            System.out.println("### - Debug Info -");
            System.out.println("###   Results of \"--dump\" option of the Vnano Engine for the setting script");
            System.out.println("################################################################################");
            System.out.println("");
        }
        try {
            object = new ScriptLoader(DEFAULT_SETTING_SCRIPT_ENCODING);
            ((ScriptLoader)object).setMainScriptPath(file.getPath());
            ((ScriptLoader)object).load();
            string4 = ((ScriptLoader)object).getMainScriptContent();
            vnanoEngine.executeScript(string4);
        }
        catch (VnanoException | VnanoFatalException exception) {
            String string6 = MessageManager.customizeExceptionMessage(exception.getMessage());
            if (string5.equals("en-us")) {
                MessageManager.showErrorMessage(string6, "Setting Error", string5, this.alwaysPrintError);
            }
            if (string5.equals("ja-jp")) {
                MessageManager.showErrorMessage(string6, "\u8a2d\u5b9a\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u30a8\u30e9\u30fc", string5, this.alwaysPrintError);
            }
            throw new RINPnException(exception);
        }
        try {
            vnanoEngine.disconnectAllPlugins();
        }
        catch (Exception exception) {
            string4 = exception.getMessage();
            if (exception.getCause() != null && exception.getCause().getMessage() != null) {
                string4 = exception.getCause().getMessage();
            }
            if (string5.equals("en-us")) {
                MessageManager.showErrorMessage(string4, "Plug-in Finalization Error", string5, this.alwaysPrintError);
            }
            if (string5.equals("ja-jp")) {
                MessageManager.showErrorMessage(string4, "\u30d7\u30e9\u30b0\u30a4\u30f3\u7d42\u4e86\u6642\u51e6\u7406\u30a8\u30e9\u30fc", string5, this.alwaysPrintError);
            }
            System.err.println("\n" + string4);
            MessageManager.showExceptionStackTrace(exception, string5);
        }
        this.checkAndNormalizeSettingValues();
    }

    private final void checkAndNormalizeSettingValues() throws RINPnException {
        boolean bl = false;
        String string = null;
        this.localeCode = this.localeCode.toLowerCase(Locale.ROOT);
        if (!LocaleCode.isSupported(this.localeCode)) {
            if (this.localeCode.equals("en-us")) {
                string = "The locale-code \"" + this.localeCode + "\" is not supported.";
            }
            if (this.localeCode.equals("ja-jp")) {
                string = "\u975e\u5bfe\u5fdc\u306e\u30ed\u30b1\u30fc\u30eb\u30b3\u30fc\u30c9 \"" + this.localeCode + "\" \u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
            }
            bl = true;
        }
        if (this.localeCode.equals("auto")) {
            this.localeCode = LocaleCode.getDefaultLocaleCode();
        }
        if (this.textFieldFontSize <= 0) {
            if (this.localeCode.equals("en-us")) {
                string = "The value of \"textFieldFontSize\" should be grater than 0.";
            }
            if (this.localeCode.equals("ja-jp")) {
                string = "\"textFieldFontSize\" \u306e\u5024\u306f 0 \u3088\u308a\u3082\u5927\u304d\u3044\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002";
            }
            bl = true;
        }
        if (this.windowWidth <= 0) {
            if (this.localeCode.equals("en-us")) {
                string = "The value of \"windowWidth\" should be grater than 0.";
            }
            if (this.localeCode.equals("ja-jp")) {
                string = "\"windowWidth\" \u306e\u5024\u306f 0 \u3088\u308a\u3082\u5927\u304d\u3044\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002";
            }
            bl = true;
        }
        if (this.windowHeight <= 0) {
            if (this.localeCode.equals("en-us")) {
                string = "The value of \"windowHeight\" should be grater than 0.";
            }
            if (this.localeCode.equals("ja-jp")) {
                string = "\"windowHeight\" \u306e\u5024\u306f 0 \u3088\u308a\u3082\u5927\u304d\u3044\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002";
            }
            bl = true;
        }
        if (this.windowOpacity <= 0.0) {
            if (this.localeCode.equals("en-us")) {
                string = "The value of \"windowOpacity\" should be grater than 0.";
            }
            if (this.localeCode.equals("ja-jp")) {
                string = "\"windowOpacity\" \u306e\u5024\u306f 0 \u3088\u308a\u3082\u5927\u304d\u3044\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002";
            }
            bl = true;
        }
        if (this.windowBackgroundColorR < 0 || 255 < this.windowBackgroundColorR) {
            if (this.localeCode.equals("en-us")) {
                string = "The value of \"windowBackgroundColorR\" should be in the range of 0 ~ 255.";
            }
            if (this.localeCode.equals("ja-jp")) {
                string = "\"windowBackgroundColorR\" \u306e\u5024\u306f 0 ~ 255 \u306e\u7bc4\u56f2\u5185\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            }
            bl = true;
        }
        if (this.windowBackgroundColorG < 0 || 255 < this.windowBackgroundColorG) {
            if (this.localeCode.equals("en-us")) {
                string = "The value of \"windowBackgroundColorG\" should be in the range of 0 ~ 255.";
            }
            if (this.localeCode.equals("ja-jp")) {
                string = "\"windowBackgroundColorG\" \u306e\u5024\u306f 0 ~ 255 \u306e\u7bc4\u56f2\u5185\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            }
            bl = true;
        }
        if (this.windowBackgroundColorB < 0 || 255 < this.windowBackgroundColorB) {
            if (this.localeCode.equals("en-us")) {
                string = "The value of \"windowBackgroundColorB\" should be in the range of 0 ~ 255.";
            }
            if (this.localeCode.equals("ja-jp")) {
                string = "\"windowBackgroundColorB\" \u306e\u5024\u306f 0 ~ 255 \u306e\u7bc4\u56f2\u5185\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            }
            bl = true;
        }
        if (this.textFieldBackgroundColorR < 0 || 255 < this.textFieldBackgroundColorR) {
            if (this.localeCode.equals("en-us")) {
                string = "The value of \"textFieldBackgroundColorR\" should be in the range of 0 ~ 255.";
            }
            if (this.localeCode.equals("ja-jp")) {
                string = "\"textFieldBackgroundColorR\" \u306e\u5024\u306f 0 ~ 255 \u306e\u7bc4\u56f2\u5185\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            }
            bl = true;
        }
        if (this.textFieldBackgroundColorG < 0 || 255 < this.textFieldBackgroundColorG) {
            if (this.localeCode.equals("en-us")) {
                string = "The value of \"textFieldBackgroundColorG\" should be in the range of 0 ~ 255.";
            }
            if (this.localeCode.equals("ja-jp")) {
                string = "\"textFieldBackgroundColorG\" \u306e\u5024\u306f 0 ~ 255 \u306e\u7bc4\u56f2\u5185\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            }
            bl = true;
        }
        if (this.textFieldBackgroundColorB < 0 || 255 < this.textFieldBackgroundColorB) {
            if (this.localeCode.equals("en-us")) {
                string = "The value of \"textFieldBackgroundColorB\" should be in the range of 0 ~ 255.";
            }
            if (this.localeCode.equals("ja-jp")) {
                string = "\"textFieldBackgroundColorB\" \u306e\u5024\u306f 0 ~ 255 \u306e\u7bc4\u56f2\u5185\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            }
            bl = true;
        }
        if (this.textFieldForegroundColorR < 0 || 255 < this.textFieldForegroundColorR) {
            if (this.localeCode.equals("en-us")) {
                string = "The value of \"textFieldForegroundColorR\" should be in the range of 0 ~ 255.";
            }
            if (this.localeCode.equals("ja-jp")) {
                string = "\"textFieldForegroundColorR\" \u306e\u5024\u306f 0 ~ 255 \u306e\u7bc4\u56f2\u5185\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            }
            bl = true;
        }
        if (this.textFieldForegroundColorG < 0 || 255 < this.textFieldForegroundColorG) {
            if (this.localeCode.equals("en-us")) {
                string = "The value of \"textFieldForegroundColorG\" should be in the range of 0 ~ 255.";
            }
            if (this.localeCode.equals("ja-jp")) {
                string = "\"textFieldForegroundColorG\" \u306e\u5024\u306f 0 ~ 255 \u306e\u7bc4\u56f2\u5185\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            }
            bl = true;
        }
        if (this.textFieldForegroundColorB < 0 || 255 < this.textFieldForegroundColorB) {
            if (this.localeCode.equals("en-us")) {
                string = "The value of \"textFieldForegroundColorB\" should be in the range of 0 ~ 255.";
            }
            if (this.localeCode.equals("ja-jp")) {
                string = "\"textFieldForegroundColorB\" \u306e\u5024\u306f 0 ~ 255 \u306e\u7bc4\u56f2\u5185\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            }
            bl = true;
        }
        try {
            if (!this.roundingMode.equals("HALF_TO_EVEN")) {
                RoundingMode.valueOf(this.roundingMode);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.localeCode.equals("en-us")) {
                string = "Invalid value of \"roundingMode\": " + this.roundingMode;
            }
            if (this.localeCode.equals("ja-jp")) {
                string = "\"roundingMode\" \u306b\u3001\u6b63\u3057\u3044\u9078\u629e\u80a2\u306b\u306f\u7121\u3044\u5024\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059: " + this.roundingMode;
            }
            bl = true;
        }
        try {
            RoundingTarget.valueOf(this.roundingTarget);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.localeCode.equals("en-us")) {
                string = "Invalid value of \"roundingTarget\": " + this.roundingMode;
            }
            if (this.localeCode.equals("ja-jp")) {
                string = "\"roundingTarget\" \u306b\u3001\u6b63\u3057\u3044\u9078\u629e\u80a2\u306b\u306f\u7121\u3044\u5024\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059: " + this.roundingMode;
            }
            bl = true;
        }
        if (this.roundingLength < 1 || 100 < this.roundingLength) {
            if (this.localeCode.equals("en-us")) {
                string = "The value of \"roundingLength\" should be in the range of 1 ~ 100.";
            }
            if (this.localeCode.equals("ja-jp")) {
                string = "\"roundingLength\" \u306e\u5024\u306f 1 ~ 100 \u306e\u7bc4\u56f2\u5185\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            }
            bl = true;
        }
        if (bl) {
            String string2 = null;
            if (this.localeCode.equals("en-us")) {
                string2 = "Setting Error";
            }
            if (this.localeCode.equals("ja-jp")) {
                string2 = "\u8a2d\u5b9a\u30a8\u30e9\u30fc";
            }
            MessageManager.showErrorMessage(string, string2, this.localeCode, this.alwaysPrintError);
            throw new RINPnException(string);
        }
    }
}

