/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process;

import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ProcessEngineDriveInterface;

public class ProcessEngineDriveManager
implements Runnable {
    private boolean mainRoop = true;
    public ProcessEngine engine;
    public ProcessEngineDriveInterface drive;
    public Thread thread = null;
    private int wait = 1000;
    private int waitOffset = 0;
    private long startTime = 0L;
    private long endTime = 1000L;
    private long inTime = 0L;
    private long flops = 1000L;
    private long maxFlops = 3000000L;
    private boolean processRequest = false;

    public ProcessEngineDriveManager(ProcessEngine processEngine, ProcessEngineDriveInterface processEngineDriveInterface) {
        this.engine = processEngine;
        this.drive = processEngineDriveInterface;
        this.start();
    }

    public void setProcessEngine(ProcessEngine processEngine) {
        this.engine = processEngine;
    }

    public void setProcessEngineDriveInterface(ProcessEngineDriveInterface processEngineDriveInterface) {
        this.drive = processEngineDriveInterface;
    }

    public void init() {
    }

    public void dispose() {
        this.disposeResource();
    }

    public void disposeResource() {
        this.mainRoop = false;
        this.thread = null;
        this.engine = null;
        this.drive = null;
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void outputDriveFrequency(long l) {
        if (this.drive != null) {
            this.drive.processEngineDriving(l);
        }
    }

    @Override
    public void run() {
        while (this.mainRoop) {
            if (this.processRequest) {
                this.engine.process(null);
                this.processRequest = false;
            }
            this.inTime = this.endTime - this.startTime;
            if (this.inTime > 2000L) {
                this.wait /= 2;
            } else if (this.inTime < 500L) {
                this.wait *= 2;
            } else if (this.inTime > 1500L) {
                this.wait = (int)((double)this.wait / 1.5);
            } else if (this.inTime < 750L) {
                this.wait = (int)((double)this.wait * 1.5);
            } else if (this.inTime > 1100L) {
                this.wait = (int)((double)this.wait / 1.2);
            } else if (this.inTime < 900L) {
                this.wait = (int)((double)this.wait * 1.2);
            } else if (this.inTime > 1010L) {
                --this.wait;
            } else if (this.inTime < 990L) {
                ++this.wait;
            }
            if (this.wait < 0) {
                this.wait = 1;
            } else if (this.wait > 10000) {
                this.wait = 10000;
            }
            if (this.engine == null) {
                this.flops = 0L;
            } else {
                this.flops = this.engine.operationCounter;
                this.engine.operationCounter = 0L;
            }
            this.outputDriveFrequency(this.flops);
            this.startTime = System.currentTimeMillis();
            try {
                Thread.sleep(this.wait + this.waitOffset);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.endTime = System.currentTimeMillis();
        }
    }
}

