/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process;

import javax.swing.JOptionPane;
import rxvesapi.process.ProcessCompatibilityException;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.decode.ProcessCodeGenericsTokenizer;
import rxvesapi.process.decode.ProcessCodeScopeForm;
import rxvesapi.process.kernel.FunctionCallKernel;
import rxvesapi.process.kernel.ProcessKernel;
import rxvesapi.process.kernel.ScopeCallKernel;
import rxvesapi.process.object.ProcessStruct;
import rxvesapi.process.unit.FunctionCallUnit;
import rxvesapi.process.unit.ProcessUnit;

public class ProcessProgram {
    private boolean runtimeCompileSecurityState = false;
    public ProcessEngine ENGINE;
    public ScopeCallKernel KERNEL;
    private String NAME;
    public String CODE;
    public ProcessUnit[] VARIABLE;
    public ProcessStruct[] struct;
    public FunctionCallKernel[] FUNCTION;
    public int VARIABLE_ACCESSABLE_INDEX = 0;
    public int FUNCTION_ACCESSABLE_INDEX = 0;
    public String[] INCLUDE_PROGRAM_NAME;
    public String[] IMPORT_PROGRAM_NAME;
    public ProcessProgram[] IMPORT_PROGRAM;
    public static final int PRAGMA_COMPILE_ALL = 1;
    public static final int PRAGMA_COMPILE_REFFERED = 2;
    private boolean compileAll = true;

    public ProcessEngine getProcessEngine() {
        return this.ENGINE;
    }

    public ProcessProgram(String string, String string2, ProcessEngine processEngine) {
        this.NAME = this.getEscapedProgramName(string);
        this.CODE = string2;
        this.VARIABLE = new ProcessUnit[0];
        this.struct = new ProcessStruct[0];
        this.FUNCTION = new FunctionCallKernel[0];
        this.INCLUDE_PROGRAM_NAME = new String[0];
        this.IMPORT_PROGRAM_NAME = new String[0];
        this.IMPORT_PROGRAM = new ProcessProgram[0];
        this.ENGINE = processEngine;
    }

    public void disposeResource() {
    }

    public void dispose() {
        this.disposeResource();
    }

    public String getEscapedProgramName(String string) {
        String string2 = string;
        string2 = string2.replaceAll(" ", "_");
        string2 = string2.replaceAll("\\(", "_");
        string2 = string2.replaceAll("\\)", "_");
        string2 = string2.replaceAll("\\[", "_");
        string2 = string2.replaceAll("\\]", "_");
        string2 = string2.replaceAll("\\^", "_");
        string2 = string2.replaceAll("\\$", "_");
        string2 = string2.replaceAll("\\$", "_");
        string2 = string2.replaceAll("\\*", "_");
        string2 = string2.replaceAll("\\+", "_");
        string2 = string2.replaceAll("\\?", "_");
        string2 = string2.replaceAll("\\|", "_");
        string2 = string2.replaceAll("&", "_");
        string2 = string2.replaceAll("-", "_");
        string2 = string2.replaceAll("/", "_");
        string2 = string2.replaceAll("%", "_");
        string2 = string2.replaceAll("@", "_");
        string2 = string2.replaceAll("<", "_");
        string2 = string2.replaceAll(">", "_");
        string2 = string2.replaceAll("\"", "_");
        string2 = string2.replaceAll("'", "_");
        string2 = string2.replaceAll("#", "_");
        string2 = string2.replaceAll("!", "_");
        string2 = string2.replaceAll("=", "_");
        string2 = string2.replaceAll("~", "_");
        string2 = string2.replaceAll(":", "_");
        string2 = string2.replaceAll(";", "_");
        string2 = string2.replaceAll("\\{", "_");
        string2 = string2.replaceAll("\\}", "_");
        string2 = string2.replaceAll("`", "_");
        string2 = string2.replaceAll(",", "_");
        string2 = string2.replaceAll("\\\\", "_");
        return string2;
    }

    public void setAccessableAll() {
        this.VARIABLE_ACCESSABLE_INDEX = Integer.MAX_VALUE;
        this.FUNCTION_ACCESSABLE_INDEX = Integer.MAX_VALUE;
    }

    public boolean isImported(String string) {
        for (int i = 0; i < this.IMPORT_PROGRAM_NAME.length; ++i) {
            if (string.equals("System") || !this.IMPORT_PROGRAM_NAME[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public void importProgram() {
        if (this.IMPORT_PROGRAM_NAME.length == 0) {
            return;
        }
        this.IMPORT_PROGRAM = new ProcessProgram[this.IMPORT_PROGRAM_NAME.length];
        int n = this.IMPORT_PROGRAM_NAME.length;
        ProcessProgram[] processProgramArray = this.ENGINE.getProgarmList();
        int n2 = processProgramArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            this.IMPORT_PROGRAM[i] = this.getProgramByName(this.IMPORT_PROGRAM_NAME[i]);
            if (this.IMPORT_PROGRAM[i] != null) continue;
            String string2 = string = this.IMPORT_PROGRAM_NAME[i];
            this.IMPORT_PROGRAM[i] = this.getProgramByName(string2);
            if (this.IMPORT_PROGRAM[i] != null) continue;
            if (ScriptProcessor.locale.isJapanese()) {
                String string3 = "import \u5bfe\u8c61\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u300c" + this.IMPORT_PROGRAM_NAME[i] + "\u300d\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002";
                this.ENGINE.error(string3);
            } else {
                String string4 = "Could not find The program \"" + this.IMPORT_PROGRAM_NAME[i] + "\" which is specified to be \"import\"-ed.";
                this.ENGINE.error(string4);
            }
            return;
        }
    }

    public ProcessProgram getProgramByName(String string) {
        ProcessProgram[] processProgramArray = this.ENGINE.getProgarmList();
        int n = processProgramArray.length;
        for (int i = 0; i < n; ++i) {
            if (processProgramArray[i] == null || !processProgramArray[i].NAME.equals(string)) continue;
            return processProgramArray[i];
        }
        return null;
    }

    public FunctionCallKernel getDefaultConstructor(ProcessUnit[] processUnitArray) {
        FunctionCallKernel functionCallKernel = this.getFunction(this.NAME, processUnitArray);
        return functionCallKernel;
    }

    public FunctionCallKernel getDefaultConstructor() {
        ProcessUnit[] processUnitArray = new ProcessUnit[]{};
        FunctionCallKernel functionCallKernel = this.getFunction(this.NAME, processUnitArray);
        return functionCallKernel;
    }

    public void printFunctionLoadInfo(ProcessCodeScopeForm processCodeScopeForm) {
        int n;
        String string = processCodeScopeForm.type;
        for (n = 0; n < processCodeScopeForm.dimension; ++n) {
            string = string + "[]";
        }
        string = string + " ";
        string = string + processCodeScopeForm.name;
        string = string + "( ";
        string = string + processCodeScopeForm.argument;
        string = string + " )";
        for (n = 0; n < this.ENGINE.engineDriver.length; ++n) {
            if (this.ENGINE.engineDriver[n] == null || this.ENGINE.hasError()) continue;
            this.ENGINE.engineDriver[0].processFunctionDecoded("   COMPILE > " + string);
        }
    }

    public void printInfo(String string) {
        for (int i = 0; i < this.ENGINE.engineDriver.length; ++i) {
            if (this.ENGINE.engineDriver[i] == null || this.ENGINE.hasError()) continue;
            this.ENGINE.engineDriver[0].processFunctionDecoded(string);
        }
    }

    public void setCompilePragma(int n) {
        this.compileAll = n == 1;
    }

    public void ready() {
        this.setAccessableAll();
        this.printInfo("");
        this.printInfo("COMPILE > " + this.getName());
        this.KERNEL.ready();
        for (int i = 0; i < this.FUNCTION.length; ++i) {
            if (this.FUNCTION[i] == null) continue;
            this.printFunctionLoadInfo(this.FUNCTION[i].form);
            if (this.ENGINE.fullDecode) {
                if (!this.compileAll) continue;
                this.FUNCTION[i].ready();
                continue;
            }
            if (this.FUNCTION[i].isConstructor()) {
                this.FUNCTION[i].ready();
                continue;
            }
            if (this.FUNCTION[i].getFunctionName().equals("main")) {
                this.FUNCTION[i].ready();
                continue;
            }
            if (!this.FUNCTION[i].using()) continue;
            this.FUNCTION[i].ready();
        }
        this.checkMemberVariable();
    }

    void checkMemberVariable() {
        for (ProcessUnit processUnit : this.VARIABLE) {
            ProcessCompatibilityException processCompatibilityException;
            if (processUnit == null || this.getName().equals("System")) continue;
            if (processUnit.isConst() && processUnit.getValueType() == 103 && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.ENGINE.error(this.getName() + "." + processUnit.getName() + " : varfloat\u578b\u306e\u30b0\u30ed\u30fc\u30d0\u30eb\u5b9a\u6570 ( const ) \u306f\u63a8\u5968\u3055\u308c\u307e\u305b\u3093\u3002varfloat\u578b\u306e\u7cbe\u5ea6\u306f\u201c\u5b9f\u884c\u4e2d\u201d\u306bdigit\u95a2\u6570\u306b\u3088\u3063\u3066\u8a2d\u5b9a\u3055\u308c\u307e\u3059\u304c\u3001\u30b0\u30ed\u30fc\u30d0\u30eb\u5b9a\u6570\u306f\u201c\u5b9f\u884c\u524d\u201d\u306b\u521d\u671f\u5316\u3055\u308c\u307e\u3059\u3002\u3053\u306e\u305f\u3081 varfloat\u578b\u306e\u30b0\u30ed\u30fc\u30d0\u30eb\u5b9a\u6570\u306f\u3001\u5ba3\u8a00\u884c\u306b\u3088\u3089\u305a\u30b7\u30b9\u30c6\u30e0\u30c7\u30d5\u30a9\u30eb\u30c8\u8a2d\u5b9a\u306e\u7cbe\u5ea6\u3067\u521d\u671f\u5316\u3055\u308c\u308b\u305f\u3081\u3001\u5272\u308a\u5207\u308c\u306a\u3044\u5024\u3067\u521d\u671f\u5316\u3057\u305f\u5834\u5408\u306b\u5371\u967a\u3067\u3059\u3002");
                } else {
                    this.ENGINE.error(this.getName() + "." + processUnit.getName() + " : Using varfloat-type global constants (const variables) is not recommended. In general, you can change the precision of varfloat-type variables using \"digit\" function, but const variables are initalized when the program is started. So const varfloat-type variables has values in the system-default precision, regardless the precision specified by \"digit\" function. It is confusing, so we never recommend to declare varfloat variables as constants.");
                }
            }
            if (!processUnit.isConst() || processUnit.getValueType() != 141 || (processCompatibilityException = new ProcessCompatibilityException()).alert()) continue;
            if (ScriptProcessor.locale.isJapanese()) {
                this.ENGINE.error(this.getName() + "." + processUnit.getName() + " : varcomplex\u578b\u306e\u30b0\u30ed\u30fc\u30d0\u30eb\u5b9a\u6570 ( const ) \u306f\u63a8\u5968\u3055\u308c\u307e\u305b\u3093\u3002varfloat\u578b\u306e\u7cbe\u5ea6\u306f\u201c\u5b9f\u884c\u4e2d\u201d\u306bdigit\u95a2\u6570\u306b\u3088\u3063\u3066\u8a2d\u5b9a\u3055\u308c\u307e\u3059\u304c\u3001\u30b0\u30ed\u30fc\u30d0\u30eb\u5b9a\u6570\u306f\u201c\u5b9f\u884c\u524d\u201d\u306b\u521d\u671f\u5316\u3055\u308c\u307e\u3059\u3002\u3053\u306e\u305f\u3081 varcomplex\u578b\u306e\u30b0\u30ed\u30fc\u30d0\u30eb\u5b9a\u6570\u306f\u3001\u5ba3\u8a00\u884c\u306b\u3088\u3089\u305a\u30b7\u30b9\u30c6\u30e0\u30c7\u30d5\u30a9\u30eb\u30c8\u8a2d\u5b9a\u306e\u7cbe\u5ea6\u3067\u521d\u671f\u5316\u3055\u308c\u308b\u305f\u3081\u3001\u5272\u308a\u5207\u308c\u306a\u3044\u5024\u3067\u521d\u671f\u5316\u3057\u305f\u5834\u5408\u306b\u5371\u967a\u3067\u3059\u3002");
                continue;
            }
            this.ENGINE.error(this.getName() + "." + processUnit.getName() + " : Using varcomplex-type global constants (const variables) is not recommended. In general, you can change the precision of varcomplex-type variables using \\\"digit\\\" function, but const variables are initalized when the program is started. So const varcomplex-type variables has values in the system-default precision, regardless the precision specified by \\\"digit\\\" function. It is confusing, so we never recommend to declare varcomplex variables as constants.");
        }
    }

    public void initConst() {
        this.KERNEL.getProcessScope().initConst();
    }

    public void process() {
        this.KERNEL.getProcessScope().STACK_TRACE = true;
        this.KERNEL.process();
    }

    public void callMain(ProcessUnit[] processUnitArray) {
        Object object;
        FunctionCallKernel functionCallKernel = this.getFunction("main", processUnitArray);
        if (functionCallKernel == null) {
            object = new ProcessUnit[]{};
            functionCallKernel = this.getFunction("main", (ProcessUnit[])object);
        }
        if (functionCallKernel != null) {
            object = new FunctionCallUnit(processUnitArray, functionCallKernel, this.ENGINE);
            ((ProcessUnit)object).setProcessKernel(functionCallKernel);
            ((FunctionCallUnit)object).process();
            return;
        }
    }

    public void exitAllFunctions() {
        int n = this.FUNCTION.length;
        for (int i = 0; i < n; ++i) {
            if (this.FUNCTION[i] == null) continue;
            this.FUNCTION[i].exit();
        }
    }

    public void callConstructor(ProcessUnit[] processUnitArray) {
        FunctionCallKernel[] functionCallKernelArray = this.getConstructor(processUnitArray);
        int n = functionCallKernelArray.length;
        for (int i = 0; i < n; ++i) {
            functionCallKernelArray[i].call(processUnitArray);
        }
    }

    public void callDefaultConstructor() {
        ProcessUnit[] processUnitArray = new ProcessUnit[]{};
        FunctionCallKernel[] functionCallKernelArray = this.getConstructor(processUnitArray);
        int n = functionCallKernelArray.length;
        for (int i = 0; i < n; ++i) {
            functionCallKernelArray[i].call(processUnitArray);
        }
    }

    public String getName() {
        return this.NAME;
    }

    public void setName(String string) {
        this.NAME = this.getEscapedProgramName(string);
    }

    public void addImport(String string) {
        int n;
        int n2 = this.IMPORT_PROGRAM_NAME.length;
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = this.IMPORT_PROGRAM_NAME[n];
        }
        this.IMPORT_PROGRAM_NAME = new String[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.IMPORT_PROGRAM_NAME[n] = stringArray[n];
        }
        this.IMPORT_PROGRAM_NAME[n2] = string;
        stringArray = null;
    }

    public void addInclude(String string) {
        int n;
        int n2 = this.INCLUDE_PROGRAM_NAME.length;
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = this.INCLUDE_PROGRAM_NAME[n];
        }
        this.INCLUDE_PROGRAM_NAME = new String[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.INCLUDE_PROGRAM_NAME[n] = stringArray[n];
        }
        this.INCLUDE_PROGRAM_NAME[n2] = string;
        stringArray = null;
    }

    public boolean isIncluded(String string) {
        for (String string2 : this.INCLUDE_PROGRAM_NAME) {
            if (string.equals(string2)) {
                return true;
            }
            String[] stringArray = string2.split(".");
            if (2 > stringArray.length || !string.equals(string2 = stringArray[stringArray.length - 1])) continue;
            return true;
        }
        return false;
    }

    public void addVariable(ProcessUnit processUnit) {
        int n;
        int n2 = this.VARIABLE.length;
        ProcessUnit[] processUnitArray = new ProcessUnit[n2];
        for (n = 0; n < n2; ++n) {
            processUnitArray[n] = this.VARIABLE[n];
        }
        this.VARIABLE = new ProcessUnit[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.VARIABLE[n] = processUnitArray[n];
        }
        this.VARIABLE[n2] = processUnit;
        processUnitArray = null;
    }

    public void addStruct(ProcessStruct processStruct) {
        int n;
        int n2 = this.struct.length;
        ProcessStruct[] processStructArray = new ProcessStruct[n2];
        for (n = 0; n < n2; ++n) {
            processStructArray[n] = this.struct[n];
        }
        this.struct = new ProcessStruct[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.struct[n] = processStructArray[n];
        }
        this.struct[n2] = processStruct;
        processStructArray = null;
    }

    public void addFunction(FunctionCallKernel functionCallKernel) {
        int n;
        int n2 = this.FUNCTION.length;
        FunctionCallKernel[] functionCallKernelArray = new FunctionCallKernel[n2];
        for (n = 0; n < n2; ++n) {
            functionCallKernelArray[n] = this.FUNCTION[n];
        }
        this.FUNCTION = new FunctionCallKernel[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.FUNCTION[n] = functionCallKernelArray[n];
        }
        this.FUNCTION[n2] = functionCallKernel;
        functionCallKernelArray = null;
    }

    public boolean isCompetitiveFunction(FunctionCallKernel functionCallKernel) {
        for (int i = 0; i < this.FUNCTION.length; ++i) {
            if (this.FUNCTION[i] == null || !this.FUNCTION[i].isCompetitive(functionCallKernel)) continue;
            return true;
        }
        return false;
    }

    boolean checkVariableWarning(String string, boolean bl) {
        ProcessCompatibilityException processCompatibilityException;
        if (!bl) {
            return true;
        }
        boolean bl2 = false;
        String string2 = this.getName();
        String string3 = "";
        if (string2.equals("GUI")) {
            if (string.equals("SIZE_INNER")) {
                bl2 = true;
                string3 = "INNER";
            } else if (string.equals("SIZE_OUTER")) {
                bl2 = true;
                string3 = "OUTER";
            } else if (string.equals("VALUE_ALL")) {
                bl2 = true;
                string3 = "LISTED";
            } else if (string.equals("VALUE_SELECTED")) {
                bl2 = true;
                string3 = "SELECTED";
            }
        } else if (string2.equals("Graphics3D")) {
            if (string.equals("VERTEX_QUADRANGLE_LIST")) {
                bl2 = true;
                string3 = "QUADRANGLE_LIST";
            } else if (string.equals("VERTEX_QUADRANGLE_GRID")) {
                bl2 = true;
                string3 = "QUADRANGLE_GRID";
            } else if (string.equals("VERTEX_TRIANGLE_LIST")) {
                bl2 = true;
                string3 = "TRIANGLE_LIST";
            } else if (string.equals("VERTEX_TRIANGLE_STRIP")) {
                bl2 = true;
                string3 = "TRIANGLE_STRIP";
            } else if (string.equals("VERTEX_TRIANGLE_FAN")) {
                bl2 = true;
                string3 = "TRIANGLE_FAN";
            }
        }
        if (bl2 && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.ENGINE.error(string2 + "." + string + " \u306e\u4f7f\u7528\u306f\u63a8\u5968\u3055\u308c\u307e\u305b\u3093\u3002 " + string2 + "." + string3 + " \u3092\u4f7f\u7528\u3057\u3066\u4e0b\u3055\u3044\u3002");
            } else {
                this.ENGINE.error("The variable \"" + string2 + "." + string + "\" is deprecated. Please use \"" + string2 + "." + string3 + "\" instead.");
            }
        }
        return !bl2;
    }

    public ProcessUnit getMemberVariable(String string, boolean bl, boolean bl2) {
        if (!this.checkVariableWarning(string, bl2)) {
            return null;
        }
        int n = this.VARIABLE.length;
        for (int i = n - 1; 0 <= i; --i) {
            if (bl) {
                if (this.VARIABLE[i] == null || !this.VARIABLE[i].name.equals(string)) continue;
                if (bl2) {
                    if (this.VARIABLE[i].getAccessPermission() != 100) continue;
                    return this.VARIABLE[i];
                }
                return this.VARIABLE[i];
            }
            if (this.VARIABLE[i] == null || !this.VARIABLE[i].id.equals(string)) continue;
            if (bl2) {
                if (this.VARIABLE[i].getAccessPermission() != 100) continue;
                return this.VARIABLE[i];
            }
            return this.VARIABLE[i];
        }
        return null;
    }

    public ProcessStruct getMemberStruct(String string, boolean bl) {
        return this.getMemberStruct(string, bl, null);
    }

    public ProcessStruct getMemberStruct(String string, boolean bl, String[] stringArray) {
        int n = this.struct.length;
        for (int i = n - 1; 0 <= i; --i) {
            if (this.struct[i] == null || !this.struct[i].getType().equals(string)) continue;
            if (bl) {
                if (this.struct[i].getAccessPermission() != 1) continue;
                return this.struct[i].getStruct(stringArray);
            }
            return this.struct[i].getStruct(stringArray);
        }
        return null;
    }

    public ProcessUnit getVariable(String string) {
        return this.getVariable(string, true, false);
    }

    public ProcessUnit getIDVariable(String string) {
        return this.getVariable(string, false, false);
    }

    private ProcessUnit getVariable(String string, boolean bl) {
        return this.getVariable(string, bl, false);
    }

    private ProcessUnit getVariable(String string, boolean bl, boolean bl2) {
        int n;
        Object object;
        String string2 = string;
        String string3 = null;
        if (0 <= string.indexOf(".")) {
            object = string.split("\\.");
            if (((String[])object).length < 2) {
                return null;
            }
            string2 = object[((String[])object).length - 1];
            string3 = "";
            for (int i = 0; i < ((String[])object).length - 2; ++i) {
                string3 = string3 + object[i] + ".";
            }
            string3 = string3 + object[((String[])object).length - 2];
        }
        if (string3 == null) {
            object = this.getMemberVariable(string2, bl, false);
            if (object != null) {
                return object;
            }
            ProcessUnit processUnit = null;
            if (object == null && this.IMPORT_PROGRAM != null) {
                for (int i = this.IMPORT_PROGRAM.length - 1; 0 <= i; --i) {
                    if (this.IMPORT_PROGRAM[i] == null || (processUnit = this.IMPORT_PROGRAM[i].getMemberVariable(string2, bl, true)) == null) continue;
                    return processUnit;
                }
            }
            ProcessUnit[] processUnitArray = this.ENGINE.getVariableList();
            for (int i = Math.min(this.VARIABLE_ACCESSABLE_INDEX, processUnitArray.length - 1); 0 <= i; --i) {
                if (!(bl ? processUnitArray[i] != null && processUnitArray[i].name.equals(string2) && processUnitArray[i].getAccessPermission() == 100 : processUnitArray[i] != null && processUnitArray[i].id.equals(string2) && processUnitArray[i].getAccessPermission() == 100)) continue;
                return processUnitArray[i];
            }
            return null;
        }
        if (string3.equals("this") || string3.equals(this.NAME)) {
            object = this.getMemberVariable(string2, bl, bl2);
            if (object == null) {
                return null;
            }
            return object;
        }
        object = this.ENGINE.getAllProgram();
        String string4 = null;
        int n2 = ((String[])object).length;
        for (n = n2 - 1; 0 <= n; --n) {
            if (object[n] == null || !((ProcessProgram)((Object)object[n])).getName().equals(string3)) continue;
            string4 = object[n];
        }
        if (string4 == null) {
            for (n = n2 - 1; 0 <= n; --n) {
                String string5;
                String[] stringArray;
                if (object[n] == null || 1 > (stringArray = ((ProcessProgram)((Object)object[n])).getName().split("\\.")).length || !(string5 = stringArray[stringArray.length - 1]).equals(string3)) continue;
                string4 = object[n];
                string3 = ((ProcessProgram)((Object)object[n])).getName();
            }
        }
        if (string4 == null) {
            return null;
        }
        return super.getVariable(string3 + "." + string2, true, true);
    }

    public ProcessStruct getStruct(String string) {
        return this.getStruct(string, false);
    }

    private ProcessStruct getStruct(String string, boolean bl) {
        String string2;
        String[] stringArray;
        int n;
        Object object;
        String string3 = string;
        if (0 <= string3.indexOf(91)) {
            string3 = string3.substring(0, string3.indexOf(91));
        }
        if (0 <= string3.indexOf(60)) {
            string3 = string3.substring(0, string3.indexOf(60));
        }
        if (0 <= string3.indexOf(44) || 0 <= string3.indexOf(40) || 0 <= string3.indexOf(41) || 0 <= string3.indexOf(34) || 0 <= string3.indexOf(39)) {
            return null;
        }
        boolean bl2 = false;
        String[] stringArray2 = null;
        if (0 <= string.indexOf(60) && 0 <= string.indexOf(62)) {
            bl2 = true;
            stringArray2 = ProcessCodeGenericsTokenizer.getTopLevelParameters(string);
            string = string.substring(0, string.indexOf(60));
        }
        String string4 = string;
        String string5 = null;
        if (0 <= string.indexOf(".")) {
            object = string.split("\\.");
            string4 = object[((String[])object).length - 1];
            string5 = "";
            for (int i = 0; i < ((String[])object).length - 2; ++i) {
                string5 = string5 + object[i] + ".";
            }
            string5 = string5 + object[((String[])object).length - 2];
        }
        if (string5 == null) {
            object = this.getMemberStruct(string4, false, stringArray2);
            if (object != null) {
                return object;
            }
            ProcessStruct processStruct = null;
            if (object == null && this.IMPORT_PROGRAM != null) {
                for (int i = this.IMPORT_PROGRAM.length - 1; 0 <= i; --i) {
                    if (this.IMPORT_PROGRAM[i] == null || (processStruct = this.IMPORT_PROGRAM[i].getMemberStruct(string4, true, stringArray2)) == null) continue;
                    return processStruct;
                }
            }
            ProcessStruct[] processStructArray = this.ENGINE.getStructList();
            for (int i = processStructArray.length - 1; 0 <= i; --i) {
                if (processStructArray[i] == null || !processStructArray[i].getType().equals(string4) || processStructArray[i].getAccessPermission() != 1) continue;
                return processStructArray[i].getStruct(stringArray2);
            }
            return null;
        }
        if (string5.equals("this") || string5.equals(this.NAME)) {
            object = this.getMemberStruct(string4, bl);
            if (object == null) {
                return null;
            }
            return object;
        }
        object = this.ENGINE.getAllProgram();
        String string6 = null;
        int n2 = ((String[])object).length;
        for (n = n2 - 1; 0 <= n; --n) {
            if (object[n] == null || !((ProcessProgram)((Object)object[n])).getName().equals(string5)) continue;
            string6 = object[n];
        }
        if (string6 == null) {
            for (n = n2 - 1; 0 <= n; --n) {
                if (object[n] == null || 1 > (stringArray = ((ProcessProgram)((Object)object[n])).getName().split("\\.")).length || !(string2 = stringArray[stringArray.length - 1]).equals(string5)) continue;
                string6 = object[n];
                string5 = ((ProcessProgram)((Object)object[n])).getName();
            }
        }
        string5 = string5.replaceAll(" ", "");
        string5 = string5.replaceAll("\t", "");
        if (string6 == null) {
            for (n = n2 - 1; 0 <= n; --n) {
                if (object[n] == null || 1 > (stringArray = ((ProcessProgram)((Object)object[n])).getName().split("\\.")).length || !(string2 = stringArray[stringArray.length - 1]).equals(string5)) continue;
                string6 = object[n];
                string5 = ((ProcessProgram)((Object)object[n])).getName();
            }
        }
        if (string6 == null) {
            return null;
        }
        return super.getStruct(string5 + "." + string4, true);
    }

    public boolean highLiskWarning(String string) {
        int n;
        String[] stringArray = ScriptProcessor.locale.isJapanese() ? new String[]{string, "\u5b9f\u884c\u3092\u8a31\u53ef\u3057\u307e\u3059\u304b ?", "\u3000", "\u300c \u3044\u3044\u3048 \u300d\u3092\u9078\u629e\u3059\u308b\u3068\u3001\u30d7\u30ed\u30b0\u30e9\u30e0\u3092\u5f37\u5236\u7d42\u4e86\u3057\u307e\u3059\u3002"} : new String[]{string, "Do you permit it ?", "  ", "(If you select \"No\", this program will be terminated.)"};
        int n2 = JOptionPane.showConfirmDialog(null, stringArray, "! WARNING", 0);
        if (n2 == 0 && (n = ScriptProcessor.locale.isJapanese() ? JOptionPane.showConfirmDialog(null, "\u672c\u5f53\u306b\u5b9f\u884c\u3092\u8a31\u53ef\u3057\u307e\u3059\u304b ?", "! WARNING", 0) : JOptionPane.showConfirmDialog(null, "Are you sure to permit it ?", "! WARNING", 0)) == 0) {
            return true;
        }
        this.ENGINE.abnormallyExit();
        return false;
    }

    public FunctionCallKernel getMemberFunction(String string, boolean bl, boolean bl2, String[] stringArray) {
        int n = this.FUNCTION.length;
        for (int i = n - 1; 0 <= i; --i) {
            if (this.FUNCTION[i] == null || this.FUNCTION[i].getKernelType() != ProcessKernel.FUNCTION_CALL_TYPE && this.FUNCTION[i].getKernelType() != ProcessKernel.FUNCTION_MACRO_TYPE || !this.FUNCTION[i].getFunctionName().equals(string) || this.FUNCTION[i].isConstructor() != bl) continue;
            if (bl2) {
                if (this.FUNCTION[i].getAccessPermission() != ProcessKernel.PUBLIC) continue;
                this.FUNCTION[i].use();
                return this.FUNCTION[i].getKernel(stringArray);
            }
            this.FUNCTION[i].use();
            return this.FUNCTION[i].getKernel(stringArray);
        }
        return null;
    }

    public FunctionCallKernel getMemberFunction(String string, ProcessUnit[] processUnitArray, boolean bl, boolean bl2, String[] stringArray) {
        int n = this.FUNCTION.length;
        for (int i = n - 1; 0 <= i; --i) {
            if (this.FUNCTION[i] == null || this.FUNCTION[i].getKernelType() != ProcessKernel.FUNCTION_CALL_TYPE && this.FUNCTION[i].getKernelType() != ProcessKernel.FUNCTION_MACRO_TYPE || !this.FUNCTION[i].getFunctionName().equals(string) || !this.FUNCTION[i].isProcessableArgument(processUnitArray, stringArray)) continue;
            if (bl2) {
                if (this.FUNCTION[i].getAccessPermission() != ProcessKernel.PUBLIC) continue;
                this.FUNCTION[i].use();
                return this.FUNCTION[i].getKernel(stringArray);
            }
            this.FUNCTION[i].use();
            return this.FUNCTION[i].getKernel(stringArray);
        }
        return null;
    }

    public FunctionCallKernel getFunction(String string) {
        FunctionCallKernel functionCallKernel = this.getFunction(string, false, false);
        return functionCallKernel;
    }

    public FunctionCallKernel getFunction(String string, boolean bl) {
        return this.getFunction(string, bl, false);
    }

    public FunctionCallKernel getFunction(String stringArray, boolean bl, boolean bl2) {
        int n;
        int n2;
        Object object;
        String[] stringArray2 = null;
        Object object2 = null;
        Object object3 = stringArray;
        String string = null;
        if (0 <= ((String)object3).indexOf("<")) {
            object = object3;
            if (((String)object).lastIndexOf(">") < 0) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.ENGINE.error("\u30b8\u30a7\u30cd\u30ea\u30af\u30b9\u3092\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff1a" + (String)object);
                } else {
                    this.ENGINE.error("Could not interpret the generic parameters:" + (String)object);
                }
                return null;
            }
            object = ((String)object).substring(((String)object3).indexOf("<") + 1, ((String)object3).length());
            object2 = object = ((String)object).substring(0, ((String)object).lastIndexOf(">"));
            object = ((String)object).replaceAll(" ", "");
            object = ((String)object).replaceAll("\t", "");
            object = ((String)object).replaceAll("\\r", "");
            object = ((String)object).replaceAll("\\n", "");
            stringArray2 = ((String)object).split(",");
            object3 = ((String)object3).substring(0, ((String)object3).indexOf("<"));
        }
        if (0 <= stringArray.indexOf(".")) {
            object = stringArray.split("\\.");
            object3 = object[((String[])object).length - 1];
            string = object[0];
            for (n2 = 1; n2 <= ((String[])object).length - 2; ++n2) {
                string = string + "." + (String)object[n2];
            }
        }
        if (string == null) {
            ProcessKernel[] processKernelArray;
            object = this.getMemberFunction((String)object3, bl, bl2, stringArray2);
            if (object != null) {
                return object;
            }
            n2 = this.FUNCTION.length;
            FunctionCallKernel functionCallKernel = null;
            if (this.IMPORT_PROGRAM != null) {
                for (int i = this.IMPORT_PROGRAM.length - 1; 0 <= i; --i) {
                    if (this.IMPORT_PROGRAM[i] == null || (functionCallKernel = this.IMPORT_PROGRAM[i].getMemberFunction((String)object3, bl, true, stringArray2)) == null) continue;
                    return functionCallKernel;
                }
            }
            if ((processKernelArray = this.ENGINE.getFunctionList()) != null) {
                for (int i = Math.min(this.FUNCTION_ACCESSABLE_INDEX, processKernelArray.length - 1); 0 <= i; --i) {
                    if (processKernelArray[i] == null || processKernelArray[i].getKernelType() != ProcessKernel.FUNCTION_CALL_TYPE && processKernelArray[i].getKernelType() != ProcessKernel.FUNCTION_MACRO_TYPE || !((FunctionCallKernel)processKernelArray[i]).getFunctionName().equals(object3) || ((FunctionCallKernel)processKernelArray[i]).isConstructor() != bl || processKernelArray[i].getAccessPermission() != ProcessKernel.PUBLIC) continue;
                    ((FunctionCallKernel)processKernelArray[i]).use();
                    return ((FunctionCallKernel)processKernelArray[i]).getKernel(stringArray2);
                }
            }
            return null;
        }
        if (string.equals("this") || string.equals(this.NAME)) {
            int n3 = this.FUNCTION.length;
            for (n2 = n3 - 1; 0 <= n2; --n2) {
                if (this.FUNCTION[n2] == null || this.FUNCTION[n2].getKernelType() != ProcessKernel.FUNCTION_CALL_TYPE && this.FUNCTION[n2].getKernelType() != ProcessKernel.FUNCTION_MACRO_TYPE || !this.FUNCTION[n2].getFunctionName().equals(object3) || this.FUNCTION[n2].isConstructor() != bl) continue;
                if (bl2) {
                    if (this.FUNCTION[n2].getAccessPermission() != ProcessKernel.PUBLIC) continue;
                    this.FUNCTION[n2].use();
                    return this.FUNCTION[n2].getKernel(stringArray2);
                }
                this.FUNCTION[n2].use();
                return this.FUNCTION[n2].getKernel(stringArray2);
            }
            return null;
        }
        object = this.ENGINE.getAllProgram();
        Object object4 = null;
        int n4 = ((String[])object).length;
        for (n = n4 - 1; 0 <= n; --n) {
            if (object[n] == null || !((ProcessProgram)object[n]).getName().equals(string)) continue;
            object4 = object[n];
        }
        if (object4 == null) {
            for (n = n4 - 1; 0 <= n; --n) {
                String string2;
                String[] stringArray3;
                if (object[n] == null || 1 > (stringArray3 = ((ProcessProgram)object[n]).getName().split("\\.")).length || !(string2 = stringArray3[stringArray3.length - 1]).equals(string)) continue;
                object4 = object[n];
                string = ((ProcessProgram)object[n]).getName();
            }
        }
        if (object4 == null) {
            return null;
        }
        if (object2 == null) {
            return ((ProcessProgram)object4).getFunction(string + "." + (String)object3, false, true);
        }
        return ((ProcessProgram)object4).getFunction(string + "." + (String)object3 + "<" + (String)object2 + ">", false, true);
    }

    public FunctionCallKernel[] getConstructor(ProcessUnit[] processUnitArray) {
        Object object;
        int n = this.INCLUDE_PROGRAM_NAME.length;
        FunctionCallKernel[] functionCallKernelArray = new FunctionCallKernel[n + 1];
        for (int i = 0; i < n; ++i) {
            object = this.INCLUDE_PROGRAM_NAME[i].split("\\.");
            String string = object[((String[])object).length - 1];
            functionCallKernelArray[i] = this.getFunction(string, processUnitArray, true);
            if (functionCallKernelArray[i] == null || functionCallKernelArray[i].isConstructor()) continue;
            functionCallKernelArray[i] = null;
        }
        String[] stringArray = this.NAME.split("\\.");
        object = stringArray[stringArray.length - 1];
        functionCallKernelArray[n] = this.getFunction((String)object, processUnitArray, true);
        if (functionCallKernelArray[n] != null && !functionCallKernelArray[n].isConstructor()) {
            functionCallKernelArray[n] = null;
        }
        int n2 = 0;
        for (int i = 0; i < n + 1; ++i) {
            if (functionCallKernelArray[i] == null) continue;
            ++n2;
        }
        FunctionCallKernel[] functionCallKernelArray2 = new FunctionCallKernel[n2];
        int n3 = 0;
        for (int i = 0; i < n + 1; ++i) {
            if (functionCallKernelArray[i] == null) continue;
            functionCallKernelArray2[i] = functionCallKernelArray[i];
            ++n3;
        }
        return functionCallKernelArray2;
    }

    public FunctionCallKernel getFunction(String string, ProcessUnit[] processUnitArray) {
        return this.getFunction(string, processUnitArray, false, false);
    }

    public FunctionCallKernel getFunction(String string, ProcessUnit[] processUnitArray, boolean bl) {
        return this.getFunction(string, processUnitArray, false, false);
    }

    public FunctionCallKernel getFunction(String stringArray, ProcessUnit[] processUnitArray, boolean bl, boolean bl2) {
        int n;
        int n2;
        Object object;
        String[] stringArray2 = null;
        Object object2 = null;
        Object object3 = stringArray;
        String string = null;
        if (0 <= ((String)object3).indexOf("<")) {
            object = object3;
            if (((String)object).lastIndexOf(">") < 0) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.ENGINE.error("\u30b8\u30a7\u30cd\u30ea\u30af\u30b9\u3092\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff1a" + (String)object);
                } else {
                    this.ENGINE.error("Could not interpret the generic parameters:" + (String)object);
                }
                return null;
            }
            object = ((String)object).substring(((String)object3).indexOf("<") + 1, ((String)object3).length());
            object2 = object = ((String)object).substring(0, ((String)object).lastIndexOf(">"));
            object = ((String)object).replaceAll(" ", "");
            object = ((String)object).replaceAll("\t", "");
            object = ((String)object).replaceAll("\\r", "");
            object = ((String)object).replaceAll("\\n", "");
            stringArray2 = ((String)object).split(",");
            object3 = ((String)object3).substring(0, ((String)object3).indexOf("<"));
        }
        if (0 <= stringArray.indexOf(".")) {
            object = stringArray.split("\\.");
            object3 = object[((String[])object).length - 1];
            string = object[0];
            for (n2 = 1; n2 <= ((Object)object).length - 2; ++n2) {
                string = string + "." + (String)object[n2];
            }
        }
        if (string == null) {
            ProcessKernel[] processKernelArray;
            FunctionCallKernel functionCallKernel = this.getMemberFunction((String)object3, processUnitArray, bl, bl2, stringArray2);
            if (functionCallKernel != null) {
                return functionCallKernel;
            }
            int n3 = this.FUNCTION.length;
            FunctionCallKernel functionCallKernel2 = null;
            if (this.IMPORT_PROGRAM != null) {
                for (int i = this.IMPORT_PROGRAM.length - 1; 0 <= i; --i) {
                    if (this.IMPORT_PROGRAM[i] == null || (functionCallKernel2 = this.IMPORT_PROGRAM[i].getMemberFunction((String)object3, processUnitArray, bl, true, stringArray2)) == null) continue;
                    return functionCallKernel2;
                }
            }
            if ((processKernelArray = this.ENGINE.getFunctionList()) != null) {
                for (int i = Math.min(this.FUNCTION_ACCESSABLE_INDEX, processKernelArray.length - 1); 0 <= i; --i) {
                    if (processKernelArray[i] == null || processKernelArray[i].getKernelType() != ProcessKernel.FUNCTION_CALL_TYPE && processKernelArray[i].getKernelType() != ProcessKernel.FUNCTION_MACRO_TYPE || !((FunctionCallKernel)processKernelArray[i]).getFunctionName().equals(object3) || !((FunctionCallKernel)processKernelArray[i]).isProcessableArgument(processUnitArray, stringArray2) || processKernelArray[i].getAccessPermission() != ProcessKernel.PUBLIC) continue;
                    ((FunctionCallKernel)processKernelArray[i]).use();
                    return ((FunctionCallKernel)processKernelArray[i]).getKernel(stringArray2);
                }
            }
            return null;
        }
        if (string.equals("this") || string.equals(this.NAME)) {
            n2 = this.FUNCTION.length;
            for (int i = n2 - 1; 0 <= i; --i) {
                if (this.FUNCTION[i] == null || this.FUNCTION[i].getKernelType() != ProcessKernel.FUNCTION_CALL_TYPE && this.FUNCTION[i].getKernelType() != ProcessKernel.FUNCTION_MACRO_TYPE || !this.FUNCTION[i].getFunctionName().equals(object3) || !this.FUNCTION[i].isProcessableArgument(processUnitArray, stringArray2)) continue;
                if (bl2) {
                    if (this.FUNCTION[i].getAccessPermission() != ProcessKernel.PUBLIC) continue;
                    this.FUNCTION[i].use();
                    return this.FUNCTION[i].getKernel(stringArray2);
                }
                this.FUNCTION[i].use();
                return this.FUNCTION[i].getKernel(stringArray2);
            }
            return null;
        }
        ProcessProgram[] processProgramArray = this.ENGINE.getAllProgram();
        ProcessProgram processProgram = null;
        int n4 = processProgramArray.length;
        for (n = n4 - 1; 0 <= n; --n) {
            if (processProgramArray[n] == null || !processProgramArray[n].getName().equals(string)) continue;
            processProgram = processProgramArray[n];
        }
        if (processProgram == null) {
            for (n = n4 - 1; 0 <= n; --n) {
                String string2;
                String[] stringArray3;
                if (processProgramArray[n] == null || 1 > (stringArray3 = processProgramArray[n].getName().split("\\.")).length || !(string2 = stringArray3[stringArray3.length - 1]).equals(string)) continue;
                processProgram = processProgramArray[n];
                string = processProgramArray[n].getName();
            }
        }
        if (processProgram == null) {
            return null;
        }
        if (object2 == null) {
            return processProgram.getFunction(string + "." + (String)object3, processUnitArray, true);
        }
        return processProgram.getFunction(string + "." + (String)object3 + "<" + (String)object2 + ">", processUnitArray, true);
    }

    public void print() {
        int n;
        System.out.println("NAME: " + this.NAME);
        System.out.print("IMPORT: ");
        for (n = 0; n < this.IMPORT_PROGRAM.length; ++n) {
            System.out.print(this.IMPORT_PROGRAM[n].NAME + ";");
        }
        System.out.println("");
        System.out.println("FIELD: ");
        for (n = 0; n < this.VARIABLE.length; ++n) {
            try {
                System.out.println("\t" + n + ": " + this.VARIABLE[n].name);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        System.out.println("METHOD: ");
        for (n = 0; n < this.FUNCTION.length; ++n) {
            System.out.println("\t" + n + ": " + this.FUNCTION[n].getFunctionName());
        }
    }
}

