/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Locale;
import javax.swing.JOptionPane;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ProcessEngineDriveInterface;
import rxvesapi.process.ProcessEngineDriveManager;
import rxvesapi.process.ProcessSecurity;
import rxvesapi.process.connection.GeneralProcessConnectionInterface;
import rxvesapi.process.decode.ProcessCodeImporter;
import rxvesapi.process.decode.ProcessDecoder;
import rxvesapi.process.driver.FileIOProcessDriver;
import rxvesapi.process.driver.FileProcessDriver;
import rxvesapi.process.driver.GUIProcessDriver;
import rxvesapi.process.driver.Graph2DProcessDriver;
import rxvesapi.process.driver.Graph3DProcessDriver;
import rxvesapi.process.driver.GraphProcessDriver;
import rxvesapi.process.driver.GraphProcessDriverDetector;
import rxvesapi.process.driver.Graphics2DProcessDriver;
import rxvesapi.process.driver.Graphics3DProcessDriver;
import rxvesapi.process.driver.GraphicsProcessDriver;
import rxvesapi.process.driver.NativeProcessDriver;
import rxvesapi.process.driver.SoundProcessDriver;
import rxvesapi.process.driver.StringProcessDriver;
import rxvesapi.process.driver.SystemProcessDriver;
import rxvesapi.process.driver.ThreadProcessDriver;
import rxvesapi.process.driver.TimeProcessDriver;
import rxvesapi.process.kernel.FunctionCallKernel;
import rxvesapi.process.kernel.ProcessKernel;

public class ScriptProcessor {
    public static volatile LocaleManager locale = new LocaleManager();
    private static String sysClassPath = System.getProperty("java.class.path");
    private static File jarLocationDir = new File(sysClassPath);
    public static String MODEL_ID;
    public static String MODEL_NAME;
    public static String ARCHITECTURE_NAME;
    public static String PROGRAM_PROCESSOR_NAME;
    public static String GRAPHICS_PROCESSOR_NAME;
    public static String DECODE_PROCESSOR_NAME;
    public static String SCRIPT_VERSION;
    public static String SCRIPT_REVISION;
    public static String SCRIPT_LIMITED;
    private ProcessSecurity security;
    public ProcessEngine engine;
    public ProcessEngineDriveInterface driver;
    public ProcessEngineDriveManager manager;
    public String[] mainArgument;
    FileIOProcessDriver fileIODriver;
    SystemProcessDriver systemDriver;
    FileProcessDriver fileDriver;
    NativeProcessDriver nativeDriver;
    GraphProcessDriver graphDriver;
    Graph2DProcessDriver graph2DDriver;
    Graph3DProcessDriver graph3DDriver;
    GraphicsProcessDriver graphicsDriver;
    Graphics2DProcessDriver graphics2DDriver;
    Graphics3DProcessDriver graphics3DDriver;
    GUIProcessDriver guiDriver;
    StringProcessDriver stringDriver;
    ThreadProcessDriver threadDriver;
    TimeProcessDriver timeDriver;
    SoundProcessDriver soundDriver;

    public static String getUntitledProgramName() {
        return "(EDITOR)";
    }

    public ScriptProcessor() {
        this.engine = new ProcessEngine();
        this.manager = new ProcessEngineDriveManager(this.engine, this.driver);
    }

    public ScriptProcessor(Thread thread, ProcessSecurity processSecurity) {
        this.security = processSecurity;
        this.engine = new ProcessEngine(this.security);
        this.engine.setThread(thread);
        this.manager = new ProcessEngineDriveManager(this.engine, this.driver);
    }

    public void setThread(Thread thread) {
        this.engine.setThread(thread);
    }

    public void init() {
        this.engine.format();
        this.disposeDynamicConnecterDriver();
        this.addStandardDriver();
    }

    public void loadSystemLibrary(File file) {
        ProcessCodeImporter processCodeImporter = new ProcessCodeImporter(this.engine, this);
        processCodeImporter.setMainDirectory(file);
        processCodeImporter.load_INTERNAL_FILENAME("System");
        processCodeImporter.disposeResource();
        processCodeImporter = null;
    }

    public void dispose() {
        this.disposeResource();
    }

    public void process(String[] stringArray) {
        if (this.engine != null) {
            this.engine.process(stringArray);
            if (this.manager == null) {
                this.manager = new ProcessEngineDriveManager(this.engine, this.driver);
            }
        }
    }

    public void exit() {
        if (this.engine != null) {
            this.engine.exit();
        }
    }

    public void load(URL uRL) {
        Object object;
        File file = new File(uRL.getFile());
        String string = file.getPath();
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        file = new File(string);
        String string2 = file.getName();
        String[] stringArray = string2.split("\\.");
        if (3 <= stringArray.length) {
            if (locale.isJapanese()) {
                object = "\u30d5\u30a1\u30a4\u30eb\u540d\u306b\u3001\u62e1\u5f35\u5b50\u4ee5\u5916\u3067\u30c9\u30c3\u30c8\u300c.\u300d\u8a18\u53f7\u3092\u4f7f\u7528\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002";
                JOptionPane.showMessageDialog(null, object);
            } else {
                object = "Cannot use a dot \".\" in the program's file name, excluding the file extention.";
                JOptionPane.showMessageDialog(null, object);
            }
        }
        object = file.getParentFile();
        this.loadSystemLibrary((File)object);
        ProcessDecoder processDecoder = new ProcessDecoder(this.engine, this);
        processDecoder.decode(uRL);
        if (processDecoder.hasError()) {
            this.outputDecodeErrorMessage();
        }
        processDecoder.disposeResource();
        processDecoder = null;
    }

    public void load(String string, File file) {
        this.load(string, file, "UNKNOWN_PROGRAM");
    }

    public void load(String string, File file, String string2) {
        Object object = string2;
        String[] stringArray = ((String)object).split("\\.");
        if (3 <= stringArray.length) {
            if (locale.isJapanese()) {
                String string3 = "\u30d5\u30a1\u30a4\u30eb\u540d\u306b\u3001\u62e1\u5f35\u5b50\u4ee5\u5916\u3067\u30c9\u30c3\u30c8\u300c.\u300d\u8a18\u53f7\u3092\u4f7f\u7528\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002";
                JOptionPane.showMessageDialog(null, string3);
            } else {
                String string4 = "Cannot use a dot \".\" in the program's file name, excluding the file extention.";
                JOptionPane.showMessageDialog(null, string4);
            }
        }
        this.loadSystemLibrary(file);
        object = new ProcessDecoder(this.engine, this);
        ((ProcessDecoder)object).decode(string, file, string2);
        if (((ProcessDecoder)object).hasError()) {
            this.outputDecodeErrorMessage();
        }
        ((ProcessDecoder)object).disposeResource();
        object = null;
    }

    public void load(String[] stringArray, File file, String[] stringArray2) {
        this.loadSystemLibrary(file);
        ProcessDecoder processDecoder = new ProcessDecoder(this.engine, this);
        processDecoder.setBufferingImportedListState(true);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray2[i];
            String[] stringArray3 = string.split("\\.");
            if (3 <= stringArray3.length) {
                String string2;
                if (locale.isJapanese()) {
                    string2 = "\u30d5\u30a1\u30a4\u30eb\u540d\u306b\u3001\u62e1\u5f35\u5b50\u4ee5\u5916\u3067\u30c9\u30c3\u30c8\u300c.\u300d\u8a18\u53f7\u3092\u4f7f\u7528\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002";
                    JOptionPane.showMessageDialog(null, string2);
                } else {
                    string2 = "Cannot use a dot \".\" in the program's file name, excluding the file extention.";
                    JOptionPane.showMessageDialog(null, string2);
                }
            }
            processDecoder.decode(stringArray[i], file, stringArray2[i]);
        }
        if (processDecoder.hasError()) {
            this.outputDecodeErrorMessage();
        }
        processDecoder.disposeResource();
        processDecoder = null;
    }

    public void loadInternalLibrary(String string, File file) {
        ProcessDecoder processDecoder = new ProcessDecoder(this.engine, this);
        processDecoder.decodeInternalLibrary(string, file);
        if (processDecoder.hasError()) {
            this.outputDecodeErrorMessage();
        }
        processDecoder.disposeResource();
        processDecoder = null;
    }

    public void load(String string) {
        this.load(string, jarLocationDir);
    }

    public void loadInternalLibrary(String string) {
        this.loadInternalLibrary(string, jarLocationDir);
    }

    public void outputDecodeErrorMessage() {
        String string = System.getProperty("line.separator");
        String string2 = "";
        string2 = string2 + "--------------------------------------------------";
        string2 = string2 + System.getProperty("line.separator");
        string2 = string2 + "ERROR";
        string2 = string2 + string;
        if (locale.isJapanese()) {
            string2 = string2 + "\u30d7\u30ed\u30b0\u30e9\u30e0\u30b3\u30fc\u30c9\u306e\u5168\u4f53\u7684\u306a\u69cb\u9020\u304c\u6b63\u5e38\u3067\u306a\u304b\u3063\u305f\u305f\u3081\u3001\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + string;
            string2 = string2 + "\u3053\u306e\u539f\u56e0\u306b\u306f\u4ee5\u4e0b\u306e\u3088\u3046\u306a\u3082\u306e\u304c\u63a8\u6e2c\u3055\u308c\u307e\u3059\uff1a" + string;
            string2 = string2 + string;
            string2 = string2 + "* \u30d6\u30ed\u30c3\u30af\u306e\u8a18\u53f7\u300c { \u300d\u307e\u305f\u306f\u300c } \u300d\u304c\u3069\u3053\u304b\u3067\u6b20\u843d\u3057\u3066\u3044\u308b\u5834\u5408" + string;
            string2 = string2 + "\u3000\u3000\u5bfe\u7b56\uff1a\u30b3\u30fc\u30c9\u5185\u306e\u300c { \u300d\u3068\u300c } \u300d\u306e\u5bfe\u5fdc\u95a2\u4fc2\u304c\u6b63\u3057\u3044\u304b\u3092\u518d\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + string;
            string2 = string2 + string;
            string2 = string2 + "* \u6587\u5b57\u5217\u4ee3\u5165\u90e8\u306e\u30c0\u30d6\u30eb\u30af\u30a6\u30a9\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3\u8a18\u53f7\u300c \" \u300d\u304c\u629c\u3051\u3066\u3044\u308b" + string;
            string2 = string2 + "\u3000\u3000\u5bfe\u7b56\uff1a\u6587\u5b57\u5217\u30ea\u30c6\u30e9\u30eb\u304c\u6b63\u3057\u304f\u8a18\u8ff0\u3055\u308c\u3066\u3044\u308b\u304b\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + string;
            string2 = string2 + string;
            string2 = string2 + "* \u6587\u5b57\u5217\u5024\u306e\u4e2d\u306e\u30c0\u30d6\u30eb\u30af\u30a6\u30a9\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3\u8a18\u53f7\u300c \" \u300d\u304c\u30a8\u30b9\u30b1\u30fc\u30d7\u3055\u308c\u3066\u3044\u306a\u3044" + string;
            string2 = string2 + "\u3000\u3000\u5bfe\u7b56\uff1a\u6587\u5b57\u5217\u30ea\u30c6\u30e9\u30eb\u304c\u6b63\u3057\u304f\u8a18\u8ff0\u3055\u308c\u3066\u3044\u308b\u304b\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + string;
            string2 = string2 + string;
            string2 = string2 + "* import \u307e\u305f\u306f include \u3057\u3066\u3044\u308b\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u306a\u3044\u5834\u5408" + string;
            string2 = string2 + "\u3000\u3000\u5bfe\u7b56\uff1a\u30d5\u30a1\u30a4\u30eb\u304c\u6b63\u3057\u3044\u5834\u6240\u306b\u5b58\u5728\u3057\u3066\u3044\u308b\u304b\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + string;
            string2 = string2 + string;
            string2 = string2 + "* \u6587\u5b57\u30b3\u30fc\u30c9\u306e\u81ea\u52d5\u8a8d\u8b58\u306b\u5931\u6557\u3057\u3066\u3044\u308b\u5834\u5408" + string;
            string2 = string2 + "\u3000\u3000\u5bfe\u7b56\uff1a\u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u5148\u982d\u884c\u3067\u4e0b\u8a18\u306e\u3088\u3046\u306b\u8a18\u8ff0\u3057\u3001\u6587\u5b57\u30b3\u30fc\u30c9\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + string;
            string2 = string2 + "\u3000\u3000\u3000[\u4f8b1]coding Shift_JIS ;" + string;
            string2 = string2 + "\u3000\u3000\u3000[\u4f8b2]coding EUC-JP ;" + string;
            string2 = string2 + "\u3000\u3000\u3000[\u4f8b3]coding UTF-8 ;" + string;
            string2 = string2 + "\u3000\u3000\u3000[\u4f8b4]coding UTF-16 ;" + string;
            string2 = string2 + "\u3000\u3000\u3000[\u4f8b5]coding UTF-32 ;" + string;
        } else {
            string2 = string2 + "Failed to parse the program code because its global structure is incorrect." + string;
            string2 = string2 + "The followings are the guessed causes:" + string;
            string2 = string2 + string;
            string2 = string2 + "* A block-beginning symbol \"{\" or a block-end symbol \"}\" is deficient:" + string;
            string2 = string2 + "    How to Fix: Check the correspondence between \"{\" and \"}\" in the code." + string;
            string2 = string2 + string;
            string2 = string2 + "* Lacking a double-quatation '\"'' at the beginning/end of a string literal:" + string;
            string2 = string2 + "    How to Fix: Check the correctness of string literals in the code." + string;
            string2 = string2 + string;
            string2 = string2 + "* Forgetting to escape a double-quatation '\"'' in a string literal:" + string;
            string2 = string2 + "    How to Fix: Check the correctness of string literals in the code." + string;
            string2 = string2 + string;
            string2 = string2 + "* The \"import\"-ed or \"include\"-ed library does not exist:" + string;
            string2 = string2 + "    How to Fix: Check that it exists at the correct location." + string;
            string2 = string2 + string;
            string2 = string2 + "* Failed to recognize the character-set automatically:" + string;
            string2 = string2 + "    How to Fix: Declare the character-set explicitly at the first line of the code, as follows:" + string;
            string2 = string2 + "       coding UTF-8 ;" + string;
            string2 = string2 + "         or " + string;
            string2 = string2 + "       coding Shift_JIS ;" + string;
            string2 = string2 + "         or " + string;
            string2 = string2 + "       coding EUC-JP ;" + string;
        }
        string2 = string2 + string;
    }

    public boolean hasError() {
        return this.engine.hasError();
    }

    public String getErrorMessage() {
        return this.engine.getErrorMessage();
    }

    public void ready() {
        this.engine.ready();
    }

    public ProcessEngine getProcessEngine() {
        return this.engine;
    }

    public void setProcessEngineDriveInterface(ProcessEngineDriveInterface processEngineDriveInterface) {
        this.driver = processEngineDriveInterface;
        this.engine.addProcessEngineDriveInterface(processEngineDriveInterface);
        this.manager.setProcessEngineDriveInterface(processEngineDriveInterface);
    }

    public Graph2DProcessDriver getGraph2DProcessDriver() {
        if (this.graph2DDriver == null) {
            this.connectGraph2DProcessDriver();
        }
        return this.graph2DDriver;
    }

    public Graph3DProcessDriver getGraph3DProcessDriver() {
        if (this.graph3DDriver == null) {
            this.connectGraph3DProcessDriver();
        }
        return this.graph3DDriver;
    }

    public void disposeResource() {
        if (this.engine != null) {
            this.engine.disposeResource();
        }
        if (this.manager != null) {
            this.manager.disposeResource();
        }
        this.engine = null;
        this.manager = null;
        this.driver = null;
        this.fileIODriver = null;
        this.systemDriver = null;
        this.graphDriver = null;
        this.graphicsDriver = null;
        this.graphics2DDriver = null;
        this.graphics3DDriver = null;
        this.guiDriver = null;
        this.stringDriver = null;
        this.nativeDriver = null;
        this.threadDriver = null;
        this.fileDriver = null;
        this.timeDriver = null;
        this.soundDriver = null;
    }

    public void outputDriveFrequency(long l) {
    }

    public void outputDriveFrequency(String string) {
    }

    public void addFunctionProcessKernel(FunctionCallKernel functionCallKernel) {
        this.engine.addFunctionProcessKernel(functionCallKernel);
    }

    public void addProcessConnectionInterface(GeneralProcessConnectionInterface generalProcessConnectionInterface) {
        this.engine.addProcessConnectionInterface(generalProcessConnectionInterface);
    }

    public void disposeDynamicConnecterDriver() {
        if (this.graph2DDriver != null) {
            this.graph2DDriver.disposeResource();
            this.graph2DDriver = null;
        }
        if (this.graph3DDriver != null) {
            this.graph3DDriver.disposeResource();
            this.graph3DDriver = null;
        }
        if (this.graphicsDriver != null) {
            this.graphicsDriver.disposeResource();
            this.graphicsDriver = null;
        }
        if (this.graphicsDriver != null) {
            this.graphicsDriver.disposeResource();
            this.graphicsDriver = null;
        }
        if (this.graphics2DDriver != null) {
            this.graphics2DDriver.disposeResource();
            this.graphics2DDriver = null;
        }
        if (this.graphics3DDriver != null) {
            this.graphics3DDriver.disposeResource();
            this.graphics3DDriver = null;
        }
        if (this.guiDriver != null) {
            this.guiDriver.disposeResource();
            this.guiDriver = null;
        }
        if (this.stringDriver != null) {
            this.stringDriver.disposeResource();
            this.stringDriver = null;
        }
        if (this.threadDriver != null) {
            this.threadDriver.disposeResource();
            this.threadDriver = null;
        }
        if (this.timeDriver != null) {
            this.timeDriver.disposeResource();
            this.timeDriver = null;
        }
        if (this.soundDriver != null) {
            this.soundDriver.disposeResource();
            this.soundDriver = null;
        }
    }

    public void connectGraph2DProcessDriver() {
        if (this.graph2DDriver != null) {
            return;
        }
        boolean bl = GraphProcessDriverDetector.detectGraph2D();
        if (bl) {
            this.connectGraphicsProcessDriver();
            this.graph2DDriver = new Graph2DProcessDriver();
            this.engine.addProcessConnectionInterface(this.graph2DDriver);
            this.graph2DDriver.format();
            this.graph2DDriver.engine = this.engine;
            this.graph2DDriver.graphicsDriver = this.graphicsDriver;
            ProcessKernel[] processKernelArray = this.graph2DDriver.getKernel();
            this.engine.addFunctionProcessKernel(processKernelArray);
        }
    }

    public void connectGraph3DProcessDriver() {
        if (this.graph3DDriver != null) {
            return;
        }
        boolean bl = GraphProcessDriverDetector.detectGraph3D();
        if (bl) {
            this.connectGraphicsProcessDriver();
            this.graph3DDriver = new Graph3DProcessDriver();
            this.engine.addProcessConnectionInterface(this.graph3DDriver);
            this.graph3DDriver.format();
            this.graph3DDriver.engine = this.engine;
            this.graph3DDriver.graphicsDriver = this.graphicsDriver;
            ProcessKernel[] processKernelArray = this.graph3DDriver.getKernel();
            this.engine.addFunctionProcessKernel(processKernelArray);
        }
    }

    public void connectGraphicsProcessDriver() {
        if (this.graphicsDriver != null) {
            return;
        }
        this.graphicsDriver = new GraphicsProcessDriver();
        this.engine.addProcessConnectionInterface(this.graphicsDriver);
        this.graphicsDriver.format();
        this.graphicsDriver.engine = this.engine;
    }

    public void connectGraphics2DProcessDriver() {
        if (this.graphics2DDriver != null) {
            return;
        }
        this.connectGraphicsProcessDriver();
        this.graphics2DDriver = new Graphics2DProcessDriver(this.graphicsDriver);
        this.engine.addProcessConnectionInterface(this.graphics2DDriver);
        this.graphics2DDriver.format();
        this.graphics2DDriver.engine = this.engine;
        ProcessKernel[] processKernelArray = this.graphics2DDriver.getKernel();
        this.engine.addFunctionProcessKernel(processKernelArray);
    }

    public void connectGraphics3DProcessDriver() {
        if (this.graphics3DDriver != null) {
            return;
        }
        this.connectGraphicsProcessDriver();
        this.connectGUIProcessDriver();
        this.graphics3DDriver = new Graphics3DProcessDriver(this.graphicsDriver, this.guiDriver);
        this.engine.addProcessConnectionInterface(this.graphics3DDriver);
        this.graphics3DDriver.format();
        this.graphics3DDriver.engine = this.engine;
        ProcessKernel[] processKernelArray = this.graphics3DDriver.getKernel();
        this.engine.addFunctionProcessKernel(processKernelArray);
    }

    public void connectGUIProcessDriver() {
        if (this.guiDriver != null) {
            return;
        }
        this.connectGraphicsProcessDriver();
        this.guiDriver = new GUIProcessDriver(this.graphicsDriver);
        this.engine.addProcessConnectionInterface(this.guiDriver);
        this.guiDriver.format();
        this.guiDriver.engine = this.engine;
        ProcessKernel[] processKernelArray = this.guiDriver.getKernel();
        this.engine.addFunctionProcessKernel(processKernelArray);
    }

    public void connectStringProcessDriver() {
        if (this.stringDriver != null) {
            return;
        }
        this.stringDriver = new StringProcessDriver();
        this.stringDriver.engine = this.engine;
        this.engine.addProcessConnectionInterface(this.stringDriver);
        this.stringDriver.format();
    }

    public void connectThreadProcessDriver() {
        if (this.threadDriver != null) {
            return;
        }
        this.threadDriver = new ThreadProcessDriver();
        this.engine.addProcessConnectionInterface(this.threadDriver);
        this.threadDriver.format();
        this.threadDriver.engine = this.engine;
    }

    public void connectTimeProcessDriver() {
        if (this.timeDriver != null) {
            return;
        }
        this.timeDriver = new TimeProcessDriver();
        this.engine.addProcessConnectionInterface(this.timeDriver);
        this.timeDriver.format();
        this.timeDriver.engine = this.engine;
    }

    public void connectSoundProcessDriver() {
        if (this.soundDriver != null) {
            return;
        }
        this.soundDriver = new SoundProcessDriver();
        this.engine.addProcessConnectionInterface(this.soundDriver);
        this.soundDriver.format();
        this.soundDriver.engine = this.engine;
    }

    public void addStandardDriver() {
        boolean bl = GraphProcessDriverDetector.detectGraph2D();
        boolean bl2 = GraphProcessDriverDetector.detectGraph3D();
        if (this.nativeDriver != null) {
            this.nativeDriver.disposeResource();
        }
        this.systemDriver = new SystemProcessDriver(this.engine);
        this.graphDriver = new GraphProcessDriver();
        this.fileIODriver = new FileIOProcessDriver();
        this.fileDriver = new FileProcessDriver();
        this.nativeDriver = new NativeProcessDriver();
        this.engine.addProcessConnectionInterface(this.systemDriver);
        this.engine.addProcessConnectionInterface(this.fileIODriver);
        this.engine.addProcessConnectionInterface(this.graphDriver);
        this.engine.addProcessConnectionInterface(this.nativeDriver);
        this.engine.addProcessConnectionInterface(this.fileDriver);
        this.systemDriver.format();
        this.nativeDriver.format();
        this.fileDriver.format();
        this.fileIODriver.engine = this.engine;
        this.nativeDriver.engine = this.engine;
        this.fileDriver.engine = this.engine;
        if (bl && bl2) {
            this.graphDriver.engine = this.engine;
        }
        ProcessKernel[] processKernelArray = this.systemDriver.getKernel();
        this.engine.addFunctionProcessKernel(processKernelArray);
        ProcessKernel[] processKernelArray2 = this.fileIODriver.getKernel();
        this.engine.addFunctionProcessKernel(processKernelArray2);
    }

    static {
        if (sysClassPath.contains(";") || sysClassPath.contains(":")) {
            jarLocationDir = new File(".");
        }
        if (sysClassPath.endsWith(".jar")) {
            if (sysClassPath.contains(System.getProperty("file.separator"))) {
                String string = sysClassPath.substring(0, sysClassPath.lastIndexOf(System.getProperty("file.separator")));
                jarLocationDir = new File(string);
            } else {
                jarLocationDir = new File(".");
            }
        }
        MODEL_ID = "VCSSL Engine R4704A";
        MODEL_NAME = "Magic Hour";
        ARCHITECTURE_NAME = "VACATION Canonical Compatibility Enhanced";
        PROGRAM_PROCESSOR_NAME = "GARNet  Ver.2.3.22";
        GRAPHICS_PROCESSOR_NAME = "SD-MIKS  Ver.1.2.2";
        DECODE_PROCESSOR_NAME = "SlipStream  Ver.3.2.20";
        SCRIPT_VERSION = "3.4";
        SCRIPT_REVISION = "54";
        SCRIPT_LIMITED = null;
    }

    public static final class LocaleManager {
        private volatile boolean isJapanese = Locale.getDefault().getLanguage() != null && Locale.getDefault().getLanguage().equals("ja") || Locale.getDefault().getCountry() != null && Locale.getDefault().getCountry().equals("JP");

        public void setLocale(String string) {
            this.isJapanese = (string = string.toLowerCase()).equals("ja-jp") || string.equals("ja") || string.equals("jp");
        }

        public boolean isJapanese() {
            return this.isJapanese;
        }
    }
}

