/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.decode;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ProcessProgram;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.decode.ProcessCodeLoader;
import rxvesapi.process.decode.ProcessCodePathDecoder;
import rxvesapi.process.driver.GraphProcessDriverDetector;

public class ProcessCodeImporter {
    private static String sysClassPath = System.getProperty("java.class.path");
    private static File jarLocationDir = new File(sysClassPath);
    private boolean USE_ARCHIVED_LIB = false;
    public ScriptProcessor processor = null;
    public ProcessEngine engine;
    public File mainDirectory;
    public String[] IMPORTED_LIST;

    public void setImportedList(String string) {
        this.IMPORTED_LIST = string.split(";");
    }

    public String getImportedList() {
        int n = this.IMPORTED_LIST.length;
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + this.IMPORTED_LIST[i] + ";";
        }
        return string;
    }

    public ProcessCodeImporter(ProcessEngine processEngine, ScriptProcessor scriptProcessor) {
        this.processor = scriptProcessor;
        this.engine = processEngine;
        this.IMPORTED_LIST = new String[0];
    }

    public void addImpoted(String string) {
        int n;
        if ((string = string.replaceAll("\"", "")).endsWith(".vcssl")) {
            string = string.substring(0, string.length() - 6);
        }
        int n2 = this.IMPORTED_LIST.length;
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = this.IMPORTED_LIST[n];
        }
        this.IMPORTED_LIST = new String[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.IMPORTED_LIST[n] = stringArray[n];
        }
        this.IMPORTED_LIST[n2] = string;
    }

    public boolean isImported(String string) {
        if (string.equals("System")) {
            return true;
        }
        int n = this.IMPORTED_LIST.length;
        for (int i = 0; i < n; ++i) {
            if (!this.IMPORTED_LIST[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public void setMainDirectory(File file) {
        this.mainDirectory = file;
    }

    public void disposeResource() {
        this.engine = null;
        this.processor = null;
        this.mainDirectory = null;
    }

    public void load(String string, File file, String string2) {
        this.setMainDirectory(file);
        if (0 <= string2.indexOf(".")) {
            String[] stringArray = string2.split("\\.");
            string2 = stringArray[stringArray.length - 2];
        }
        this.load_INTERNAL_CODE(string, string2);
    }

    public void load(String string, File file) {
        this.setMainDirectory(file);
        this.load_INTERNAL_CODE(string);
    }

    public void loadInternalLibrary(String string, File file) {
        this.setMainDirectory(file);
        this.compileInternalLibrary(string, "INTERENAL_LIBRARY");
    }

    public void load(URL uRL) {
        boolean bl = this.isOnline();
        String string = uRL.getPath();
        ProcessCodePathDecoder processCodePathDecoder = new ProcessCodePathDecoder();
        string = processCodePathDecoder.decode(uRL.getFile());
        processCodePathDecoder = null;
        File file = new File(string);
        File file2 = file.getParentFile();
        this.setMainDirectory(file2);
        this.engine.setMainProgramDirectory(file2);
        this.engine.setMainProgramURL(uRL);
        String string2 = file.getName();
        if (string2.startsWith("./") || string2.startsWith(".\\")) {
            string2 = string2.substring(2, string2.length());
        }
        this.load_INTERNAL_FILENAME("\"" + string2 + "\"");
    }

    public void load_INTERNAL_CODE(String string) {
        this.load_INTERNAL_CODE(string, ScriptProcessor.getUntitledProgramName());
    }

    public void load_INTERNAL_CODE(String string, String string2) {
        String string3;
        this.addImpoted(string2);
        this.addImpoted("./" + string2);
        ProcessProgram processProgram = new ProcessProgram("", "", this.engine);
        String string4 = new File(string2).getName();
        processProgram.setName(this.getEscapedProgramName(string4));
        String string5 = string;
        ProcessCodeLoader processCodeLoader = new ProcessCodeLoader();
        processCodeLoader.setProcessEngine(this.engine);
        boolean bl = true;
        string5 = processCodeLoader.decode(string5, string2, true);
        String string6 = processCodeLoader.getPragma("COMPILE")[0];
        if (string6 != null && string6.toLowerCase().equals("referral")) {
            processProgram.setCompilePragma(2);
        }
        String[] stringArray = processCodeLoader.getPragma("CONNECT");
        this.connectDriver(stringArray);
        string5 = this.removeLine(string5, this.getTagLineIndex(string5, "encode", 0));
        string5 = this.removeLine(string5, this.getTagLineIndex(string5, "encoding", 0));
        string5 = this.removeLine(string5, this.getTagLineIndex(string5, "coding", 0));
        int n = this.getTagLineIndex(string5, "include", 0);
        String string7 = this.getTag(string5, n, processCodeLoader);
        while (string7 != null) {
            String string8 = this.getIncludeCode(string7, processProgram);
            string8 = this.removeEncodeTag(string8);
            processProgram.addInclude(this.getEscapedProgramName(string7));
            string3 = this.getLine(string5, n);
            string5 = string5.replaceAll(string3, string8);
            n = this.getTagLineIndex(string5, "include", 0);
            string7 = this.getTag(string5, n, processCodeLoader);
        }
        int n2 = this.getTagLineIndex(string5, "import", 0);
        string3 = this.getTag(string5, n2, processCodeLoader);
        while (string3 != null && !this.engine.error) {
            processProgram.addImport(this.getEscapedProgramName(string3));
            if (!this.isImported(string3)) {
                this.load_INTERNAL_FILENAME(string3);
            }
            string5 = this.removeLine(string5, n2);
            n2 = this.getTagLineIndex(string5, "import", 0);
            string3 = this.getTag(string5, n2, processCodeLoader);
        }
        int n3 = this.getTagLineIndex(string5, "connect", 0);
        String string9 = this.getTag(string5, n3, processCodeLoader);
        while (string9 != null && !this.engine.error) {
            this.connect(string9);
            string5 = this.removeLine(string5, n3);
            n3 = this.getTagLineIndex(string5, "connect", 0);
            string9 = this.getTag(string5, n3, processCodeLoader);
        }
        string5 = processCodeLoader.unescape(string5);
        processCodeLoader.disposeResource();
        processCodeLoader = null;
        processProgram.CODE = string5;
        if (!this.engine.error) {
            this.compile(processProgram);
        }
        if (this.engine != null && this.engine.hasError()) {
            return;
        }
        if (string2 == null || string2.equals("UNKNOWN_PROGRAM") || string2.equals("Untitled")) {
            this.printLogln("LOAD > " + ScriptProcessor.getUntitledProgramName());
        } else {
            this.printLogln("LOAD > " + string2.replaceAll("\"", ""));
        }
    }

    public void load_INTERNAL_FILENAME(String string) {
        this.load_INTERNAL_FILENAME(string, null);
    }

    public void load_INTERNAL_FILENAME(String string, File file) {
        String string2;
        String string3;
        if (this.engine != null && this.engine.hasError()) {
            return;
        }
        this.addImpoted(string);
        this.addImpoted("./" + string);
        File file2 = this.getFile(string, file);
        File file3 = null;
        URL uRL = null;
        if (file2 == null && this.isInCompressedFile(string)) {
            uRL = this.getCodeURLFromCompressedFile(string);
        } else if (file2 != null) {
            file3 = file2.getParentFile();
            uRL = this.getCodeURL(file2);
        }
        if (uRL == null) {
            return;
        }
        ProcessCodeLoader processCodeLoader = new ProcessCodeLoader();
        boolean bl = true;
        String string4 = processCodeLoader.load(uRL, bl);
        ProcessProgram processProgram = new ProcessProgram("", "", this.engine);
        String string5 = new File(string).getName();
        String string6 = processCodeLoader.getPragma("COMPILE")[0];
        if (string6 != null && string6.toLowerCase().equals("referral")) {
            processProgram.setCompilePragma(2);
        }
        String[] stringArray = processCodeLoader.getPragma("CONNECT");
        this.connectDriver(stringArray);
        processProgram.setName(this.getEscapedProgramName(string));
        StringBuffer stringBuffer = new StringBuffer(string4);
        string4 = this.removeLine(string4, this.getTagLineIndex(string4, "encode", 0));
        string4 = this.removeLine(string4, this.getTagLineIndex(string4, "encoding", 0));
        string4 = this.removeLine(string4, this.getTagLineIndex(string4, "coding", 0));
        int n = this.getTagLineIndex(string4, "include", 0);
        String string7 = this.getTag(string4, n, processCodeLoader);
        while (string7 != null) {
            String string8 = this.getIncludeCode(string7, processProgram, file, file3);
            string8 = this.removeEncodeTag(string8);
            processProgram.addInclude(this.getEscapedProgramName(string7));
            string3 = this.getLine(string4, n);
            String string9 = string4.substring(0, n);
            string2 = string4.substring(n + string3.length() + 1, string4.length());
            string4 = string9 + string8 + string2;
            n = this.getTagLineIndex(string4, "include", 0);
            string7 = this.getTag(string4, n, processCodeLoader);
        }
        int n2 = this.getTagLineIndex(string4, "import", 0);
        string3 = this.getTag(string4, n2, processCodeLoader);
        while (string3 != null && !this.engine.error) {
            if (!this.isImported(string3)) {
                this.load_INTERNAL_FILENAME(string3, file3);
            }
            processProgram.addImport(this.getEscapedProgramName(string3));
            string4 = this.removeLine(string4, n2);
            n2 = this.getTagLineIndex(string4, "import", 0);
            string3 = this.getTag(string4, n2, processCodeLoader);
        }
        int n3 = this.getTagLineIndex(string4, "connect", 0);
        string2 = this.getTag(string4, n3, processCodeLoader);
        while (string2 != null && !this.engine.error) {
            this.connect(string2);
            string4 = this.removeLine(string4, n3);
            n3 = this.getTagLineIndex(string4, "connect", 0);
            string2 = this.getTag(string4, n3, processCodeLoader);
        }
        string4 = processCodeLoader.unescape(string4);
        processCodeLoader.disposeResource();
        processCodeLoader = null;
        processProgram.CODE = string4;
        if (!this.engine.error) {
            this.compile(processProgram);
        }
        if (this.engine != null && this.engine.hasError()) {
            return;
        }
        try {
            this.printLogln("LOAD > " + new File(uRL.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            this.printLogln("LOAD > " + uRL);
        }
    }

    public String getIncludeCode(String string, ProcessProgram processProgram) {
        return this.getIncludeCode(string, processProgram, null);
    }

    public String getIncludeCode(String string, ProcessProgram processProgram, File file) {
        return this.getIncludeCode(string, processProgram, null, null);
    }

    public String getIncludeCode(String string, ProcessProgram processProgram, File file, File file2) {
        File file3;
        if (string.startsWith("\"") && string.endsWith("\"")) {
            file = file2;
        }
        if ((file3 = this.getFile(string, file)) == null) {
            return null;
        }
        ProcessCodeLoader processCodeLoader = new ProcessCodeLoader();
        URL uRL = this.getCodeURL(file3);
        boolean bl = true;
        String string2 = processCodeLoader.load(uRL, bl);
        String string3 = this.getTagValue(string2, "include");
        File file4 = file3.getParentFile();
        while (string3 != null) {
            String string4 = this.getIncludeCode(string3, processProgram, file4);
            String string5 = this.getTagLine(string2, "include");
            string2 = string2.replaceAll(string5, string4);
            processProgram.addInclude(this.getEscapedProgramName(string3));
            string3 = this.getTagValue(string2, "include");
        }
        string2 = processCodeLoader.unescape(string2);
        processCodeLoader.disposeResource();
        return string2;
    }

    void printLogln(String string) {
        if (this.engine == null || this.engine.engineDriver == null) {
            return;
        }
        for (int i = 0; i < this.engine.engineDriver.length; ++i) {
            if (this.engine.engineDriver[i] == null) continue;
            this.engine.engineDriver[i].processFunctionDecoded(string);
        }
    }

    void printLog(String string) {
        if (this.engine == null || this.engine.engineDriver == null) {
            return;
        }
        for (int i = 0; i < this.engine.engineDriver.length; ++i) {
            if (this.engine.engineDriver[i] == null) continue;
            this.engine.engineDriver[i].processPrint(string);
        }
    }

    public String getCode(String string) {
        File file = this.getFile(string);
        try {
            URI uRI = file.toURI();
            URL uRL = uRI.toURL();
            String string2 = "";
            ProcessCodeLoader processCodeLoader = new ProcessCodeLoader();
            processCodeLoader.setProcessEngine(this.engine);
            boolean bl = false;
            string2 = processCodeLoader.load(uRL, bl);
            processCodeLoader.disposeResource();
            processCodeLoader = null;
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public String getCode(File file) {
        URL uRL = this.getCodeURL(file);
        ProcessCodeLoader processCodeLoader = new ProcessCodeLoader();
        boolean bl = false;
        String string = processCodeLoader.load(uRL, bl);
        processCodeLoader.disposeResource();
        processCodeLoader = null;
        return string;
    }

    public URL getCodeURL(File file) {
        if (file == null) {
            return null;
        }
        try {
            String string;
            URI uRI = file.toURI();
            URL uRL = uRI.toURL();
            if (file == null || !file.exists() || file.isDirectory()) {
                string = new File(new File(jarLocationDir, "lib/"), file.getPath()).getPath() + ".vcssl";
                string = string.replaceAll("\\\\", "/");
                uRL = this.getClass().getClassLoader().getResource(string);
            }
            string = "";
            ProcessCodeLoader processCodeLoader = new ProcessCodeLoader();
            processCodeLoader.setProcessEngine(this.engine);
            if (uRL == null) {
                return null;
            }
            return uRL;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public URL getCodeURLFromCompressedFile(String string) {
        string = string.replaceAll("\\.", "/");
        String string2 = new File(new File(jarLocationDir, "lib/"), string + ".vcssl").getPath();
        string2 = string2.replaceAll("\\\\", "/");
        URL uRL = this.getClass().getClassLoader().getResource(string2);
        return uRL;
    }

    public String getCodeFromCompressedFile(String string) {
        URL uRL = this.getCodeURLFromCompressedFile(string);
        ProcessCodeLoader processCodeLoader = new ProcessCodeLoader();
        processCodeLoader.setProcessEngine(this.engine);
        boolean bl = false;
        String string2 = processCodeLoader.load(uRL, bl);
        processCodeLoader.disposeResource();
        processCodeLoader = null;
        return string2;
    }

    public void alert(String string) {
        JOptionPane.showMessageDialog(null, string, "", 1);
    }

    public boolean existsOnline(File file) {
        String string = file.getPath();
        if (string.startsWith("./") || string.startsWith(".\\")) {
            string = string.substring(2, string.length());
        }
        string = string.replaceAll("\\\\", "/");
        string = string.replaceAll("http:/", "http://");
        URL uRL = this.getClass().getClassLoader().getResource(string);
        return uRL != null;
    }

    public File searchFile(File file, String string) {
        File file2 = new File(file, string);
        if (!file2.exists() || file2.isDirectory()) {
            file2 = new File(file, string + ".vcssl");
        }
        if (!file2.exists() || file2.isDirectory()) {
            file2 = new File(file, string + ".VCSSL");
        }
        if (!file2.exists() || file2.isDirectory()) {
            file2 = new File(file, string + ".vcssl.txt");
        }
        if (!file2.exists() || file2.isDirectory()) {
            file2 = new File(file, string + ".VCSSL.txt");
        }
        if (!file2.exists()) {
            file2 = null;
        }
        return file2;
    }

    private boolean isOnline() {
        boolean bl = false;
        File file = new File(".");
        if (file.exists()) {
            // empty if block
        }
        return bl;
    }

    private boolean isInCompressedFile(String string) {
        String string2 = new File(new File(jarLocationDir, "lib/"), string + ".vcssl").getPath();
        string2 = string2.replaceAll("\\\\", "/");
        URL uRL = this.getClass().getClassLoader().getResource(string2);
        return uRL != null;
    }

    public File getFile(String string) {
        return this.getFile(string, null);
    }

    public File getFile(String string, File file) {
        File file2 = null;
        boolean bl = this.isOnline();
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
            file2 = file != null ? this.searchFile(file, string) : this.searchFile(this.mainDirectory, string);
            String[] stringArray = this.engine.getLibraryPath();
            if (stringArray != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (file2 != null) continue;
                    file2 = this.searchFile(new File(stringArray[i]), string);
                }
            }
            if (file2 == null) {
                file2 = this.searchFile(new File(jarLocationDir, "lib/"), string);
            }
            if (file2 == null) {
                file2 = this.searchFile(new File(jarLocationDir, "bin/"), string);
            }
            if (file2 == null) {
                file2 = this.searchFile(jarLocationDir, string);
            }
        } else if (string.startsWith("<") && string.endsWith(">")) {
            string = string.substring(1, string.length() - 1);
            file2 = null;
            String[] stringArray = this.engine.getLibraryPath();
            if (stringArray != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (file2 != null) continue;
                    file2 = this.searchFile(new File(stringArray[i]), string);
                }
            }
            if (file2 == null) {
                file2 = this.searchFile(new File(jarLocationDir, "lib/"), string);
            }
            if (file2 == null) {
                file2 = this.searchFile(new File(jarLocationDir, "bin/"), string);
            }
            if (file2 == null) {
                file2 = this.searchFile(jarLocationDir, string);
            }
            if (file2 == null) {
                file2 = this.searchFile(this.mainDirectory, string);
            }
            if (file2 == null && file != null) {
                file2 = this.searchFile(file, string);
            }
        } else {
            String[] stringArray;
            file2 = this.searchFile(this.mainDirectory, string);
            if (file2 == null) {
                if (string.endsWith(".vcssl") || string.endsWith(".VCSSL")) {
                    string = string.substring(0, string.length() - 6);
                }
                string = string.replaceAll("\\.", "/");
            }
            if (file2 == null) {
                file2 = this.searchFile(this.mainDirectory, string);
            }
            if ((stringArray = this.engine.getLibraryPath()) != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (file2 != null) continue;
                    file2 = this.searchFile(new File(stringArray[i]), string);
                }
            }
            if (file2 == null) {
                file2 = this.searchFile(new File(jarLocationDir, "lib/"), string);
            }
            if (file2 == null) {
                file2 = this.searchFile(new File(jarLocationDir, "bin/"), string);
            }
            if (file2 == null) {
                file2 = this.searchFile(jarLocationDir, string);
            }
        }
        return file2;
    }

    public void connect(String string) {
        File file = new File(this.mainDirectory, string);
        boolean bl = this.engine.getSecurity().request_CONNECT(file.getPath());
        if (!bl) {
            this.engine.exit();
            return;
        }
        if (!file.exists()) {
            file = new File(this.mainDirectory, string + ".class");
        }
        if (!file.exists()) {
            file = new File(this.mainDirectory, string + ".CLASS");
        }
        if (!file.exists()) {
            string = string.replaceAll("\\.class", "SYSTEM_PROCESS_ESCAPE_EXT_DRIVER");
            string = string.replaceAll("\\.CLASS", "SYSTEM_PROCESS_ESCAPE_EXT_DRIVER");
            string = string.replaceAll("\\.", "/");
            string = string.replaceAll("SYSTEM_PROCESS_ESCAPE_EXT_DRIVER", ".class");
            file = new File(this.mainDirectory, string);
        }
        if (!file.exists()) {
            file = new File(this.mainDirectory, string + ".class");
        }
        if (!file.exists()) {
            file = new File(this.mainDirectory, string + ".CLASS");
        }
        if (!file.exists()) {
            file = new File(jarLocationDir, string);
        }
        if (!file.exists()) {
            file = new File(jarLocationDir, string + ".class");
        }
        if (!file.exists()) {
            file = new File(jarLocationDir, string + ".CLASS");
        }
        if (!file.exists()) {
            file = new File(new File(jarLocationDir, "lib/"), string);
        }
        if (!file.exists()) {
            file = new File(new File(jarLocationDir, "lib/"), string + ".class");
        }
        if (!file.exists()) {
            file = new File(new File(jarLocationDir, "lib/"), string + ".CLASS");
        }
        if (!file.exists()) {
            file = new File(new File(jarLocationDir, "bin/"), string);
        }
        if (!file.exists()) {
            file = new File(new File(jarLocationDir, "bin/"), string + ".class");
        }
        if (!file.exists()) {
            file = new File(new File(jarLocationDir, "bin/"), string + ".CLASS");
        }
        String string2 = file.getPath();
        this.engine.connect(string2);
        if (!file.exists() || file.isDirectory()) {
            String string3 = "";
            string3 = ScriptProcessor.locale.isJapanese() ? string3 + "\u30d7\u30e9\u30b0\u30a4\u30f3\u300c " + string + " \u300d\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + System.getProperty("line.separator") : string3 + "The specified plug-in \"" + string + "\" was not found." + System.getProperty("line.separator");
            this.engine.error(string3);
        }
    }

    public void compile(ProcessProgram processProgram) {
        if (!this.engine.error) {
            this.engine.addProgram(processProgram);
        }
    }

    public void compileInternalLibrary(String string, String string2) {
    }

    public String getEscapedProgramPath(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (string.startsWith("<") && string.endsWith(">")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    public String getEscapedProgramName(String string) {
        if (string.startsWith("\"") && string.endsWith("\"") && 0 <= (string = string.substring(1, string.length() - 1)).lastIndexOf(".")) {
            string = string.substring(0, string.lastIndexOf("."));
        }
        if (string.startsWith("<") && string.endsWith(">") && 0 <= (string = string.substring(1, string.length() - 1)).lastIndexOf(".")) {
            string = string.substring(0, string.lastIndexOf("."));
        }
        if (0 <= string.indexOf("/")) {
            string = string.replaceAll("/", ".");
        }
        return string;
    }

    public boolean isStandardLibrary(String string) {
        if ((string = this.getEscapedProgramPath(string)).equals("System")) {
            return true;
        }
        if (string.equals("Math")) {
            return true;
        }
        if (string.equals("Color")) {
            return true;
        }
        if (string.equals("GUI")) {
            return true;
        }
        if (string.equals("Graphics")) {
            return true;
        }
        if (string.equals("Graphics2D")) {
            return true;
        }
        if (string.equals("Graphics3D")) {
            return true;
        }
        if (string.equals("Text")) {
            return true;
        }
        if (string.equals("Time")) {
            return true;
        }
        if (string.equals("Process")) {
            return true;
        }
        if (string.equals("Thread")) {
            return true;
        }
        if (string.equals("File")) {
            return true;
        }
        if (string.equals("Sound")) {
            return true;
        }
        if (string.equals("tool.Graph2D") || string.equals("tool/Graph2D") || string.equals("science.graph.Graph2D") || string.equals("science/graph/Graph2D")) {
            return true;
        }
        return string.equals("tool.Graph3D") || string.equals("tool/Graph3D") || string.equals("science.graph.Graph3D") || string.equals("science/graph/Graph3D");
    }

    void connectDriver(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        if (this.processor == null) {
            return;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            boolean bl;
            if (stringArray[i].equals("rxvesapi.process.driver.GUIProcessDriver")) {
                this.processor.connectGUIProcessDriver();
                continue;
            }
            if (stringArray[i].equals("rxvesapi.process.driver.GraphicsProcessDriver")) {
                this.processor.connectGraphicsProcessDriver();
                continue;
            }
            if (stringArray[i].equals("rxvesapi.process.driver.Graphics2DProcessDriver")) {
                this.processor.connectGraphics2DProcessDriver();
                continue;
            }
            if (stringArray[i].equals("rxvesapi.process.driver.Graphics3DProcessDriver")) {
                this.processor.connectGraphics3DProcessDriver();
                continue;
            }
            if (stringArray[i].equals("rxvesapi.process.driver.TextProcessDriver")) {
                this.processor.connectStringProcessDriver();
                continue;
            }
            if (stringArray[i].equals("rxvesapi.process.driver.TimeProcessDriver")) {
                this.processor.connectTimeProcessDriver();
                continue;
            }
            if (stringArray[i].equals("rxvesapi.process.driver.NativeProcessDriver")) continue;
            if (stringArray[i].equals("rxvesapi.process.driver.ThreadProcessDriver")) {
                this.processor.connectThreadProcessDriver();
                continue;
            }
            if (stringArray[i].equals("rxvesapi.process.driver.FileProcessDriver")) continue;
            if (stringArray[i].equals("rxvesapi.process.driver.SoundProcessDriver")) {
                this.processor.connectSoundProcessDriver();
                continue;
            }
            if (stringArray[i].equals("rxvesapi.process.driver.Graph2DProcessDriver")) {
                bl = GraphProcessDriverDetector.detectGraph2D();
                if (bl) {
                    this.processor.connectGraphicsProcessDriver();
                    this.processor.connectGraph2DProcessDriver();
                    continue;
                }
                if (ScriptProcessor.locale.isJapanese()) {
                    string = "RinearnGraph2D.jar \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002RinearnGraph2D.jar \u3092 bin \u30d5\u30a9\u30eb\u30c0\u5185\u306b\u914d\u7f6e\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
                    string = string + System.getProperty("line.separator");
                } else {
                    string = "\"RinearnGraph2D.jar\" was not found. Please put it in \"bin\" folder.";
                    string = string + System.getProperty("line.separator");
                }
                JOptionPane.showMessageDialog(null, string, "!", 1);
                continue;
            }
            if (!stringArray[i].equals("rxvesapi.process.driver.Graph3DProcessDriver")) continue;
            bl = GraphProcessDriverDetector.detectGraph3D();
            if (bl) {
                this.processor.connectGraphicsProcessDriver();
                this.processor.connectGraph3DProcessDriver();
                continue;
            }
            if (ScriptProcessor.locale.isJapanese()) {
                string = "RinearnGraph3D.jar RinearnGraph3D.jar \u3092 bin \u30d5\u30a9\u30eb\u30c0\u5185\u306b\u914d\u7f6e\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
                string = string + System.getProperty("line.separator");
            } else {
                string = "\"RinearnGraph3D.jar\" was not found. Please put it in \"bin\" folder.";
                string = string + System.getProperty("line.separator");
            }
            JOptionPane.showMessageDialog(null, string, "!", 1);
        }
    }

    public int getTagLineIndex(String string, String string2, int n) {
        if (string == null) {
            return -1;
        }
        int n2 = string2.length();
        int n3 = n;
        while (0 < (n3 = string.indexOf(string2, n3)) && n3 >= 0 && 0 != n3) {
            if (!(0 >= n3 || string.charAt(n3 - 1) != ' ' && string.charAt(n3 - 1) != '\t' && string.charAt(n3 - 1) != '\r' && string.charAt(n3 - 1) != '\n' && string.charAt(n3 - 1) != '#' && string.charAt(n3 - 1) != ';' && string.charAt(n3 - 1) != '}' && string.charAt(n3 - 1) != '{' || string.charAt(n3 + n2) != ' ' && string.charAt(n3 + n2) != '\t' && string.charAt(n3 + n2) != '\r' && string.charAt(n3 + n2) != '\n')) {
                String string3;
                if (string2.equals("import") || string2.equals("include")) {
                    int n4 = string.lastIndexOf(";", n3);
                    String string4 = string.substring(n4 + 1, n3);
                    StringTokenizer stringTokenizer = new StringTokenizer(string4 = string4.replaceAll("#", "").replaceAll(" ", "").replaceAll("\t", "").replaceAll("\\r", "").replaceAll("\\n", ""));
                    if (!stringTokenizer.hasMoreTokens()) break;
                    String string5 = ScriptProcessor.locale.isJapanese() ? string2 + "\u6587\u306e\u8a18\u8ff0\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059" : string2 + "There is an incorrect statement";
                    string5 = n4 + 1 < string.indexOf(";", n3) ? string5 + ": " + string.substring(n4 + 1, string.indexOf(";", n3)) + System.getProperty("line.separator") : (ScriptProcessor.locale.isJapanese() ? string5 + "\u3002" + System.getProperty("line.separator") : string5 + ". " + System.getProperty("line.separator"));
                    this.engine.error(string5);
                }
                if ((string3 = this.getLine(string, n3)).indexOf(61) < 0 && string3.indexOf(43) < 0 && string3.indexOf(45) < 0 && string3.indexOf(42) < 0 && string3.indexOf(47) < 0 && string3.indexOf(37) < 0 && string3.indexOf(94) < 0 && string3.indexOf(124) < 0 && string3.indexOf(91) < 0 && string3.indexOf(93) < 0 && string3.indexOf(40) < 0 && string3.indexOf(41) < 0 && string3.indexOf(38) < 0 && string3.indexOf(123) < 0 && string3.indexOf(125) < 0) break;
            }
            ++n3;
        }
        return n3;
    }

    public String getLine(String string, int n) {
        if (n < 0) {
            return null;
        }
        int n2 = string.indexOf(";", n);
        if (n2 < 0) {
            n2 = string.length();
        }
        return string.substring(n, n2);
    }

    public String removeLine(String string, int n) {
        if (n < 0) {
            return string;
        }
        int n2 = string.indexOf(";", n);
        if (n2 < 0) {
            n2 = string.length();
        }
        String string2 = string.substring(0, n) + string.substring(n2, string.length());
        return string2;
    }

    public String getTagLine(String string, String string2) {
        StringTokenizer stringTokenizer;
        String string3;
        String string4;
        String string5 = null;
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            string4 = null;
            string3 = null;
            stringTokenizer = new StringTokenizer(stringArray[i]);
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            }
            if (string4 == null) continue;
            string4 = string4.replaceAll(" ", "");
            string4 = string4.replaceAll("\u3000", "");
            if (!(string4 = string4.replaceAll("\t", "")).equals(string2) && !string4.equals("#" + string2)) continue;
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if (string3 == null) continue;
            return stringArray[i];
        }
        stringArray = null;
        stringTokenizer = null;
        string4 = null;
        string3 = null;
        return string5;
    }

    public String getTagValue(String string, String string2) {
        StringTokenizer stringTokenizer;
        String string3;
        String string4;
        if (string == null) {
            return null;
        }
        String string5 = null;
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            string4 = null;
            string3 = null;
            stringTokenizer = new StringTokenizer(stringArray[i]);
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            }
            if (string4 == null) continue;
            string4 = string4.replaceAll(" ", "");
            string4 = string4.replaceAll("\u3000", "");
            if (!(string4 = string4.replaceAll("\t", "")).equals(string2) && !string4.equals("#" + string2)) continue;
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if (string3 == null) continue;
            string3 = string3.replaceAll(" ", "");
            string3 = string3.replaceAll("\u3000", "");
            string5 = string3 = string3.replaceAll("\t", "");
            break;
        }
        stringArray = null;
        stringTokenizer = null;
        string4 = null;
        string3 = null;
        return string5;
    }

    public String removeEncodeTag(String string) {
        int n = 0;
        while (0 <= (n = this.getTagLineIndex(string, "encode", n))) {
            string = this.removeLine(string, n);
        }
        int n2 = 0;
        while (0 <= (n2 = this.getTagLineIndex(string, "encoding", n2))) {
            string = this.removeLine(string, n2);
        }
        int n3 = 0;
        while (0 <= (n3 = this.getTagLineIndex(string, "coding", n3))) {
            string = this.removeLine(string, n3);
        }
        return string;
    }

    public String __removeEncodeTag(String string) {
        Object var6_8;
        String string2;
        StringTokenizer stringTokenizer;
        Object object;
        boolean bl = true;
        if (0 <= string.indexOf(";")) {
            object = string.substring(string.lastIndexOf(";") + 1, string.length());
            stringTokenizer = new StringTokenizer((String)object);
            if (stringTokenizer.hasMoreTokens()) {
                bl = false;
            }
            stringTokenizer = null;
        }
        if (string.endsWith(";")) {
            bl = true;
        }
        object = string.split(";");
        for (int i = 0; i < ((String[])object).length; ++i) {
            string2 = null;
            var6_8 = null;
            stringTokenizer = new StringTokenizer(object[i]);
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            if (string2 == null) continue;
            string2 = string2.replaceAll(" ", "");
            string2 = string2.replaceAll("\u3000", "");
            if (!(string2 = string2.replaceAll("\t", "")).equals("encode") && !string2.equals("#encode") && !string2.equals("coding") && !string2.equals("#coding") && !string2.equals("encoding") && !string2.equals("#encoding")) continue;
            object[i] = "";
        }
        String string3 = "";
        for (int i = 0; i < ((String[])object).length - 1; ++i) {
            string3 = string3 + object[i] + ";";
        }
        string3 = string3 + object[((String[])object).length - 1];
        if (bl) {
            string3 = string3 + ";";
        }
        object = null;
        stringTokenizer = null;
        string2 = null;
        var6_8 = null;
        return string3;
    }

    public String getImportTag(String string, ProcessCodeLoader processCodeLoader) {
        String string2 = this.getTag(string, "import", processCodeLoader);
        return string2;
    }

    public String getEncodeTag(String string, ProcessCodeLoader processCodeLoader) {
        return this.getTag(string, "encode", processCodeLoader);
    }

    public String getIncludeTag(String string, ProcessCodeLoader processCodeLoader) {
        return this.getTag(string, "include", processCodeLoader);
    }

    public String getConnectTag(String string, ProcessCodeLoader processCodeLoader) {
        return this.getTag(string, "connect", processCodeLoader);
    }

    public String getTag(String string, String string2, ProcessCodeLoader processCodeLoader) {
        if (string2 == null) {
            return null;
        }
        int n = this.getTagLineIndex(string, string2, 0);
        if (n < 0) {
            return null;
        }
        String string3 = this.getLine(string, n);
        String string4 = null;
        String string5 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        if (string4 != null) {
            string4 = string4.replaceAll(" ", "");
            string4 = string4.replaceAll("\u3000", "");
            if ((string4 = string4.replaceAll("\t", "")).equals(string2)) {
                if (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                }
                if (string5 != null) {
                    string5 = string5.replaceAll(" ", "");
                    string5 = string5.replaceAll("\u3000", "");
                    string5 = string5.replaceAll("\t", "");
                }
            }
        }
        if (string5.startsWith("SYSTEM_ESCAPE_STRING_SECTION_")) {
            string5 = processCodeLoader.escapedMap.get(string5);
        }
        return string5;
    }

    public String getTag(String string, int n, ProcessCodeLoader processCodeLoader) {
        String string2 = this.getLine(string, n);
        if (string2 == null) {
            return null;
        }
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (string3 != null) {
            string3 = string3.replaceAll(" ", "");
            string3 = string3.replaceAll("\u3000", "");
            string3 = string3.replaceAll("\t", "");
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            }
            if (string4 != null) {
                string4 = string4.replaceAll(" ", "");
                string4 = string4.replaceAll("\u3000", "");
                string4 = string4.replaceAll("\t", "");
            }
        }
        if (string4.startsWith("SYSTEM_ESCAPE_STRING_SECTION_")) {
            string4 = processCodeLoader.escapedMap.get(string4);
        }
        return string4;
    }

    public String ___getImportTag(String string) {
        StringTokenizer stringTokenizer;
        String string2;
        String string3;
        String string4 = null;
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            string3 = null;
            string2 = null;
            stringTokenizer = new StringTokenizer(stringArray[i]);
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if (string3 == null) continue;
            string3 = string3.replaceAll(" ", "");
            string3 = string3.replaceAll("\u3000", "");
            if (!(string3 = string3.replaceAll("\t", "")).equals("import")) continue;
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            if (string2 == null) continue;
            string2 = string2.replaceAll(" ", "");
            string2 = string2.replaceAll("\u3000", "");
            string4 = string2 = string2.replaceAll("\t", "");
            break;
        }
        stringArray = null;
        stringTokenizer = null;
        string3 = null;
        string2 = null;
        return string4;
    }

    public String removeImportTag(String string, String string2) {
        String string3;
        String string4;
        StringTokenizer stringTokenizer;
        Object object;
        boolean bl = true;
        if (0 <= string.indexOf(";")) {
            object = string.substring(string.lastIndexOf(";") + 1, string.length());
            stringTokenizer = new StringTokenizer((String)object);
            if (stringTokenizer.hasMoreTokens()) {
                bl = false;
            }
            stringTokenizer = null;
        }
        if (string.endsWith(";")) {
            bl = true;
        }
        object = string.split(";");
        for (int i = 0; i < ((String[])object).length; ++i) {
            string4 = null;
            string3 = null;
            stringTokenizer = new StringTokenizer(object[i]);
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            }
            if (string4 == null) continue;
            string4 = string4.replaceAll(" ", "");
            string4 = string4.replaceAll("\u3000", "");
            if (!(string4 = string4.replaceAll("\t", "")).equals("import")) continue;
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if (string3 == null) continue;
            string3 = string3.replaceAll(" ", "");
            string3 = string3.replaceAll("\u3000", "");
            if (!(string3 = string3.replaceAll("\t", "")).equals(string2)) continue;
            object[i] = "";
        }
        String string5 = "";
        for (int i = 0; i < ((String[])object).length - 1; ++i) {
            string5 = string5 + object[i] + ";";
        }
        string5 = string5 + object[((String[])object).length - 1];
        if (bl) {
            string5 = string5 + ";";
        }
        object = null;
        stringTokenizer = null;
        string4 = null;
        string3 = null;
        return string5;
    }

    public String removeConnectTagAll(String string, String string2) {
        int n = 0;
        while (0 <= (n = this.getTagLineIndex(string, "connect", n))) {
            this.removeLine(string, n);
        }
        return string;
    }

    public String __removeConnectTagAll(String string, String string2) {
        String string3;
        String string4;
        StringTokenizer stringTokenizer;
        Object object;
        boolean bl = true;
        if (0 <= string.indexOf(";")) {
            object = string.substring(string.lastIndexOf(";") + 1, string.length());
            stringTokenizer = new StringTokenizer((String)object);
            if (stringTokenizer.hasMoreTokens()) {
                bl = false;
            }
            stringTokenizer = null;
        }
        if (string.endsWith(";")) {
            bl = true;
        }
        object = string.split(";");
        for (int i = 0; i < ((String[])object).length; ++i) {
            string4 = null;
            string3 = null;
            stringTokenizer = new StringTokenizer(object[i]);
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            }
            if (string4 == null) continue;
            string4 = string4.replaceAll(" ", "");
            string4 = string4.replaceAll("\u3000", "");
            if (!(string4 = string4.replaceAll("\t", "")).equals("connect")) continue;
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if (string3 == null) continue;
            string3 = string3.replaceAll(" ", "");
            string3 = string3.replaceAll("\u3000", "");
            if (!(string3 = string3.replaceAll("\t", "")).equals(string2)) continue;
            object[i] = "";
        }
        String string5 = "";
        for (int i = 0; i < ((String[])object).length - 1; ++i) {
            string5 = string5 + object[i] + ";";
        }
        string5 = string5 + object[((String[])object).length - 1];
        if (bl) {
            string5 = string5 + ";";
        }
        object = null;
        stringTokenizer = null;
        string4 = null;
        string3 = null;
        return string5;
    }

    static {
        if (sysClassPath.contains(";") || sysClassPath.contains(":")) {
            jarLocationDir = new File(".");
        }
        if (sysClassPath.endsWith(".jar")) {
            if (sysClassPath.contains(System.getProperty("file.separator"))) {
                String string = sysClassPath.substring(0, sysClassPath.lastIndexOf(System.getProperty("file.separator")));
                jarLocationDir = new File(string);
            } else {
                jarLocationDir = new File(".");
            }
        }
    }
}

