/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.decode;

import java.io.File;
import java.net.URL;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.decode.ProcessCodeImporter;

public class ProcessDecoder {
    public ScriptProcessor processor = null;
    public ProcessEngine engine;
    public boolean error;
    private String importedList = "";
    private boolean usingImportedList;

    public ProcessDecoder(ProcessEngine processEngine, ScriptProcessor scriptProcessor) {
        this.engine = processEngine;
        this.processor = scriptProcessor;
    }

    public void setBufferingImportedListState(boolean bl) {
        this.usingImportedList = bl;
    }

    public void disposeResource() {
        this.engine = null;
        this.processor = null;
    }

    public boolean hasError() {
        return this.error;
    }

    public void decode(URL uRL) {
        this.error = false;
        ProcessCodeImporter processCodeImporter = new ProcessCodeImporter(this.engine, this.processor);
        if (this.usingImportedList) {
            processCodeImporter.setImportedList(this.importedList);
        }
        try {
            processCodeImporter.load(uRL);
            if (this.usingImportedList) {
                this.importedList = this.importedList + processCodeImporter.getImportedList();
            }
        }
        catch (Exception exception) {
            this.error = true;
            exception.printStackTrace();
        }
        processCodeImporter.disposeResource();
        processCodeImporter = null;
    }

    public void decode(String string, File file) {
        this.decode(string, file, "UNKNOWN_PROGRAM");
    }

    public void decode(String string, File file, String string2) {
        this.error = false;
        ProcessCodeImporter processCodeImporter = new ProcessCodeImporter(this.engine, this.processor);
        if (this.usingImportedList) {
            processCodeImporter.setImportedList(this.importedList);
        }
        try {
            processCodeImporter.load(string, file, string2);
            if (this.usingImportedList) {
                this.importedList = this.importedList + processCodeImporter.getImportedList();
            }
        }
        catch (Exception exception) {
            this.error = true;
            exception.printStackTrace();
        }
        processCodeImporter.disposeResource();
        processCodeImporter = null;
        this.engine.setMainProgramDirectory(file);
    }

    public void decodeInternalLibrary(String string, File file) {
        this.error = false;
        ProcessCodeImporter processCodeImporter = new ProcessCodeImporter(this.engine, this.processor);
        if (this.usingImportedList) {
            processCodeImporter.setImportedList(this.importedList);
        }
        try {
            processCodeImporter.loadInternalLibrary(string, file);
            if (this.usingImportedList) {
                this.importedList = this.importedList + processCodeImporter.getImportedList();
            }
        }
        catch (Exception exception) {
            this.error = true;
            exception.printStackTrace();
        }
        processCodeImporter.disposeResource();
        processCodeImporter = null;
    }
}

