/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.driver;

import com.rinearn.rxg3dlegacyimpl.ProcessDrivenGraph3DWindow;
import java.awt.Color;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ProcessEnvironmentProperty;
import rxvesapi.process.ProcessRuntimeException;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.connection.GeneralProcessConnectionInterface;
import rxvesapi.process.driver.GraphicsProcessDriver;
import rxvesapi.process.graph.graph3d.function.Function_addGraph3DData;
import rxvesapi.process.graph.graph3d.function.Function_setGraph3DData;
import rxvesapi.process.kernel.FunctionCallKernel;
import rxvesapi.process.unit.FunctionCallUnit;
import rxvesapi.process.unit.IntegerUnit;
import rxvesapi.process.unit.ProcessUnit;
import rxvesapi.system.kernel.cache.VirtualizedIOServer;

public class Graph3DProcessDriver
implements GeneralProcessConnectionInterface,
WindowListener {
    private static final Map<String, String> FILEMODE_LIBARG_RG3DARG_MAP = new HashMap<String, String>(){
        {
            this.put("AUTO", "AUTO");
            this.put("MATRIX_STSV", "MATRIX(TSV)");
            this.put("MATRIX_CSV", "MATRIX(CSV)");
            this.put("3COLUMNS_STSV", "3-COLUMNS(TSV)");
            this.put("3COLUMNS_CSV", "3-COLUMNS(CSV)");
            this.put("4COLUMNS_STSV", "4-COLUMNS(TSV)");
            this.put("4COLUMNS_CSV", "4-COLUMNS(CSV)");
            this.put("3COL_STSV", "3-COLUMNS(TSV)");
            this.put("3COL_CSV", "3-COLUMNS(CSV)");
            this.put("4COL_STSV", "4-COLUMNS(TSV)");
            this.put("4COL_CSV", "4-COLUMNS(CSV)");
        }
    };
    ProcessDrivenGraph3DWindow[] graph;
    public double[][][][] vertexX;
    public double[][][][] vertexY;
    public double[][][][] vertexZ;
    public ProcessEngine engine;
    public GraphicsProcessDriver graphicsDriver;
    public FunctionCallKernel[] kernel;
    protected int defaultGraphIndex = -1;
    boolean frameEventInited = false;
    private ProcessUnit[] windowArgUnit;
    private FunctionCallUnit[] windowClosingUnit;
    private FunctionCallKernel[] windowClosingKernel;

    public void disposeResource() {
        for (int i = 0; i < this.graph.length; ++i) {
            if (this.graph[i] != null) {
                if (this.graph[i].isDisposable()) {
                    this.graph[i].disposeResource();
                } else {
                    this.graph[i].disposeDriver();
                    this.graph[i].removeWindowListener(this);
                    this.graph[i].setVisible(true);
                }
            }
            this.graph[i] = null;
        }
        this.graph = null;
        this.vertexX = null;
        this.vertexY = null;
        this.vertexZ = null;
    }

    @Override
    public void init() {
    }

    @Override
    public void dispose() {
        this.disposeResource();
        this.kernel = null;
    }

    public void format() {
        if (this.graph != null) {
            for (int i = 0; i < this.graph.length; ++i) {
                if (this.graph[i].isDisposable()) {
                    this.graph[i].disposeResource();
                } else {
                    this.graph[i].disposeDriver();
                    this.graph[i].removeWindowListener(this);
                }
                this.graph[i] = null;
            }
            this.graph = null;
        }
        this.graph = new ProcessDrivenGraph3DWindow[1];
        this.vertexX = new double[1][0][0][0];
        this.vertexY = new double[1][0][0][0];
        this.vertexZ = new double[1][0][0][0];
        this.createKernel();
    }

    public FunctionCallKernel[] getKernel() {
        return this.kernel;
    }

    public void createKernel() {
        int n = 2;
        int n2 = 0;
        this.kernel = new FunctionCallKernel[n];
        this.kernel[n2] = new Function_setGraph3DData(this);
        this.kernel[++n2] = new Function_addGraph3DData(this);
        ++n2;
    }

    public void setDefaultGraph(ProcessDrivenGraph3DWindow processDrivenGraph3DWindow) {
        this.defaultGraphIndex = this.generateGraph(processDrivenGraph3DWindow);
    }

    public int getDefaultGraph() {
        if (0 <= this.defaultGraphIndex) {
            return this.defaultGraphIndex;
        }
        return this.generateGraph();
    }

    public int generateGraph() {
        return this.generateGraph(new ProcessDrivenGraph3DWindow());
    }

    public int generateGraph(ProcessDrivenGraph3DWindow processDrivenGraph3DWindow) {
        int n = this.graph.length;
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (this.graph[i] != null) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            int n3;
            ProcessDrivenGraph3DWindow[] processDrivenGraph3DWindowArray = new ProcessDrivenGraph3DWindow[n];
            for (n3 = 0; n3 < n; ++n3) {
                processDrivenGraph3DWindowArray[n3] = this.graph[n3];
            }
            this.graph = new ProcessDrivenGraph3DWindow[n * 2];
            for (n3 = 0; n3 < n; ++n3) {
                this.graph[n3] = processDrivenGraph3DWindowArray[n3];
            }
            processDrivenGraph3DWindowArray = null;
            this.vertexX = new double[n * 2][0][0][0];
            this.vertexY = new double[n * 2][0][0][0];
            this.vertexZ = new double[n * 2][0][0][0];
            n2 = n;
        }
        this.graph[n2] = processDrivenGraph3DWindow;
        this.graph[n2].graphicsDriver = this.graphicsDriver;
        this.graph[n2].graphID = n2;
        this.graph[n2].addWindowListener(this);
        this.waitFor(n2);
        return n2;
    }

    public void setGraph3DData(int n, int[] nArray, double[] dArray, double[] dArray2, double[] dArray3) {
        this.waitFor(n);
        if (nArray.length == 1) {
            this.addGraph3DData1D(n, nArray, dArray, dArray2, dArray3, true);
        } else if (nArray.length == 2) {
            this.addGraph3DData2D(n, nArray, dArray, dArray2, dArray3, true);
        } else if (nArray.length == 3) {
            this.addGraph3DData3D(n, nArray, dArray, dArray2, dArray3, true);
        }
        this.waitFor(n);
    }

    public void addGraph3DData(int n, int[] nArray, double[] dArray, double[] dArray2, double[] dArray3) {
        this.waitFor(n);
        if (nArray.length == 1) {
            this.addGraph3DData1D(n, nArray, dArray, dArray2, dArray3, false);
        } else if (nArray.length == 2) {
            this.addGraph3DData2D(n, nArray, dArray, dArray2, dArray3, false);
        } else if (nArray.length == 3) {
            this.addGraph3DData3D(n, nArray, dArray, dArray2, dArray3, false);
        }
        this.waitFor(n);
    }

    public void clearGraph3D(int n) {
        this.waitFor(n);
        int n2 = n;
        if (this.graph[n2] != null) {
            this.graph[n2].format();
        }
        this.waitFor(n);
    }

    public void addGraph3DData3D(int n, int[] nArray, double[] dArray, double[] dArray2, double[] dArray3, boolean bl) {
        int n2;
        double[][][] dArray4;
        double[][][] dArray5;
        double[][][] dArray6;
        this.waitFor(n);
        int n3 = 0;
        int n4 = nArray[0];
        int n5 = nArray[1];
        int n6 = nArray[2];
        if (bl) {
            if (n4 != this.vertexX[n].length || 1 > n4 || n5 != this.vertexX[n][0].length || 1 > n5 || n6 != this.vertexX[n][0][0].length || 1 > n6) {
                this.vertexX[n] = new double[n4][n5][n6];
                this.vertexY[n] = new double[n4][n5][n6];
                this.vertexZ[n] = new double[n4][n5][n6];
            }
            dArray6 = this.vertexX[n];
            dArray5 = this.vertexY[n];
            dArray4 = this.vertexZ[n];
        } else {
            dArray6 = new double[n4][n5][n6];
            dArray5 = new double[n4][n5][n6];
            dArray4 = new double[n4][n5][n6];
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n6; ++j) {
                    n3 = n2 * n6 * n5 + i * n6 + j;
                    dArray6[n2][i][j] = dArray[n3];
                    dArray5[n2][i][j] = dArray2[n3];
                    dArray4[n2][i][j] = dArray3[n3];
                }
            }
        }
        if (bl) {
            this.graph[n].format_NOREPAINT();
        }
        for (n2 = 0; n2 < dArray6.length; ++n2) {
            this.graph[n].addSystem(dArray6[n2], dArray5[n2], dArray4[n2]);
        }
        this.fitRange(n, dArray6, dArray5, dArray4, bl);
        if (!(this.graph[n].isAutomaticSetRangeX() || this.graph[n].isAutomaticSetRangeY() || this.graph[n].isAutomaticSetRangeZ())) {
            this.waitFor(n);
            this.graph[n].repaintGraph();
        }
        if (dArray6.length == 0) {
            this.waitFor(n);
            this.graph[n].repaintGraph();
        }
        this.waitFor(n);
    }

    public void addGraph3DData2D(int n, int[] nArray, double[] dArray, double[] dArray2, double[] dArray3, boolean bl) {
        double[][][] dArray4;
        double[][][] dArray5;
        double[][][] dArray6;
        this.waitFor(n);
        int n2 = 0;
        int n3 = nArray[0];
        int n4 = nArray[1];
        if (bl) {
            if (1 != this.vertexX[n].length || n3 != this.vertexX[n][0].length || n4 != this.vertexX[n][0][0].length) {
                this.vertexX[n] = new double[1][n3][n4];
                this.vertexY[n] = new double[1][n3][n4];
                this.vertexZ[n] = new double[1][n3][n4];
            }
            dArray6 = this.vertexX[n];
            dArray5 = this.vertexY[n];
            dArray4 = this.vertexZ[n];
        } else {
            dArray6 = new double[1][n3][n4];
            dArray5 = new double[1][n3][n4];
            dArray4 = new double[1][n3][n4];
        }
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                n2 = i * n4 + j;
                dArray6[0][i][j] = dArray[n2];
                dArray5[0][i][j] = dArray2[n2];
                dArray4[0][i][j] = dArray3[n2];
            }
        }
        if (bl) {
            this.graph[n].format_NOREPAINT();
        }
        this.graph[n].addSystem(dArray6[0], dArray5[0], dArray4[0]);
        this.fitRange(n, dArray6, dArray5, dArray4, bl);
        if (!(this.graph[n].isAutomaticSetRangeX() || this.graph[n].isAutomaticSetRangeY() || this.graph[n].isAutomaticSetRangeZ())) {
            this.waitFor(n);
            this.graph[n].repaintGraph();
        }
        this.waitFor(n);
    }

    public void addGraph3DData1D(int n, int[] nArray, double[] dArray, double[] dArray2, double[] dArray3, boolean bl) {
        double[][][] dArray4;
        double[][][] dArray5;
        double[][][] dArray6;
        this.waitFor(n);
        int n2 = 0;
        int n3 = nArray[0];
        if (bl) {
            if (1 != this.vertexX[n].length || 1 != this.vertexX[n][0].length || n3 != this.vertexX[n][0][0].length) {
                this.vertexX[n] = new double[1][1][n3];
                this.vertexY[n] = new double[1][1][n3];
                this.vertexZ[n] = new double[1][1][n3];
            }
            dArray6 = this.vertexX[n];
            dArray5 = this.vertexY[n];
            dArray4 = this.vertexZ[n];
        } else {
            dArray6 = new double[1][1][n3];
            dArray5 = new double[1][1][n3];
            dArray4 = new double[1][1][n3];
        }
        for (int i = 0; i < n3; ++i) {
            n2 = i;
            dArray6[0][0][i] = dArray[n2];
            dArray5[0][0][i] = dArray2[n2];
            dArray4[0][0][i] = dArray3[n2];
        }
        if (bl) {
            this.graph[n].format_NOREPAINT();
        }
        this.graph[n].addSystem(dArray6[0], dArray5[0], dArray4[0]);
        this.fitRange(n, dArray6, dArray5, dArray4, bl);
        if (!(this.graph[n].isAutomaticSetRangeX() || this.graph[n].isAutomaticSetRangeY() || this.graph[n].isAutomaticSetRangeZ())) {
            this.waitFor(n);
            this.graph[n].repaintGraph();
        }
        this.waitFor(n);
    }

    public void fitRange(int n, double[][][] dArray, double[][][] dArray2, double[][][] dArray3, boolean bl) {
        int n2;
        int n3;
        int n4;
        double d;
        double d2;
        this.waitFor(n);
        if (this.graph[n].isAutomaticSetRangeX()) {
            if (bl) {
                d2 = -1.7976931348623157E308;
                d = Double.MAX_VALUE;
            } else {
                d2 = this.graph[n].getXMax();
                d = this.graph[n].getXMin();
            }
            for (n4 = 0; n4 < dArray.length; ++n4) {
                for (n3 = 0; n3 < dArray[n4].length; ++n3) {
                    for (n2 = 0; n2 < dArray[n4][n3].length; ++n2) {
                        if (d2 < dArray[n4][n3][n2]) {
                            d2 = dArray[n4][n3][n2];
                        }
                        if (!(dArray[n4][n3][n2] < d)) continue;
                        d = dArray[n4][n3][n2];
                    }
                }
            }
            this.graph[n].setXRange(d2, d);
        }
        if (this.graph[n].isAutomaticSetRangeY()) {
            if (bl) {
                d2 = -1.7976931348623157E308;
                d = Double.MAX_VALUE;
            } else {
                d2 = this.graph[n].getYMax();
                d = this.graph[n].getYMin();
            }
            for (n4 = 0; n4 < dArray2.length; ++n4) {
                for (n3 = 0; n3 < dArray2[n4].length; ++n3) {
                    for (n2 = 0; n2 < dArray2[n4][n3].length; ++n2) {
                        if (d2 < dArray2[n4][n3][n2]) {
                            d2 = dArray2[n4][n3][n2];
                        }
                        if (!(dArray2[n4][n3][n2] < d)) continue;
                        d = dArray2[n4][n3][n2];
                    }
                }
            }
            this.graph[n].setYRange(d2, d);
        }
        if (this.graph[n].isAutomaticSetRangeZ()) {
            if (bl) {
                d2 = -1.7976931348623157E308;
                d = Double.MAX_VALUE;
            } else {
                d2 = this.graph[n].getZMax();
                d = this.graph[n].getZMin();
            }
            for (n4 = 0; n4 < dArray3.length; ++n4) {
                for (n3 = 0; n3 < dArray3[n4].length; ++n3) {
                    for (n2 = 0; n2 < dArray3[n4][n3].length; ++n2) {
                        if (d2 < dArray3[n4][n3][n2]) {
                            d2 = dArray3[n4][n3][n2];
                        }
                        if (!(dArray3[n4][n3][n2] < d)) continue;
                        d = dArray3[n4][n3][n2];
                    }
                }
            }
            this.graph[n].setZRange(d2, d);
        }
        this.waitFor(n);
    }

    @Override
    public boolean isProcessable(String string) {
        return string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_START") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_newGraph3D") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_deleteGraph3D") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_clearGraph3D") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_getGraph3DSystemDefaultInstance") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_newGraph3DGraphics") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DCameraAngle") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DCameraDistance") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DCameraMagnification") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DCameraPerspective") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_hideGraph3D") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_showGraph3D") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DWindowTitle") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DLocation") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DSize") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DFile") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DFiles") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DFileWithMode") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DFilesWithModes") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DDataString") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_exportGraph3DData") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DBackgroundColor") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DScaleColor") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DAutoRange") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DRange") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DRangeX") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DRangeY") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DRangeZ") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DTickX") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DTickY") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DTickZ") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DTickColorBar") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DLabelX") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DLabelY") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DLabelZ") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DOption") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DMenu") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DTitle") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DLegend") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_exportGraph3D") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_INTERNAL_FLOW_CONTROL_waitForInterruptible") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DAnimation") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DConfigurationFile") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DConfigurationLine") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_END");
    }

    @Override
    public synchronized String[] process(String string, String[] stringArray) {
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        String[] stringArray2 = new String[]{"false"};
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_newGraph3D")) {
            n5 = this.generateGraph();
            stringArray2 = new String[]{"" + n5};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_deleteGraph3D")) {
            n5 = Integer.parseInt(stringArray[0]);
            if (this.graph[n5] != null) {
                if (this.graph[n5].isDisposable()) {
                    this.graph[n5].disposeResource();
                } else {
                    this.graph[n5].disposeDriver();
                    this.graph[n5].removeWindowListener(this);
                }
            }
            this.graph[n5] = null;
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_clearGraph3D")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            if (this.graph[n5] != null) {
                this.graph[n5].format();
            }
            stringArray2 = new String[]{"" + n5};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_getGraph3DSystemDefaultInstance")) {
            n5 = this.getDefaultGraph();
            stringArray2 = new String[]{"" + n5};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_newGraph3DGraphics")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            n4 = this.graphicsDriver.getAvailableImageIndex();
            this.graphicsDriver.image[n4] = this.graph[n5].getImage();
            this.graph[n5].lastImage = this.graph[n5].getImage();
            this.graph[n5].graphicsDriver = this.graphicsDriver;
            this.graph[n5].imageID = n4;
            this.graph[n5].imageSync = true;
            stringArray2 = new String[]{"" + n4};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_deleteGraph3DGraphics")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            n4 = Integer.parseInt(stringArray[1]);
            this.graphicsDriver.image[n4] = null;
            this.graph[n5].graphicsDriver = null;
            this.graph[n5].imageID = -1;
            this.graph[n5].imageSync = false;
            stringArray2 = new String[]{""};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_hideGraph3D")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            this.graph[n5].setVisible(false);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_showGraph3D")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            this.graph[n5].setVisible(true);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DWindowTitle")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            this.graph[n5].setTitle(stringArray[1]);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DLocation")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            n4 = Integer.parseInt(stringArray[1]);
            n3 = Integer.parseInt(stringArray[2]);
            n2 = (int)this.graph[n5].getBounds().getWidth();
            n = (int)this.graph[n5].getBounds().getHeight();
            this.graph[n5].setBounds(n4, n3, n2, n);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DSize")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            n4 = Integer.parseInt(stringArray[1]);
            n3 = Integer.parseInt(stringArray[2]);
            n2 = (int)this.graph[n5].getBounds().getX();
            n = (int)this.graph[n5].getBounds().getY();
            this.graph[n5].setBounds(n2, n, n4, n3);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DFile")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            String string2 = stringArray[1];
            File file = this.engine.getResourceFile(string2);
            if (ProcessEnvironmentProperty.isOnline()) {
                String string3 = file.getPath();
                String string4 = VirtualizedIOServer.getInstance().getFileContent(string3);
                this.graph[n5].plotVertexString_steals(string4);
                this.graph[n5].setTitleFileName("UNKNOWN FILE ");
            } else {
                string2 = file.getPath();
                try {
                    this.graph[n5].plotFile(string2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.graph[n5].setTitleFileName(file.getName());
            }
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DFileWithMode")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            String string5 = stringArray[1];
            String string6 = stringArray[2];
            if (!FILEMODE_LIBARG_RG3DARG_MAP.containsKey(string6)) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.engine.error("3D\u30b0\u30e9\u30d5\u3067\u672a\u30b5\u30dd\u30fc\u30c8\u306e\u30d5\u30a1\u30a4\u30eb\u5f62\u5f0f\u540d\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f: " + string6);
                } else {
                    this.engine.error("The specified mode is not supported for the 3D Graph Software: " + string6);
                }
                stringArray2 = new String[]{"false"};
                return stringArray2;
            }
            string6 = FILEMODE_LIBARG_RG3DARG_MAP.get(string6);
            File file = this.engine.getResourceFile(string5);
            if (ProcessEnvironmentProperty.isOnline()) {
                String string7 = file.getPath();
                object = VirtualizedIOServer.getInstance().getFileContent(string7);
                this.graph[n5].plotVertexString_steals((String)object);
                this.graph[n5].setTitleFileName("UNKNOWN FILE ");
            } else {
                string5 = file.getPath();
                try {
                    this.graph[n5].plotFile(string5, string6);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.graph[n5].setTitleFileName(file.getName());
            }
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DFiles")) {
            Object object2;
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            String[] stringArray3 = new String[stringArray.length - 1];
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringArray3[i] = stringArray[i + 1];
                File file = this.engine.getResourceFile(stringArray3[i]);
                stringArray3[i] = file.getPath();
            }
            if (ProcessEnvironmentProperty.isOnline()) {
                object2 = System.getProperty("line.separator");
                String string8 = VirtualizedIOServer.getInstance().getFileContentsSeparatedByBlankLines(stringArray3, (String)object2 + (String)object2);
                this.graph[n5].plotVertexString_steals(string8);
                this.graph[n5].setTitleFileName("UNKNOWN FILE ");
            } else {
                try {
                    this.graph[n5].plotFile(stringArray3);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                object2 = this.engine.getResourceFile(stringArray3[0]);
                this.graph[n5].setTitleFileName(((File)object2).getName());
            }
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DFilesWithModes")) {
            Object object3;
            int n6;
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            int n7 = (stringArray.length - 1) / 2;
            String[] stringArray4 = new String[n7];
            String[] stringArray5 = new String[n7];
            for (n6 = 0; n6 < n7; ++n6) {
                stringArray4[n6] = stringArray[1 + n6];
                object = this.engine.getResourceFile(stringArray4[n6]);
            }
            for (n6 = 0; n6 < n7; ++n6) {
                stringArray5[n6] = stringArray[1 + n7 + n6];
                if (!FILEMODE_LIBARG_RG3DARG_MAP.containsKey(stringArray5[n6])) {
                    if (ScriptProcessor.locale.isJapanese()) {
                        this.engine.error("3D\u30b0\u30e9\u30d5\u3067\u672a\u30b5\u30dd\u30fc\u30c8\u306e\u30d5\u30a1\u30a4\u30eb\u5f62\u5f0f\u540d\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f: " + stringArray5[n6]);
                    } else {
                        this.engine.error("The specified mode is not supported for the 3D Graph Software: " + stringArray5[n6]);
                    }
                    stringArray2 = new String[]{"false"};
                    return stringArray2;
                }
                stringArray5[n6] = FILEMODE_LIBARG_RG3DARG_MAP.get(stringArray5[n6]);
            }
            if (ProcessEnvironmentProperty.isOnline()) {
                object3 = System.getProperty("line.separator");
                object = VirtualizedIOServer.getInstance().getFileContentsSeparatedByBlankLines(stringArray4, (String)object3 + (String)object3);
                this.graph[n5].plotVertexString_steals((String)object);
                this.graph[n5].setTitleFileName("UNKNOWN FILE ");
            } else {
                try {
                    this.graph[n5].plotFile(stringArray4, stringArray5);
                }
                catch (IOException iOException) {
                    stringArray2 = new String[]{"false"};
                    return stringArray2;
                }
                object3 = this.engine.getResourceFile(stringArray4[0]);
                this.graph[n5].setTitleFileName(((File)object3).getName());
            }
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DConfigurationFile")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            String string9 = stringArray[1];
            File file = this.engine.getResourceFile(string9);
            string9 = file.getPath();
            try {
                this.graph[n5].loadConfigurationFile(string9);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DConfigurationLine")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            String string10 = stringArray[1];
            this.graph[n5].setConfigurationLine(string10);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_exportGraph3DData")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            String string11 = stringArray[1];
            File file = this.engine.getResourceFile(string11);
            string11 = file.getPath();
            try {
                this.graph[n5].exportData(string11, 0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_exportGraph3D")) {
            n5 = Integer.parseInt(stringArray[0]);
            String string12 = stringArray[1];
            String string13 = stringArray[2].toLowerCase();
            if (string13.equals("png") && !string12.endsWith(".png")) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.engine.error("\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u540d\u306e\u62e1\u5f35\u5b50\u304c\u3001\u6307\u5b9a\u3055\u308c\u305f\u5f62\u5f0f\u3068\u6574\u5408\u3057\u307e\u305b\u3093\u3002");
                } else {
                    this.engine.error("The extension of the specified file name does not match with the specified file format.");
                }
                this.engine.exit();
            }
            if ((string13.equals("jpg") || string13.equals("jpeg")) && !string12.endsWith(".jpg") && !string12.endsWith(".jpeg")) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.engine.error("\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u540d\u306e\u62e1\u5f35\u5b50\u304c\u3001\u6307\u5b9a\u3055\u308c\u305f\u5f62\u5f0f\u3068\u6574\u5408\u3057\u307e\u305b\u3093\u3002");
                } else {
                    this.engine.error("The extension of the specified file name does not match with the specified file format.");
                }
                this.engine.exit();
            }
            File file = this.engine.getResourceFile(string12);
            if (!this.engine.getSecurity().request_WRITE_FILE(string12)) {
                this.engine.exit();
                return new String[]{"false"};
            }
            if (file.exists() && !this.engine.getSecurity().request_OVERWRITE_FILE(string12)) {
                this.engine.exit();
                return new String[]{"false"};
            }
            if (this.graph[n5].imageSavePathField == null) {
                this.graph[n5].launchSaveMenuWindow();
                this.graph[n5].saveMenuWindow.setVisible(false);
            }
            this.graph[n5].saveFormatChoice.setSelectedItem(stringArray[2]);
            this.graph[n5].imageQualityField.setText(stringArray[3]);
            boolean bl = false;
            this.graph[n5].waitForInterruptable();
            this.graph[n5].save(this.graph[n5].screenImage, string12, file.getParentFile().getAbsolutePath(), bl);
            this.graph[n5].waitForInterruptable();
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_INTERNAL_FLOW_CONTROL_waitForInterruptible")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.graph[n5].waitForInterruptable();
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DDataString")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            String string14 = stringArray[1];
            this.graph[n5].plotVertexString_steals(string14);
            this.graph[n5].setTitleFileName("UNKNOWN FILE ");
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DBackgroundColor")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            int n8 = Integer.parseInt(stringArray[1]);
            int n9 = Integer.parseInt(stringArray[2]);
            int n10 = Integer.parseInt(stringArray[3]);
            int n11 = Integer.parseInt(stringArray[4]);
            object = new Color(n8, n9, n10, n11);
            this.graph[n5].setGraphBackgroundColor((Color)object);
            this.graph[n5].setWithBlackScreenState(false);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DScaleColor")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            int n12 = Integer.parseInt(stringArray[1]);
            int n13 = Integer.parseInt(stringArray[2]);
            int n14 = Integer.parseInt(stringArray[3]);
            int n15 = Integer.parseInt(stringArray[4]);
            object = new Color(n12, n13, n14, n15);
            this.graph[n5].setGraphScaleColor((Color)object);
            this.graph[n5].setWithBlackScreenState(false);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DAutoRange")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            if (stringArray[1].equals("true")) {
                this.graph[n5].setAutomaticSetRangeX(true);
            } else {
                this.graph[n5].setAutomaticSetRangeX(false);
            }
            if (stringArray[2].equals("true")) {
                this.graph[n5].setAutomaticSetRangeY(true);
            } else {
                this.graph[n5].setAutomaticSetRangeY(false);
            }
            if (stringArray[3].equals("true")) {
                this.graph[n5].setAutomaticSetRangeZ(true);
            } else {
                this.graph[n5].setAutomaticSetRangeZ(false);
            }
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DRange")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            double d = Double.parseDouble(stringArray[1]);
            double d2 = Double.parseDouble(stringArray[2]);
            this.graph[n5].setXRange(d, d2);
            d = Double.parseDouble(stringArray[3]);
            d2 = Double.parseDouble(stringArray[4]);
            this.graph[n5].setYRange(d, d2);
            d = Double.parseDouble(stringArray[5]);
            d2 = Double.parseDouble(stringArray[6]);
            this.graph[n5].setZRange(d, d2);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DRangeX")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            double d = Double.parseDouble(stringArray[1]);
            double d3 = Double.parseDouble(stringArray[2]);
            this.graph[n5].setXRange(d, d3);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DRangeY")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            double d = Double.parseDouble(stringArray[1]);
            double d4 = Double.parseDouble(stringArray[2]);
            this.graph[n5].setYRange(d, d4);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DRangeZ")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            double d = Double.parseDouble(stringArray[1]);
            double d5 = Double.parseDouble(stringArray[2]);
            this.graph[n5].setZRange(d, d5);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DCameraAngle")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            double d = Double.parseDouble(stringArray[1]);
            double d6 = Double.parseDouble(stringArray[2]);
            object = stringArray[3];
            if (stringArray[3].equals("ZENITH_X")) {
                this.graph[n5].setCameraAngle(d, d6, "X");
                stringArray2 = new String[]{"true"};
            } else if (stringArray[3].equals("ZENITH_Y")) {
                this.graph[n5].setCameraAngle(d, d6, "Y");
                stringArray2 = new String[]{"true"};
            } else if (stringArray[3].equals("ZENITH_Z")) {
                this.graph[n5].setCameraAngle(d, d6, "Z");
                stringArray2 = new String[]{"true"};
            } else {
                System.err.println("Warning: RinearnGraph3D: The specified angle mode \"" + stringArray[3] + "\" is not supported.");
                stringArray2 = new String[]{"false"};
            }
            this.waitFor(n5);
            this.graph[n5].waitForInterruptable();
            this.graph[n5].repaint3D();
            this.graph[n5].waitForInterruptable();
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DCameraMagnification")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            double d = Double.parseDouble(stringArray[1]);
            this.graph[n5].setCameraMagnification(d);
            this.waitFor(n5);
            this.graph[n5].waitForInterruptable();
            this.graph[n5].repaint3D();
            this.graph[n5].waitForInterruptable();
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DCameraDistance")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            double d = Double.parseDouble(stringArray[1]);
            this.graph[n5].setCameraDistance(d);
            this.waitFor(n5);
            this.graph[n5].waitForInterruptable();
            this.graph[n5].repaint3D();
            this.graph[n5].waitForInterruptable();
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DCameraPerspective")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            boolean bl = stringArray[1].equals("true");
            this.graph[n5].setCameraPerspectiveEnabled(bl);
            this.waitFor(n5);
            this.graph[n5].waitForInterruptable();
            this.graph[n5].repaint3D();
            this.graph[n5].waitForInterruptable();
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DOption")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            String string15 = stringArray[1];
            boolean bl = false;
            if (stringArray[2].equals("true")) {
                bl = true;
            }
            if (string15.equals("WITH_MEMBRANES") || string15.equals("MEMBRANE")) {
                this.graph[n5].setWithMembranesState(bl);
            }
            if (string15.equals("WITH_MESHES") || string15.equals("MESH")) {
                this.graph[n5].setWithMeshesState(bl);
            }
            if (string15.equals("WITH_POINTS") || string15.equals("POINT")) {
                this.graph[n5].setWithPointsState(bl);
            }
            if (string15.equals("WITH_DOTS") || string15.equals("DOT")) {
                this.graph[n5].withDotsBox.setState(bl);
            }
            if (string15.equals("WITH_LINES") || string15.equals("LINE")) {
                this.graph[n5].setWithLinesState(bl);
            }
            if (string15.equals("GRID") || string15.equals("GRID_LINE") || string15.equals("WITH_GRID_LINE")) {
                this.graph[n5].withGridLineBox.setState(bl);
            }
            if (string15.equals("GRADATION") || string15.equals("WITH_GRADATION")) {
                this.graph[n5].withRainbowBox.setState(bl);
            }
            if (string15.equals("ALPHA") || string15.equals("WITH_ALPHA")) {
                this.graph[n5].withSeeThroughBox.setState(bl);
            }
            if (string15.equals("FRAME") || string15.equals("WITH_FRAME")) {
                this.graph[n5].withFrameBox.setState(bl);
            }
            if (string15.equals("SCALE") || string15.equals("WITH_SCALE")) {
                this.graph[n5].withScaleBox.setState(bl);
            }
            if (string15.equals("FLAT")) {
                this.graph[n5].flatBox.setState(bl);
            }
            if (string15.equals("LOG_X")) {
                this.graph[n5].lnXBox.setState(bl);
            }
            if (string15.equals("LOG_Y")) {
                this.graph[n5].lnYBox.setState(bl);
            }
            if (string15.equals("LOG_Z")) {
                this.graph[n5].lnZBox.setState(bl);
            }
            if (string15.equals("REVERSE_X")) {
                this.graph[n5].revXBox.setState(bl);
            }
            if (string15.equals("REVERSE_Y")) {
                this.graph[n5].revYBox.setState(bl);
            }
            if (string15.equals("REVERSE_Z")) {
                this.graph[n5].revZBox.setState(bl);
            }
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DMenu")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            String string16 = stringArray[1];
            if (string16.equals("SET_LABEL_X") || string16.equals("SET_X_LABEL")) {
                this.graph[n5].setXName(stringArray[2]);
            }
            if (string16.equals("SET_LABEL_Y") || string16.equals("SET_Y_LABEL")) {
                this.graph[n5].setYName(stringArray[2]);
            }
            if (string16.equals("SET_LABEL_Z") || string16.equals("SET_Z_LABEL")) {
                this.graph[n5].setZName(stringArray[2]);
            }
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DTitle")) {
            // empty if block
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DLabelX")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            this.graph[n5].setXName(stringArray[1]);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DLabelY")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            this.graph[n5].setYName(stringArray[1]);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DLabelZ")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            this.graph[n5].setZName(stringArray[1]);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DTickX")) {
            int n16;
            n5 = Integer.parseInt(stringArray[0]);
            int n17 = Integer.parseInt(stringArray[1]);
            double[] dArray = new double[n17];
            String[] stringArray6 = new String[n17];
            int n18 = 2;
            for (n16 = 0; n16 < n17; ++n16) {
                dArray[n16] = Double.parseDouble(stringArray[n18]);
                ++n18;
            }
            for (n16 = 0; n16 < n17; ++n16) {
                stringArray6[n16] = stringArray[n18];
                ++n18;
            }
            this.waitFor(n5);
            this.graph[n5].setXTicks(dArray, stringArray6);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DTickY")) {
            int n19;
            n5 = Integer.parseInt(stringArray[0]);
            int n20 = Integer.parseInt(stringArray[1]);
            double[] dArray = new double[n20];
            String[] stringArray7 = new String[n20];
            int n21 = 2;
            for (n19 = 0; n19 < n20; ++n19) {
                dArray[n19] = Double.parseDouble(stringArray[n21]);
                ++n21;
            }
            for (n19 = 0; n19 < n20; ++n19) {
                stringArray7[n19] = stringArray[n21];
                ++n21;
            }
            this.waitFor(n5);
            this.graph[n5].setYTicks(dArray, stringArray7);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DTickZ")) {
            int n22;
            n5 = Integer.parseInt(stringArray[0]);
            int n23 = Integer.parseInt(stringArray[1]);
            double[] dArray = new double[n23];
            String[] stringArray8 = new String[n23];
            int n24 = 2;
            for (n22 = 0; n22 < n23; ++n22) {
                dArray[n22] = Double.parseDouble(stringArray[n24]);
                ++n24;
            }
            for (n22 = 0; n22 < n23; ++n22) {
                stringArray8[n22] = stringArray[n24];
                ++n24;
            }
            this.waitFor(n5);
            this.graph[n5].setZTicks(dArray, stringArray8);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DTickColorBar")) {
            int n25;
            n5 = Integer.parseInt(stringArray[0]);
            int n26 = Integer.parseInt(stringArray[1]);
            double[] dArray = new double[n26];
            String[] stringArray9 = new String[n26];
            int n27 = 2;
            for (n25 = 0; n25 < n26; ++n25) {
                dArray[n25] = Double.parseDouble(stringArray[n27]);
                ++n27;
            }
            for (n25 = 0; n25 < n26; ++n25) {
                stringArray9[n25] = stringArray[n27];
                ++n27;
            }
            this.waitFor(n5);
            this.graph[n5].setColorBarTicks(dArray, stringArray9);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DLegend")) {
            // empty if block
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH3D_setGraph3DAnimation")) {
            stringArray[0] = stringArray[0].replaceAll("INDEX", "INDEX-POINT");
            stringArray[0] = stringArray[0].replaceAll("SERIES_INDEX", "INDEX-SERIES");
            stringArray[0] = stringArray[0].replaceAll("SERIES-INDEX", "INDEX-SERIES");
            stringArray[0] = stringArray[0].replaceAll("X-INDEX", "INDEX-X");
            stringArray[0] = stringArray[0].replaceAll("Y-INDEX", "INDEX-Y");
            stringArray[0] = stringArray[0].replaceAll("Z-INDEX", "INDEX-Z");
            stringArray[0] = stringArray[0].replaceAll("X-AREA", "AREA-X");
            stringArray[0] = stringArray[0].replaceAll("Y-AREA", "AREA-Y");
            stringArray[0] = stringArray[0].replaceAll("Z-AREA", "AREA-Z");
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            if (stringArray[2].equals("true")) {
                this.graph[n5].setAnimationState(true);
                this.graph[n5].setAnimationMode(stringArray[1]);
            } else {
                this.graph[n5].setAnimationState(false);
            }
            this.waitFor(n5);
        }
        return stringArray2;
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        try {
            Object object = windowEvent.getSource();
            ProcessDrivenGraph3DWindow processDrivenGraph3DWindow = (ProcessDrivenGraph3DWindow)object;
            int n = processDrivenGraph3DWindow.graphID;
            this.waitFor(n);
            this.frameEventInit();
            if (this.windowClosingKernel != null) {
                this.windowArgUnit[0].setIntegerValue(n);
                for (int i = 0; i < this.windowClosingKernel.length; ++i) {
                    try {
                        this.windowClosingUnit[i].process();
                        continue;
                    }
                    catch (ProcessRuntimeException processRuntimeException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    void frameEventInit() {
        if (!this.frameEventInited) {
            this.windowArgUnit = new ProcessUnit[1];
            this.windowArgUnit[0] = new IntegerUnit(-1L, this.engine);
            this.windowClosingKernel = this.engine.getAllFunctionCallKernel("onGraph3DClose");
            if (this.windowClosingKernel != null) {
                this.windowClosingUnit = new FunctionCallUnit[this.windowClosingKernel.length];
                for (int i = 0; i < this.windowClosingKernel.length; ++i) {
                    this.windowClosingUnit[i] = new FunctionCallUnit(this.windowArgUnit, this.windowClosingKernel[i], this.engine);
                    this.windowClosingUnit[i].setProcessKernel(this.windowClosingKernel[i]);
                }
            }
            this.frameEventInited = true;
        }
    }

    public void waitFor(int n) {
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
    }
}

