/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.driver;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import rxvesapi.process.ProcessCompatibilityException;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.connection.GeneralProcessConnectionInterface;
import rxvesapi.process.kernel.FunctionCallKernel;
import rxvesapi.system.kernel.process.SystemNativeProcess;
import rxvesapi.system.kernel.process.SystemNativeProcessEvent;
import rxvesapi.system.kernel.process.SystemNativeProcessListener;

public class NativeProcessDriver
implements GeneralProcessConnectionInterface,
SystemNativeProcessListener {
    public ProcessEngine engine;
    public SystemNativeProcess[] process;
    public String lfc = System.getProperty("line.separator");
    public FunctionCallKernel[] kernel;

    @Override
    public void init() {
    }

    @Override
    public void dispose() {
        this.disposeResource();
    }

    public void disposeResource() {
    }

    public void format() {
        this.engine = null;
        if (this.process != null) {
            int n = this.process.length;
            for (int i = 0; i < n; ++i) {
                if (this.process[i] == null) continue;
                try {
                    this.process[i].destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.process[i].dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.process[i] = null;
            }
            this.process = null;
        }
    }

    public FunctionCallKernel[] getKernel() {
        return null;
    }

    public void createKernel() {
    }

    @Override
    public boolean isProcessable(String string) {
        return string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_start") || string.equals("___exec") || string.equals("___system") || string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_startProcess") || string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_createProcess") || string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_disposeProcess") || string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_waitForProcess") || string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_destroyProcess") || string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_getProcessExitValue") || string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_getProcessError") || string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_getProcessOutput") || string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_clearProcessOutput") || string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_clearProcessError") || string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_flushProcessOutput") || string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_flushProcessError") || string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_setProcessInput") || string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_setProcessInputEncoding") || string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_setProcessOutputEncoding") || string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_setProcessErrorEncoding") || string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_setProcessWorkingDirectory") || string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_end");
    }

    @Override
    public String[] process(String string, String[] stringArray) {
        String[] stringArray2 = new String[]{"false"};
        if (string.equals("___exec")) {
            if (!this.engine.getSecurity().request_SYSTEM_COMMAND(stringArray)) {
                this.engine.exit();
                return new String[]{""};
            }
            int n = this.createProcess(stringArray);
            this.startProcess(n);
            return new String[]{"" + n};
        }
        if (string.equals("___system")) {
            if (!this.engine.getSecurity().request_SYSTEM_COMMAND(stringArray)) {
                this.engine.exit();
                return new String[]{""};
            }
            int n = this.createProcess(stringArray);
            this.startProcess(n);
            this.waitFor(n);
            int n2 = this.process[n].getExitValue();
            return new String[]{"" + n2};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_createProcess")) {
            if (!this.engine.getSecurity().request_SYSTEM_COMMAND(stringArray)) {
                this.engine.exit();
                return new String[]{""};
            }
            int n = this.createProcess(stringArray);
            return new String[]{"" + n};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_disposeProcess")) {
            int n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.disposeProcess(n);
            return new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_startProcess")) {
            int n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.startProcess(n);
            return new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_waitForProcess")) {
            int n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.waitFor(n);
            return new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_destroyProcess")) {
            int n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.destroyProcess(n);
            return new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_getProcessExitValue")) {
            int n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n3 = this.getProcessExitValue(n);
            return new String[]{"" + n3};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_getProcessError")) {
            int n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String string2 = this.getProcessError(n);
            return new String[]{"" + string2};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_getProcessOutput")) {
            int n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String string3 = this.getProcessOutput(n);
            return new String[]{"" + string3};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_getProcessError")) {
            int n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String string4 = this.getProcessOutput(n);
            return new String[]{"" + string4};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_clearProcessOutput")) {
            int n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.clearProcessOutput(n);
            return new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_clearProcessError")) {
            int n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.clearProcessError(n);
            return new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_flushProcessOutput")) {
            int n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.flushProcessOutput(n);
            return new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_flushProcessError")) {
            int n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.flushProcessError(n);
            return new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_setProcessInput")) {
            int n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.setProcessInput(n, stringArray[1]);
            return new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_setProcessInputEncoding")) {
            int n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String string5 = stringArray[1];
            this.setProcessInputEncoding(n, string5);
            return new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_setProcessOutputEncoding")) {
            int n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String string6 = stringArray[1];
            this.setProcessOutputEncoding(n, string6);
            return new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_setProcessErrorEncoding")) {
            int n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String string7 = stringArray[1];
            this.setProcessErrorEncoding(n, string7);
            return new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_NATIVE_setProcessWorkingDirectory")) {
            int n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String string8 = stringArray[1];
            this.setProcessWorkingDirectory(n, string8);
            return new String[]{""};
        }
        return new String[]{"false"};
    }

    public int createProcess(String[] stringArray) {
        ProcessCompatibilityException processCompatibilityException;
        File file = this.engine.getMainRelativeFile(".");
        String string = null;
        try {
            string = FileSystems.getDefault().getPath(file.getPath(), new String[0]).toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        catch (Exception exception) {
            string = file.getPath();
        }
        file = new File(string);
        if (file.getPath().startsWith("\\\\") && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
            String string2 = "";
            string2 = ScriptProcessor.locale.isJapanese() ? string2 + "\u73fe\u5728\u306e\u30ab\u30ec\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u30d5\u30a1\u30a4\u30eb\u30d1\u30b9\u306f\u3001IP\u30a2\u30c9\u30ec\u30b9\u3092\u7528\u3044\u3066\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u4e0a\u306e\u30d1\u30b9\u3092\u6307\u3057\u3066\u3044\u307e\u3059\uff08" + string + "\uff09\u3002\u3053\u306e\u72b6\u614b\u3067\u306f\u3001\u74b0\u5883\u306b\u3088\u3063\u3066\u306f\u3001\u6b63\u5e38\u306b\u30ab\u30ec\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u8a2d\u5b9a\u3057\u3066OS\u30b3\u30de\u30f3\u30c9\u3092\u5b9f\u884c\u3067\u304d\u306a\u3044\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\u3053\u306e\u554f\u984c\u3092\u907f\u3051\u308b\u306b\u306f\u3001\u30b9\u30af\u30ea\u30d7\u30c8\u304c\u3042\u308b\u5834\u6240\u3092\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u30c9\u30e9\u30a4\u30d6\u306b\u5272\u308a\u5f53\u3066\u308b\u306a\u3069\u3057\u3066\u3001\u30ab\u30ec\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u6a19\u6e96\u7684\u306a\u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\u30d1\u30b9\u306b\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002" : string2 + "The path of the 'current directory' is pointing the directopy on the network, using an IP address (" + string + "). Under this condition, it may fail to set the current directory of the requested OS commands correctly, depending on your environment. To avoid this, please assign the directory/drive in which this script locating as a network drive, to make the path of the current directory regular format.";
            this.engine.error(string2);
            return -1;
        }
        int n = this.getAvailableProcessIndex();
        this.process[n] = new SystemNativeProcess(stringArray, file);
        if (this.process[n].COMMAND_ENABLED) {
            this.process[n].id = n;
            this.process[n].engine = this.engine;
        } else {
            n = -1;
        }
        return n;
    }

    public void disposeProcess(int n) {
        this.process[n].dispose();
        this.process[n] = null;
    }

    public void startProcess(int n) {
        try {
            this.process[n].start();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = "";
            string = ScriptProcessor.locale.isJapanese() ? string + "\u30d7\u30ed\u30bb\u30b9\u306e\u6a19\u6e96\u5165\u51fa\u529b\u306b\u6307\u5b9a\u3055\u308c\u305f\u6587\u5b57\u30b3\u30fc\u30c9\u306f\u3001\u3053\u306e\u74b0\u5883\u3067\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093: " + unsupportedEncodingException.getMessage() : string + "The encoding specified for the standard input/output of the process is not available in this environment: " + unsupportedEncodingException.getMessage();
            this.engine.error(string);
        }
        catch (IOException iOException) {
            String string = "";
            string = ScriptProcessor.locale.isJapanese() ? string + "\u30d7\u30ed\u30bb\u30b9\u306e\u8d77\u52d5\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30d7\u30ed\u30bb\u30b9\u306e\u5b9f\u884c\u30d5\u30a1\u30a4\u30eb\u306e\u30d1\u30b9\u3092\u3001\u7d76\u5bfe\u30d1\u30b9\u3067\u6307\u5b9a\u3059\u308b\u3068\u89e3\u6c7a\u3059\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\u554f\u984c\u306e\u539f\u56e0: " + iOException.getMessage() : string + "Failed to execute the process. Specifying the executable file of the process by the absolute path may resolve this problem. Cause of the problem: " + iOException.getMessage();
            this.engine.error(string);
        }
    }

    public void destroyProcess(int n) {
        this.process[n].destroy();
    }

    public void waitFor(int n) {
        this.process[n].waitFor();
    }

    public void setProcessInput(int n, String string) {
        this.process[n].standardInput(string);
    }

    public void setProcessInput(int n, String string, String string2) {
        this.process[n].standardInput(string, string2);
    }

    public String getProcessOutput(int n) {
        return this.process[n].getOutput();
    }

    public void clearProcessOutput(int n) {
        this.process[n].clearOutput();
    }

    public void clearProcessError(int n) {
        this.process[n].clearError();
    }

    public void flushProcessOutput(int n) {
        this.process[n].flushOutput();
    }

    public void flushProcessError(int n) {
        this.process[n].flushError();
    }

    public String getProcessError(int n) {
        return this.process[n].getError();
    }

    public int getProcessExitValue(int n) {
        return this.process[n].getExitValue();
    }

    public void setProcessInputEncoding(int n, String string) {
        this.process[n].setStandardInputEncoding(string);
    }

    public void setProcessOutputEncoding(int n, String string) {
        this.process[n].setStandardOutputEncoding(string);
    }

    public void setProcessErrorEncoding(int n, String string) {
        this.process[n].setStandardErrorEncoding(string);
    }

    public void setProcessWorkingDirectory(int n, String string) {
        File file = new File(string);
        if (file.isAbsolute()) {
            this.process[n].setCurrentDirectory(file);
        } else {
            file = this.engine.getMainRelativeFile(string);
            String string2 = null;
            try {
                string2 = FileSystems.getDefault().getPath(file.getPath(), new String[0]).toRealPath(new LinkOption[0]).toString();
            }
            catch (IOException iOException) {
                string2 = file.getAbsolutePath();
            }
            catch (Exception exception) {
                string2 = file.getPath();
            }
            file = new File(string2);
            this.process[n].setCurrentDirectory(file);
        }
    }

    public int getAvailableProcessIndex() {
        int n;
        if (this.process == null) {
            this.process = new SystemNativeProcess[1];
        }
        boolean bl = false;
        int n2 = this.process.length;
        for (int i = 0; i < n2; ++i) {
            if (this.process[i] != null) continue;
            return i;
        }
        SystemNativeProcess[] systemNativeProcessArray = new SystemNativeProcess[n2];
        for (n = 0; n < n2; ++n) {
            systemNativeProcessArray[n] = this.process[n];
        }
        this.process = new SystemNativeProcess[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.process[n] = systemNativeProcessArray[n];
        }
        return n2;
    }

    @Override
    public void systemNativeProcessTerminated(SystemNativeProcessEvent systemNativeProcessEvent) {
    }

    @Override
    public void systemNativeProcessStandardOutput(SystemNativeProcessEvent systemNativeProcessEvent) {
    }

    @Override
    public void systemNativeProcessStandardError(SystemNativeProcessEvent systemNativeProcessEvent) {
    }
}

