/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.driver;

import rxvesapi.process.ProcessEngine;
import rxvesapi.process.connection.GeneralProcessConnectionInterface;
import rxvesapi.process.kernel.FunctionCallKernel;
import rxvesapi.process.sound.SoundProcessEngine;
import rxvesapi.process.unit.FunctionCallUnit;
import rxvesapi.process.unit.IntegerUnit;
import rxvesapi.process.unit.ProcessUnit;

public class SoundProcessDriver
implements GeneralProcessConnectionInterface {
    public ProcessEngine engine;
    public SoundProcessEngine[] soundEngine;
    ProcessUnit[] soundStartArgUnit;
    FunctionCallKernel[] soundStartKernel;
    FunctionCallUnit[] soundStartUnit;
    boolean soundStartEventInited = false;
    ProcessUnit[] soundStopArgUnit;
    FunctionCallKernel[] soundStopKernel;
    FunctionCallUnit[] soundStopUnit;
    boolean soundStopEventInited = false;
    ProcessUnit[] soundEndArgUnit;
    FunctionCallKernel[] soundEndKernel;
    FunctionCallUnit[] soundEndUnit;
    boolean soundEndEventInited = false;

    @Override
    public void dispose() {
        this.disposeResource();
    }

    public void disposeResource() {
        for (int i = 0; i < this.soundEngine.length; ++i) {
            try {
                if (this.soundEngine[i] == null) continue;
                this.soundEngine[i].disposeResource();
                this.soundEngine[i] = null;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void format() {
        this.engine = null;
        if (this.soundEngine != null) {
            int n = this.soundEngine.length;
            for (int i = 0; i < n; ++i) {
                if (this.soundEngine[i] == null) continue;
                try {
                    this.soundEngine[i].disposeResource();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.soundEngine[i] = null;
            }
            this.soundEngine = null;
        }
    }

    @Override
    public void init() {
    }

    public FunctionCallKernel[] getKernel() {
        return null;
    }

    public void createKernel() {
    }

    @Override
    public boolean isProcessable(String string) {
        return string.equals("SYSTEM_PROCESS_DRIVER_SOUND_newSound") || string.equals("SYSTEM_PROCESS_DRIVER_SOUND_deleteSound") || string.equals("SYSTEM_PROCESS_DRIVER_SOUND_startSound") || string.equals("SYSTEM_PROCESS_DRIVER_SOUND_stopSound") || string.equals("SYSTEM_PROCESS_DRIVER_SOUND_setSoundFrame") || string.equals("SYSTEM_PROCESS_DRIVER_SOUND_getSoundFrame") || string.equals("SYSTEM_PROCESS_DRIVER_SOUND_getSoundFrameLength") || string.equals("SYSTEM_PROCESS_DRIVER_SOUND_getSoundTime") || string.equals("SYSTEM_PROCESS_DRIVER_SOUND_getSoundTimeLength") || string.equals("SYSTEM_PROCESS_DRIVER_SOUND_setSoundVolumeGain");
    }

    @Override
    public String[] process(String string, String[] stringArray) {
        int n;
        String[] stringArray2 = new String[]{"false"};
        if (string.equals("SYSTEM_PROCESS_DRIVER_SOUND_newSound")) {
            String string2 = stringArray[0];
            int n2 = this.getAvailableEngineIndex();
            if (!this.engine.getSecurity().request_READ_FILE(stringArray[0])) {
                this.engine.exit();
                return null;
            }
            this.soundEngine[n2] = new SoundProcessEngine(n2, this.engine, this);
            this.soundEngine[n2].open(this.engine.getResourceURL(stringArray[0]));
            return new String[]{"" + n2};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_SOUND_deleteSound")) {
            int n3 = -1;
            try {
                n3 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.soundEngine[n3].disposeResource();
            this.soundEngine[n3] = null;
            return new String[]{"" + n3};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_SOUND_startSound")) {
            n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.soundEngine[n].start();
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_SOUND_stopSound")) {
            n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.soundEngine[n].stop();
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_SOUND_setSoundVolumeGain")) {
            n = -1;
            double d = -1.0;
            try {
                n = Integer.parseInt(stringArray[0]);
                d = Double.parseDouble(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.soundEngine[n].setVolumeGain(d);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_SOUND_setSoundFrame")) {
            n = -1;
            int n4 = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
                n4 = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.soundEngine[n].setFramePosition(n4);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_SOUND_getSoundFrame")) {
            n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new String[]{"" + this.soundEngine[n].getFramePosition()};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_SOUND_getSoundFrameLength")) {
            n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new String[]{"" + this.soundEngine[n].getFrameLength()};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_SOUND_getSoundTime")) {
            n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new String[]{"" + this.soundEngine[n].getTimePosition()};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_SOUND_getSoundTimeLength")) {
            n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new String[]{"" + this.soundEngine[n].getTimeLength()};
        }
        return new String[]{"false"};
    }

    public int getAvailableEngineIndex() {
        int n;
        if (this.soundEngine == null) {
            this.soundEngine = new SoundProcessEngine[32];
        }
        boolean bl = false;
        int n2 = this.soundEngine.length;
        for (int i = 0; i < n2; ++i) {
            if (this.soundEngine[i] != null) continue;
            return i;
        }
        SoundProcessEngine[] soundProcessEngineArray = new SoundProcessEngine[n2];
        for (n = 0; n < n2; ++n) {
            soundProcessEngineArray[n] = this.soundEngine[n];
        }
        this.soundEngine = new SoundProcessEngine[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.soundEngine[n] = soundProcessEngineArray[n];
        }
        return n2;
    }

    void soundStartEvent() {
        if (!this.soundStartEventInited) {
            this.soundStartArgUnit = new ProcessUnit[1];
            this.soundStartArgUnit[0] = new IntegerUnit(-1L, this.engine);
            this.soundStartKernel = this.engine.getAllFunctionCallKernel("onSoundStart");
            if (this.soundStartKernel != null) {
                this.soundStartUnit = new FunctionCallUnit[this.soundStartKernel.length];
                for (int i = 0; i < this.soundStartKernel.length; ++i) {
                    this.soundStartUnit[i] = new FunctionCallUnit(this.soundStartArgUnit, this.soundStartKernel[i], this.engine);
                    this.soundStartUnit[i].setProcessKernel(this.soundStartKernel[i]);
                }
            }
            this.soundStartEventInited = true;
        }
    }

    public void onSoundStart(int n) {
        this.soundStartEvent();
        if (this.soundStartKernel != null) {
            this.soundStartArgUnit[0].setIntegerValue(n);
            for (int i = 0; i < this.soundStartKernel.length; ++i) {
                this.soundStartUnit[i].process();
            }
        }
    }

    void soundStopEvent() {
        if (!this.soundStopEventInited) {
            this.soundStopArgUnit = new ProcessUnit[1];
            this.soundStopArgUnit[0] = new IntegerUnit(-1L, this.engine);
            this.soundStopKernel = this.engine.getAllFunctionCallKernel("onSoundStop");
            if (this.soundStopKernel != null) {
                this.soundStopUnit = new FunctionCallUnit[this.soundStopKernel.length];
                for (int i = 0; i < this.soundStopKernel.length; ++i) {
                    this.soundStopUnit[i] = new FunctionCallUnit(this.soundStopArgUnit, this.soundStopKernel[i], this.engine);
                    this.soundStopUnit[i].setProcessKernel(this.soundStopKernel[i]);
                }
            }
            this.soundStopEventInited = true;
        }
    }

    public void onSoundStop(int n) {
        this.soundStopEvent();
        if (this.soundStopKernel != null) {
            this.soundStopArgUnit[0].setIntegerValue(n);
            for (int i = 0; i < this.soundStopKernel.length; ++i) {
                this.soundStopUnit[i].process();
            }
        }
    }

    void soundEndEvent() {
        if (!this.soundEndEventInited) {
            this.soundEndArgUnit = new ProcessUnit[1];
            this.soundEndArgUnit[0] = new IntegerUnit(-1L, this.engine);
            this.soundEndKernel = this.engine.getAllFunctionCallKernel("onSoundEnd");
            if (this.soundEndKernel != null) {
                this.soundEndUnit = new FunctionCallUnit[this.soundEndKernel.length];
                for (int i = 0; i < this.soundEndKernel.length; ++i) {
                    this.soundEndUnit[i] = new FunctionCallUnit(this.soundEndArgUnit, this.soundEndKernel[i], this.engine);
                    this.soundEndUnit[i].setProcessKernel(this.soundEndKernel[i]);
                }
            }
            this.soundEndEventInited = true;
        }
    }

    public void onSoundEnd(int n) {
        this.soundEndEvent();
        if (this.soundEndKernel != null) {
            this.soundEndArgUnit[0].setIntegerValue(n);
            for (int i = 0; i < this.soundEndKernel.length; ++i) {
                this.soundEndUnit[i].process();
            }
        }
    }
}

