/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.graphics;

import java.awt.Component;
import java.awt.Image;
import rxvesapi.process.driver.GUIProcessDriver;
import rxvesapi.process.driver.GraphicsProcessDriver;
import rxvesapi.system3d.geometry.CoordinateSystem3DEG;
import rxvesapi.system3d.geometry.Element3DEG;
import rxvesapi.system3d.geometry.Model3DEG;
import rxvesapi.system3d.renderer.ScreenSystem3DEG;

public class Graphics3DProcessEngine {
    public GUIProcessDriver guiDriver;
    public ScreenSystem3DEG screen;
    public CoordinateSystem3DEG world;
    public GraphicsProcessDriver driver;
    public Image image;
    public int id;
    public int worldSystemID;
    public int screenSystemID;
    public int imageID;

    public Graphics3DProcessEngine() {
        this.init();
    }

    public Graphics3DProcessEngine(GraphicsProcessDriver graphicsProcessDriver) {
        this.driver = graphicsProcessDriver;
        this.init();
    }

    public ScreenSystem3DEG getScreenSystem() {
        return this.screen;
    }

    public CoordinateSystem3DEG getWorldSystem() {
        return this.world;
    }

    public void disposeResource() {
        if (this.screen != null) {
            this.screen.disposeResource();
            this.screen = null;
        }
        this.world = null;
        this.image = null;
        this.driver = null;
    }

    public void init() {
        this.screen = new ScreenSystem3DEG();
        this.world = new CoordinateSystem3DEG();
        this.world.setOrigin(0.0, 0.0, -10.0);
        this.screen.add(this.world);
        this.screen.setMagnification(1000.0);
        this.image = this.screen.getScreenImage();
    }

    public void repaint3D() {
        this.screen.repaint3D();
    }

    public Image getScreenImage() {
        return this.image;
    }

    public void setScreenSize(int n, int n2) {
        this.screen.setScreenSize(n, n2);
        this.image = this.screen.getScreenImage();
    }

    public void setEventSource(Component component) {
        this.screen.setEventSource(component, this.world);
    }

    public void request(Model3DEG model3DEG) {
        this.screen.request(model3DEG);
    }

    public void request(Element3DEG element3DEG) {
        this.screen.request(element3DEG);
    }

    public void cancel(Model3DEG model3DEG) {
        this.screen.cancel(model3DEG);
    }

    public void cancel(Element3DEG element3DEG) {
        this.screen.cancel(element3DEG);
    }
}

