/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.io;

import java.io.IOException;
import rxvesapi.process.io.FileInputEngine;
import rxvesapi.process.io.FileOutputEngine;

public class FileIOEngine {
    public static final String FILE_PATH_STDIN = "???//<SYSTEM_PROCESS_IO>::___STDIN___";
    public static final String FILE_PATH_STDOUT = "???//<SYSTEM_PROCESS_IO>::___STDOUT___";
    public static final String FILE_PATH_STDERR = "???//<SYSTEM_PROCESS_IO>::___STDERR___";
    private FileInputEngine inputEngine = null;
    private FileOutputEngine outputEngine = null;

    public FileIOEngine(String string, String string2, String string3) {
        if (string2.equals("w")) {
            this.outputEngine = new FileOutputEngine(string, 0, null, string3, false);
        }
        if (string2.equals("a")) {
            this.outputEngine = new FileOutputEngine(string, 0, null, string3, true);
        }
        if (string2.equals("r")) {
            this.inputEngine = new FileInputEngine(string, 0, null, string3);
        }
        if (string2.equals("wb")) {
            this.outputEngine = new FileOutputEngine(string, 300, null, string3, false);
        }
        if (string2.equals("ab")) {
            this.outputEngine = new FileOutputEngine(string, 300, null, string3, true);
        }
        if (string2.equals("rb")) {
            this.inputEngine = new FileInputEngine(string, 300, null, string3);
        }
        if (string2.equals("wtsv")) {
            this.outputEngine = new FileOutputEngine(string, 100, "\t", string3, false);
        }
        if (string2.equals("atsv")) {
            this.outputEngine = new FileOutputEngine(string, 100, "\t", string3, true);
        }
        if (string2.equals("rtsv")) {
            this.inputEngine = new FileInputEngine(string, 101, null, string3);
        }
        if (string2.equals("wcsv")) {
            this.outputEngine = new FileOutputEngine(string, 100, ",", string3, false);
        }
        if (string2.equals("acsv")) {
            this.outputEngine = new FileOutputEngine(string, 100, ",", string3, true);
        }
        if (string2.equals("rcsv")) {
            this.inputEngine = new FileInputEngine(string, 102, null, string3);
        }
    }

    public boolean exists() {
        if (this.inputEngine != null) {
            return this.inputEngine.exists();
        }
        if (this.outputEngine != null) {
            return this.outputEngine.exists();
        }
        return false;
    }

    public int getOutputMode() {
        return this.outputEngine.getMode();
    }

    public void writeb(byte[] byArray) {
        try {
            this.outputEngine.writeb(byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(String[] stringArray) {
        try {
            this.outputEngine.write(stringArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeln(String[] stringArray) {
        try {
            this.outputEngine.write(stringArray);
            this.outputEngine.lineFeed();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String[] read() {
        try {
            return this.inputEngine.readAll();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String[] readln() {
        try {
            return this.inputEngine.readLine();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String load() {
        try {
            return this.inputEngine.loadAll();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String loadln() {
        try {
            return this.inputEngine.loadLine();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int getLineCount() {
        int n = this.inputEngine.getLineCount();
        return n;
    }

    public void flush() {
        this.outputEngine.flush();
    }

    public void close() {
        if (this.inputEngine != null) {
            this.inputEngine.close();
        }
        if (this.outputEngine != null) {
            this.outputEngine.close();
        }
    }

    public void dispose() {
        try {
            if (this.inputEngine != null) {
                this.inputEngine.dispose();
            }
            if (this.outputEngine != null) {
                this.outputEngine.dispose();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

