/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.kernel;

import rxvesapi.process.ProcessCircuit;
import rxvesapi.process.kernel.FunctionCallKernel;
import rxvesapi.process.kernel.ProcessKernel;
import rxvesapi.process.scope.FunctionScope;
import rxvesapi.process.scope.ProcessScope;
import rxvesapi.process.unit.FunctionCallUnit;
import rxvesapi.process.unit.ProcessUnit;

public class ExternalFunctionCallKernel
extends FunctionCallKernel {
    public String functionName = "";
    public ProcessUnit[] argumentUnit;
    public ProcessUnit returnUnit;
    public boolean variadic = false;
    public boolean vartype = false;
    public boolean vardirect = false;
    public boolean isSystem = true;

    public ExternalFunctionCallKernel() {
        this.NATIVE_CALL = true;
        this.processEngine = null;
        this.kernelNumber = 1024;
        this.scopeNumber = 1024;
        this.kernelType = ProcessKernel.FUNCTION_CALL_TYPE;
        this.mainCircuit = new ProcessCircuit("", 1024, this.kernelNumber, this.scopeNumber, this.processEngine);
        this.mainCircuit.setProcessKernel(this);
        this.mainCircuit.createCircuit("");
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    @Override
    public FunctionCallKernel createClone() {
        return this;
    }

    @Override
    public void nullResource() {
    }

    @Override
    public boolean isProcessing() {
        return this.isProcessing;
    }

    public void setVariadic(boolean bl) {
        this.variadic = bl;
    }

    @Override
    public String getArgumentDescription() {
        String string = "";
        for (int i = 0; i < this.argumentUnit.length; ++i) {
            ProcessUnit processUnit = this.argumentUnit[i];
            if (processUnit == null) continue;
            if (this.vartype) {
                string = string + "var";
            } else if (processUnit.getValueType() == 101) {
                string = string + "int";
            } else if (processUnit.getValueType() == 100) {
                string = string + "float";
            } else if (processUnit.getValueType() == 104) {
                string = string + "varint";
            } else if (processUnit.getValueType() == 103) {
                string = string + "varfloat";
            } else if (processUnit.getValueType() == 102) {
                string = string + "string";
            } else if (processUnit.getValueType() == 105) {
                string = string + "bool";
            }
            if (processUnit.arrayType) {
                string = string + "[]";
            }
            if (processUnit.getName() != null) {
                string = string + " ";
                string = string + processUnit.getName();
            }
            if (i == this.argumentUnit.length - 1) continue;
            string = string + ", ";
        }
        return string;
    }

    public void setArgumentUnit(ProcessUnit[] processUnitArray) {
        this.argumentUnit = processUnitArray;
    }

    @Override
    public void setFunctionName(String string) {
        this.functionName = string;
    }

    @Override
    public ProcessUnit getReturnUnit() {
        return this.returnUnit;
    }

    @Override
    public boolean isProcessableArgument(ProcessUnit[] processUnitArray, String[] stringArray) {
        return this.isProcessableArgument(processUnitArray);
    }

    @Override
    public boolean isProcessableArgument(ProcessUnit[] processUnitArray) {
        if (this.variadic) {
            return true;
        }
        if (this.argumentUnit.length != processUnitArray.length) {
            return processUnitArray.length == 1 && processUnitArray[0] == null && this.argumentUnit.length == 0;
        }
        if (this.argumentUnit.length == 0 && processUnitArray.length == 0) {
            return true;
        }
        if (this.argumentUnit == null && processUnitArray == null) {
            return true;
        }
        if (this.argumentUnit.length == 1 && processUnitArray.length == 1 && this.argumentUnit[0] == null && processUnitArray[0] == null) {
            return true;
        }
        for (int i = 0; i < this.argumentUnit.length; ++i) {
            ProcessUnit processUnit = this.argumentUnit[i];
            if (processUnit == null && processUnitArray[i] != null) {
                return false;
            }
            if (processUnit != null && processUnitArray[i] == null) {
                return false;
            }
            if (this.vartype) continue;
            if (processUnit.getValueType() != processUnitArray[i].getValueType()) {
                return false;
            }
            if (processUnit.arrayType == processUnitArray[i].arrayType) continue;
            return false;
        }
        return true;
    }

    private void inputArgumentValue(ProcessUnit[] processUnitArray) {
        if (this.vardirect) {
            this.argumentUnit = processUnitArray;
            return;
        }
        if (this.variadic) {
            int[] nArray;
            if (this.argumentUnit[0].getCapacity() != processUnitArray.length) {
                nArray = new int[]{processUnitArray.length};
                this.argumentUnit[0].setLength(nArray);
            }
            nArray = new int[]{0};
            for (int i = 0; i < processUnitArray.length; ++i) {
                nArray[0] = i;
                this.argumentUnit[0].setIndex(nArray);
                this.argumentUnit[0].setStringValue(processUnitArray[i].getStringValue());
            }
            return;
        }
        if (this.argumentUnit == null) {
            return;
        }
        if (this.argumentUnit.length == 0) {
            return;
        }
        if (this.argumentUnit.length == 1 && this.argumentUnit[0] == null) {
            return;
        }
        for (int i = 0; i < processUnitArray.length; ++i) {
            int n = this.argumentUnit[i].getValueType();
            if (this.argumentUnit[i].isArrayType()) {
                processUnitArray[i].operateArray();
                this.argumentUnit[i].setLength(processUnitArray[i].getLength());
                for (int j = 0; j < this.argumentUnit[i].getCapacity(); ++j) {
                    this.argumentUnit[i].index = j;
                    processUnitArray[i].index = j;
                    processUnitArray[i].setIndexedValue();
                    processUnitArray[i].setProcessPermission(false);
                    if (n == 105) {
                        this.argumentUnit[i].setBooleanValue(processUnitArray[i].getBooleanValue());
                    } else if (n == 100) {
                        this.argumentUnit[i].setDecimalValue(processUnitArray[i].getDecimalValue());
                    } else if (n == 101) {
                        this.argumentUnit[i].setIntegerValue(processUnitArray[i].getIntegerValue());
                    } else if (n == 103) {
                        this.argumentUnit[i].setBigDecimalValue(processUnitArray[i].getBigDecimalValue());
                    } else if (n == 104) {
                        this.argumentUnit[i].setBigIntegerValue(processUnitArray[i].getBigIntegerValue());
                    } else if (n == 102) {
                        this.argumentUnit[i].setStringValue(processUnitArray[i].getStringValue());
                    }
                    processUnitArray[i].setProcessPermission(true);
                }
                continue;
            }
            if (n == 105) {
                this.argumentUnit[i].setBooleanValue(processUnitArray[i].getBooleanValue());
                continue;
            }
            if (n == 100) {
                this.argumentUnit[i].setDecimalValue(processUnitArray[i].getDecimalValue());
                continue;
            }
            if (n == 101) {
                this.argumentUnit[i].setIntegerValue(processUnitArray[i].getIntegerValue());
                continue;
            }
            if (n == 103) {
                this.argumentUnit[i].setBigDecimalValue(processUnitArray[i].getBigDecimalValue());
                continue;
            }
            if (n == 104) {
                this.argumentUnit[i].setBigIntegerValue(processUnitArray[i].getBigIntegerValue());
                continue;
            }
            if (n != 102) continue;
            this.argumentUnit[i].setStringValue(processUnitArray[i].getStringValue());
        }
    }

    @Override
    public void setParentScope(ProcessScope processScope) {
        this.parentScope = processScope;
    }

    @Override
    public void disposeResource() {
    }

    @Override
    public ProcessUnit getDummyReturnUnit() {
        return this.returnUnit;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public FunctionScope getFunctionScope() {
        return null;
    }

    @Override
    public void addVariable(ProcessUnit processUnit) {
    }

    @Override
    public void setFunctionScope(FunctionScope functionScope) {
    }

    @Override
    public void ready() {
        this.ready = true;
    }

    @Override
    public void process() {
    }

    @Override
    public synchronized ProcessUnit call(ProcessUnit[] processUnitArray) {
        if (!this.isProcessing) {
            this.isProcessing = true;
            this.inputArgumentValue(processUnitArray);
            this.call();
            this.isProcessing = false;
            return this.returnUnit;
        }
        return null;
    }

    @Override
    public synchronized ProcessUnit call(ProcessUnit[] processUnitArray, FunctionCallUnit functionCallUnit) {
        if (!this.isProcessing) {
            this.isProcessing = true;
            this.inputArgumentValue(processUnitArray);
            this.call();
            this.isProcessing = false;
            return this.returnUnit;
        }
        return null;
    }

    public void call() {
    }
}

