/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.kernel;

import rxvesapi.process.ProcessCircuit;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.kernel.ProcessKernel;
import rxvesapi.process.scope.ProcessScope;
import rxvesapi.process.unit.ProcessUnit;

public class ScopeCallKernel
extends ProcessKernel {
    public ProcessScope processScope;

    public ScopeCallKernel(ProcessScope processScope, int n, int n2, ProcessEngine processEngine) {
        this.kernelNumber = n;
        this.scopeNumber = n2;
        this.processEngine = processEngine;
        this.kernelType = ProcessKernel.SCOPE_CALL_TYPE;
        this.processScope = processScope;
    }

    @Override
    public void setErrorDetection(boolean bl) {
        this.errorDetection = bl;
        this.processScope.setErrorDetection(bl);
    }

    @Override
    public void setParentScope(ProcessScope processScope) {
        this.processScope.setParentScope(processScope);
        this.parentScope = processScope;
    }

    @Override
    public void disposeResource() {
        if (this.processScope != null) {
            this.processScope.disposeResource();
            this.processScope = null;
        }
        if (this.processUnit != null) {
            this.counter = 0;
            for (int i = 0; i < this.processUnit.length; ++i) {
                if (this.processUnit[i] == null) continue;
                this.processUnit[i].disposeResource();
                this.processUnit[i] = null;
            }
        }
        this.rootUnit = null;
        if (this.mainCircuit != null) {
            this.mainCircuit.disposeResource();
            this.mainCircuit = null;
        }
        this.programLine = null;
        this.processFormula = null;
        this.kernelID = null;
        this.kernelName = null;
    }

    @Override
    public void exit() {
        if (this.parentScope != null) {
            this.parentScope.breakScope();
        }
        if (this.processScope != null) {
            this.processScope.breakScope();
            this.processScope.exit();
        }
    }

    @Override
    public ProcessScope getProcessScope() {
        this.mainCircuit = new ProcessCircuit("", 1024, this.kernelNumber, this.scopeNumber, this.processEngine);
        this.mainCircuit.setProcessKernel(this);
        this.mainCircuit.createCircuit("");
        return this.processScope;
    }

    @Override
    public void addVariable(ProcessUnit processUnit) {
        if (this.mainCircuit == null) {
            this.mainCircuit = new ProcessCircuit("", 1024, this.kernelNumber, this.scopeNumber, this.processEngine);
            this.mainCircuit.setProcessKernel(this);
            this.mainCircuit.createCircuit("");
        }
        this.mainCircuit.addVariable(processUnit);
        this.processScope.addVariable(processUnit);
    }

    public void setProcessScope(ProcessScope processScope) {
        this.processScope = processScope;
    }

    @Override
    public void ready() {
        if (!this.ready && this.processScope != null) {
            this.checkLineNumber();
            this.processScope.ready();
            this.ready = true;
        }
    }

    @Override
    public void process() {
        if (this.processScope != null) {
            this.processScope.process();
        }
    }

    public void checkLineNumber() {
        this.processScope.setLineAddressCode(this.lineAddressCode);
        ProcessKernel[] processKernelArray = this.processScope.processKernel;
        if (1 <= processKernelArray.length) {
            if (processKernelArray[0] instanceof ScopeCallKernel) {
                processKernelArray[0].lineAddressCode = this.getIncrementAddressCode(this.lineAddressCode);
            }
            for (int i = 1; i < processKernelArray.length; ++i) {
                if (!(processKernelArray[i] instanceof ScopeCallKernel)) continue;
                processKernelArray[i].lineAddressCode = this.getIncrementAddressCode(processKernelArray[i - 1].lineAddressCode);
            }
        }
    }

    private String getIncrementAddressCode(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("@");
        if (stringArray.length == 2) {
            String string2 = stringArray[1];
            String string3 = stringArray[0];
            try {
                int n = Integer.parseInt(string3);
                string3 = "" + ++n;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (!string3.endsWith("?")) {
                string3 = string3 + " ?";
            }
            return string3 + "@" + string2;
        }
        return null;
    }
}

