/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.scope;

import rxvesapi.process.ProcessCircuit;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ProcessProgram;
import rxvesapi.process.ProcessRuntimeException;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.decode.ProcessCodeScopeConstructor;
import rxvesapi.process.kernel.ProcessKernel;
import rxvesapi.process.scope.ProcessScope;
import rxvesapi.process.unit.ProcessUnit;

public class WhileScope
extends ProcessScope {
    ProcessKernel conditionKernel;
    ProcessUnit conditionUnit;
    ProcessCircuit conditionCircuit;
    String conditionFormula;
    public int inputCounter = 0;

    public int countInput() {
        ++this.inputCounter;
        return this.inputCounter;
    }

    public WhileScope(String string, int n, ProcessEngine processEngine, ProcessProgram processProgram, ProcessCodeScopeConstructor processCodeScopeConstructor) {
        this.scopeInfo = ScriptProcessor.locale.isJapanese() ? "while \u6587\u306e\u30d6\u30ed\u30c3\u30af" : "The block of \"while\" statement";
        this.scopeNumber = n;
        this.processEngine = processEngine;
        this.programLines = this.getProgramLines(string);
        this.programInstance = processProgram;
        this.init(processCodeScopeConstructor);
    }

    @Override
    public void breakRoopScope() {
        this.scopeBreak = true;
    }

    @Override
    public void continueRoopScope() {
        this.scopeContinue = true;
    }

    @Override
    public void nullResource() {
        int n;
        try {
            this.conditionKernel.nullResource();
            this.conditionKernel = null;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.conditionFormula = null;
        this.counter = 0L;
        this.kernelCounter = 0;
        for (n = 0; n < this.variableUnit.length; ++n) {
            try {
                this.variableUnit[n] = null;
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        for (n = 0; n < this.processKernel.length; ++n) {
            try {
                this.processKernel[n].nullResource();
                this.processKernel[n] = null;
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.processEngine = null;
        this.kernelErrorMessage = null;
        this.scopeErrorMessage = null;
        for (n = 0; n < this.programLines.length; ++n) {
            try {
                this.programLines[n] = null;
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.programLines = null;
        try {
            this.returnUnit = null;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void disposeResource() {
        int n;
        try {
            this.conditionKernel.disposeResource();
            this.conditionKernel = null;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.conditionFormula = null;
        this.counter = 0L;
        this.kernelCounter = 0;
        for (n = 0; n < this.variableUnit.length; ++n) {
            try {
                this.variableUnit[n].disposeResource();
                this.variableUnit[n] = null;
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        for (n = 0; n < this.processKernel.length; ++n) {
            try {
                this.processKernel[n].disposeResource();
                this.processKernel[n] = null;
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.processEngine = null;
        this.kernelErrorMessage = null;
        this.scopeErrorMessage = null;
        for (n = 0; n < this.programLines.length; ++n) {
            try {
                this.programLines[n] = null;
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.programLines = null;
        try {
            this.returnUnit.disposeResource();
            this.returnUnit = null;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setCondition(String string) {
        int n = this.countInput();
        this.conditionKernel = new ProcessKernel(string, n, this.scopeNumber, this.processEngine, this.programInstance);
        this.conditionKernel.setKernelName("SYSTEM_PROCESS_SCOPEINPUT_KERNEL_K" + n + "_S" + this.scopeNumber);
        this.conditionKernel.setKernelID("SYSTEM_PROCESS_SCOPEINPUT_KERNEL_K" + n + "_S" + this.scopeNumber);
        this.conditionKernel.setScopeNumber(this.scopeNumber);
        this.conditionFormula = string;
    }

    public void checkConditonArray() {
        if (this.conditionUnit.getDimension() != 1 || this.conditionUnit.getLength()[0] != 1) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.conditionKernel.error("while \u6587\u306e\u6761\u4ef6\u5f0f\u306b\u914d\u5217\u3092\u6307\u5b9a\u3059\u308b\u4e8b\u306f\u3001\u8981\u7d20\u6570\u304c 1 \u306e\u5834\u5408\u3092\u9664\u3044\u3066\u3067\u304d\u307e\u305b\u3093\u3002");
            } else {
                this.conditionKernel.error("Cannot specify an array for the condition of \"while\" statement, excluding when its length is 1.");
            }
            this.processEngine.errorWaitFor = true;
            ProcessRuntimeException processRuntimeException = new ProcessRuntimeException();
            throw processRuntimeException;
        }
    }

    @Override
    public void process() {
        this.scopeBreak = false;
        this.scopeContinue = false;
        if (this.conditionUnit.arrayType) {
            this.conditionUnit.operateArray();
            this.checkConditonArray();
            this.conditionUnit.index = 0;
            this.conditionUnit.setIndexedValue();
            while (this.conditionUnit.getBooleanValue() && !this.scopeBreak) {
                this.processEngine.operationCounter += this.conditionUnit.operator;
                this.scopeProcess();
                this.conditionUnit.operateArray();
                this.checkConditonArray();
                this.conditionUnit.index = 0;
                this.conditionUnit.setIndexedValue();
            }
        } else {
            while (this.conditionUnit.getBooleanValue() && !this.scopeBreak) {
                if (this.processEngine != null) {
                    this.processEngine.operationCounter += this.conditionUnit.operator;
                }
                this.scopeProcess();
            }
        }
    }

    @Override
    public void setLineAddressCode(String string) {
        this.conditionKernel.lineAddressCode = string;
    }

    @Override
    public void ready() {
        for (int i = 0; i < this.variableUnit.length; ++i) {
            this.conditionKernel.addVariable(this.variableUnit[i]);
        }
        this.conditionKernel.createCircuit(this.conditionFormula);
        this.scopeReady();
        this.conditionUnit = this.conditionKernel.getExecutionUnit();
        this.conditionUnit.countOperator();
    }
}

