/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.sound;

import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.driver.SoundProcessDriver;

public class SoundProcessEngine
implements LineListener {
    SoundProcessDriver driver;
    int id = -1;
    Clip clip;

    public SoundProcessEngine(int n, ProcessEngine processEngine, SoundProcessDriver soundProcessDriver) {
        this.id = n;
        this.driver = soundProcessDriver;
    }

    public void dispose() {
        this.disposeResource();
    }

    public void disposeResource() {
        this.driver = null;
        this.clip.stop();
        this.clip.close();
        this.clip = null;
    }

    public void open(URL uRL) {
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(uRL);
            AudioFormat audioFormat = audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, audioFormat);
            this.clip = (Clip)AudioSystem.getLine(info);
            this.clip.open(audioInputStream);
            this.clip.addLineListener(this);
            audioInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        this.clip.close();
    }

    public void start() {
        this.clip.start();
    }

    public void stop() {
        if (this.clip != null) {
            this.clip.stop();
        }
    }

    public void setVolumeGain(double d) {
        if (this.clip != null) {
            FloatControl floatControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
            double d2 = d;
            floatControl.setValue((float)d);
        }
    }

    public long getTimeLength() {
        if (this.clip != null) {
            return this.clip.getMicrosecondLength() / 1000L;
        }
        return -1L;
    }

    public long getTimePosition() {
        if (this.clip != null) {
            return this.clip.getMicrosecondPosition() / 1000L;
        }
        return -1L;
    }

    public long getFrameLength() {
        if (this.clip != null) {
            return this.clip.getFrameLength();
        }
        return -1L;
    }

    public long getFramePosition() {
        if (this.clip != null) {
            return this.clip.getFramePosition();
        }
        return -1L;
    }

    public void setFramePosition(int n) {
        if (this.clip != null) {
            this.clip.setFramePosition(n);
        }
    }

    @Override
    public void update(LineEvent lineEvent) {
        if (lineEvent.getType() == LineEvent.Type.STOP) {
            if (this.getFramePosition() == this.getFrameLength()) {
                this.driver.onSoundEnd(this.id);
            } else {
                this.driver.onSoundStop(this.id);
            }
        }
        if (lineEvent.getType() == LineEvent.Type.START) {
            this.driver.onSoundStart(this.id);
        }
    }
}

