/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import rxvesapi.process.ProcessEngine;
import rxvesapi.process.unit.ProcessUnit;

public class AndUnit
extends ProcessUnit {
    public AndUnit(ProcessUnit[] processUnitArray, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.inputUnit = processUnitArray;
        this.nodeType = 201;
        this.setValueType(105);
        this.arrayType = false;
        for (int i = 0; i < this.inputUnit.length; ++i) {
            if (!this.inputUnit[i].isArrayType()) continue;
            this.arrayType = true;
            this.dimension = this.inputUnit[i].getDimension();
            this.length = this.inputUnit[i].getLength();
            this.capacity = this.inputUnit[i].getCapacity();
            break;
        }
    }

    @Override
    public int[] getLength() {
        for (int i = 0; i < this.inputUnit.length; ++i) {
            if (!this.inputUnit[i].isArrayType()) continue;
            this.length = this.inputUnit[i].getLength();
            return this.length;
        }
        return null;
    }

    public void reloadLength() {
        this.length = this.getLength();
        this.dimension = this.length.length;
        this.capacity = 0;
        for (int i = 0; i < this.dimension; ++i) {
            this.capacity += this.length[i];
        }
    }

    @Override
    public void operateArray() {
        if (this.arrayType) {
            this.reloadLength();
        }
        for (int i = 0; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].operateArray();
        }
    }

    @Override
    public void process() {
        if (this.arrayType) {
            this.booleanArrayProcess();
        } else {
            this.booleanProcess();
        }
    }

    private void booleanArrayProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            if (this.inputUnit[i].getBooleanValue()) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void booleanProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length; ++i) {
            if (this.inputUnit[i].getBooleanValue()) continue;
            this.booleanValue = false;
            return;
        }
    }

    @Override
    public String getFormula() {
        return this.getFormula(Integer.MAX_VALUE);
    }

    @Override
    public String getFormula(int n) {
        if (this.getRank() == n) {
            return this.getStringValue();
        }
        String string = "";
        string = n == this.getRank() + 1 ? "[ " : "";
        for (int i = 0; i < this.inputUnit.length; ++i) {
            string = string + this.inputUnit[i].getFormula(n);
            if (i >= this.inputUnit.length - 1) continue;
            string = string + "&&";
        }
        string = n == this.getRank() + 1 ? string + " = " + this.getStringValue() + " ]" : string + "";
        if (this.inputUnit.length == 1) {
            string = this.getStringValue();
        }
        return string;
    }
}

