/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.math.BigDecimal;
import java.math.BigInteger;
import rxvesapi.process.ProcessCircuit;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.object.ProcessStruct;
import rxvesapi.process.unit.ProcessUnit;

public class ArrayAccessUnit
extends ProcessUnit {
    ProcessCircuit[] indexCircuit;
    public int[] indexArray;
    boolean errorOuted = false;

    public ArrayAccessUnit(ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.nodeType = 200;
        this.specialType = 10002;
    }

    @Override
    public void reloadInputUnit() {
        if (this.inputUnit != null && this.inputUnit[this.inputUnit.length - 1] != null) {
            this.inputUnit[this.inputUnit.length - 1].reloadInputUnit();
        }
    }

    @Override
    public void increment() {
        this.setIndexArray();
        this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
        this.inputUnit[this.inputUnit.length - 1].incrementAt();
    }

    @Override
    public void decrement() {
        this.setIndexArray();
        this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
        this.inputUnit[this.inputUnit.length - 1].decrementAt();
    }

    public void setIndexUnit(ProcessUnit[] processUnitArray) {
        this.reloadInputUnit();
        this.inputUnit = new ProcessUnit[processUnitArray.length + 1];
        for (int i = 0; i < processUnitArray.length; ++i) {
            this.inputUnit[i] = processUnitArray[i];
        }
        this.indexArray = new int[processUnitArray.length];
    }

    public ProcessUnit[] getIndexUnit() {
        ProcessUnit[] processUnitArray = new ProcessUnit[this.inputUnit.length - 1];
        for (int i = 0; i < processUnitArray.length; ++i) {
            processUnitArray[i] = this.inputUnit[i];
        }
        return processUnitArray;
    }

    public void setArrayUnit(ProcessUnit processUnit) {
        this.reloadInputUnit();
        this.inputUnit[this.inputUnit.length - 1] = processUnit;
        this.valueType = processUnit.valueType;
        this.inputType = processUnit.inputType;
        this.nodeType = 200;
    }

    public ProcessUnit getArrayUnit() {
        return this.inputUnit[this.inputUnit.length - 1];
    }

    public void addressing() {
        this.reloadInputUnit();
        this.setIndexArray();
        this.inputUnit[this.inputUnit.length - 1].operateArray();
        this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
        this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
    }

    public void setIndexArray() {
        this.reloadInputUnit();
        if (this.inputUnit[this.inputUnit.length - 1].getDimension() < this.inputUnit.length - 1) {
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u914d\u5217\u306e\u6b21\u5143\u6570\u3068\u3001\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u306e\u6570\u304c\u4e00\u81f4\u3057\u3066\u3044\u307e\u305b\u3093\u3002" : "The number of the indices does not match with the number of the dimensions of the array.";
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
        }
        for (int i = 0; i < this.indexArray.length; ++i) {
            this.indexArray[i] = (int)this.inputUnit[i].getIntegerValue();
        }
    }

    private void arrayAccessError() {
        String string = "";
        for (int i = 0; i < this.indexArray.length; ++i) {
            string = string + "[" + this.indexArray[i] + "]";
        }
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u914d\u5217\u300c " + this.inputUnit[this.inputUnit.length - 1].getName() + " \u300d\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u304c\u3001\u78ba\u4fdd\u9818\u57df\u5916\u3092\u53c2\u7167\u3057\u307e\u3057\u305f: " + string : "The indices point to out of range of the array \"" + this.inputUnit[this.inputUnit.length - 1].getName() + "\": " + string;
        this.error(this.errorMessage);
    }

    @Override
    public void process() {
    }

    @Override
    public void free() {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].indexedFree();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    @Override
    public void alloc(int[] nArray) {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].indexedAlloc(nArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    @Override
    public void setDecimalValue(double d) {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setDecimalValue(d);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    @Override
    public void setIntegerValue(long l) {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setIntegerValue(l);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    @Override
    public void setBigDecimalValue(String string) {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setBigDecimalValue(string);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    @Override
    public void setBigDecimalValue(BigDecimal bigDecimal) {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setBigDecimalValue(bigDecimal);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    @Override
    public void setBigIntegerValue(String string) {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setBigIntegerValue(string);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    @Override
    public void setBigIntegerValue(BigInteger bigInteger) {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setBigIntegerValue(bigInteger);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    @Override
    public void setBooleanValue(boolean bl) {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setBooleanValue(bl);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    @Override
    public void setStringValue(String string) {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setStringValue(string);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    @Override
    public void setStructValue(ProcessUnit processUnit) {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setStructValue(processUnit);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    @Override
    public void setComplexValue(double[] dArray) {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setComplexValue(dArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    @Override
    public void setComplexValue(double d) {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setComplexValue(d);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    @Override
    public void setComplexValue(String string) {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setComplexValue(string);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    public void setComplexValue(long l) {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setComplexValue(l);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    @Override
    public void setBigComplexValue(BigDecimal[] bigDecimalArray) {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setBigComplexValue(bigDecimalArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    @Override
    public void setBigComplexValue(BigDecimal bigDecimal) {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setBigComplexValue(bigDecimal);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    @Override
    public void setBigComplexValue(String string) {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setBigComplexValue(string);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    @Override
    public long getIntegerValue() {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].operateArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
        return this.inputUnit[this.inputUnit.length - 1].getIntegerValue();
    }

    @Override
    public double getDecimalValue() {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].operateArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
        return this.inputUnit[this.inputUnit.length - 1].getDecimalValue();
    }

    @Override
    public double[] getComplexValue() {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].operateArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
        return this.inputUnit[this.inputUnit.length - 1].getComplexValue();
    }

    @Override
    public BigInteger getBigIntegerValue() {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].operateArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
        return this.inputUnit[this.inputUnit.length - 1].getBigIntegerValue();
    }

    @Override
    public BigDecimal getBigDecimalValue() {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].operateArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
        return this.inputUnit[this.inputUnit.length - 1].getBigDecimalValue();
    }

    @Override
    public BigDecimal[] getBigComplexValue() {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].operateArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
        return this.inputUnit[this.inputUnit.length - 1].getBigComplexValue();
    }

    @Override
    public String getStringValue() {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].operateArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
        return this.inputUnit[this.inputUnit.length - 1].getStringValue();
    }

    @Override
    public boolean getBooleanValue() {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].operateArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
        return this.inputUnit[this.inputUnit.length - 1].getBooleanValue();
    }

    @Override
    public ProcessUnit getStructValue() {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].operateArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
        return this.inputUnit[this.inputUnit.length - 1].getStructValue();
    }

    @Override
    public ProcessStruct getStruct() {
        return this.inputUnit[this.inputUnit.length - 1].getStruct();
    }

    @Override
    public ProcessUnit[] getMemberVariable() {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].operateArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
            return this.inputUnit[this.inputUnit.length - 1].getMemberVariable();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
            return null;
        }
    }

    @Override
    public boolean isMemberInitialized() {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].operateArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
            return this.inputUnit[this.inputUnit.length - 1].isMemberInitialized();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
            return false;
        }
    }

    @Override
    public void initialize() {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].operateArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
            this.inputUnit[this.inputUnit.length - 1].initialize();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    @Override
    public boolean isDefaulted() {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].operateArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
            return this.inputUnit[this.inputUnit.length - 1].isDefaulted();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
            return false;
        }
    }

    @Override
    public void setDefaulted(boolean bl) {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].operateArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
            this.inputUnit[this.inputUnit.length - 1].setDefaulted(bl);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
        }
    }

    @Override
    public boolean equalsMember(ProcessUnit processUnit) {
        try {
            this.setIndexArray();
            this.inputUnit[this.inputUnit.length - 1].operateArray();
            this.inputUnit[this.inputUnit.length - 1].setIndex(this.indexArray);
            this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
            return this.inputUnit[this.inputUnit.length - 1].equalsMember(processUnit);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.arrayAccessError();
            return false;
        }
    }

    @Override
    public String getFormula() {
        String string = "";
        string = string + this.inputUnit[this.inputUnit.length - 1].getName();
        int n = this.inputUnit.length;
        for (int i = 0; i < n; ++i) {
            string = string + "[" + this.inputUnit[i].getFormula() + "]";
        }
        return string;
    }

    @Override
    public String getFormula(int n) {
        String string = "";
        string = string + this.inputUnit[this.inputUnit.length - 1].getName();
        int n2 = this.inputUnit.length;
        for (int i = 0; i < n2 - 1; ++i) {
            string = string + "[" + this.inputUnit[i].getFormula(Math.max(n, this.rank + 1)) + "]";
        }
        return string;
    }
}

