/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.math.BigDecimal;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.unit.ProcessUnit;

public class BigDecimalUnit
extends ProcessUnit {
    public BigDecimalUnit(ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.bigDecimalValue = new BigDecimal("0.0");
        this.valueType = 103;
        this.nodeType = 200;
    }

    public BigDecimalUnit(String string, ProcessEngine processEngine) {
        BigDecimal bigDecimal;
        this.processEngine = processEngine;
        this.valueType = 103;
        this.nodeType = 200;
        try {
            bigDecimal = new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            bigDecimal = null;
            if (ScriptProcessor.locale.isJapanese()) {
                processEngine.error("varfloat \u578b\u5909\u6570\u306e\u521d\u671f\u5316\u306b\u7528\u3044\u3089\u308c\u3066\u3044\u308b\u6587\u5b57\u5217\u304c\u3001verfloat \u578b\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002 @ " + this);
            }
            processEngine.error("Failed to initialize the verfloat type variable by a string value. It isn't convertible to a verfloat value.  @ " + this);
        }
        this.bigDecimalValue = bigDecimal;
    }

    @Override
    public BigDecimal getBigDecimalValue() {
        return this.bigDecimalValue;
    }

    @Override
    public void increment() {
        this.bigDecimalValue = this.bigDecimalValue.add(bd_one);
    }

    @Override
    public void decrement() {
        this.bigDecimalValue = this.bigDecimalValue.subtract(bd_one);
    }

    @Override
    public String getFormula() {
        if (this.isConst()) {
            if (this.bigDecimalValue.compareTo(new BigDecimal("0")) < 0) {
                return "(" + this.bigDecimalValue.toString() + ")";
            }
            return this.bigDecimalValue.toString() + "vf";
        }
        return this.name;
    }

    @Override
    public String getFormula(int n) {
        if (this.isConst()) {
            return this.getFormula();
        }
        return this.name;
    }
}

