/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import rxvesapi.process.ProcessEngine;
import rxvesapi.process.unit.ProcessUnit;

public class CastUnit
extends ProcessUnit {
    public CastUnit() {
        this.valueType = Integer.MAX_VALUE;
        this.nodeType = 200;
    }

    public CastUnit(ProcessUnit processUnit, int n, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.valueType = n;
        this.nodeType = 200;
        this.inputUnit = new ProcessUnit[]{processUnit};
    }

    @Override
    public void process() {
        if (this.processPermission) {
            if (this.inputUnit[0].isArrayType()) {
                this.arrayType = true;
                this.setLength(this.inputUnit[0].getLength());
                this.dimension = this.inputUnit[0].getDimension();
            }
            if (this.getValueType() == 101) {
                this.integerValue = this.inputUnit[0].getIntegerValue();
            } else if (this.getValueType() == 100) {
                this.decimalValue = this.inputUnit[0].getDecimalValue();
            } else if (this.getValueType() == 140) {
                this.setComplexValue(this.inputUnit[0].getComplexValue());
            } else if (this.getValueType() == 104) {
                this.bigIntegerValue = this.inputUnit[0].getBigIntegerValue();
            } else if (this.getValueType() == 103) {
                this.bigDecimalValue = this.inputUnit[0].getBigDecimalValue();
            } else if (this.getValueType() == 141) {
                this.setBigComplexValue(this.inputUnit[0].getBigComplexValue());
            } else if (this.getValueType() == 102) {
                this.stringValue = this.inputUnit[0].getStringValue();
            } else if (this.getValueType() == 105) {
                this.booleanValue = this.inputUnit[0].getBooleanValue();
            }
        }
    }

    @Override
    public void setIndex(int[] nArray) {
        this.inputUnit[0].setIndex(nArray);
    }

    @Override
    public void setIndexedValue() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        if (this.getValueType() == 101) {
            this.integerValue = this.inputUnit[0].getIntegerValue();
        } else if (this.getValueType() == 100) {
            this.decimalValue = this.inputUnit[0].getDecimalValue();
        } else if (this.getValueType() == 140) {
            this.setComplexValue(this.inputUnit[0].getComplexValue());
        } else if (this.getValueType() == 104) {
            this.bigIntegerValue = this.inputUnit[0].getBigIntegerValue();
        } else if (this.getValueType() == 103) {
            this.bigDecimalValue = this.inputUnit[0].getBigDecimalValue();
        } else if (this.getValueType() == 141) {
            this.setBigComplexValue(this.inputUnit[0].getBigComplexValue());
        } else if (this.getValueType() == 102) {
            this.stringValue = this.inputUnit[0].getStringValue();
        } else if (this.getValueType() == 105) {
            this.booleanValue = this.inputUnit[0].getBooleanValue();
        }
    }

    @Override
    public String getFormula() {
        this.process();
        if (this.getValueType() == 101) {
            return Long.toString(this.integerValue);
        }
        if (this.getValueType() == 100) {
            return Double.toString(this.decimalValue);
        }
        if (this.getValueType() == 104) {
            return "" + this.bigIntegerValue;
        }
        if (this.getValueType() == 103) {
            return "" + this.bigDecimalValue;
        }
        if (this.getValueType() == 102) {
            return this.stringValue;
        }
        if (this.getValueType() == 105) {
            return "" + this.booleanValue;
        }
        return "";
    }

    @Override
    public String getFormula(int n) {
        if (this.getRank() == n) {
            return this.getStringValue();
        }
        String string = "";
        if (n == this.getRank() + 1) {
            this.process();
            string = this.getValueType() == 101 ? string + "  [ (int)" + this.inputUnit[0].getStringValue() + "=" + Long.toString(this.integerValue) + " ]  " : (this.getValueType() == 100 ? string + "  [ (float)" + this.inputUnit[0].getStringValue() + "=" + Double.toString(this.integerValue) + " ]  " : (this.getValueType() == 104 ? string + "  [ (varint)" + this.inputUnit[0].getStringValue() + "=" + this.bigIntegerValue + " ]  " : (this.getValueType() == 103 ? string + "  [ (varfloat)" + this.inputUnit[0].getStringValue() + "=" + this.bigDecimalValue + " ]  " : (this.getValueType() == 102 ? string + "  [ (string)" + this.inputUnit[0].getStringValue() + "=" + this.stringValue + " ]  " : (this.getValueType() == 105 ? string + "  [ (bool)" + this.inputUnit[0].getStringValue() + "=" + this.booleanValue + " ]  " : string + "unknown type cast")))));
        } else {
            this.process();
            string = this.getValueType() == 101 ? string + "(int)" + this.inputUnit[0].getFormula(n) : (this.getValueType() == 100 ? string + "(float)" + this.inputUnit[0].getFormula(n) : (this.getValueType() == 104 ? string + "(varint)" + this.inputUnit[0].getFormula(n) : (this.getValueType() == 103 ? string + "(varfloat)" + this.inputUnit[0].getFormula(n) : (this.getValueType() == 102 ? string + "(string)" + this.inputUnit[0].getFormula(n) : (this.getValueType() == 105 ? string + "(bool)" + this.inputUnit[0].getFormula(n) : string + "unknown type cast")))));
        }
        return string;
    }
}

