/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.unit.ProcessUnit;

public class GreaterEqualUnit
extends ProcessUnit {
    public GreaterEqualUnit(ProcessUnit[] processUnitArray, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.inputUnit = processUnitArray;
        this.nodeType = 201;
        this.setType();
        this.setValueType(105);
        this.arrayType = false;
        for (int i = 0; i < this.inputUnit.length; ++i) {
            if (!this.inputUnit[i].isArrayType()) continue;
            this.arrayType = true;
            this.dimension = this.inputUnit[i].getDimension();
            this.length = this.inputUnit[i].getLength();
            this.capacity = this.inputUnit[i].getCapacity();
            break;
        }
    }

    @Override
    public int[] getLength() {
        for (int i = 0; i < this.inputUnit.length; ++i) {
            if (!this.inputUnit[i].isArrayType()) continue;
            this.length = this.inputUnit[i].getLength();
            return this.length;
        }
        return null;
    }

    public void reloadLength() {
        this.length = this.getLength();
        this.dimension = this.length.length;
        this.capacity = 0;
        for (int i = 0; i < this.dimension; ++i) {
            this.capacity += this.length[i];
        }
    }

    @Override
    public void operateArray() {
        if (this.arrayType) {
            this.reloadLength();
        }
        for (int i = 0; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].operateArray();
        }
    }

    @Override
    public void process() {
        if (this.arrayType) {
            if (this.getInputType() == 105) {
                this.booleanArrayProcess();
            } else if (this.getInputType() == 101) {
                this.integerArrayProcess();
            } else if (this.getInputType() == 100) {
                this.decimalArrayProcess();
            } else if (this.getInputType() == 104) {
                this.bigIntegerArrayProcess();
            } else if (this.getInputType() == 103) {
                this.bigDecimalArrayProcess();
            } else if (this.getInputType() == 102) {
                this.stringArrayProcess();
            } else if (this.getInputType() == Integer.MAX_VALUE) {
                this.unknownArrayProcess();
            } else {
                this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\uff08\u5185\u90e8\u30a8\u30e9\u30fc\uff09\u6bd4\u8f03\u6f14\u7b97\u306e\u30aa\u30da\u30e9\u30f3\u30c9\u306e\u5909\u6570\u578b\u304c\u4e0d\u660e\u3067\u3059\u3002" + System.getProperty("line.separator") : this.errorMessage + "(Internal Error) Cannot detect data types of the operands of the comparison operation." + System.getProperty("line.separator");
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.error(this.errorMessage);
            }
        } else if (this.getInputType() == 105) {
            this.booleanProcess();
        } else if (this.getInputType() == 101) {
            this.integerProcess();
        } else if (this.getInputType() == 100) {
            this.decimalProcess();
        } else if (this.getInputType() == 104) {
            this.bigIntegerProcess();
        } else if (this.getInputType() == 103) {
            this.bigDecimalProcess();
        } else if (this.getInputType() == 102) {
            this.stringProcess();
        } else if (this.getInputType() == Integer.MAX_VALUE) {
            this.unknownProcess();
        } else {
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\uff08\u5185\u90e8\u30a8\u30e9\u30fc\uff09\u6bd4\u8f03\u6f14\u7b97\u306e\u30aa\u30da\u30e9\u30f3\u30c9\u306e\u5909\u6570\u578b\u304c\u4e0d\u660e\u3067\u3059\u3002" + System.getProperty("line.separator") : this.errorMessage + "(Internal Error) Cannot detect data types of the operands of the comparison operation." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
        }
    }

    private void unknownProcess() {
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\uff08\u5185\u90e8\u30a8\u30e9\u30fc\uff09\u6bd4\u8f03\u6f14\u7b97\u306e\u30aa\u30da\u30e9\u30f3\u30c9\u306e\u5909\u6570\u578b\u304c\u672a\u8a2d\u5b9a\u3067\u3059\u3002" + System.getProperty("line.separator") : this.errorMessage + "(Internal Error) Data types of the operands of the comparison operation are not set." + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.error(this.errorMessage);
    }

    private void unknownArrayProcess() {
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\uff08\u5185\u90e8\u30a8\u30e9\u30fc\uff09\u6bd4\u8f03\u6f14\u7b97\u306e\u30aa\u30da\u30e9\u30f3\u30c9\u306e\u5909\u6570\u578b\u304c\u672a\u8a2d\u5b9a\u3067\u3059\u3002" + System.getProperty("line.separator") : this.errorMessage + "(Internal Error) Data types of the operands of the comparison operation are not set." + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.error(this.errorMessage);
    }

    private void booleanArrayProcess() {
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "bool\u578b\u306b\u5bfe\u3057\u3066\u3001\u6bd4\u8f03\u6f14\u7b97\u3092\u5b9f\u884c\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" + this.integerValue + "\" )" + System.getProperty("line.separator") : this.errorMessage + "Cannot perform comparison operations on bool type values. ( \"" + this.integerValue + "\" )" + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.error(this.errorMessage);
    }

    private void integerArrayProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.inputUnit[i + 1].index = this.index;
            this.inputUnit[i + 1].setIndexedValue();
            if (this.inputUnit[i].getIntegerValue() >= this.inputUnit[i + 1].getIntegerValue()) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void decimalArrayProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.inputUnit[i + 1].index = this.index;
            this.inputUnit[i + 1].setIndexedValue();
            if (!(this.inputUnit[i].getDecimalValue() < this.inputUnit[i + 1].getDecimalValue())) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void bigIntegerArrayProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.inputUnit[i + 1].index = this.index;
            this.inputUnit[i + 1].setIndexedValue();
            if (this.inputUnit[i].getBigIntegerValue().compareTo(this.inputUnit[i + 1].getBigIntegerValue()) >= 0) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void bigDecimalArrayProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.inputUnit[i + 1].index = this.index;
            this.inputUnit[i + 1].setIndexedValue();
            if (this.inputUnit[i].getBigDecimalValue().compareTo(this.inputUnit[i + 1].getBigDecimalValue()) >= 0) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void stringArrayProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.inputUnit[i + 1].index = this.index;
            this.inputUnit[i + 1].setIndexedValue();
            if (this.inputUnit[i].getStringValue().length() >= this.inputUnit[i + 1].getStringValue().length()) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void booleanProcess() {
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "bool\u578b\u306b\u5bfe\u3057\u3066\u3001\u6bd4\u8f03\u6f14\u7b97\u3092\u5b9f\u884c\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" + this.integerValue + "\" )" + System.getProperty("line.separator") : this.errorMessage + "Cannot perform comparison operations on bool type values. ( \"" + this.integerValue + "\" )" + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.error(this.errorMessage);
    }

    private void integerProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            if (this.inputUnit[i].getIntegerValue() >= this.inputUnit[i + 1].getIntegerValue()) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void decimalProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            if (!(this.inputUnit[i].getDecimalValue() < this.inputUnit[i + 1].getDecimalValue())) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void bigIntegerProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            if (this.inputUnit[i].getBigIntegerValue().compareTo(this.inputUnit[i + 1].getBigIntegerValue()) >= 0) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void bigDecimalProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            if (this.inputUnit[i].getBigDecimalValue().compareTo(this.inputUnit[i + 1].getBigDecimalValue()) >= 0) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void stringProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            if (this.inputUnit[i].getStringValue().length() >= this.inputUnit[i + 1].getStringValue().length()) continue;
            this.booleanValue = false;
            return;
        }
    }

    @Override
    public String getFormula() {
        return this.getFormula(Integer.MAX_VALUE);
    }

    @Override
    public String getFormula(int n) {
        if (this.getRank() == n) {
            return this.getStringValue();
        }
        String string = "";
        string = n == this.getRank() + 1 ? " [" : "";
        for (int i = 0; i < this.inputUnit.length; ++i) {
            string = string + this.inputUnit[i].getFormula(n);
            if (i >= this.inputUnit.length - 1) continue;
            string = string + ">=";
        }
        string = n == this.getRank() + 1 ? string + " = " + this.getStringValue() + " ]" : string + "";
        if (this.inputUnit.length == 1) {
            string = this.getStringValue();
        }
        return string;
    }
}

