/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import rxvesapi.process.ProcessEngine;
import rxvesapi.process.unit.ProcessUnit;

public class IntegerUnit
extends ProcessUnit {
    public IntegerUnit() {
        this.valueType = 101;
        this.nodeType = 200;
    }

    public IntegerUnit(long l, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.valueType = 101;
        this.nodeType = 200;
        this.integerValue = l;
    }

    public IntegerUnit(String string, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.valueType = 101;
        this.nodeType = 200;
        this.integerValue = l;
    }

    @Override
    public long getIntegerValue() {
        return this.integerValue;
    }

    @Override
    public double getDecimalValue() {
        return this.integerValue;
    }

    @Override
    public final void increment() {
        ++this.integerValue;
    }

    @Override
    public final void decrement() {
        --this.integerValue;
    }

    @Override
    public String getFormula() {
        if (this.isConst()) {
            if (this.integerValue < 0L) {
                return "(" + Long.toString(this.integerValue) + ")";
            }
            return Long.toString(this.integerValue);
        }
        return this.name;
    }

    @Override
    public String getFormula(int n) {
        if (this.isConst()) {
            return this.getFormula();
        }
        return this.name;
    }
}

