/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.unit.ProcessUnit;

public class SIMDMultiplicationUnit
extends ProcessUnit {
    public SIMDMultiplicationUnit(ProcessUnit[] processUnitArray, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.inputUnit = processUnitArray;
        this.nodeType = 201;
        this.setValueType();
        int n = this.getValueType();
        this.arrayType = true;
        for (int i = 0; i < this.inputUnit.length; ++i) {
            if (!this.inputUnit[i].isArrayType()) continue;
            this.arrayType = true;
            this.dimension = this.inputUnit[i].getDimension();
            this.length = this.inputUnit[i].getLength();
            this.capacity = this.inputUnit[i].getCapacity();
            break;
        }
    }

    @Override
    public int[] getLength() {
        for (int i = 0; i < this.inputUnit.length; ++i) {
            if (!this.inputUnit[i].isArrayType()) continue;
            this.length = this.inputUnit[i].getLength();
            return this.length;
        }
        return null;
    }

    public void reloadLength() {
        this.length = this.getLength();
        this.dimension = this.length.length;
        this.capacity = 0;
        for (int i = 0; i < this.dimension; ++i) {
            this.capacity += this.length[i];
        }
    }

    @Override
    public void operateArray() {
        if (this.arrayType) {
            this.reloadLength();
        }
        for (int i = 0; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].operateArray();
        }
    }

    @Override
    public void process() {
        if (this.arrayType) {
            if (this.getValueType() == 101) {
                this.integerArrayProcess();
            } else if (this.getValueType() == 100) {
                this.decimalArrayProcess();
            } else if (this.getValueType() == 140) {
                this.complexArrayProcess();
            } else if (this.getValueType() == 104) {
                this.bigIntegerArrayProcess();
            } else if (this.getValueType() == 103) {
                this.bigDecimalArrayProcess();
            } else if (this.getValueType() == 141) {
                this.bigComplexArrayProcess();
            } else if (this.getValueType() == 102) {
                this.stringArrayProcess();
            }
        } else if (this.getValueType() == 101) {
            this.integerProcess();
        } else if (this.getValueType() == 100) {
            this.decimalProcess();
        } else if (this.getValueType() == 140) {
            this.complexProcess();
        } else if (this.getValueType() == 104) {
            this.bigIntegerProcess();
        } else if (this.getValueType() == 103) {
            this.bigDecimalProcess();
        } else if (this.getValueType() == 141) {
            this.bigComplexProcess();
        } else if (this.getValueType() == 102) {
            this.stringProcess();
        }
    }

    private void integerArrayProcess() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        this.integerValue = this.inputUnit[0].getIntegerValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.integerValue *= this.inputUnit[i].getIntegerValue();
        }
    }

    private void decimalArrayProcess() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        this.decimalValue = this.inputUnit[0].getDecimalValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.decimalValue *= this.inputUnit[i].getDecimalValue();
        }
    }

    private void complexArrayProcess() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        this.inputUnit[1].index = this.index;
        this.inputUnit[1].setIndexedValue();
        double[] dArray = this.inputUnit[0].getComplexValue();
        double[] dArray2 = this.inputUnit[1].getComplexValue();
        double[] dArray3 = new double[]{dArray[0] * dArray2[0] - dArray[1] * dArray2[1], dArray[0] * dArray2[1] + dArray[1] * dArray2[0]};
        this.setComplexValue(dArray3);
    }

    private void bigIntegerArrayProcess() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        BigInteger bigInteger = this.inputUnit[0].getBigIntegerValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            bigInteger = bigInteger.multiply(this.inputUnit[i].getBigIntegerValue());
        }
        this.bigIntegerValue = bigInteger;
    }

    private void bigDecimalArrayProcess() {
        MathContext mathContext = (MathContext)this.processEngine.getMathContext();
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        BigDecimal bigDecimal = this.inputUnit[0].getBigDecimalValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            bigDecimal = bigDecimal.multiply(this.inputUnit[i].getBigDecimalValue(), mathContext);
            bigDecimal = this.inputUnit[0].getFixedDigitBigDecimal(bigDecimal);
        }
        this.bigDecimalValue = bigDecimal;
    }

    private void bigComplexArrayProcess() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        this.inputUnit[1].index = this.index;
        this.inputUnit[1].setIndexedValue();
        BigDecimal[] bigDecimalArray = this.inputUnit[0].getBigComplexValue();
        BigDecimal[] bigDecimalArray2 = this.inputUnit[1].getBigComplexValue();
        MathContext mathContext = (MathContext)this.processEngine.getMathContext();
        BigDecimal[] bigDecimalArray3 = new BigDecimal[]{bigDecimalArray[0].multiply(bigDecimalArray2[0], mathContext).subtract(bigDecimalArray[1].multiply(bigDecimalArray2[1], mathContext), mathContext), bigDecimalArray[0].multiply(bigDecimalArray2[1], mathContext).add(bigDecimalArray[1].multiply(bigDecimalArray2[0], mathContext), mathContext)};
        this.setBigComplexValue(bigDecimalArray3);
    }

    private void stringArrayProcess() {
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u4e57\u7b97\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" : this.errorMessage + "Cannot perform the multiplication. ( \"";
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.errorMessage = this.errorMessage + "\"" + this.inputUnit[i].getStringValue() + "\"";
            this.errorMessage = this.errorMessage + "*";
        }
        this.errorMessage = this.errorMessage + "\"" + this.inputUnit[this.inputUnit.length - 1].getStringValue() + "\" )" + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.error(this.errorMessage);
        this.stringValue = "SYSTEM_ERROR_VALUE";
    }

    private void integerProcess() {
        this.integerValue = this.inputUnit[0].getIntegerValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.integerValue *= this.inputUnit[i].getIntegerValue();
        }
    }

    private void decimalProcess() {
        this.decimalValue = this.inputUnit[0].getDecimalValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.decimalValue *= this.inputUnit[i].getDecimalValue();
        }
    }

    private void complexProcess() {
        double[] dArray = this.inputUnit[0].getComplexValue();
        double[] dArray2 = this.inputUnit[1].getComplexValue();
        double[] dArray3 = new double[]{dArray[0] * dArray2[0] - dArray[1] * dArray2[1], dArray[0] * dArray2[1] + dArray[1] * dArray2[0]};
        this.setComplexValue(dArray3);
    }

    private void bigIntegerProcess() {
        BigInteger bigInteger = this.inputUnit[0].getBigIntegerValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            bigInteger = bigInteger.multiply(this.inputUnit[i].getBigIntegerValue());
        }
        this.bigIntegerValue = bigInteger;
    }

    private void bigDecimalProcess() {
        BigDecimal bigDecimal = this.inputUnit[0].getBigDecimalValue();
        MathContext mathContext = (MathContext)this.processEngine.getMathContext();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            bigDecimal = bigDecimal.multiply(this.inputUnit[i].getBigDecimalValue(), mathContext);
        }
        this.bigDecimalValue = bigDecimal;
    }

    private void bigComplexProcess() {
        BigDecimal[] bigDecimalArray = this.inputUnit[0].getBigComplexValue();
        BigDecimal[] bigDecimalArray2 = this.inputUnit[1].getBigComplexValue();
        MathContext mathContext = (MathContext)this.processEngine.getMathContext();
        BigDecimal[] bigDecimalArray3 = new BigDecimal[]{bigDecimalArray[0].multiply(bigDecimalArray2[0], mathContext).subtract(bigDecimalArray[1].multiply(bigDecimalArray2[1], mathContext), mathContext), bigDecimalArray[0].multiply(bigDecimalArray2[1], mathContext).add(bigDecimalArray[1].multiply(bigDecimalArray2[0], mathContext), mathContext)};
        this.setBigComplexValue(bigDecimalArray3);
    }

    private void stringProcess() {
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u4e57\u7b97\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" : this.errorMessage + "Cannot perform the multiplication. ( \"";
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.errorMessage = this.errorMessage + "\"" + this.inputUnit[i].getStringValue() + "\"";
            this.errorMessage = this.errorMessage + "*";
        }
        this.errorMessage = this.errorMessage + "\"" + this.inputUnit[this.inputUnit.length - 1].getStringValue() + "\" )" + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.error(this.errorMessage);
        this.stringValue = "SYSTEM_ERROR_VALUE";
    }

    @Override
    public String getFormula() {
        return this.getFormula(Integer.MAX_VALUE);
    }

    @Override
    public String getFormula(int n) {
        if (this.getRank() == n) {
            if (this.isArrayType()) {
                return SIMDMultiplicationUnit.getArrayLine(this);
            }
            return this.getStringValue();
        }
        String string = "";
        string = n == this.getRank() + 1 ? "[ " : "";
        for (int i = 0; i < this.inputUnit.length; ++i) {
            string = string + this.inputUnit[i].getFormula(n);
            if (i >= this.inputUnit.length - 1) continue;
            string = string + "*";
        }
        string = n == this.getRank() + 1 ? (this.isArrayType() ? string + " = " + SIMDMultiplicationUnit.getArrayLine(this) + " ]" : string + " = " + this.getStringValue() + " ]") : string + "";
        if (this.inputUnit.length == 1) {
            string = this.getStringValue();
        }
        return string;
    }
}

