/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import rxvesapi.process.ProcessCompatibilityException;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.unit.ProcessUnit;

public class SIMDRemainderUnit
extends ProcessUnit {
    public SIMDRemainderUnit(ProcessUnit[] processUnitArray, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.inputUnit = processUnitArray;
        this.nodeType = 201;
        this.setValueType();
        this.arrayType = true;
        for (int i = 0; i < this.inputUnit.length; ++i) {
            if (!this.inputUnit[i].isArrayType()) continue;
            this.arrayType = true;
            this.dimension = this.inputUnit[i].getDimension();
            this.length = this.inputUnit[i].getLength();
            this.capacity = this.inputUnit[i].getCapacity();
            break;
        }
    }

    @Override
    public int[] getLength() {
        for (int i = 0; i < this.inputUnit.length; ++i) {
            if (!this.inputUnit[i].isArrayType()) continue;
            this.length = this.inputUnit[i].getLength();
            return this.length;
        }
        return null;
    }

    public void reloadLength() {
        this.length = this.getLength();
        this.dimension = this.length.length;
        this.capacity = 0;
        for (int i = 0; i < this.dimension; ++i) {
            this.capacity += this.length[i];
        }
    }

    @Override
    public void operateArray() {
        if (this.arrayType) {
            this.reloadLength();
        }
        for (int i = 0; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].operateArray();
        }
    }

    @Override
    public void process() {
        if (this.arrayType) {
            if (this.getValueType() == 101) {
                this.decimalArrayProcess();
            } else if (this.getValueType() == 100) {
                this.decimalArrayProcess();
            } else if (this.getValueType() == 104) {
                this.bigIntegerArrayProcess();
            } else if (this.getValueType() == 103) {
                this.bigDecimalArrayProcess();
            } else if (this.getValueType() == 102) {
                this.stringArrayProcess();
            }
        } else if (this.getValueType() == 101) {
            this.integerProcess();
        } else if (this.getValueType() == 100) {
            this.decimalProcess();
        } else if (this.getValueType() == 104) {
            this.bigIntegerProcess();
        } else if (this.getValueType() == 103) {
            this.bigDecimalProcess();
        } else if (this.getValueType() == 102) {
            this.stringProcess();
        }
    }

    private void integerArrayProcess() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        this.integerValue = this.inputUnit[0].getIntegerValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.integerValue %= this.inputUnit[i].getIntegerValue();
        }
    }

    private void decimalArrayProcess() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        this.decimalValue = this.inputUnit[0].getDecimalValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.decimalValue %= this.inputUnit[i].getDecimalValue();
        }
    }

    private void bigIntegerArrayProcess() {
        try {
            this.inputUnit[0].index = this.index;
            this.inputUnit[0].setIndexedValue();
            BigInteger bigInteger = this.inputUnit[0].getBigIntegerValue();
            for (int i = 1; i < this.inputUnit.length; ++i) {
                ProcessCompatibilityException processCompatibilityException;
                this.inputUnit[i].index = this.index;
                this.inputUnit[i].setIndexedValue();
                bigInteger = bigInteger.remainder(this.inputUnit[i].getBigIntegerValue());
                if (bigInteger.compareTo(BigInteger.ZERO) >= 0 && this.inputUnit[i].getBigIntegerValue().compareTo(BigInteger.ZERO) >= 0 || (processCompatibilityException = new ProcessCompatibilityException()).alert()) continue;
                if (ScriptProcessor.locale.isJapanese()) {
                    this.error("\u8ca0\u306e\u6570\u306b\u5bfe\u3059\u308b varint\u578b\u306e\u5270\u4f59\u6f14\u7b97\u306f\u3001\u30d0\u30fc\u30b8\u30e7\u30f3 3.1.12 \u4ee5\u524d\u3068 3.1.14 \u4ee5\u5f8c\u3067\u6319\u52d5\u304c\u7570\u306a\u308a\u307e\u3059\u30023.1.12\u4ee5\u524d\u306b\u8a18\u8ff0\u3055\u308c\u305f\u30d7\u30ed\u30b0\u30e9\u30e0\u306f\u30013.1.12\u4ee5\u524d\u306e\u30e9\u30f3\u30bf\u30a4\u30e0\u3067\u5b9f\u884c\u3057\u3066\u4e0b\u3055\u3044\u3002");
                    continue;
                }
                this.error("It is not recommended to perform remainder operations on negative varint values. Its behaviour depends on the version of VCSSL (after 3.1.14 or before 3.1.12).");
            }
            this.bigIntegerValue = bigInteger;
        }
        catch (ArithmeticException arithmeticException) {
            BigInteger bigInteger = new BigInteger("0");
            for (int i = 1; i < this.inputUnit.length; ++i) {
                if (this.inputUnit[i].getBigIntegerValue().compareTo(bigInteger) != 0) continue;
                if (ScriptProcessor.locale.isJapanese()) {
                    this.errorMessage = this.errorMessage + "\u5909\u6570\u300c" + this.inputUnit[i].getName() + "\u300d\u306e\u5024\u304c0\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002" + System.getProperty("line.separator");
                    this.errorMessage = this.errorMessage + "\u3053\u306e\u5909\u6570\u3067\u5270\u4f59\u7b97\u3092\u5b9f\u884c\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + System.getProperty("line.separator");
                } else {
                    this.errorMessage = this.errorMessage + "Cannot perform the remainder operation by variable \"" + this.inputUnit[i].getName() + "\", because its value is zero.";
                }
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.bigIntegerValue = new BigInteger("0");
                this.error(this.errorMessage);
                return;
            }
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u5270\u4f59\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4e0d\u660e\u306a\u6f14\u7b97\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 @" + this + System.getProperty("line.separator") : this.errorMessage + "Unexpected error occurred on the remainder operation. @" + this + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.bigIntegerValue = new BigInteger("0");
            this.error(this.errorMessage);
            return;
        }
    }

    private void bigDecimalArrayProcess() {
        try {
            this.inputUnit[0].index = this.index;
            this.inputUnit[0].setIndexedValue();
            BigDecimal bigDecimal = this.inputUnit[0].getBigDecimalValue();
            MathContext mathContext = (MathContext)this.processEngine.getMathContext();
            for (int i = 1; i < this.inputUnit.length; ++i) {
                this.inputUnit[i].index = this.index;
                this.inputUnit[i].setIndexedValue();
                BigDecimal bigDecimal2 = this.inputUnit[i].getBigDecimalValue();
                this.bigDecimalValue = bigDecimal.remainder(bigDecimal2, mathContext);
            }
        }
        catch (ArithmeticException arithmeticException) {
            BigDecimal bigDecimal = new BigDecimal("0.0");
            for (int i = 1; i < this.inputUnit.length; ++i) {
                if (this.inputUnit[i].getBigDecimalValue().compareTo(bigDecimal) != 0) continue;
                if (ScriptProcessor.locale.isJapanese()) {
                    this.errorMessage = this.errorMessage + "\u5909\u6570\u300c" + this.inputUnit[i].getName() + "\u300d\u306e\u5024\u304c0\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002" + System.getProperty("line.separator");
                    this.errorMessage = this.errorMessage + "\u3053\u306e\u5909\u6570\u3067\u5270\u4f59\u7b97\u3092\u5b9f\u884c\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + System.getProperty("line.separator");
                } else {
                    this.errorMessage = this.errorMessage + "Cannot perform the remainder operation by variable \"" + this.inputUnit[i].getName() + "\", because its value is zero.";
                }
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.bigDecimalValue = new BigDecimal("0.0");
                this.error(this.errorMessage);
                return;
            }
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u5270\u4f59\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4e0d\u660e\u306a\u6f14\u7b97\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 @" + this + System.getProperty("line.separator") : this.errorMessage + "Unexpected error occurred on the remainder operation. @" + this + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.bigDecimalValue = new BigDecimal("0.0");
            this.error(this.errorMessage);
            return;
        }
    }

    private void stringArrayProcess() {
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6f14\u7b97\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" : this.errorMessage + "Cannot perform the operation. ( \"";
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.errorMessage = this.errorMessage + "\"" + this.inputUnit[i].getStringValue() + "\"";
            this.errorMessage = this.errorMessage + "/";
        }
        this.errorMessage = this.errorMessage + "\"" + this.inputUnit[this.inputUnit.length - 1].getStringValue() + "\" )" + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.error(this.errorMessage);
        this.stringValue = "SYSTEM_ERROR_VALUE";
    }

    private void integerProcess() {
        this.integerValue = this.inputUnit[0].getIntegerValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.integerValue %= this.inputUnit[i].getIntegerValue();
        }
    }

    private void decimalProcess() {
        this.decimalValue = this.inputUnit[0].getDecimalValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.decimalValue %= this.inputUnit[i].getDecimalValue();
        }
    }

    private void bigIntegerProcess() {
        try {
            BigInteger bigInteger = this.inputUnit[0].getBigIntegerValue();
            for (int i = 1; i < this.inputUnit.length; ++i) {
                ProcessCompatibilityException processCompatibilityException;
                if ((bigInteger = bigInteger.remainder(this.inputUnit[i].getBigIntegerValue())).compareTo(BigInteger.ZERO) >= 0 && this.inputUnit[i].getBigIntegerValue().compareTo(BigInteger.ZERO) >= 0 || (processCompatibilityException = new ProcessCompatibilityException()).alert()) continue;
                if (ScriptProcessor.locale.isJapanese()) {
                    this.error("\u8ca0\u306e\u6570\u306b\u5bfe\u3059\u308b varint\u578b\u306e\u5270\u4f59\u6f14\u7b97\u306f\u3001\u30d0\u30fc\u30b8\u30e7\u30f3 3.1.12 \u4ee5\u524d\u3068 3.1.14 \u4ee5\u5f8c\u3067\u6319\u52d5\u304c\u7570\u306a\u308a\u307e\u3059\u30023.1.12\u4ee5\u524d\u306b\u8a18\u8ff0\u3055\u308c\u305f\u30d7\u30ed\u30b0\u30e9\u30e0\u306f\u30013.1.12\u4ee5\u524d\u306e\u30e9\u30f3\u30bf\u30a4\u30e0\u3067\u5b9f\u884c\u3057\u3066\u4e0b\u3055\u3044\u3002");
                    continue;
                }
                this.error("It is not recommended to perform remainder operations on negative varint values. Its behaviour depends on the version of VCSSL (after 3.1.14 or before 3.1.12).");
            }
            this.bigIntegerValue = bigInteger;
        }
        catch (ArithmeticException arithmeticException) {
            BigInteger bigInteger = new BigInteger("0");
            for (int i = 1; i < this.inputUnit.length; ++i) {
                if (this.inputUnit[i].getBigIntegerValue().compareTo(bigInteger) != 0) continue;
                if (ScriptProcessor.locale.isJapanese()) {
                    this.errorMessage = this.errorMessage + "\u5909\u6570\u300c" + this.inputUnit[i].getName() + "\u300d\u306e\u5024\u304c0\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002" + System.getProperty("line.separator");
                    this.errorMessage = this.errorMessage + "\u3053\u306e\u5909\u6570\u3067\u5270\u4f59\u7b97\u3092\u5b9f\u884c\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + System.getProperty("line.separator");
                } else {
                    this.errorMessage = this.errorMessage + "Cannot perform the remainder operation by variable \"" + this.inputUnit[i].getName() + "\", because its value is zero.";
                }
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.bigIntegerValue = new BigInteger("0");
                this.error(this.errorMessage);
                return;
            }
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u5270\u4f59\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4e0d\u660e\u306a\u6f14\u7b97\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 @" + this + System.getProperty("line.separator") : this.errorMessage + "Unexpected error occurred on the remainder operation. @" + this + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
            this.bigIntegerValue = new BigInteger("0");
            return;
        }
    }

    private void bigDecimalProcess() {
        try {
            BigDecimal bigDecimal = this.inputUnit[0].getBigDecimalValue();
            MathContext mathContext = (MathContext)this.processEngine.getMathContext();
            for (int i = 1; i < this.inputUnit.length; ++i) {
                BigDecimal bigDecimal2 = this.inputUnit[i].getBigDecimalValue();
                bigDecimal = bigDecimal.remainder(bigDecimal2, mathContext);
            }
            this.bigDecimalValue = bigDecimal;
        }
        catch (ArithmeticException arithmeticException) {
            BigDecimal bigDecimal = new BigDecimal("0.0");
            for (int i = 1; i < this.inputUnit.length; ++i) {
                if (this.inputUnit[i].getBigDecimalValue().compareTo(bigDecimal) != 0) continue;
                if (ScriptProcessor.locale.isJapanese()) {
                    this.errorMessage = this.errorMessage + "\u5909\u6570\u300c" + this.inputUnit[i].getName() + "\u300d\u306e\u5024\u304c0\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002" + System.getProperty("line.separator");
                    this.errorMessage = this.errorMessage + "\u3053\u306e\u5909\u6570\u3067\u5270\u4f59\u7b97\u3092\u5b9f\u884c\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + System.getProperty("line.separator");
                } else {
                    this.errorMessage = this.errorMessage + "Cannot perform the remainder operation by variable \"" + this.inputUnit[i].getName() + "\", because its value is zero.";
                }
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.error(this.errorMessage);
                this.bigDecimalValue = new BigDecimal("0.0");
                return;
            }
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u5270\u4f59\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4e0d\u660e\u306a\u6f14\u7b97\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 @" + this + System.getProperty("line.separator") : this.errorMessage + "Unexpected error occurred on the remainder operation. @" + this + System.getProperty("line.separator");
            this.error(this.errorMessage);
            this.bigDecimalValue = new BigDecimal("0.0");
            return;
        }
    }

    private void stringProcess() {
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6f14\u7b97\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" : this.errorMessage + "Cannot perform the operation. ( \"";
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.errorMessage = this.errorMessage + "\"" + this.inputUnit[i].getStringValue() + "\"";
            this.errorMessage = this.errorMessage + "/";
        }
        this.errorMessage = this.errorMessage + "\"" + this.inputUnit[this.inputUnit.length - 1].getStringValue() + "\" )" + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.error(this.errorMessage);
        this.stringValue = "SYSTEM_ERROR_VALUE";
    }

    @Override
    public String getFormula() {
        return this.getFormula(Integer.MAX_VALUE);
    }

    @Override
    public String getFormula(int n) {
        if (this.getRank() == n) {
            if (this.isArrayType()) {
                return SIMDRemainderUnit.getArrayLine(this);
            }
            return this.getStringValue();
        }
        String string = "";
        string = n == this.getRank() + 1 ? "[ " : "";
        for (int i = 0; i < this.inputUnit.length; ++i) {
            string = string + this.inputUnit[i].getFormula(n);
            if (i >= this.inputUnit.length - 1) continue;
            string = string + "%";
        }
        string = n == this.getRank() + 1 ? (this.isArrayType() ? string + " = " + SIMDRemainderUnit.getArrayLine(this) + " ]" : string + " = " + this.getStringValue() + " ]") : string + "";
        if (this.inputUnit.length == 1) {
            string = this.getStringValue();
        }
        return string;
    }
}

