/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.math.BigDecimal;
import java.math.MathContext;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.unit.ProcessUnit;

public class SISDAdditionUnit
extends ProcessUnit {
    public SISDAdditionUnit(ProcessUnit[] processUnitArray, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.inputUnit = processUnitArray;
        this.inputUnit0 = processUnitArray[0];
        this.inputUnit1 = processUnitArray[1];
        this.nodeType = 201;
        this.setValueType();
        this.arrayType = false;
    }

    @Override
    public void process() {
        if (this.valueType == 100) {
            this.decimalValue = this.inputUnit0.getDecimalValue() + this.inputUnit1.getDecimalValue();
        } else if (this.valueType == 101) {
            this.integerValue = this.inputUnit0.getIntegerValue() + this.inputUnit1.getIntegerValue();
        } else if (this.valueType == 140) {
            double[] dArray = this.inputUnit1.getComplexValue();
            double[] dArray2 = this.inputUnit0.getComplexValue();
            dArray2[0] = dArray2[0] + dArray[0];
            dArray2[1] = dArray2[1] + dArray[1];
            this.setComplexValue(dArray2);
        } else if (this.valueType == 104) {
            this.bigIntegerValue = this.inputUnit0.getBigIntegerValue().add(this.inputUnit1.getBigIntegerValue());
        } else if (this.valueType == 103) {
            MathContext mathContext = (MathContext)this.processEngine.getMathContext();
            this.bigDecimalValue = this.inputUnit0.getBigDecimalValue().add(this.inputUnit1.getBigDecimalValue(), mathContext);
        } else if (this.valueType == 141) {
            BigDecimal[] bigDecimalArray = this.inputUnit1.getBigComplexValue();
            BigDecimal[] bigDecimalArray2 = this.inputUnit0.getBigComplexValue();
            MathContext mathContext = (MathContext)this.processEngine.getMathContext();
            bigDecimalArray2[0] = bigDecimalArray2[0].add(bigDecimalArray[0], mathContext);
            bigDecimalArray2[1] = bigDecimalArray2[1].add(bigDecimalArray[1], mathContext);
            this.setBigComplexValue(bigDecimalArray2);
        } else if (this.valueType == 102) {
            String string = "";
            for (int i = 0; i < this.inputUnit.length; ++i) {
                String string2 = this.inputUnit[i].getStringValue();
                if (string2 == null) {
                    this.stringValue = null;
                    return;
                }
                string = string + string2;
            }
            this.stringValue = string;
        }
    }

    @Override
    public final long getIntegerValue() {
        try {
            if (this.valueType == 101) {
                this.integerValue = this.inputUnit0.getIntegerValue() + this.inputUnit1.getIntegerValue();
                return this.integerValue;
            }
            if (this.valueType == 100) {
                this.decimalValue = this.inputUnit0.getDecimalValue() + this.inputUnit1.getDecimalValue();
                return (long)this.decimalValue;
            }
            if (this.valueType == 104) {
                this.bigIntegerValue = this.inputUnit0.getBigIntegerValue().add(this.inputUnit1.getBigIntegerValue());
                return this.bigIntegerValue.longValue();
            }
            if (this.valueType == 103) {
                MathContext mathContext = (MathContext)this.processEngine.getMathContext();
                this.bigDecimalValue = this.inputUnit0.getBigDecimalValue().add(this.inputUnit1.getBigDecimalValue(), mathContext);
                return this.bigDecimalValue.longValue();
            }
            if (this.valueType == 102) {
                String string = this.inputUnit[0].getStringValue();
                for (int i = 1; i < this.inputUnit.length; ++i) {
                    string = string + this.inputUnit[i].getStringValue();
                }
                this.stringValue = string;
                return super.getIntegerValue();
            }
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6574\u6570\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" + this.getStringValue() + "\" )" : this.errorMessage + "Cannot convert to an int type value. ( \"" + this.getStringValue() + "\" )";
            this.error(this.errorMessage);
            return 0L;
        }
        catch (NullPointerException nullPointerException) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.errorMessage = this.errorMessage + "\u5909\u6570\u300c" + this.name + "\u300d\u306f\u6b63\u5e38\u306a\u5024\u3092\u4fdd\u6301\u3057\u3066\u3044\u307e\u305b\u3093\u3002" + System.getProperty("line.separator");
                this.errorMessage = this.errorMessage + "\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u306a\u3044\u304b\u3001\u51e6\u7406\u4e0d\u80fd\u306a\u6f14\u7b97\u304c\u884c\u308f\u308c\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" + System.getProperty("line.separator");
            } else {
                this.errorMessage = this.errorMessage + "The variable \"" + this.name + "\" does not store the valid value." + System.getProperty("line.separator");
                this.errorMessage = this.errorMessage + "Probably it is uninitialized, or performed invalid operations." + System.getProperty("line.separator");
            }
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
            return 0L;
        }
    }

    @Override
    public final double getDecimalValue() {
        if (this.valueType == 100) {
            this.decimalValue = this.inputUnit0.getDecimalValue() + this.inputUnit1.getDecimalValue();
            return this.decimalValue;
        }
        if (this.valueType == 101) {
            this.integerValue = this.inputUnit0.getIntegerValue() + this.inputUnit1.getIntegerValue();
            return this.integerValue;
        }
        if (this.valueType == 104) {
            this.bigIntegerValue = this.inputUnit0.getBigIntegerValue().add(this.inputUnit1.getBigIntegerValue());
            return this.bigIntegerValue.doubleValue();
        }
        if (this.valueType == 103) {
            MathContext mathContext = (MathContext)this.processEngine.getMathContext();
            this.bigDecimalValue = this.inputUnit0.getBigDecimalValue().add(this.inputUnit1.getBigDecimalValue(), mathContext);
            return this.bigDecimalValue.doubleValue();
        }
        if (this.valueType == 102) {
            String string = this.inputUnit[0].getStringValue();
            for (int i = 1; i < this.inputUnit.length; ++i) {
                string = string + this.inputUnit[i].getStringValue();
            }
            this.stringValue = string;
            return super.getDecimalValue();
        }
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6d6e\u52d5\u5c0f\u6570\u70b9\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" + this.getStringValue() + "\" )" : this.errorMessage + "Cannot convert to a float type value. ( \"" + this.getStringValue() + "\" )";
        this.error(this.errorMessage);
        return 0.0;
    }

    @Override
    public String getFormula() {
        return this.getFormula(Integer.MAX_VALUE);
    }

    @Override
    public String getFormula(int n) {
        if (this.getRank() == n) {
            return this.getStringValue();
        }
        String string = "";
        string = n == this.getRank() + 1 ? "[ " : "";
        for (int i = 0; i < this.inputUnit.length; ++i) {
            string = string + this.inputUnit[i].getFormula(n);
            if (i >= this.inputUnit.length - 1) continue;
            string = string + "+";
        }
        string = n == this.getRank() + 1 ? string + " = " + this.getStringValue() + " ]" : string + "";
        if (this.inputUnit.length == 1) {
            string = this.getStringValue();
        }
        return string;
    }
}

