/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.unit.ProcessUnit;

public class SISDDivisionUnit
extends ProcessUnit {
    int lastDigit = -1;

    public SISDDivisionUnit(ProcessUnit[] processUnitArray, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.inputUnit = processUnitArray;
        this.inputUnit0 = processUnitArray[0];
        this.inputUnit1 = processUnitArray[1];
        this.nodeType = 201;
        this.setValueType();
        this.arrayType = false;
    }

    @Override
    public final void process() {
        if (this.valueType == 100) {
            this.decimalValue = this.inputUnit0.getDecimalValue() / this.inputUnit1.getDecimalValue();
        } else if (this.valueType == 101) {
            try {
                this.integerValue = this.inputUnit0.getIntegerValue() / this.inputUnit1.getIntegerValue();
            }
            catch (ArithmeticException arithmeticException) {
                this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4f55\u3089\u304b\u306e\u6f14\u7b97\u30a8\u30e9\u30fc\uff08\u30bc\u30ed\u9664\u7b97\u306a\u3069\uff09\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : "Unexpected error (e.g. divided by zero) has occurred on the division." + System.getProperty("line.separator");
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.error(this.errorMessage);
            }
        } else if (this.valueType == 140) {
            double[] dArray = this.inputUnit0.getComplexValue();
            double[] dArray2 = this.inputUnit1.getComplexValue();
            double d = dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1];
            double[] dArray3 = new double[]{(dArray[0] * dArray2[0] + dArray[1] * dArray2[1]) / d, (dArray[1] * dArray2[0] - dArray[0] * dArray2[1]) / d};
            this.setComplexValue(dArray3);
        } else if (this.valueType == 104) {
            this.bigIntegerProcess();
        } else if (this.valueType == 103) {
            this.bigDecimalProcess();
        } else if (this.valueType == 141) {
            MathContext mathContext = (MathContext)this.processEngine.getMathContext();
            BigDecimal[] bigDecimalArray = this.inputUnit0.getBigComplexValue();
            BigDecimal[] bigDecimalArray2 = this.inputUnit1.getBigComplexValue();
            BigDecimal bigDecimal = bigDecimalArray2[0].multiply(bigDecimalArray2[0], mathContext).add(bigDecimalArray2[1].multiply(bigDecimalArray2[1]), mathContext);
            bigDecimal = this.getFixedDigitBigDecimal(bigDecimal);
            BigDecimal[] bigDecimalArray3 = new BigDecimal[]{bigDecimalArray[0].multiply(bigDecimalArray2[0], mathContext).add(bigDecimalArray[1].multiply(bigDecimalArray2[1], mathContext), mathContext), bigDecimalArray[1].multiply(bigDecimalArray2[0], mathContext).subtract(bigDecimalArray[0].multiply(bigDecimalArray2[1], mathContext), mathContext)};
            bigDecimalArray3[0] = this.div(bigDecimalArray3[0], bigDecimal);
            bigDecimalArray3[1] = this.div(bigDecimalArray3[1], bigDecimal);
            this.setBigComplexValue(bigDecimalArray3);
        } else if (this.getValueType() == 102) {
            this.stringProcess();
        }
    }

    @Override
    public final long getIntegerValue() {
        block13: {
            try {
                if (this.valueType == 101) {
                    try {
                        this.integerValue = this.inputUnit0.getIntegerValue() / this.inputUnit1.getIntegerValue();
                        return this.integerValue;
                    }
                    catch (ArithmeticException arithmeticException) {
                        this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4f55\u3089\u304b\u306e\u6f14\u7b97\u30a8\u30e9\u30fc\uff08\u30bc\u30ed\u9664\u7b97\u306a\u3069\uff09\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : "Unexpected error (e.g. divided by zero) has occurred on the division." + System.getProperty("line.separator");
                        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                        this.error(this.errorMessage);
                        break block13;
                    }
                }
                if (this.valueType == 100) {
                    this.decimalValue = this.inputUnit0.getDecimalValue() / this.inputUnit1.getDecimalValue();
                    return (long)this.decimalValue;
                }
                if (this.valueType == 104) {
                    this.bigIntegerProcess();
                    return this.bigIntegerValue.longValue();
                }
                if (this.valueType == 103) {
                    this.bigDecimalProcess();
                    return this.bigDecimalValue.longValue();
                }
                if (this.valueType == 102) {
                    this.stringProcess();
                    long l = 0L;
                    try {
                        l = Long.parseLong(this.stringValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.errorMessage = this.errorMessage + "\t\u6574\u6570\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" + this.stringValue + "\" )" + System.getProperty("line.separator");
                        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                        this.error(this.errorMessage);
                    }
                    return l;
                }
                this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6574\u6570\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" + this.getStringValue() + "\" )" : this.errorMessage + "Cannot convert to an int type value. ( \"" + this.getStringValue() + "\" )";
                this.error(this.errorMessage);
                return 0L;
            }
            catch (NullPointerException nullPointerException) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.errorMessage = this.errorMessage + "\u5909\u6570\u300c" + this.name + "\u300d\u306f\u6b63\u5e38\u306a\u5024\u3092\u4fdd\u6301\u3057\u3066\u3044\u307e\u305b\u3093\u3002" + System.getProperty("line.separator");
                    this.errorMessage = this.errorMessage + "\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u306a\u3044\u304b\u3001\u51e6\u7406\u4e0d\u80fd\u306a\u6f14\u7b97\u304c\u884c\u308f\u308c\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" + System.getProperty("line.separator");
                } else {
                    this.errorMessage = this.errorMessage + "The variable \"" + this.name + "\" does not store the valid value." + System.getProperty("line.separator");
                    this.errorMessage = this.errorMessage + "Probably it is uninitialized, or performed invalid operations." + System.getProperty("line.separator");
                }
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.error(this.errorMessage);
            }
        }
        return 0L;
    }

    @Override
    public final double getDecimalValue() {
        if (this.valueType == 100) {
            this.decimalValue = this.inputUnit0.getDecimalValue() / this.inputUnit1.getDecimalValue();
            return this.decimalValue;
        }
        if (this.valueType == 101) {
            try {
                this.integerValue = this.inputUnit0.getIntegerValue() / this.inputUnit1.getIntegerValue();
                return this.integerValue;
            }
            catch (ArithmeticException arithmeticException) {
                this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4f55\u3089\u304b\u306e\u6f14\u7b97\u30a8\u30e9\u30fc\uff08\u30bc\u30ed\u9664\u7b97\u306a\u3069\uff09\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : "Unexpected error (e.g. divided by zero) has occurred on the division." + System.getProperty("line.separator");
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.error(this.errorMessage);
            }
        } else {
            if (this.valueType == 104) {
                this.bigIntegerProcess();
                return this.bigIntegerValue.doubleValue();
            }
            if (this.valueType == 103) {
                this.bigDecimalProcess();
                return this.bigDecimalValue.doubleValue();
            }
            if (this.valueType == 102) {
                this.stringProcess();
                double d = 0.0;
                try {
                    d = Double.parseDouble(this.stringValue);
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6d6e\u52d5\u5c0f\u6570\u70b9\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" + this.stringValue + "\" )" : this.errorMessage + "Cannot convert to a float type value. ( \"" + this.stringValue + "\" )";
                    this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                    this.error(this.errorMessage);
                }
                return d;
            }
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6d6e\u52d5\u5c0f\u6570\u70b9\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" + this.getStringValue() + "\" )" : this.errorMessage + "Cannot convert to a float type value. ( \"" + this.getStringValue() + "\" )";
            this.error(this.errorMessage);
            return 0.0;
        }
        return 0.0;
    }

    private void bigIntegerProcess() {
        BigInteger bigInteger = new BigInteger("0");
        try {
            if (this.inputUnit0.getBigIntegerValue().compareTo(bigInteger) == 0) {
                this.bigIntegerValue = new BigInteger("0");
                return;
            }
            this.bigIntegerValue = this.inputUnit0.getBigIntegerValue().divide(this.inputUnit1.getBigIntegerValue());
        }
        catch (ArithmeticException arithmeticException) {
            if (this.inputUnit0.getBigIntegerValue().compareTo(bigInteger) == 0) {
                this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4f55\u3089\u304b\u306e\u6f14\u7b97\u30a8\u30e9\u30fc\uff08\u30bc\u30ed\u9664\u7b97\u306a\u3069\uff09\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : "Unexpected error (e.g. divided by zero) has occurred on the division." + System.getProperty("line.separator");
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.bigIntegerValue = new BigInteger("0");
                this.error(this.errorMessage);
                return;
            }
            if (this.inputUnit1.getBigIntegerValue().compareTo(bigInteger) == 0) {
                this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4f55\u3089\u304b\u306e\u6f14\u7b97\u30a8\u30e9\u30fc\uff08\u30bc\u30ed\u9664\u7b97\u306a\u3069\uff09\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : "Unexpected error (e.g. divided by zero) has occurred on the division." + System.getProperty("line.separator");
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.bigIntegerValue = new BigInteger("0");
                this.error(this.errorMessage);
                return;
            }
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4f55\u3089\u304b\u306e\u6f14\u7b97\u30a8\u30e9\u30fc\uff08\u30bc\u30ed\u9664\u7b97\u306a\u3069\uff09\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : "Unexpected error (e.g. divided by zero) has occurred on the division." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.bigIntegerValue = new BigInteger("0");
            this.error(this.errorMessage);
            return;
        }
    }

    private void bigDecimalProcess() {
        BigDecimal bigDecimal = bd_zero;
        try {
            if (this.inputUnit0.getBigDecimalValue().compareTo(bigDecimal) == 0) {
                this.bigDecimalValue = bd_zero;
                return;
            }
            BigDecimal bigDecimal2 = this.inputUnit0.getBigDecimalValue();
            BigDecimal bigDecimal3 = this.inputUnit1.getBigDecimalValue();
            MathContext mathContext = (MathContext)this.processEngine.getMathContext();
            bigDecimal2 = bigDecimal2.divide(bigDecimal3, mathContext);
            this.bigDecimalValue = this.getFixedDigitBigDecimal(bigDecimal2);
        }
        catch (ArithmeticException arithmeticException) {
            if (this.inputUnit0.getBigDecimalValue().compareTo(bigDecimal) == 0) {
                this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4f55\u3089\u304b\u306e\u6f14\u7b97\u30a8\u30e9\u30fc\uff08\u30bc\u30ed\u9664\u7b97\u306a\u3069\uff09\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : "Unexpected error (e.g. divided by zero) has occurred on the division." + System.getProperty("line.separator");
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.bigDecimalValue = new BigDecimal("0.0");
                this.error(this.errorMessage);
                return;
            }
            if (this.inputUnit1.getBigDecimalValue().compareTo(bigDecimal) == 0) {
                this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4f55\u3089\u304b\u306e\u6f14\u7b97\u30a8\u30e9\u30fc\uff08\u30bc\u30ed\u9664\u7b97\u306a\u3069\uff09\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : "Unexpected error (e.g. divided by zero) has occurred on the division." + System.getProperty("line.separator");
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.bigDecimalValue = new BigDecimal("0.0");
                this.error(this.errorMessage);
                return;
            }
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4f55\u3089\u304b\u306e\u6f14\u7b97\u30a8\u30e9\u30fc\uff08\u30bc\u30ed\u9664\u7b97\u306a\u3069\uff09\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : "Unexpected error (e.g. divided by zero) has occurred on the division." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.bigDecimalValue = new BigDecimal("0.0");
            this.error(this.errorMessage);
            return;
        }
    }

    private BigDecimal div(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        BigDecimal bigDecimal3 = bd_zero;
        try {
            if (bigDecimal.compareTo(bigDecimal3) == 0) {
                return bd_zero;
            }
            bigDecimal = this.inputUnit0.getFixedDigitBigDecimal(bigDecimal);
            bigDecimal2 = this.inputUnit1.getFixedDigitBigDecimal(bigDecimal2);
            MathContext mathContext = (MathContext)this.processEngine.getMathContext();
            bigDecimal = bigDecimal.divide(bigDecimal2, mathContext);
            return this.getFixedDigitBigDecimal(bigDecimal);
        }
        catch (ArithmeticException arithmeticException) {
            if (this.inputUnit0.getBigDecimalValue().compareTo(bigDecimal3) == 0) {
                this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4f55\u3089\u304b\u306e\u6f14\u7b97\u30a8\u30e9\u30fc\uff08\u30bc\u30ed\u9664\u7b97\u306a\u3069\uff09\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : "Unexpected error (e.g. divided by zero) has occurred on the division." + System.getProperty("line.separator");
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.bigDecimalValue = new BigDecimal("0.0");
                this.error(this.errorMessage);
                return null;
            }
            if (this.inputUnit1.getBigDecimalValue().compareTo(bigDecimal3) == 0) {
                this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4f55\u3089\u304b\u306e\u6f14\u7b97\u30a8\u30e9\u30fc\uff08\u30bc\u30ed\u9664\u7b97\u306a\u3069\uff09\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : "Unexpected error (e.g. divided by zero) has occurred on the division." + System.getProperty("line.separator");
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.bigDecimalValue = new BigDecimal("0.0");
                this.error(this.errorMessage);
                return null;
            }
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4f55\u3089\u304b\u306e\u6f14\u7b97\u30a8\u30e9\u30fc\uff08\u30bc\u30ed\u9664\u7b97\u306a\u3069\uff09\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : "Unexpected error (e.g. divided by zero) has occurred on the division." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.bigDecimalValue = new BigDecimal("0.0");
            this.error(this.errorMessage);
            return null;
        }
    }

    private void stringProcess() {
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u9664\u7b97\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" : this.errorMessage + "Cannot perform the division. ( \"";
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.errorMessage = this.errorMessage + "\"" + this.inputUnit[i].getStringValue() + "\"";
            this.errorMessage = this.errorMessage + "/";
        }
        this.errorMessage = this.errorMessage + "\"" + this.inputUnit[this.inputUnit.length - 1].getStringValue() + "\" )" + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.error(this.errorMessage);
        this.stringValue = "SYSTEM_ERROR_VALUE";
    }

    @Override
    public String getFormula() {
        return this.getFormula(Integer.MAX_VALUE);
    }

    @Override
    public String getFormula(int n) {
        if (this.getRank() == n) {
            return this.getStringValue();
        }
        String string = "";
        string = n == this.getRank() + 1 ? "[ " : "";
        for (int i = 0; i < this.inputUnit.length; ++i) {
            string = string + this.inputUnit[i].getFormula(n);
            if (i >= this.inputUnit.length - 1) continue;
            string = string + "/";
        }
        string = n == this.getRank() + 1 ? string + " = " + this.getStringValue() + " ]" : string + "";
        if (this.inputUnit.length == 1) {
            string = this.getStringValue();
        }
        return string;
    }
}

