/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.math.BigDecimal;
import java.math.MathContext;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.unit.ProcessUnit;

public class SISDPowerUnit
extends ProcessUnit {
    public SISDPowerUnit(ProcessUnit[] processUnitArray, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.inputUnit = processUnitArray;
        this.nodeType = 201;
        this.setValueType();
        int n = this.getValueType();
        if (n == 101) {
            this.setValueType(100);
        }
        if (n == 104) {
            this.setValueType(103);
        }
        this.arrayType = false;
    }

    @Override
    public void process() {
        if (this.valueType == 101) {
            this.decimalValue = this.inputUnit[0].getDecimalValue();
            for (int i = 1; i < this.inputUnit.length; ++i) {
                this.decimalValue = Math.pow(this.decimalValue, this.inputUnit[i].getDecimalValue());
            }
        } else if (this.valueType == 100) {
            this.decimalValue = this.inputUnit[0].getDecimalValue();
            for (int i = 1; i < this.inputUnit.length; ++i) {
                this.decimalValue = Math.pow(this.decimalValue, this.inputUnit[i].getDecimalValue());
            }
        } else if (this.valueType == 104) {
            BigDecimal bigDecimal = this.inputUnit[0].getBigDecimalValue();
            for (int i = 1; i < this.inputUnit.length; ++i) {
                bigDecimal = this.pow(bigDecimal, this.inputUnit[i].getBigDecimalValue());
            }
            this.bigDecimalValue = this.getFixedDigitBigDecimal(bigDecimal);
        } else if (this.valueType == 103) {
            MathContext mathContext = (MathContext)this.processEngine.getMathContext();
            BigDecimal bigDecimal = this.inputUnit[0].getBigDecimalValue();
            for (int i = 1; i < this.inputUnit.length; ++i) {
                bigDecimal = this.pow(bigDecimal, this.inputUnit[i].getBigDecimalValue());
            }
            this.bigDecimalValue = this.getFixedDigitBigDecimal(bigDecimal);
        } else {
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6f14\u7b97\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" : this.errorMessage + "Cannot perform the operation. ( \"";
            for (int i = 0; i < this.inputUnit.length - 1; ++i) {
                this.errorMessage = this.errorMessage + "\"" + this.inputUnit[i].getStringValue() + "\"";
                this.errorMessage = this.errorMessage + "*";
            }
            this.errorMessage = this.errorMessage + "\"" + this.inputUnit[this.inputUnit.length - 1].getStringValue() + "\" )" + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
            this.stringValue = "SYSTEM_ERROR_VALUE";
        }
    }

    BigDecimal pow(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        long l = 0L;
        boolean bl = false;
        try {
            l = Long.parseLong(bigDecimal2.toString());
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        MathContext mathContext = (MathContext)this.processEngine.getMathContext();
        if (bl) {
            if (l == 0L) {
                return new BigDecimal("1");
            }
            if (0L < l) {
                BigDecimal bigDecimal3 = new BigDecimal("1");
                for (long i = 0L; i < l; ++i) {
                    bigDecimal3 = bigDecimal3.multiply(bigDecimal, mathContext);
                }
                bigDecimal3 = this.inputUnit[0].getFixedDigitBigDecimal(bigDecimal3);
                return bigDecimal3;
            }
            if (0L > l) {
                long l2 = -l;
                BigDecimal bigDecimal4 = new BigDecimal("1");
                for (long i = 0L; i < l2; ++i) {
                    bigDecimal4 = bigDecimal4.multiply(bigDecimal, mathContext);
                }
                bigDecimal4 = this.inputUnit[0].getFixedDigitBigDecimal(bigDecimal4);
                BigDecimal bigDecimal5 = new BigDecimal("1");
                bigDecimal5 = bigDecimal5.divide(bigDecimal4, mathContext);
                bigDecimal5 = this.inputUnit[0].getFixedDigitBigDecimal(bigDecimal5);
                return bigDecimal5;
            }
        }
        if (!bl) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.processEngine.error("verfloat\u6f14\u7b97\u30a8\u30e9\u30fc\uff08\u7d44\u307f\u8fbc\u307f\u51aa\u4e57\u7b97\u306f\u5c0f\u6570\u4e57\u3092\u6271\u3048\u307e\u305b\u3093\uff09");
            } else {
                this.processEngine.error("verfloat operation error (The built-in exp operation cannot handle float/varfiloa values for the right operand.)");
            }
        }
        return new BigDecimal("0");
    }

    @Override
    public String getFormula() {
        return this.getFormula(Integer.MAX_VALUE);
    }

    @Override
    public String getFormula(int n) {
        if (this.getRank() == n) {
            return this.getStringValue();
        }
        String string = "";
        string = n == this.getRank() + 1 ? "[ " : "";
        for (int i = 0; i < this.inputUnit.length; ++i) {
            string = string + this.inputUnit[i].getFormula(n);
            if (i >= this.inputUnit.length - 1) continue;
            string = string + "**";
        }
        string = n == this.getRank() + 1 ? string + " = " + this.getStringValue() + " ]" : string + "";
        if (this.inputUnit.length == 1) {
            string = this.getStringValue();
        }
        return string;
    }
}

