/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import rxvesapi.process.ProcessCompatibilityException;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.unit.ProcessUnit;

public class SISDRemainderUnit
extends ProcessUnit {
    public SISDRemainderUnit(ProcessUnit[] processUnitArray, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.inputUnit = processUnitArray;
        this.inputUnit0 = processUnitArray[0];
        this.inputUnit1 = processUnitArray[1];
        this.nodeType = 201;
        this.setValueType();
        this.arrayType = false;
    }

    @Override
    public void process() {
        if (this.valueType == 100) {
            this.decimalValue = this.inputUnit0.getDecimalValue() % this.inputUnit1.getDecimalValue();
        } else if (this.valueType == 101) {
            this.integerValue = this.inputUnit0.getIntegerValue() % this.inputUnit1.getIntegerValue();
        } else if (this.getValueType() == 104) {
            this.bigIntegerProcess();
        } else if (this.getValueType() == 103) {
            this.bigDecimalProcess();
        } else if (this.getValueType() == 102) {
            this.stringProcess();
        } else if (ScriptProcessor.locale.isJapanese()) {
            this.error("\u3053\u306e\u578b\u3067\u306f\u3001\u5270\u4f59\u6f14\u7b97\u3092\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002");
        } else {
            this.error("Cannot perform the remainder operation on this data type.");
        }
    }

    @Override
    public long getIntegerValue() {
        block10: {
            try {
                if (this.valueType == 101) {
                    this.integerValue = this.inputUnit0.getIntegerValue() % this.inputUnit1.getIntegerValue();
                    return this.integerValue;
                }
                if (this.valueType == 100) {
                    this.decimalValue = this.inputUnit0.getDecimalValue() % this.inputUnit1.getDecimalValue();
                    return (long)this.decimalValue;
                }
                if (this.valueType == 104) {
                    this.bigIntegerProcess();
                    return this.bigIntegerValue.longValue();
                }
                if (this.valueType == 103) {
                    this.bigDecimalProcess();
                    return this.bigDecimalValue.longValue();
                }
                if (this.valueType != 102) break block10;
                this.stringProcess();
                long l = 0L;
                try {
                    l = Long.parseLong(this.stringValue);
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6574\u6570\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" + this.stringValue + "\" )" + System.getProperty("line.separator") : this.errorMessage + "Cannot convert to an int type value. ( \"" + this.stringValue + "\" )" + System.getProperty("line.separator");
                    this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                    this.error(this.errorMessage);
                }
                return l;
            }
            catch (NullPointerException nullPointerException) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.errorMessage = this.errorMessage + "\u5909\u6570\u300c" + this.name + "\u300d\u306f\u6b63\u5e38\u306a\u5024\u3092\u4fdd\u6301\u3057\u3066\u3044\u307e\u305b\u3093\u3002" + System.getProperty("line.separator");
                    this.errorMessage = this.errorMessage + "\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u306a\u3044\u304b\u3001\u51e6\u7406\u4e0d\u80fd\u306a\u6f14\u7b97\u304c\u884c\u308f\u308c\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" + System.getProperty("line.separator");
                } else {
                    this.errorMessage = this.errorMessage + "The variable \"" + this.name + "\" does not store the valid value." + System.getProperty("line.separator");
                    this.errorMessage = this.errorMessage + "Probably it is uninitialized, or performed invalid operations." + System.getProperty("line.separator");
                }
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.error(this.errorMessage);
            }
        }
        return 0L;
    }

    @Override
    public double getDecimalValue() {
        if (this.valueType == 100) {
            this.decimalValue = this.inputUnit0.getDecimalValue() % this.inputUnit1.getDecimalValue();
            return this.decimalValue;
        }
        if (this.valueType == 101) {
            this.integerValue = this.inputUnit0.getIntegerValue() % this.inputUnit1.getIntegerValue();
            return this.integerValue;
        }
        if (this.valueType == 104) {
            this.bigIntegerProcess();
            return this.bigIntegerValue.doubleValue();
        }
        if (this.valueType == 103) {
            this.bigDecimalProcess();
            return this.bigDecimalValue.doubleValue();
        }
        if (this.valueType == 102) {
            this.stringProcess();
            double d = 0.0;
            try {
                d = Double.parseDouble(this.stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6d6e\u52d5\u5c0f\u6570\u70b9\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" + this.stringValue + "\" )" + System.getProperty("line.separator") : this.errorMessage + "Cannot convert to a float type value. ( \"" + this.stringValue + "\" )" + System.getProperty("line.separator");
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.error(this.errorMessage);
            }
            return d;
        }
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6f14\u7b97\u3067\u304d\u307e\u305b\u3093\u3002" : this.errorMessage + "Cannot perform the operation.";
        this.error(this.errorMessage);
        return 0.0;
    }

    private void bigIntegerProcess() {
        try {
            Serializable serializable;
            if (!(this.inputUnit0.getBigIntegerValue().compareTo(BigInteger.ZERO) >= 0 && this.inputUnit1.getBigIntegerValue().compareTo(BigInteger.ZERO) >= 0 || ((ProcessCompatibilityException)(serializable = new ProcessCompatibilityException())).alert())) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.error("\u8ca0\u306e\u6570\u306b\u5bfe\u3059\u308b varint\u578b\u306e\u5270\u4f59\u6f14\u7b97\u306f\u3001\u30d0\u30fc\u30b8\u30e7\u30f3 3.1.12 \u4ee5\u524d\u3068 3.1.14 \u4ee5\u5f8c\u3067\u6319\u52d5\u304c\u7570\u306a\u308a\u307e\u3059\u30023.1.12\u4ee5\u524d\u306b\u8a18\u8ff0\u3055\u308c\u305f\u30d7\u30ed\u30b0\u30e9\u30e0\u306f\u30013.1.12\u4ee5\u524d\u306e\u30e9\u30f3\u30bf\u30a4\u30e0\u3067\u5b9f\u884c\u3057\u3066\u4e0b\u3055\u3044\u3002");
                } else {
                    this.error("It is not recommended to perform remainder operations on negative varint values. Its behaviour depends on the version of VCSSL (after 3.1.14 or before 3.1.12).");
                }
            }
            serializable = this.inputUnit0.getBigIntegerValue();
            serializable = ((BigInteger)serializable).remainder(this.inputUnit1.getBigIntegerValue());
            this.bigIntegerValue = serializable;
        }
        catch (ArithmeticException arithmeticException) {
            BigInteger bigInteger = new BigInteger("0");
            if (this.inputUnit0.getBigIntegerValue().compareTo(bigInteger) == 0) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.errorMessage = this.errorMessage + "\u5909\u6570\u300c" + this.inputUnit0.getName() + "\u300d\u306e\u5024\u304c0\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002" + System.getProperty("line.separator");
                    this.errorMessage = this.errorMessage + "\u3053\u306e\u5909\u6570\u3067\u5270\u4f59\u7b97\u3092\u5b9f\u884c\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + System.getProperty("line.separator");
                } else {
                    this.errorMessage = this.errorMessage + "Cannot perform the remainder operation by variable \"" + this.inputUnit0.getName() + "\", because its value is zero.";
                }
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.bigIntegerValue = new BigInteger("0");
                this.error(this.errorMessage);
                return;
            }
            if (this.inputUnit1.getBigIntegerValue().compareTo(bigInteger) == 0) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.errorMessage = this.errorMessage + "\u5909\u6570\u300c" + this.inputUnit1.getName() + "\u300d\u306e\u5024\u304c0\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002" + System.getProperty("line.separator");
                    this.errorMessage = this.errorMessage + "\u3053\u306e\u5909\u6570\u3067\u5270\u4f59\u7b97\u3092\u5b9f\u884c\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + System.getProperty("line.separator");
                } else {
                    this.errorMessage = this.errorMessage + "Cannot perform the remainder operation by variable \"" + this.inputUnit1.getName() + "\", because its value is zero.";
                }
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.bigIntegerValue = new BigInteger("0");
                this.error(this.errorMessage);
                return;
            }
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u5270\u4f59\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4e0d\u660e\u306a\u6f14\u7b97\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 @" + this + System.getProperty("line.separator") : this.errorMessage + "Unexpected error occurred on the remainder operation. @" + this + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
            this.bigIntegerValue = new BigInteger("0");
            return;
        }
    }

    private void bigDecimalProcess() {
        try {
            BigDecimal bigDecimal = this.inputUnit0.getBigDecimalValue();
            BigDecimal bigDecimal2 = this.inputUnit1.getBigDecimalValue();
            MathContext mathContext = (MathContext)this.processEngine.getMathContext();
            this.bigDecimalValue = bigDecimal.remainder(bigDecimal2, mathContext);
        }
        catch (ArithmeticException arithmeticException) {
            BigDecimal bigDecimal = new BigDecimal("0.0");
            if (this.inputUnit0.getBigDecimalValue().compareTo(bigDecimal) == 0) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.errorMessage = this.errorMessage + "\u5909\u6570\u300c" + this.inputUnit0.getName() + "\u300d\u306e\u5024\u304c0\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002" + System.getProperty("line.separator");
                    this.errorMessage = this.errorMessage + "\u3053\u306e\u5909\u6570\u3067\u5270\u4f59\u7b97\u3092\u5b9f\u884c\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + System.getProperty("line.separator");
                } else {
                    this.errorMessage = this.errorMessage + "Cannot perform the remainder operation by variable \"" + this.inputUnit0.getName() + "\", because its value is zero.";
                }
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.error(this.errorMessage);
                this.bigDecimalValue = new BigDecimal("0.0");
                return;
            }
            if (this.inputUnit1.getBigDecimalValue().compareTo(bigDecimal) == 0) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.errorMessage = this.errorMessage + "\u5909\u6570\u300c" + this.inputUnit1.getName() + "\u300d\u306e\u5024\u304c0\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002" + System.getProperty("line.separator");
                    this.errorMessage = this.errorMessage + "\u3053\u306e\u5909\u6570\u3067\u5270\u4f59\u7b97\u3092\u5b9f\u884c\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + System.getProperty("line.separator");
                } else {
                    this.errorMessage = this.errorMessage + "Cannot perform the remainder operation by variable \"" + this.inputUnit1.getName() + "\", because its value is zero.";
                }
                this.error(this.errorMessage);
                this.bigDecimalValue = new BigDecimal("0.0");
                return;
            }
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u5270\u4f59\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4e0d\u660e\u306a\u6f14\u7b97\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 @" + this + System.getProperty("line.separator") : this.errorMessage + "Unexpected error occurred on the remainder operation. @" + this + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
            this.bigDecimalValue = new BigDecimal("0.0");
            arithmeticException.printStackTrace();
            return;
        }
    }

    private void stringProcess() {
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6f14\u7b97\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" : this.errorMessage + "Cannot perform the operation. ( \"";
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.errorMessage = this.errorMessage + "\"" + this.inputUnit[i].getStringValue() + "\"";
            this.errorMessage = this.errorMessage + "%";
        }
        this.errorMessage = this.errorMessage + "\"" + this.inputUnit[this.inputUnit.length - 1].getStringValue() + "\" )" + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.error(this.errorMessage);
        this.stringValue = "SYSTEM_ERROR_VALUE";
    }

    @Override
    public String getFormula() {
        return this.getFormula(Integer.MAX_VALUE);
    }

    @Override
    public String getFormula(int n) {
        if (this.getRank() == n) {
            return this.getStringValue();
        }
        String string = "";
        string = n == this.getRank() + 1 ? "[ " : "";
        for (int i = 0; i < this.inputUnit.length; ++i) {
            string = string + this.inputUnit[i].getFormula(n);
            if (i >= this.inputUnit.length - 1) continue;
            string = string + "%";
        }
        string = n == this.getRank() + 1 ? string + " = " + this.getStringValue() + " ]" : string + "";
        if (this.inputUnit.length == 1) {
            string = this.getStringValue();
        }
        return string;
    }
}

