/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import rxvesapi.process.ProcessEngine;
import rxvesapi.process.object.ProcessStruct;
import rxvesapi.process.unit.BigComplexArrayUnit;
import rxvesapi.process.unit.BigComplexUnit;
import rxvesapi.process.unit.BigDecimalArrayUnit;
import rxvesapi.process.unit.BigDecimalUnit;
import rxvesapi.process.unit.BigIntegerArrayUnit;
import rxvesapi.process.unit.BigIntegerUnit;
import rxvesapi.process.unit.BooleanArrayUnit;
import rxvesapi.process.unit.BooleanUnit;
import rxvesapi.process.unit.ComplexArrayUnit;
import rxvesapi.process.unit.ComplexUnit;
import rxvesapi.process.unit.DecimalArrayUnit;
import rxvesapi.process.unit.DecimalUnit;
import rxvesapi.process.unit.EqualUnit;
import rxvesapi.process.unit.IntegerArrayUnit;
import rxvesapi.process.unit.IntegerUnit;
import rxvesapi.process.unit.ProcessUnit;
import rxvesapi.process.unit.SIMDSubstitutionUnit;
import rxvesapi.process.unit.StringArrayUnit;
import rxvesapi.process.unit.StringUnit;
import rxvesapi.process.unit.StructArrayUnit;

public class StructUnit
extends ProcessUnit {
    private ProcessStruct struct;
    private ProcessUnit[] variable = null;
    private boolean initialized = false;
    private boolean defaulted = false;
    final boolean READY_MEMBER = true;

    public StructUnit(ProcessStruct processStruct, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.struct = processStruct;
        this.valueType = 200;
        this.nodeType = 200;
    }

    public StructUnit(ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.struct = null;
        this.valueType = 200;
        this.nodeType = 200;
    }

    @Override
    public void readyMember() {
        if (!this.isDefaulted()) {
            this.initialize();
            this.setDefaulted(true);
        }
    }

    @Override
    public void setStruct(ProcessStruct processStruct) {
        this.struct = processStruct;
    }

    @Override
    public boolean isMemberInitialized() {
        return this.initialized;
    }

    @Override
    public void free() {
        this.setDefaulted(true);
        if (this.variable != null) {
            int n;
            for (n = 0; n < this.variable.length; ++n) {
                this.variable[n].free();
            }
            for (n = 0; n < this.variable.length; ++n) {
                this.variable[n].disposeResource();
            }
            for (n = 0; n < this.variable.length; ++n) {
                this.variable[n] = null;
            }
            this.variable = null;
        }
    }

    @Override
    public void alloc(int[] nArray) {
        this.free();
        this.initVariable();
        this.setStructDefaultValue();
    }

    public void initVariable() {
        ProcessUnit[] processUnitArray = this.struct.getVariable();
        int n = processUnitArray.length;
        this.variable = new ProcessUnit[n];
        for (int i = 0; i < n; ++i) {
            if (processUnitArray[i] instanceof IntegerUnit) {
                this.variable[i] = new IntegerUnit();
            } else if (processUnitArray[i] instanceof IntegerArrayUnit) {
                this.variable[i] = new IntegerArrayUnit();
            } else if (processUnitArray[i] instanceof DecimalUnit) {
                this.variable[i] = new DecimalUnit();
            } else if (processUnitArray[i] instanceof DecimalArrayUnit) {
                this.variable[i] = new DecimalArrayUnit();
            } else if (processUnitArray[i] instanceof ComplexUnit) {
                this.variable[i] = new ComplexUnit();
            } else if (processUnitArray[i] instanceof ComplexArrayUnit) {
                this.variable[i] = new ComplexArrayUnit();
            } else if (processUnitArray[i] instanceof BigIntegerUnit) {
                this.variable[i] = new BigIntegerUnit();
            } else if (processUnitArray[i] instanceof BigIntegerArrayUnit) {
                this.variable[i] = new BigIntegerArrayUnit();
            } else if (processUnitArray[i] instanceof BigDecimalUnit) {
                this.variable[i] = new BigDecimalUnit(this.processEngine);
            } else if (processUnitArray[i] instanceof BigDecimalArrayUnit) {
                this.variable[i] = new BigDecimalArrayUnit(this.processEngine);
            } else if (processUnitArray[i] instanceof BigComplexUnit) {
                this.variable[i] = new BigComplexUnit(this.processEngine);
            } else if (processUnitArray[i] instanceof BigComplexArrayUnit) {
                this.variable[i] = new BigComplexArrayUnit(this.processEngine);
            } else if (processUnitArray[i] instanceof BooleanUnit) {
                this.variable[i] = new BooleanUnit();
            } else if (processUnitArray[i] instanceof BooleanArrayUnit) {
                this.variable[i] = new BooleanArrayUnit();
            } else if (processUnitArray[i] instanceof StringUnit) {
                this.variable[i] = new StringUnit();
            } else if (processUnitArray[i] instanceof StringArrayUnit) {
                this.variable[i] = new StringArrayUnit();
            } else if (processUnitArray[i] instanceof StructUnit) {
                this.variable[i] = new StructUnit(processUnitArray[i].getStruct(), this.processEngine);
            } else if (processUnitArray[i] instanceof StructArrayUnit) {
                this.variable[i] = new StructArrayUnit(processUnitArray[i].getStruct(), this.processEngine);
            }
            this.variable[i].processEngine = this.processEngine;
            if (this.variable[i].isArrayType()) {
                int[] nArray = processUnitArray[i].getLength();
                int[] nArray2 = new int[nArray.length];
                for (int j = 0; j < nArray.length; ++j) {
                    nArray2[j] = nArray[j];
                }
                this.variable[i].setLength(nArray2);
                this.variable[i].dimension = nArray2.length;
            }
            if (!processUnitArray[i].isConst()) continue;
            this.variable[i].setConst(true);
        }
        this.initialized = true;
    }

    @Override
    public ProcessStruct getStruct() {
        return this.struct;
    }

    @Override
    public ProcessUnit[] getMemberVariable() {
        return this.variable;
    }

    public int getVariableIndex(String string) {
        int n = this.struct.getVariable().length;
        for (int i = 0; i < n; ++i) {
            if (this.struct.getVariable()[i] == null || this.struct.getVariable()[i].getName() != string) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean equalsMember(ProcessUnit processUnit) {
        ProcessUnit[] processUnitArray;
        ProcessUnit[] processUnitArray2;
        block17: {
            block16: {
                if (processUnit.getStruct() != this.getStruct()) {
                    return false;
                }
                if (!processUnit.isDefaulted() && !this.isDefaulted()) {
                    return true;
                }
                processUnitArray2 = this.getMemberVariable();
                processUnitArray = processUnit.getMemberVariable();
                if (StructUnit.isNullInputtedStructUnit(processUnit)) break block16;
                if (!StructUnit.isNullInputtedStructUnit(this)) break block17;
            }
            if (StructUnit.isNullInputtedStructUnit(processUnit)) {
                if (StructUnit.isNullInputtedStructUnit(this)) {
                    return true;
                }
            }
            return false;
        }
        if (!processUnit.isDefaulted() || !this.isDefaulted()) {
            if (!processUnit.isDefaulted()) {
                processUnitArray = processUnit.getStruct().getVariable();
            } else if (!this.isDefaulted()) {
                processUnitArray2 = this.getStruct().getVariable();
            }
        }
        int n = processUnitArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = processUnitArray2[i].getValueType();
            boolean bl = processUnitArray2[i].isArrayType();
            if (bl) {
                int n3 = processUnitArray2[i].getCapacity();
                if (processUnitArray[i].getCapacity() != n3) {
                    return false;
                }
                for (int j = 0; j < n3; ++j) {
                    if (this.equalsMemberElement(processUnitArray2[i], processUnitArray[i], n2, bl, j)) continue;
                    return false;
                }
                continue;
            }
            if (this.equalsMemberElement(processUnitArray2[i], processUnitArray[i], n2, false, -1)) continue;
            return false;
        }
        return true;
    }

    private boolean equalsMemberElement(ProcessUnit processUnit, ProcessUnit processUnit2, int n, boolean bl, int n2) {
        ProcessUnit[] processUnitArray = new ProcessUnit[]{processUnit, processUnit2};
        EqualUnit equalUnit = new EqualUnit(processUnitArray, this.processEngine);
        equalUnit.inputType = n;
        if (bl) {
            equalUnit.index = n2;
        }
        boolean bl2 = equalUnit.getBooleanValue();
        equalUnit.disposeResource();
        equalUnit = null;
        return bl2;
    }

    public static boolean isNullInputtedStructUnit(ProcessUnit processUnit) {
        if (processUnit.isDefaulted()) {
            return processUnit.getMemberVariable() == null;
        }
        return false;
    }

    @Override
    public void setStructValue(ProcessUnit processUnit) {
        if (processUnit.getValueType() == -100) {
            this.free();
            return;
        }
        this.setDefaulted(true);
        if (this.variable == null) {
            this.initVariable();
        }
        if (processUnit.isDefaulted()) {
            ProcessUnit[] processUnitArray = this.getMemberVariable();
            ProcessUnit[] processUnitArray2 = processUnit.getMemberVariable();
            if (processUnitArray2 == null) {
                this.free();
                return;
            }
            int n = processUnitArray2.length;
            ProcessUnit[] processUnitArray3 = new ProcessUnit[2];
            SIMDSubstitutionUnit[] sIMDSubstitutionUnitArray = this.getSubstitutionUnit();
            for (int i = 0; i < n; ++i) {
                if (processUnitArray2[i] instanceof StructUnit && !processUnitArray2[i].isDefaulted()) {
                    processUnitArray[i].setDefaulted(false);
                    continue;
                }
                if (processUnitArray2[i].isConst()) continue;
                processUnitArray3[0] = processUnitArray[i];
                processUnitArray3[1] = processUnitArray2[i];
                sIMDSubstitutionUnitArray[i].inputUnit = processUnitArray3;
                ((ProcessUnit)sIMDSubstitutionUnitArray[i]).process();
            }
        } else {
            this.setDefaulted(false);
        }
    }

    @Override
    public ProcessUnit getStructValue() {
        return this;
    }

    private SIMDSubstitutionUnit[] getSubstitutionUnit() {
        SIMDSubstitutionUnit[] sIMDSubstitutionUnitArray = this.getStruct().getSubstitutionUnit();
        int n = sIMDSubstitutionUnitArray.length;
        SIMDSubstitutionUnit[] sIMDSubstitutionUnitArray2 = new SIMDSubstitutionUnit[n];
        for (int i = 0; i < n; ++i) {
            sIMDSubstitutionUnitArray2[i] = sIMDSubstitutionUnitArray[i].createClone();
        }
        return sIMDSubstitutionUnitArray2;
    }

    @Override
    public void initialize() {
        this.setStructDefaultValue();
    }

    @Override
    public boolean isDefaulted() {
        return this.defaulted;
    }

    @Override
    public void setDefaulted(boolean bl) {
        this.defaulted = bl;
    }

    public void setStructDefaultValue() {
        if (this.variable == null) {
            this.initVariable();
        }
        ProcessUnit[] processUnitArray = this.getMemberVariable();
        ProcessUnit[] processUnitArray2 = this.getStruct().getVariable();
        int n = processUnitArray2.length;
        ProcessUnit[] processUnitArray3 = new ProcessUnit[2];
        SIMDSubstitutionUnit[] sIMDSubstitutionUnitArray = this.getSubstitutionUnit();
        for (int i = 0; i < n; ++i) {
            if (processUnitArray[i].isArrayType()) {
                processUnitArray[i].copyLength(processUnitArray2[i].getLength());
            }
            if (processUnitArray[i].isConst()) continue;
            processUnitArray3[0] = processUnitArray[i];
            processUnitArray3[1] = processUnitArray2[i];
            sIMDSubstitutionUnitArray[i].inputUnit = processUnitArray3;
            ((ProcessUnit)sIMDSubstitutionUnitArray[i]).process();
        }
    }
}

