/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import rxvesapi.system.PinsetApplication;
import rxvesapi.system.PinsetApplicationPropertyWindow;
import rxvesapi.system.PinsetOperatorBrowsable;
import rxvesapi.system.PinsetOperatorKernel;

public class PinsetOperatorApplicationMenu
extends JPopupMenu
implements ActionListener {
    public int x;
    public int y;
    public PinsetApplication application;
    public PinsetOperatorKernel kernel;
    public PinsetOperatorBrowsable browsable;
    private boolean japanese = false;
    public JMenuItem launchItem;
    public JMenuItem openItem;
    public JMenuItem addToDesktopItem;
    public JMenuItem removeFromDesktopItem;
    public JMenuItem removeFromSystemItem;
    public JMenuItem settingItem;
    public JMenuItem propertyItem;
    public JMenuItem cancelItem;
    public PinsetApplicationPropertyWindow applicationPropertyWindow;

    public void setEnglish() {
        this.launchItem.setText("Launch");
        this.openItem.setText("Open");
        this.addToDesktopItem.setText("Add to the Desktop");
        this.removeFromDesktopItem.setText("Remove from the Desktop");
        this.removeFromSystemItem.setText("Remove from the System");
        this.settingItem.setText("Setting");
        this.propertyItem.setText("Property");
        this.cancelItem.setText("Cancel");
    }

    public void setJapanese() {
        this.launchItem.setText("\u8d77\u52d5");
        this.openItem.setText("\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f");
        this.addToDesktopItem.setText("\u30c7\u30b9\u30af\u30c8\u30c3\u30d7\u306b\u8ffd\u52a0");
        this.removeFromDesktopItem.setText("\u30c7\u30b9\u30af\u30c8\u30c3\u30d7\u304b\u3089\u524a\u9664");
        this.removeFromSystemItem.setText("\u30b7\u30b9\u30c6\u30e0\u304b\u3089\u524a\u9664");
        this.settingItem.setText("\u8a2d\u5b9a");
        this.propertyItem.setText("\u30d7\u30ed\u30d1\u30c6\u30a3");
        this.cancelItem.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
    }

    public PinsetOperatorApplicationMenu(PinsetOperatorKernel pinsetOperatorKernel) {
        this.kernel = pinsetOperatorKernel;
        this.componentInit();
    }

    public void componentInit() {
        this.launchItem = new JMenuItem("Launch");
        this.openItem = new JMenuItem("Open");
        this.addToDesktopItem = new JMenuItem("Add to the Desktop");
        this.removeFromDesktopItem = new JMenuItem("Remove from the Desktop");
        this.removeFromSystemItem = new JMenuItem("Remove from the System");
        this.settingItem = new JMenuItem("Setting");
        this.propertyItem = new JMenuItem("Property");
        this.cancelItem = new JMenuItem("Cancel");
        this.launchItem.addActionListener(this);
        this.openItem.addActionListener(this);
        this.addToDesktopItem.addActionListener(this);
        this.removeFromDesktopItem.addActionListener(this);
        this.removeFromSystemItem.addActionListener(this);
        this.settingItem.addActionListener(this);
        this.propertyItem.addActionListener(this);
        this.add(this.launchItem);
        this.add(this.openItem);
        this.add(this.addToDesktopItem);
        this.add(this.removeFromDesktopItem);
        this.add(this.removeFromSystemItem);
        this.add(this.settingItem);
        this.add(this.propertyItem);
        this.addSeparator();
        this.add(this.cancelItem);
    }

    public void setApplication(PinsetApplication pinsetApplication) {
        this.application = pinsetApplication;
        if (this.kernel.language == PinsetOperatorKernel.LANGUAGE_ENGLISH) {
            this.setEnglish();
        }
        if (this.kernel.language == PinsetOperatorKernel.LANGUAGE_JAPANESE) {
            this.setJapanese();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        int n = -1;
        for (int i = 0; i < this.kernel.getApplication().length; ++i) {
            if (this.kernel.getApplication()[i] != this.application) continue;
            n = i;
        }
        if (string.equals("Launch") || string.equals("\u8d77\u52d5")) {
            this.kernel.generate(n);
        }
        if (string.equals("Open") || string.equals("\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f")) {
            File file = this.kernel.getFileFromDialog();
            this.kernel.generate(file, n);
        }
        if (string.equals("Add to the Desktop") || string.equals("\u30c7\u30b9\u30af\u30c8\u30c3\u30d7\u306b\u8ffd\u52a0")) {
            this.kernel.addPalletApplication(n);
            this.kernel.reloadPallet();
            this.kernel.getDisplayPanel().repaint3DRequest();
        }
        if (string.equals("Remove from the Desktop") || string.equals("\u30c7\u30b9\u30af\u30c8\u30c3\u30d7\u304b\u3089\u524a\u9664")) {
            this.kernel.removePalletApplication(n);
            this.kernel.reloadPallet();
            this.kernel.getDisplayPanel().repaint3DRequest();
        }
        if (string.equals("Remove from the System") || string.equals("\u30b7\u30b9\u30c6\u30e0\u304b\u3089\u524a\u9664")) {
            this.kernel.removeApplication(n);
            this.kernel.reloadPallet();
            this.kernel.getDisplayPanel().repaint3DRequest();
        }
        if (string.equals("Setting") || string.equals("\u8a2d\u5b9a")) {
            // empty if block
        }
        if (string.equals("Property") || string.equals("\u30d7\u30ed\u30d1\u30c6\u30a3")) {
            if (this.applicationPropertyWindow == null) {
                this.applicationPropertyWindow = new PinsetApplicationPropertyWindow();
            }
            this.applicationPropertyWindow.setApplication(this.kernel.getApplication()[n]);
            this.applicationPropertyWindow.setVisible(true);
        }
    }
}

