/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import rxvesapi.system.PinsetFileLink;
import rxvesapi.system.PinsetOperatorBrowsable;
import rxvesapi.system.PinsetOperatorKernel;

public class PinsetOperatorFileMenu
extends JPopupMenu
implements ActionListener {
    public int x;
    public int y;
    public File targetFile;
    public PinsetFileLink targetLink;
    public PinsetOperatorKernel kernel;
    public PinsetOperatorBrowsable browsable;
    private boolean japanese = false;
    public JMenuItem copyItem;
    public JMenuItem pasteItem;
    public JMenuItem renameItem;
    public JMenuItem removeItem;
    public JMenuItem removeFromDesktopItem;
    public JMenuItem makeDirectoryItem;
    public JMenuItem makeFileItem;
    public JMenuItem cancelItem;
    public boolean isLinkTargetting = false;

    public void addBrowserListener(PinsetOperatorBrowsable pinsetOperatorBrowsable) {
        this.browsable = pinsetOperatorBrowsable;
    }

    public void setEnglish() {
        this.copyItem.setText("Copy");
        this.pasteItem.setText("Paste");
        this.renameItem.setText("Rename");
        this.removeItem.setText("Remove from the Computer");
        this.removeFromDesktopItem.setText("Remove from the Desktop");
        this.makeFileItem.setText("Make a file");
        this.makeDirectoryItem.setText("Make a directory");
        this.cancelItem.setText("Cancel");
    }

    public void setJapanese() {
        this.copyItem.setText("\u30b3\u30d4\u30fc");
        this.pasteItem.setText("\u30da\u30fc\u30b9\u30c8");
        this.renameItem.setText("\u540d\u524d\u306e\u5909\u66f4");
        this.removeItem.setText("\u30b3\u30f3\u30d4\u30e5\u30fc\u30bf\u30fc\u304b\u3089\u524a\u9664");
        this.removeFromDesktopItem.setText("\u30c7\u30b9\u30af\u30c8\u30c3\u30d7\u304b\u3089\u524a\u9664");
        this.makeFileItem.setText("\u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210");
        this.makeDirectoryItem.setText("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210");
        this.cancelItem.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
    }

    public PinsetOperatorFileMenu(PinsetOperatorKernel pinsetOperatorKernel) {
        this.kernel = pinsetOperatorKernel;
        this.componentInit();
    }

    public void componentInit() {
        this.copyItem = new JMenuItem("Copy");
        this.pasteItem = new JMenuItem("Paste");
        this.renameItem = new JMenuItem("Rename");
        this.removeItem = new JMenuItem("Remove from the Computer");
        this.removeFromDesktopItem = new JMenuItem("Remove from the Desktop");
        this.makeFileItem = new JMenuItem("Make a file");
        this.makeDirectoryItem = new JMenuItem("Make a directory");
        this.cancelItem = new JMenuItem("Cancel");
        this.copyItem.addActionListener(this);
        this.pasteItem.addActionListener(this);
        this.renameItem.addActionListener(this);
        this.removeItem.addActionListener(this);
        this.removeFromDesktopItem.addActionListener(this);
        this.makeFileItem.addActionListener(this);
        this.makeDirectoryItem.addActionListener(this);
        this.add(this.copyItem);
        this.add(this.pasteItem);
        this.add(this.renameItem);
        this.add(this.removeItem);
        this.add(this.removeFromDesktopItem);
        this.add(this.makeFileItem);
        this.add(this.makeDirectoryItem);
        this.addSeparator();
        this.add(this.cancelItem);
    }

    public void setFile(File file) {
        this.removeAll();
        this.add(this.copyItem);
        this.add(this.pasteItem);
        this.add(this.renameItem);
        this.add(this.removeItem);
        this.add(this.makeFileItem);
        this.add(this.makeDirectoryItem);
        this.addSeparator();
        this.add(this.cancelItem);
        this.targetFile = file;
        if (this.kernel.language == PinsetOperatorKernel.LANGUAGE_ENGLISH) {
            this.setEnglish();
        }
        if (this.kernel.language == PinsetOperatorKernel.LANGUAGE_JAPANESE) {
            this.setJapanese();
        }
    }

    public void setLink(File file) {
        this.removeAll();
        this.add(this.copyItem);
        this.add(this.pasteItem);
        this.add(this.renameItem);
        this.add(this.removeItem);
        this.add(this.removeFromDesktopItem);
        this.add(this.makeFileItem);
        this.add(this.makeDirectoryItem);
        this.addSeparator();
        this.add(this.cancelItem);
        this.targetFile = file;
        if (this.kernel.language == PinsetOperatorKernel.LANGUAGE_ENGLISH) {
            this.setEnglish();
        }
        if (this.kernel.language == PinsetOperatorKernel.LANGUAGE_JAPANESE) {
            this.setJapanese();
        }
    }

    public void setBlank() {
        this.removeAll();
        this.add(this.pasteItem);
        this.add(this.makeFileItem);
        this.add(this.makeDirectoryItem);
        this.addSeparator();
        this.add(this.cancelItem);
        if (this.kernel.language == PinsetOperatorKernel.LANGUAGE_ENGLISH) {
            this.setEnglish();
        }
        if (this.kernel.language == PinsetOperatorKernel.LANGUAGE_JAPANESE) {
            this.setJapanese();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        String string2 = System.getProperty("file.separator");
        File file = this.targetFile;
        if (jMenuItem == this.copyItem) {
            this.kernel.setCopyTargetFiles(new File[]{file});
            this.browsable.fileCopied(file);
        } else if (jMenuItem == this.pasteItem) {
            int n;
            File[] fileArray = new File[this.kernel.getCopyTargetFiles().length];
            for (n = 0; n < fileArray.length; ++n) {
                fileArray[n] = new File(this.browsable.getCurrentDirectory().getPath() + string2 + this.kernel.getCopyTargetFiles()[n].getName());
                fileArray[n] = this.kernel.getPreferedNamedFile(fileArray[n]);
            }
            n = this.kernel.getPreferredApplicationID(new File("a.SYSTEM_DAEMON_PROCESSRESERVE"));
            int n2 = this.kernel.getPreferredApplicationID(new File("a.SYSTEM_DAEMON_COPYPROCESS"));
            if (n2 > 0 && n > 0) {
                for (int i = 0; i < fileArray.length; ++i) {
                    String[] stringArray = new String[]{Integer.toString(n2), this.kernel.getCopyTargetFiles()[i].getPath(), fileArray[i].getPath()};
                    this.kernel.generate_DIRECT(stringArray, n);
                }
            } else {
                for (int i = 0; i < fileArray.length; ++i) {
                    this.kernel.copy(this.kernel.getCopyTargetFiles()[i], fileArray[i]);
                }
            }
            this.browsable.filePasted(fileArray[0]);
        } else if (jMenuItem == this.renameItem) {
            String string3 = JOptionPane.showInputDialog(this, (Object)"\u540d\u524d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002/ Please input the name.");
            File file2 = new File(this.browsable.getCurrentDirectory().getPath() + string2 + string3);
            if (file2.exists()) {
                JOptionPane.showMessageDialog(this, "\u305d\u306e\u540d\u524d\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002/ The file already exists.", "\u305d\u306e\u540d\u524d\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002/ The file already exists.", 1);
            } else {
                file.renameTo(file2);
            }
            this.browsable.fileRenamed(file);
        } else if (jMenuItem == this.removeItem) {
            if (this.kernel.isTrashReserved(file)) {
                String[] stringArray = new String[]{"" + file, " ", "\u3053\u306e\u30d5\u30a1\u30a4\u30eb\uff08\u53c8\u306f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff09\u3092\u30b3\u30f3\u30d4\u30e5\u30fc\u30bf\u304b\u3089\u524a\u9664\u3057\u307e\u3059\u3002", "\u524a\u9664\u3059\u308b\u3068\u3001\u30b4\u30df\u7bb1\u306a\u3069\u304b\u3089\u3082\u5fa9\u5143\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002", "\u672c\u5f53\u306b\u524a\u9664\u3057\u307e\u3059\u304b?", "You will be unable to restor this file ( or directory ) anyway, if you delete it.", "Are you sure you want to delete this file ( or directory ) from your computer?"};
                int n = JOptionPane.showConfirmDialog(null, stringArray, "\uff01 CAUTION ", 0);
                if (n == 0) {
                    int n3 = this.kernel.getPreferredApplicationID(new File("a.SYSTEM_DAEMON_REMOVEPROCESS"));
                    if (n3 > 0) {
                        this.kernel.generate_DIRECT(file, n3);
                    } else {
                        this.kernel.deleteFile(file);
                    }
                }
            } else {
                String[] stringArray = new String[]{"" + file, " ", "\u3053\u306e\u30d5\u30a1\u30a4\u30eb\uff08\u53c8\u306f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff09\u3092\u524a\u9664\u4fdd\u7ba1\u5834\u6240\u306b\u79fb\u52d5\u3057\u307e\u3059\u304b?", "Do you want to move this file ( or directory ) to `TrashReserver' directory?"};
                int n = JOptionPane.showConfirmDialog(null, stringArray, "\uff01 CAUTION ", 0);
                if (n == 0) {
                    this.kernel.trashFile(file);
                }
            }
            this.browsable.fileRemoved(file);
        } else if (jMenuItem == this.removeFromDesktopItem) {
            this.kernel.removeFileLink(file);
            this.browsable.linkRemoved(file);
        } else if (jMenuItem == this.makeFileItem) {
            String string4 = JOptionPane.showInputDialog(this, (Object)"\u540d\u524d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002/ Please input the name.");
            File file3 = new File(this.browsable.getCurrentDirectory().getPath() + string2 + string4);
            if (file3.exists()) {
                JOptionPane.showMessageDialog(this, "\u305d\u306e\u540d\u524d\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002/ The file already exists.", "\u305d\u306e\u540d\u524d\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002/ The file already exists.", 1);
            } else {
                try {
                    file3.createNewFile();
                    this.browsable.fileMade(file3);
                }
                catch (IOException iOException) {}
            }
        } else if (jMenuItem == this.makeDirectoryItem) {
            String string5 = JOptionPane.showInputDialog(this, (Object)"\u540d\u524d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002/ Please input the name.");
            File file4 = new File(this.browsable.getCurrentDirectory().getPath() + string2 + string5);
            if (file4.exists()) {
                JOptionPane.showMessageDialog(this, "\u305d\u306e\u540d\u524d\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002/ The directory already exists.", "\u305d\u306e\u540d\u524d\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002/ The directory already exists.", 1);
            } else {
                file4.mkdir();
                this.browsable.directoryMade(file4);
            }
        }
    }
}

