/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import rxvesapi.io.ParameterScriptReader;
import rxvesapi.system.PinsetApplication;
import rxvesapi.system.PinsetOperatorKernel;

public class PinsetOperatorLauncher
implements Runnable,
WindowListener {
    private Thread th;
    private boolean mainRoopFrag = true;
    private PinsetApplication[] application;
    private PinsetApplication[] application_STOCK;
    private String lineFeedCode = System.getProperty("line.separator");
    private TextArea area;
    private MediaTracker mt;
    private int width = 800;
    private int height = 600;
    private String importListPath = "dialoid_setting.txt";
    private JFrame frame = new JFrame();
    private int palletElementN;
    private int[] palletElementID;

    public PinsetOperatorLauncher() {
        this.frame.setTitle("PINSET-OPERATOR Launch Module");
        this.area = new TextArea();
        this.area.setBounds(0, 0, 3000, 2000);
        this.frame.getContentPane().add(this.area);
        this.area.setBackground(Color.blue);
        this.area.setForeground(Color.white);
        this.area.setFont(new Font("Dialog", 1, 20));
        this.area.setVisible(true);
        this.application = new PinsetApplication[0];
        this.application_STOCK = new PinsetApplication[0];
        this.frame.setBounds(0, 0, this.width, this.height);
        this.frame.setExtendedState(6);
        this.frame.setVisible(true);
        this.mt = new MediaTracker(this.frame);
        this.println("");
        this.println(" **********************************************************************************************");
        this.println("  Platform Independent Numerical Simulation Environment Technology ( P.I.N.S.E.T )");
        this.println("  Vertual Operating Environment:");
        this.println("");
        this.println("\t\t-  D I A L O I D  -");
        this.println("");
        this.println("  \tKERNEL:");
        this.println(" \t\tPinsetOperatorKernel  Ver" + PinsetOperatorKernel.VERSION);
        this.println(" \t\t  DEVELOPMENT ID=" + PinsetOperatorKernel.DEVELOPMENT_ID);
        this.println(" **********************************************************************************************");
        this.println("");
        this.println(" SYSTEM > Create Launch-Modul");
        this.println(" \tLAUNCHER > Standby...");
        this.println("");
    }

    public void wait(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        this.mainRoopFrag = false;
        this.th = null;
    }

    public void start() {
        if (this.th != null) {
            this.th = new Thread(this);
        }
    }

    @Override
    public void run() {
        while (this.mainRoopFrag) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.stop();
    }

    public static URL getURL(String string) {
        throw new RuntimeException("Removed method called");
    }

    public void automaticRegister(String string) {
        Serializable serializable;
        this.println(" \tLAUNCHER > [ Automatic Register Mode ]");
        try {
            serializable = this.getClass().getClassLoader().getResource("ssdp_root.pointer");
            this.println(" \t\tREGISTORY > SSDP root path is [" + ((URL)serializable).getPath() + "]");
        }
        catch (NullPointerException nullPointerException) {
            this.println(" \t\tREGISTORY > SSDP root path was not found");
        }
        serializable = new File(string);
        File[] fileArray = ((File)serializable).listFiles();
        this.println(" \t\tREGISTORY > Searching path is [" + ((File)serializable).getPath() + "]");
        if (((File)serializable).exists()) {
            if (!((File)serializable).isDirectory()) {
                this.println(" \t\tREGISTORY > ! Failed  ( [" + serializable + "] is not Directory )");
                this.println(" \t\tREGISTORY > return");
                return;
            }
        } else {
            this.println(" \t\tREGISTORY > ! Failed ( Path [" + serializable + "] is not exist )");
            this.println(" \t\tREGISTORY > return");
            return;
        }
        this.println(" \t\tREGISTORY > Directory [" + serializable + "] is exists");
        this.println(" \t\tREGISTORY > Searching Applicationes... (from [" + serializable + "])");
        for (int i = 0; i < fileArray.length; ++i) {
            URL uRL;
            String string2;
            int n;
            if (!fileArray[i].isDirectory()) continue;
            File[] fileArray2 = fileArray[i].listFiles();
            boolean bl = false;
            for (n = 0; n < fileArray2.length; ++n) {
                String string3;
                String[] stringArray;
                if (fileArray2[n].isDirectory() || (stringArray = (string3 = fileArray2[n].getName()).split("\\.")).length < 2 || !stringArray[1].equals("pin")) continue;
                string2 = stringArray[0];
                uRL = PinsetOperatorLauncher.getURL(fileArray[i].getPath());
                this.register(uRL, string2);
                bl = true;
            }
            if (bl) continue;
            for (n = 0; n < fileArray2.length; ++n) {
                String string4;
                if (!fileArray2[n].isDirectory() || !(string4 = fileArray2[n].getName()).equals("META-INF")) continue;
                ParameterScriptReader parameterScriptReader = new ParameterScriptReader(fileArray2[n].getPath() + "\\MANIFEST.MF");
                string2 = parameterScriptReader.readString("Main-Class:");
                uRL = PinsetOperatorLauncher.getURL(fileArray[i].getPath());
                this.registerNotDesignedApplication(uRL, string2);
            }
        }
    }

    public void remove(int n) {
        int n2;
        int n3 = this.application.length;
        this.println(" \tLAUNCHER > Remove an Application (CODE=x) [" + this.application[n] + "]");
        this.application_STOCK = new PinsetApplication[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.application_STOCK[n2] = this.application[n2];
        }
        this.application = new PinsetApplication[n3 - 1];
        for (n2 = 0; n2 < n; ++n2) {
            this.application[n2] = this.application_STOCK[n2];
            this.application_STOCK[n2] = null;
        }
        for (n2 = n; n2 < n3 - 1; ++n2) {
            this.application[n2] = this.application_STOCK[n2 + 1];
            this.application_STOCK[n2 + 1] = null;
        }
        this.application_STOCK[n] = null;
        this.application_STOCK = null;
    }

    public void register(PinsetApplication pinsetApplication) {
        int n;
        int n2 = this.application.length;
        this.println(" \tLAUNCHER > Register an Application (CODE=" + n2 + ") [" + pinsetApplication + "]");
        this.application_STOCK = new PinsetApplication[n2];
        for (n = 0; n < n2; ++n) {
            this.application_STOCK[n] = this.application[n];
        }
        this.application = new PinsetApplication[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.application[n] = this.application_STOCK[n];
            this.application_STOCK[n] = null;
        }
        this.application[n2] = pinsetApplication;
        this.application[n2].designed = true;
        this.application_STOCK = null;
    }

    public void register(String string) {
        int n;
        ClassLoader classLoader = this.getClass().getClassLoader();
        int n2 = this.application.length;
        this.println(" \tLAUNCHER > Register an Application (CODE=" + n2 + ") [" + string + "]");
        this.application_STOCK = new PinsetApplication[n2];
        for (n = 0; n < n2; ++n) {
            this.application_STOCK[n] = this.application[n];
        }
        this.application = new PinsetApplication[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.application[n] = this.application_STOCK[n];
            this.application_STOCK[n] = null;
        }
        try {
            try {
                try {
                    PinsetApplication pinsetApplication;
                    Class<?> clazz = classLoader.loadClass(string);
                    this.application[n2] = pinsetApplication = (PinsetApplication)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.application[n2].name = string;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            catch (InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                this.println(" \t\tREGISTRY > ! Faild ( InstantiationException/ " + string + " )");
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            this.println(" \t\tREGISTRY > ! Faild ( Access Denied/ " + string + " )");
        }
        this.application[n2].designed = true;
        this.application_STOCK = null;
    }

    public void register(URL uRL, String string) {
        int n;
        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL});
        int n2 = this.application.length;
        this.println(" \tLAUNCHER > Register an Application (CODE=" + n2 + ") [" + uRL + "]");
        this.application_STOCK = new PinsetApplication[n2];
        for (n = 0; n < n2; ++n) {
            this.application_STOCK[n] = this.application[n];
        }
        this.application = new PinsetApplication[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.application[n] = this.application_STOCK[n];
            this.application_STOCK[n] = null;
        }
        try {
            try {
                try {
                    PinsetApplication pinsetApplication;
                    Class<?> clazz = uRLClassLoader.loadClass(string);
                    this.application[n2] = pinsetApplication = (PinsetApplication)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.application[n2].name = string;
                    pinsetApplication.designed = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.println(" \t\tREGISTRY > ! Faild ( ClassNotFound/ " + string + " )");
                }
            }
            catch (InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                this.println(" \t\tREGISTRY > ! Faild ( InstantiationException/ " + string + " )");
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            this.println(" \t\tREGISTRY > ! Faild ( Access Denied/ " + string + " )");
        }
        this.application_STOCK = null;
    }

    public void registerNotDesignedApplication(URL uRL, String string) {
        int n;
        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL});
        int n2 = this.application.length;
        this.println(" \tLAUNCHER > Register an NotDesignedApplication (CODE=" + n2 + ") [" + uRL + "]");
        this.application_STOCK = new PinsetApplication[n2];
        for (n = 0; n < n2; ++n) {
            this.application_STOCK[n] = this.application[n];
        }
        this.application = new PinsetApplication[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.application[n] = this.application_STOCK[n];
            this.application_STOCK[n] = null;
        }
        try {
            PinsetApplication pinsetApplication;
            Class<?> clazz = uRLClassLoader.loadClass(string);
            this.application[n2] = pinsetApplication = new PinsetApplication();
            this.application[n2].name = string;
            pinsetApplication.coreClass = clazz;
            pinsetApplication.designed = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.println(" \t\tREGISTRY > ! Faild ( ClassNotFound/ " + string + " )");
        }
        this.application_STOCK = null;
    }

    public void load() {
        int n = this.application.length;
        for (int i = 0; i < n; ++i) {
            this.println(" \tLAUNCHER > Loading an Application / CODE=" + i);
            this.application[i].load();
            this.println(" \t\tLOAD[" + i + "] > NAME=" + this.application[i].name);
            this.println(" \t\tLOAD[" + i + "] > INFO=" + this.application[i].info);
            this.println(" \t\tLOAD[" + i + "] > Icon image loading...");
            try {
                this.mt.addImage(this.application[i].image, 0);
                this.mt.addImage(this.application[i].image_file, 0);
                try {
                    this.mt.waitForID(0);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            catch (NullPointerException nullPointerException) {
                this.println(" \t\tLOAD[" + i + "] > !CAUTION! Null Pointer Exception");
            }
            this.println(" \t\tLOAD[" + i + "] > Finished");
            this.println("");
        }
    }

    public void overwrite() {
        File file = new File(this.importListPath);
        if (file.exists()) {
            try {
                try {
                    String string;
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(this.importListPath));
                    while ((string = bufferedReader.readLine()) != null) {
                        String[] stringArray = string.split("=");
                        if (!stringArray[0].equals("APPLICATION")) continue;
                        String[] stringArray2 = stringArray[1].split(";");
                        if (stringArray.length == 1) continue;
                        boolean bl = false;
                        for (int i = 0; i < this.application.length; ++i) {
                            if (!this.application[i].name.equals(stringArray2[0]) || !this.application[i].info.equals(stringArray2[1])) continue;
                            String[] stringArray3 = stringArray2[8].split("/");
                            this.application[i].extention = stringArray3;
                            bl = true;
                            this.println(" \tLAUNCHER > Overwriting Informations / CODE=" + i);
                            this.println(" \t\tOVERWRITE[" + i + "] > EXTENTION=" + stringArray2[8]);
                            if (stringArray2.length > 9) {
                                String[] stringArray4 = stringArray2[9].split(" ");
                                this.application[i].args = stringArray4;
                            }
                            if (stringArray2.length > 10) {
                                this.application[i].category = stringArray2[10];
                            }
                            this.println(" \t\tOVERWRITE[" + i + "] > CATEGORY=" + stringArray2[10]);
                            if (stringArray2.length > 11) {
                                this.application[i].command = stringArray2[11];
                            }
                            this.println(" \t\tOVERWRITE[" + i + "] > COMMAND=" + stringArray2[11]);
                            if (stringArray2.length > 12) {
                                this.application[i].desktop = stringArray2[12].equals("true");
                            }
                            this.println(" \t\tOVERWRITE[" + i + "] > DESKTOP=" + stringArray2[12]);
                            this.println(" \t\tOVERWRITE[" + i + "] > Finished");
                            this.println("");
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void uninstallDefaultApplication() {
        File file = new File(this.importListPath);
        if (file.exists()) {
            String[] stringArray;
            String string;
            BufferedReader bufferedReader;
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = bl;
            try {
                try {
                    bufferedReader = new BufferedReader(new FileReader(this.importListPath));
                    while ((string = bufferedReader.readLine()) != null) {
                        stringArray = string.split("=");
                        if (!stringArray[0].equals("IMPORTMODE")) continue;
                        if (stringArray[1].equals("CUSTOM")) {
                            bl3 = bl2;
                            continue;
                        }
                        if (!stringArray[1].equals("FULL")) continue;
                        bl3 = bl;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bl3 == bl) {
                return;
            }
            for (int i = 0; i < this.application.length; ++i) {
                boolean bl4 = false;
                try {
                    try {
                        bufferedReader = new BufferedReader(new FileReader(this.importListPath));
                        while ((string = bufferedReader.readLine()) != null) {
                            stringArray = string.split("=");
                            if (!stringArray[0].equals("APPLICATION")) continue;
                            String[] stringArray2 = stringArray[1].split(";");
                            if (stringArray.length == 1 || !this.application[i].name.equals(stringArray2[0]) || !this.application[i].info.equals(stringArray2[1])) continue;
                            bl4 = true;
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (bl4) continue;
                this.remove(i);
                --i;
            }
        }
    }

    public void launch() {
        this.println("");
        this.println(" \tLAUNCHER > Start Loading Applications");
        this.println("");
        this.mainRoopFrag = false;
        this.load();
        this.println(" \tLAUNCHER > Start Overwriting Applications");
        this.println("");
        this.overwrite();
        this.println("");
        this.println(" \tLAUNCHER > Start Uninstalling Applications");
        this.println("");
        this.uninstallDefaultApplication();
        this.println("");
        this.println(" \tLAUNCHER > Launching PINSET-OPERATOR Kernel...");
        this.println(" \tLAUNCHER > Launching Neomiks3D Graphics Kernel...");
        this.println(" \tLAUNCHER > Launching \"DIALOID\" GUI System...");
        this.println("");
        PinsetOperatorKernel pinsetOperatorKernel = new PinsetOperatorKernel();
        for (int i = 0; i < this.application.length; ++i) {
            pinsetOperatorKernel.addApplication(this.application[i]);
        }
        pinsetOperatorKernel.reloadPallet();
        pinsetOperatorKernel.reloadFileLink();
        this.println(" \tLAUNCHER > Finished to launch the system successful");
        this.println(" \tLAUNCHER > EXIT");
        this.println(" SYSTEM > Start");
        this.println("");
        this.println(" [ EXIT ]");
        this.frame.setVisible(false);
        this.frame.dispose();
        this.frame = null;
    }

    public void setImportList(String string) {
        this.importListPath = string;
    }

    public void importApplication() {
        File file = new File(this.importListPath);
        if (file.exists()) {
            this.palletElementN = 0;
            int n = 0;
            try {
                try {
                    String string;
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(this.importListPath));
                    while ((string = bufferedReader.readLine()) != null) {
                        URL uRL;
                        String[] stringArray;
                        ++n;
                        String[] stringArray2 = string.split("=");
                        if (stringArray2[0].equals("PALLET")) {
                            ++this.palletElementN;
                        }
                        if (!stringArray2[0].equals("APPLICATION")) continue;
                        String[] stringArray3 = stringArray2[1].split(";");
                        if (stringArray2.length == 1) continue;
                        PinsetApplication pinsetApplication = new PinsetApplication();
                        boolean bl = false;
                        pinsetApplication.name = stringArray3[0];
                        pinsetApplication.info = stringArray3[1];
                        File file2 = new File(stringArray3[2]);
                        File file3 = new File(stringArray3[3]);
                        if (!file2.exists() && !file3.exists()) continue;
                        if (file2.exists()) {
                            pinsetApplication.loadCore(stringArray3[2]);
                        } else if (file3.exists()) {
                            pinsetApplication.loadCore(stringArray3[3]);
                        }
                        file2 = new File(stringArray3[4]);
                        file3 = new File(stringArray3[5]);
                        if (file2.exists()) {
                            pinsetApplication.loadApplicationImage(stringArray3[4]);
                        } else if (file3.exists()) {
                            pinsetApplication.loadApplicationImage(stringArray3[5]);
                        } else {
                            stringArray = this.getClass().getClassLoader();
                            uRL = stringArray.getResource("pinset/system/application_noimage.png");
                            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
                            try {
                                BufferedImage bufferedImage = ImageIO.read(uRL);
                                Graphics graphics = bufferedImage.getGraphics();
                                graphics.setFont(new Font("Dialog", 1, 12));
                                graphics.setColor(Color.black);
                                graphics.drawString(pinsetApplication.name, 10, 70);
                                graphics.setColor(Color.white);
                                graphics.drawString(pinsetApplication.name, 12, 72);
                                graphics.dispose();
                                graphics = null;
                                image = bufferedImage;
                                bufferedImage = null;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            pinsetApplication.image = image;
                        }
                        file2 = new File(stringArray3[6]);
                        file3 = new File(stringArray3[7]);
                        if (file2.exists()) {
                            pinsetApplication.loadFileImage(stringArray3[6]);
                        } else if (file3.exists()) {
                            pinsetApplication.loadFileImage(stringArray3[7]);
                        } else {
                            stringArray = this.getClass().getClassLoader();
                            uRL = stringArray.getResource("pinset/system/file_noimage.png");
                            pinsetApplication.image_file = Toolkit.getDefaultToolkit().getImage(uRL);
                        }
                        if (stringArray3.length > 8) {
                            stringArray = stringArray3[8].split("/");
                            pinsetApplication.extention = stringArray;
                        }
                        if (stringArray3.length > 9) {
                            stringArray = stringArray3[9].split(" ");
                            pinsetApplication.args = stringArray;
                        }
                        if (stringArray3.length > 10) {
                            pinsetApplication.category = stringArray3[10];
                        }
                        if (stringArray3.length > 11) {
                            pinsetApplication.command = stringArray3[11];
                        }
                        if (stringArray3.length > 12) {
                            pinsetApplication.desktop = stringArray3[12].equals("true");
                        }
                        this.register(pinsetApplication);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void print(String string) {
        this.area.append(string);
    }

    public void println(String string) {
        this.area.append(string + this.lineFeedCode);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.stop();
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

