/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system.kernel.cache;

public class VirtualizedIOFile {
    private final int EOF = -1;
    private final int INITIAL_LENGTH = 1;
    private int usage = 0;
    private int[] data;
    private String virtualFilePath = null;

    public VirtualizedIOFile(String string) {
        this.virtualFilePath = string;
        this.data = new int[1];
    }

    public String getPath() {
        return this.virtualFilePath;
    }

    public void initialize() {
        this.usage = 0;
        this.data = new int[1];
    }

    public void expand() {
        int n;
        int n2 = this.data.length;
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = this.data[n];
        }
        this.data = new int[n2 * 2];
        for (n = 0; n < n2; ++n) {
            this.data[n] = nArray[n];
        }
    }

    public void compress() {
        int n;
        int n2 = this.data.length / 2;
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = this.data[n];
        }
        this.data = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.data[n] = nArray[n];
        }
    }

    public void write(int n) {
        this.data[this.usage++] = n;
        if (this.data.length <= this.usage) {
            this.expand();
        }
    }

    public int getDataLength() {
        return this.usage;
    }

    public int read(int n) {
        if (this.usage <= n) {
            return this.EOF;
        }
        if (this.data[n] <= 0) {
            return this.data[n] + 256;
        }
        return this.data[n];
    }
}

